/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithSubstitution;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.OCBooleanTypeVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeResolveVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCResolveContext
extends UserDataHolderBase
implements OCCompilationContext {
    public static final Key<Boolean> FAIL_ON_RESOLVE_CYCLE = Key.create((String)"FAIL_ON_RESOLVE_CYCLE");
    @Nullable
    private PsiElement myElement;
    @Nullable
    private final Project myProject;
    @NotNull
    private final OCTypeSubstitution mySubstitution;
    @NotNull
    private final Set<Pair<OCSymbolReference, OCTypeSubstitution>> myResolving;
    private final HashMap<OCFunctionSymbol, OCStructSymbol> myOperatorParentsCache;
    private final Set<OCTypeResolveVisitor.TypeKey> myResolvingTypes;
    private final OCExpressionEvaluator.ValueEvaluator myEvaluator;
    private Map<OCType, OCType> myAutoParamsTypeMapping;
    private Map<OCDeclaratorSymbol, OCTypeParameterValueSymbol> myAutoParamsValueMapping;
    @Nullable
    private OCResolveContext myOriginalContext;
    private int myDepth;
    private Ref<Integer> myTypeResolveCounter;
    private Stack<OCFunctionSymbol> myOuterFunctions;
    private Set<OCTypeParameterSymbol> myTypeDependencies;
    private boolean myProcessNonImported;
    private boolean myResolveBelow;
    private boolean myOriginallyProcessNonImported;
    private boolean myDontExpandVariadics;
    private boolean isVariadicExpansionMode;
    private boolean myDontUseSymbolContextsInDepends;
    private boolean myInSFINAE;
    private boolean myIncompleteMode;
    private int myTemplateSubstitutionsCnt;

    @Deprecated
    @NotNull
    public static OCResolveContext empty(@NotNull Project project2) {
        if (project2 == null) {
            OCResolveContext.$$$reportNull$$$0(0);
        }
        OCResolveContext oCResolveContext = new OCResolveContext(null, project2);
        if (oCResolveContext == null) {
            OCResolveContext.$$$reportNull$$$0(1);
        }
        return oCResolveContext;
    }

    @NotNull
    public static OCResolveContext forSymbol(@NotNull OCSymbol symbol, @NotNull Project project2) {
        if (symbol == null) {
            OCResolveContext.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            OCResolveContext.$$$reportNull$$$0(3);
        }
        OCResolveContext oCResolveContext = new OCResolveContext(symbol.getContainingOCFile(project2), project2);
        if (oCResolveContext == null) {
            OCResolveContext.$$$reportNull$$$0(4);
        }
        return oCResolveContext;
    }

    @NotNull
    public static OCResolveContext forPsi(@NotNull PsiElement element) {
        if (element == null) {
            OCResolveContext.$$$reportNull$$$0(5);
        }
        OCResolveContext oCResolveContext = new OCResolveContext(element, element.getProject());
        if (oCResolveContext == null) {
            OCResolveContext.$$$reportNull$$$0(6);
        }
        return oCResolveContext;
    }

    @Deprecated
    @NotNull
    public static OCResolveContext forNullablePsi(@Nullable PsiElement element, @NotNull Project project2) {
        if (project2 == null) {
            OCResolveContext.$$$reportNull$$$0(7);
        }
        OCResolveContext oCResolveContext = new OCResolveContext(element, project2);
        if (oCResolveContext == null) {
            OCResolveContext.$$$reportNull$$$0(8);
        }
        return oCResolveContext;
    }

    private OCResolveContext(@NotNull OCResolveContext origin, @NotNull OCTypeSubstitution substitution) {
        if (origin == null) {
            OCResolveContext.$$$reportNull$$$0(9);
        }
        if (substitution == null) {
            OCResolveContext.$$$reportNull$$$0(10);
        }
        this.myTypeResolveCounter = Ref.create((Object)0);
        this.myOuterFunctions = new Stack();
        this.myProject = origin.myProject;
        this.myOriginalContext = origin;
        this.myDepth = origin.myDepth + 1;
        this.myElement = origin.myElement;
        this.mySubstitution = substitution;
        this.myResolving = origin.myResolving;
        this.myResolvingTypes = origin.myResolvingTypes;
        this.myOperatorParentsCache = origin.myOperatorParentsCache;
        this.myTypeResolveCounter = origin.myTypeResolveCounter;
        this.myTypeDependencies = new HashSet<OCTypeParameterSymbol>();
        this.myEvaluator = origin.myEvaluator;
        this.myIncompleteMode = origin.myIncompleteMode;
    }

    private OCResolveContext(@Nullable PsiElement element, @Nullable Project project2) {
        this.myTypeResolveCounter = Ref.create((Object)0);
        this.myOuterFunctions = new Stack();
        this.myProject = project2;
        this.myElement = element;
        this.mySubstitution = OCTypeSubstitution.ID;
        this.myResolving = OCTypeUtils.newReferenceWithSubstitutionSet();
        this.myResolvingTypes = new THashSet();
        this.myOperatorParentsCache = new HashMap();
        this.myTypeDependencies = new HashSet<OCTypeParameterSymbol>();
        this.myEvaluator = new OCExpressionEvaluator.ValueEvaluator(this);
    }

    @Deprecated
    @NotNull
    public static OCResolveContext emptyContextWithoutProject() {
        OCResolveContext oCResolveContext = new OCResolveContext();
        if (oCResolveContext == null) {
            OCResolveContext.$$$reportNull$$$0(11);
        }
        return oCResolveContext;
    }

    @Deprecated
    private OCResolveContext() {
        this.myTypeResolveCounter = Ref.create((Object)0);
        this.myOuterFunctions = new Stack();
        this.myProject = null;
        this.myElement = null;
        this.mySubstitution = OCTypeSubstitution.ID;
        this.myResolving = OCTypeUtils.newReferenceWithSubstitutionSet();
        this.myResolvingTypes = new THashSet();
        this.myOperatorParentsCache = new HashMap();
        this.myTypeDependencies = new HashSet<OCTypeParameterSymbol>();
        this.myEvaluator = new OCExpressionEvaluator.ValueEvaluator(this);
    }

    public String toString() {
        String element;
        if (this.myElement instanceof OCFile) {
            OCFile file = (OCFile)this.myElement;
            element = "file " + file.getName();
        } else {
            element = this.myElement != null ? "element " + this.myElement.getClass().getSimpleName() + ": " + this.myElement.getText() : (this.myProject != null ? "project " + this.myProject.getName() : "<null (deprecated)>");
        }
        return "OCResolveContext(" + element + ")";
    }

    public List<OCSymbol> doResolveToSymbols(OCSymbolReference reference, boolean onlyTypes, boolean resolveSpecializations) {
        Pair pair2 = Pair.create((Object)reference, (Object)this.mySubstitution.getMinimalDependentSubstitution(reference, this));
        if (this.myResolving.contains(pair2)) {
            if (this.getProject().getUserData(FAIL_ON_RESOLVE_CYCLE) == Boolean.TRUE) {
                throw new RuntimeException("Cycle in resolve, use \"//Allow resolve cycle\" in tests to suppress this assertion");
            }
            return Collections.emptyList();
        }
        this.myResolving.add((Pair<OCSymbolReference, OCTypeSubstitution>)pair2);
        List<OCSymbol> result = reference.resolveToSymbols(this, onlyTypes, resolveSpecializations);
        this.myResolving.remove(pair2);
        return result;
    }

    public List<OCSymbol> resolveToSymbols(OCSymbolReference reference) {
        return this.resolveToSymbols(reference, false, false);
    }

    public List<OCSymbol> resolveToSymbols(OCSymbolReference reference, boolean processTypedefs, boolean onlyTypes) {
        return this.resolveToSymbols(reference, processTypedefs, true, onlyTypes);
    }

    public List<OCSymbol> resolveToSymbols(OCSymbolReference reference, boolean processTypedefs, boolean processTypeParameters, boolean onlyTypes) {
        List<OCSymbol> symbols = this.doResolveToSymbols(reference, onlyTypes, true);
        return OCSymbolReference.lookupUsingsAndTypedefs(processTypedefs, onlyTypes, this, symbols, reference, processTypeParameters, true);
    }

    public Set<OCTypeResolveVisitor.TypeKey> getResolvingTypes() {
        return this.myResolvingTypes;
    }

    public Set<OCQualifiedName> getResolvingTypeNames() {
        return this.myResolvingTypes.stream().map(OCTypeResolveVisitor.TypeKey::getTypeName).collect(Collectors.toSet());
    }

    @Nullable
    public OCStructSymbol getNonMemberOperatorParent(OCSymbol operator) {
        if (operator instanceof OCFunctionSymbol) {
            OCFunctionSymbol function = (OCFunctionSymbol)operator;
            List<OCDeclaratorSymbol> params = function.getParameterSymbols();
            if (function.isCppNonMemberOperator(this)) {
                if (this.myOperatorParentsCache.containsKey(function)) {
                    return this.myOperatorParentsCache.get(function);
                }
                OCStructSymbol result = null;
                boolean wasUnknown = false;
                this.myOperatorParentsCache.put(function, null);
                for (int i = 0; i < params.size(); ++i) {
                    OCDeclaratorSymbol parameter = operator.getName().equals("operator<<") ? params.get(params.size() - i - 1) : params.get(i);
                    OCType paramType = parameter.getType().resolve(this).getTerminalType();
                    if (paramType instanceof OCStructType) {
                        result = ((OCStructType)paramType).getSymbol();
                        break;
                    }
                    if (!(paramType instanceof OCUnknownType)) continue;
                    wasUnknown = true;
                }
                if (result == null && wasUnknown) {
                    this.myOperatorParentsCache.remove(function);
                } else {
                    this.myOperatorParentsCache.put(function, result);
                }
                return result;
            }
        }
        return null;
    }

    @Nullable
    public PsiFile getFile() {
        return OCElementUtil.getContainingFileSkippingFragments(this.myElement);
    }

    @Deprecated
    @Nullable
    public PsiElement getElement() {
        return this.myElement != null && this.myElement.isValid() ? this.myElement : null;
    }

    @Deprecated
    @Nullable
    public Project getProjectOrNull() {
        return this.myProject;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            OCResolveContext.$$$reportNull$$$0(12);
        }
        return project2;
    }

    public void setElement(@Nullable PsiElement element) {
        this.myElement = element;
    }

    @NotNull
    public OCTypeSubstitution getSubstitution() {
        OCTypeSubstitution oCTypeSubstitution = this.mySubstitution;
        if (oCTypeSubstitution == null) {
            OCResolveContext.$$$reportNull$$$0(13);
        }
        return oCTypeSubstitution;
    }

    @Nullable
    public OCResolveContext getOriginalContext() {
        return this.myOriginalContext;
    }

    @NotNull
    public OCResolveContext substitute(@NotNull OCTypeSubstitution substitution) {
        if (substitution == null) {
            OCResolveContext.$$$reportNull$$$0(14);
        }
        OCResolveContext oCResolveContext = this.substitute(substitution, false, false);
        if (oCResolveContext == null) {
            OCResolveContext.$$$reportNull$$$0(15);
        }
        return oCResolveContext;
    }

    @NotNull
    public OCResolveContext substitute(@NotNull OCTypeSubstitution substitution, boolean overwriteSubstitution, boolean createIfID) {
        if (substitution == null) {
            OCResolveContext.$$$reportNull$$$0(16);
        }
        if (substitution != OCTypeSubstitution.ID || createIfID) {
            OCResolveContext result = new OCResolveContext(this, OCTypeSubstitution.compose(this.mySubstitution, substitution, overwriteSubstitution));
            result.setProcessNonImported(this.myProcessNonImported);
            OCResolveContext oCResolveContext = result;
            if (oCResolveContext == null) {
                OCResolveContext.$$$reportNull$$$0(17);
            }
            return oCResolveContext;
        }
        OCResolveContext oCResolveContext = this;
        if (oCResolveContext == null) {
            OCResolveContext.$$$reportNull$$$0(18);
        }
        return oCResolveContext;
    }

    @NotNull
    public OCResolveContext substituteFirst(@NotNull OCTypeSubstitution substitution) {
        if (substitution == null) {
            OCResolveContext.$$$reportNull$$$0(19);
        }
        if (substitution != OCTypeSubstitution.ID) {
            OCResolveContext result = new OCResolveContext(this, OCTypeSubstitution.compose(substitution, this.mySubstitution, false));
            result.setProcessNonImported(this.myProcessNonImported);
            OCResolveContext oCResolveContext = result;
            if (oCResolveContext == null) {
                OCResolveContext.$$$reportNull$$$0(20);
            }
            return oCResolveContext;
        }
        OCResolveContext oCResolveContext = this;
        if (oCResolveContext == null) {
            OCResolveContext.$$$reportNull$$$0(21);
        }
        return oCResolveContext;
    }

    @NotNull
    public OCResolveContext useFor(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            OCResolveContext.$$$reportNull$$$0(22);
        }
        OCTypeSubstitution substitution = this.mySubstitution.getMinimalDependentSubstitution(symbol, this);
        substitution = symbol instanceof OCSymbolWithSubstitution ? OCTypeSubstitution.compose(substitution, ((OCSymbolWithSubstitution)((Object)symbol)).getSubstitution(), false) : substitution;
        OCResolveContext result = new OCResolveContext(this, substitution);
        result.setProcessNonImported(this.myProcessNonImported);
        OCResolveContext oCResolveContext = result;
        if (oCResolveContext == null) {
            OCResolveContext.$$$reportNull$$$0(23);
        }
        return oCResolveContext;
    }

    @NotNull
    public OCResolveContext useFor(@NotNull OCTypeArgument argument, @NotNull OCTypeSubstitution substitution) {
        if (argument == null) {
            OCResolveContext.$$$reportNull$$$0(24);
        }
        if (substitution == null) {
            OCResolveContext.$$$reportNull$$$0(25);
        }
        substitution = OCTypeSubstitution.compose(this.mySubstitution, substitution, false).getMinimalDependentSubstitution(argument, this);
        OCResolveContext result = new OCResolveContext(this, substitution);
        result.setProcessNonImported(this.myProcessNonImported);
        OCResolveContext oCResolveContext = result;
        if (oCResolveContext == null) {
            OCResolveContext.$$$reportNull$$$0(26);
        }
        return oCResolveContext;
    }

    @NotNull
    public OCResolveContext clearSubstitution() {
        OCResolveContext result = new OCResolveContext(this, OCTypeSubstitution.ID);
        result.setProcessNonImported(this.myProcessNonImported);
        OCResolveContext oCResolveContext = result;
        if (oCResolveContext == null) {
            OCResolveContext.$$$reportNull$$$0(27);
        }
        return oCResolveContext;
    }

    @NotNull
    public OCResolveContext clone() {
        OCResolveContext oCResolveContext = new OCResolveContext(this, this.mySubstitution);
        if (oCResolveContext == null) {
            OCResolveContext.$$$reportNull$$$0(28);
        }
        return oCResolveContext;
    }

    public int getNestingDepth() {
        return this.myDepth;
    }

    public OCExpressionEvaluator.ValueEvaluator getEvaluator() {
        return new OCExpressionEvaluator.ValueEvaluator(this.myEvaluator, this);
    }

    public boolean isProcessNonImported() {
        return this.myProcessNonImported || this.myOriginalContext != null && this.myOriginalContext.isProcessNonImported();
    }

    public boolean isResolveBelow() {
        return this.myResolveBelow;
    }

    public boolean isInSFINAE() {
        return this.myInSFINAE || this.myOriginalContext != null && this.myOriginalContext.isInSFINAE();
    }

    public boolean isOriginallyProcessNonImported() {
        return this.myOriginallyProcessNonImported || this.myOriginalContext != null && this.myOriginalContext.isOriginallyProcessNonImported();
    }

    public boolean isDontExpandVariadics() {
        return this.myDontExpandVariadics || this.myOriginalContext != null && this.myOriginalContext.isDontExpandVariadics();
    }

    public void setDontExpandVariadics(boolean dontExpandVariadics) {
        this.myDontExpandVariadics = dontExpandVariadics;
    }

    public boolean isVariadicExpansionMode() {
        return this.isVariadicExpansionMode;
    }

    public void setVariadicExpansionMode(boolean variadicExpansionMode) {
        this.isVariadicExpansionMode = variadicExpansionMode;
    }

    public void addTypeDependency(@NotNull OCTypeParameterSymbol dependency) {
        if (dependency == null) {
            OCResolveContext.$$$reportNull$$$0(29);
        }
        this.myTypeDependencies.add(dependency);
    }

    public void addTypeDependencies(@NotNull Set<OCTypeParameterSymbol> typeDependencies) {
        if (typeDependencies == null) {
            OCResolveContext.$$$reportNull$$$0(30);
        }
        this.myTypeDependencies.addAll(typeDependencies);
    }

    @NotNull
    public Set<OCTypeParameterSymbol> getTypeDependencies() {
        HashSet<OCTypeParameterSymbol> hashSet = new HashSet<OCTypeParameterSymbol>(this.myTypeDependencies);
        if (hashSet == null) {
            OCResolveContext.$$$reportNull$$$0(31);
        }
        return hashSet;
    }

    @NotNull
    public Set<OCTypeParameterSymbol> getTypeDependencies(@Nullable OCType extraDependenciesSource) {
        final HashSet<OCTypeParameterSymbol> dependencies = new HashSet<OCTypeParameterSymbol>(this.myTypeDependencies);
        if (extraDependenciesSource != null) {
            extraDependenciesSource.accept(new OCBooleanTypeVisitor(){

                @Override
                public Boolean visitTypeParameterType(OCTypeParameterType type) {
                    dependencies.add(type.getSymbol());
                    return true;
                }
            });
        }
        HashSet<OCTypeParameterSymbol> hashSet = dependencies;
        if (hashSet == null) {
            OCResolveContext.$$$reportNull$$$0(32);
        }
        return hashSet;
    }

    public void setTypeDependencies(@NotNull Set<OCTypeParameterSymbol> typeDependencies) {
        if (typeDependencies == null) {
            OCResolveContext.$$$reportNull$$$0(33);
        }
        this.myTypeDependencies = typeDependencies;
    }

    public void clearTypeDependencies() {
        this.myTypeDependencies.clear();
    }

    public boolean wasDependentType() {
        return !this.myTypeDependencies.isEmpty() || this.myOriginalContext != null && this.myOriginalContext.wasDependentType();
    }

    public int getTypeResolveCounter() {
        return (Integer)this.myTypeResolveCounter.get();
    }

    public void incTypeResolveCounter() {
        this.myTypeResolveCounter.set((Object)((Integer)this.myTypeResolveCounter.get() + 1));
    }

    public void setProcessNonImported(boolean processNonImported) {
        this.myProcessNonImported = processNonImported;
        if (this.myProcessNonImported) {
            this.myOriginallyProcessNonImported = true;
        }
        if (this.myOriginalContext != null) {
            this.myOriginalContext.setProcessNonImported(processNonImported);
        }
    }

    public void setResolveBelow(boolean resolveBelow) {
        this.myResolveBelow = resolveBelow;
    }

    public void setInSFINAE(boolean inSFINAE) {
        this.myInSFINAE = inSFINAE;
        if (this.myOriginalContext != null) {
            this.myOriginalContext.setInSFINAE(inSFINAE);
        }
    }

    public void setIncompleteMode(boolean incompleteMode) {
        this.myIncompleteMode = incompleteMode;
    }

    public boolean isIncompleteMode() {
        return this.myIncompleteMode;
    }

    public void setDontUseSymbolContextsInDepends(boolean flag) {
        this.myDontUseSymbolContextsInDepends = flag;
    }

    public boolean dontUseSymbolContextsInDepends() {
        return this.myDontUseSymbolContextsInDepends;
    }

    public static boolean setNonImportedFlag(@NotNull OCResolveContext context, boolean value) {
        if (context == null) {
            OCResolveContext.$$$reportNull$$$0(34);
        }
        boolean result = context.isProcessNonImported();
        context.setProcessNonImported(value);
        return result;
    }

    public static boolean setInSFINAEFlag(@NotNull OCResolveContext context, boolean value) {
        if (context == null) {
            OCResolveContext.$$$reportNull$$$0(35);
        }
        boolean result = context.isInSFINAE();
        context.setInSFINAE(value);
        return result;
    }

    public OCTypeParameterType getAutoParamTypeMapping(OCAutoType type) {
        return this.myAutoParamsTypeMapping != null ? (OCTypeParameterType)this.myAutoParamsTypeMapping.get(type) : null;
    }

    public void setAutoParamsTypeMapping(Map<OCType, OCType> autoParamsTypeMapping) {
        this.myAutoParamsTypeMapping = autoParamsTypeMapping;
    }

    @Nullable
    public OCTypeParameterValueSymbol getAutoParamValueMapping(@NotNull OCDeclaratorSymbol symbol) {
        if (symbol == null) {
            OCResolveContext.$$$reportNull$$$0(36);
        }
        return this.myAutoParamsValueMapping != null ? this.myAutoParamsValueMapping.get(symbol) : null;
    }

    public void setAutoParamsValueMapping(Map<OCDeclaratorSymbol, OCTypeParameterValueSymbol> autoParamsValueMapping) {
        this.myAutoParamsValueMapping = autoParamsValueMapping;
    }

    public void incTemplateSubstitutionsCnt() {
        ++this.myTemplateSubstitutionsCnt;
        if (this.myOriginalContext != null) {
            this.myOriginalContext.incTemplateSubstitutionsCnt();
        }
    }

    public int getTemplateSubstitutionsCnt() {
        return this.myTemplateSubstitutionsCnt;
    }

    @Override
    public boolean isCpp() {
        return !OCCodeInsightUtil.isInPlainOldC(this.myElement);
    }

    public boolean isObjc() {
        return OCCodeInsightUtil.isInObjC(this.myElement);
    }

    public void pushOuterFunction(@NotNull OCFunctionSymbol functionSymbol) {
        if (functionSymbol == null) {
            OCResolveContext.$$$reportNull$$$0(37);
        }
        this.myOuterFunctions.push(functionSymbol);
    }

    public void popOuterFunction() {
        this.myOuterFunctions.pop();
    }

    @Nullable
    public OCFunctionSymbol peekOuterFunction() {
        return this.myOuterFunctions.isEmpty() ? null : this.myOuterFunctions.peek();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/OCResolveContext";
                break;
            }
            case 2: 
            case 22: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 10: 
            case 14: 
            case 16: 
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitution";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeDependencies";
                break;
            }
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionSymbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/OCResolveContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "empty";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "forSymbol";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "forPsi";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "forNullablePsi";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyContextWithoutProject";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitution";
                break;
            }
            case 15: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "substitute";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteFirst";
                break;
            }
            case 23: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "useFor";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "clearSubstitution";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "empty";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "forSymbol";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "forPsi";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "forNullablePsi";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "substitute";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "substituteFirst";
                break;
            }
            case 22: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "useFor";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addTypeDependency";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addTypeDependencies";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "setTypeDependencies";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "setNonImportedFlag";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "setInSFINAEFlag";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getAutoParamValueMapping";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "pushOuterFunction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

