/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.navigation.PsiElementNavigationItem;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.ComplexTextRange;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.ProjectAndVirtualFileOwner;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import java.io.Serializable;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OCSymbol<T extends PsiElement>
extends OCTypeOwner,
PsiElementNavigationItem,
Comparable<OCSymbol>,
DataProvider,
Serializable,
ProjectAndVirtualFileOwner,
DeepEqual.Equality {
    public static final String UNNAMED = "<unnamed>";
    public static final Condition<OCSymbol> NON_PREDIFINITION_CONDITION = symbol -> !symbol.isPredeclaration();
    public static final Condition<OCSymbol> NON_FANTOM_SYMBOL_CONDITION = symbol -> symbol.getContainingFile() != null || symbol.getOffset() != 0;

    @NotNull
    public OCType getType();

    @Override
    @NotNull
    public OCType getResolvedType(@NotNull OCResolveContext var1);

    public OCType getResolvedType(@NotNull OCResolveContext var1, boolean var2);

    public boolean isGlobal();

    public boolean isTopLevel();

    public boolean isCallable();

    public boolean isDefinition();

    public boolean isPredeclaration();

    @NotNull
    public List<String> getAttributes();

    public void addAttributes(List<String> var1);

    public boolean isUnnamed();

    public Object getData(@NonNls String var1);

    @Nullable
    public T locateDefinition(@NotNull Project var1);

    public void compact();

    @NotNull
    public String getName();

    @NotNull
    public String getSignature(@NotNull Project var1);

    @NotNull
    public String getPresentableName();

    @Nullable
    public String getLocationString();

    public boolean isSynthetic();

    @NotNull
    public OCSymbolKind getKind();

    @NotNull
    public String getNameWithKindLowercase(@NotNull OCCompilationContext var1);

    @NotNull
    public String getNameWithKindUppercase(@NotNull OCCompilationContext var1);

    public String getKindLowercase(@NotNull OCCompilationContext var1);

    public String getKindUppercase(@NotNull OCCompilationContext var1);

    @Nullable
    public OCSymbol getDefinitionSymbol(@NotNull Project var1);

    public boolean processAssociatedSymbols(Processor<OCSymbol> var1, @NotNull Project var2);

    @Nullable
    public OCSymbol getAssociatedSymbol(@NotNull Project var1);

    public boolean processSameSymbols(Processor<OCSymbol> var1, @NotNull Project var2);

    @Nullable
    public PsiFile getContainingPsiFile(@NotNull Project var1);

    @Nullable
    public OCFile getContainingOCFile(@NotNull Project var1);

    default public int getOffset() {
        return OCSymbolOffsetUtil.getTextOffset(this.getComplexOffset());
    }

    public long getComplexOffset();

    default public void setComplexOffset(long complexOffset) {
    }

    @Nullable
    default public ComplexTextRange getScope() {
        return null;
    }

    default public void setScope(@NotNull ComplexTextRange scope) {
        if (scope == null) {
            OCSymbol.$$$reportNull$$$0(0);
        }
    }

    default public void updateOffset(int start, int lengthShift) {
        if (this.getOffset() > start) {
            this.setComplexOffset(OCSymbolOffsetUtil.shift(this.getComplexOffset(), lengthShift));
        }
        if (this.getScope() != null) {
            this.setScope(OCSymbolOffsetUtil.shift(this.getScope(), start, lengthShift));
        }
    }

    @Nullable
    public Icon getIcon(@NotNull Project var1);

    @Nullable
    public Icon getBaseIcon();

    @Nullable
    public Icon computeFullIconNow(@Nullable T var1, @NotNull Project var2);

    public boolean isSameSymbol(@Nullable OCSymbol var1, @NotNull Project var2);

    public int hashCodeExcludingOffset();

    public OCType getEffectiveType();

    @NotNull
    public OCType getEffectiveResolvedType(@NotNull OCResolveContext var1);

    public boolean isDeprecated();

    public String getDeprecatedMessage(@NotNull OCCompilationContext var1);

    public boolean isUnavailable();

    public String getUnavailableMessage(@NotNull OCCompilationContext var1);

    public boolean isForbiddenByARC(@NotNull PsiElement var1);

    public boolean isTransparentUnion();

    public boolean hasAttribute(String var1);

    @Nullable
    public String getAttributeParameters(String var1);

    @NotNull
    public OCSymbol<?> getDelegate();

    @NotNull
    public String getPresentableText();

    @Override
    @NotNull
    public Project getProject();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/jetbrains/cidr/lang/symbols/OCSymbol", "setScope"));
    }
}

