/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.IconDeferrer;
import com.intellij.util.Processor;
import com.intellij.util.PsiNavigateUtil;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.OCAttributes;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCSymbolBase<T extends PsiElement>
implements OCSymbol<T> {
    private static final String ATTRIBUTE_FORBIDDEN_BY_ARC_MESSAGE = "\"not available in automatic reference counting mode\"";
    @Deprecated
    @NotNull
    protected transient Project myProject;
    @Nullable
    protected transient VirtualFile myFile;
    protected long myComplexOffset;

    public OCSymbolBase(@NotNull Project project2, @Nullable VirtualFile file, long complexOffset) {
        if (project2 == null) {
            OCSymbolBase.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
        this.myFile = file;
        this.myComplexOffset = complexOffset;
    }

    public OCSymbolBase() {
    }

    @NotNull
    public static String getSymbolName(@Nullable OCSymbol symbol) {
        String string = symbol == null ? "<unnamed>" : symbol.getName();
        if (string == null) {
            OCSymbolBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String getTagOfStructLike(OCSymbol symbol) {
        String kind = symbol.getKind().getNameLowercase() + " ";
        String name2 = symbol.getPresentableName();
        if (name2.startsWith(kind)) {
            String string = name2.substring(kind.length());
            if (string == null) {
                OCSymbolBase.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = name2;
        if (string == null) {
            OCSymbolBase.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public static <T extends OCSymbol> T findSymbolDefinition(String name2, OCSymbolKind symbolKind, Project project2, VirtualFile context) {
        return OCSymbolBase.findSymbolDefinition(name2, symbolKind, project2, context, null);
    }

    @Nullable
    public static <T extends OCSymbol> T findSymbolDefinition(String name2, OCSymbolKind symbolKind, Project project2, VirtualFile context, @Nullable Condition<T> condition) {
        return (T)OCGlobalProjectSymbolsCache.findNearestTopLevelSymbol(project2, name2, (Condition<OCSymbol>)((Condition)symbol -> symbol.getKind() == symbolKind && !symbol.isPredeclaration() && (condition == null || condition.value(symbol))), context);
    }

    @Override
    public void init(@Nullable Project project2, @Nullable VirtualFile file) {
        this.myProject = project2;
        this.myFile = file;
    }

    @Override
    @NotNull
    public OCType getType() {
        OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
        if (oCUnknownType == null) {
            OCSymbolBase.$$$reportNull$$$0(4);
        }
        return oCUnknownType;
    }

    @Override
    @NotNull
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        if (context == null) {
            OCSymbolBase.$$$reportNull$$$0(5);
        }
        OCType oCType = this.getType().resolve(context);
        if (oCType == null) {
            OCSymbolBase.$$$reportNull$$$0(6);
        }
        return oCType;
    }

    @Override
    public OCType getResolvedType(@NotNull OCResolveContext context, boolean ignoringImports) {
        if (context == null) {
            OCSymbolBase.$$$reportNull$$$0(7);
        }
        return this.getType().resolve(context, ignoringImports);
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public boolean isTopLevel() {
        return this.isGlobal();
    }

    @Override
    public boolean isCallable() {
        return this.getKind().isCallable();
    }

    @Override
    public boolean isDefinition() {
        return !this.isPredeclaration();
    }

    @Override
    public boolean isPredeclaration() {
        return this.getKind().isPredeclaration();
    }

    @Override
    public boolean isUnnamed() {
        return "<unnamed>".equals(this.getName());
    }

    protected Class<? extends T> getPsiElementClass() {
        return this.getKind().getPsiElementClass();
    }

    @Override
    public Object getData(@NonNls String dataId) {
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return new OCSymbolHolderVirtualPsiElement(this, this.getProject());
        }
        return null;
    }

    @Override
    @Nullable
    public T locateDefinition(@NotNull Project project2) {
        if (project2 == null) {
            OCSymbolBase.$$$reportNull$$$0(8);
        }
        Class<T> elementClass = this.getPsiElementClass();
        if (this.myFile == null || !this.myFile.isValid()) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(this.myFile);
        if (psiFile == null) {
            return null;
        }
        PsiElement cur = psiFile.findElementAt(this.getOffset());
        if (cur == null) {
            return null;
        }
        cur = PsiTreeUtil.getDeepestLast((PsiElement)cur);
        while (cur != null) {
            long symbolComplexOffset;
            long curComplexOffset = OCSymbolOffsetUtil.getComplexOffset(cur);
            if (curComplexOffset == (symbolComplexOffset = this.getComplexOffset())) {
                T definitionAtPrev;
                T definitionAtCur = OCSymbolBase.findParentDefinition(cur, elementClass, symbolComplexOffset);
                if (definitionAtCur != null) {
                    return definitionAtCur;
                }
                if (this.isUnnamed() && (definitionAtPrev = OCSymbolBase.findParentDefinition(PsiTreeUtil.prevLeaf((PsiElement)cur), elementClass, symbolComplexOffset)) != null) {
                    return definitionAtPrev;
                }
                return null;
            }
            if (OCSymbolOffsetUtil.getTextOffset(curComplexOffset) != OCSymbolOffsetUtil.getTextOffset(symbolComplexOffset)) {
                return null;
            }
            cur = PsiTreeUtil.prevLeaf((PsiElement)cur);
        }
        return null;
    }

    @Nullable
    private static <T extends PsiElement> T findParentDefinition(@Nullable PsiElement cur, @NotNull Class<T> elementClass, long symbolComplexOffset) {
        if (elementClass == null) {
            OCSymbolBase.$$$reportNull$$$0(9);
        }
        if (cur == null) {
            return null;
        }
        PsiElement parent = cur;
        do {
            if (!elementClass.isInstance(parent) || OCSymbolOffsetUtil.getVirtualComplexOffset(parent) != symbolComplexOffset) continue;
            return (T)parent;
        } while ((parent = PsiTreeUtil.getParentOfType((PsiElement)parent, elementClass, (boolean)true)) != null);
        return null;
    }

    @Override
    @NotNull
    public String getSignature(@NotNull Project project2) {
        if (project2 == null) {
            OCSymbolBase.$$$reportNull$$$0(10);
        }
        String string = this.getPresentableName();
        if (string == null) {
            OCSymbolBase.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = this.getName();
        if (string == null) {
            OCSymbolBase.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    @NotNull
    public String getPresentableText() {
        String string = this.getPresentableName();
        if (string == null) {
            OCSymbolBase.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    @Nullable
    public String getLocationString() {
        return this.myFile == null ? null : this.myFile.getName();
    }

    @Override
    public boolean isSynthetic() {
        return false;
    }

    public String toString() {
        return (Object)((Object)this.getKind()) + "[" + this.getPresentableName() + "]@" + (this.getContainingFile() != null ? this.getContainingFile().getName() + ":" : "") + this.getOffset();
    }

    @Override
    @NotNull
    public abstract OCSymbolKind getKind();

    @Override
    @NotNull
    public String getNameWithKindLowercase(@NotNull OCCompilationContext context) {
        if (context == null) {
            OCSymbolBase.$$$reportNull$$$0(14);
        }
        String string = this.getKindLowercase(context) + " '" + this.getPresentableName() + "'";
        if (string == null) {
            OCSymbolBase.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Override
    @NotNull
    public String getNameWithKindUppercase(@NotNull OCCompilationContext context) {
        if (context == null) {
            OCSymbolBase.$$$reportNull$$$0(16);
        }
        String string = this.getKindUppercase(context) + " '" + this.getPresentableName() + "'";
        if (string == null) {
            OCSymbolBase.$$$reportNull$$$0(17);
        }
        return string;
    }

    @Override
    public String getKindLowercase(@NotNull OCCompilationContext context) {
        if (context == null) {
            OCSymbolBase.$$$reportNull$$$0(18);
        }
        return StringUtil.decapitalize((String)this.getKindUppercase(context));
    }

    @Override
    public String getKindUppercase(@NotNull OCCompilationContext context) {
        if (context == null) {
            OCSymbolBase.$$$reportNull$$$0(19);
        }
        return this.getKind().getNameUppercase();
    }

    @Override
    @Nullable
    public OCSymbol getDefinitionSymbol(@NotNull Project project2) {
        if (project2 == null) {
            OCSymbolBase.$$$reportNull$$$0(20);
        }
        if (this.isPredeclaration()) {
            return OCSymbolBase.findSymbolDefinition(this.getName(), this.getKind(), project2, this.myFile);
        }
        return this;
    }

    @Override
    public boolean processAssociatedSymbols(Processor<OCSymbol> processor2, @NotNull Project project2) {
        OCSymbol associatedSymbol;
        if (project2 == null) {
            OCSymbolBase.$$$reportNull$$$0(21);
        }
        return (associatedSymbol = this.getAssociatedSymbol(project2)) == null || processor2.process((Object)associatedSymbol);
    }

    @Override
    @Nullable
    public OCSymbol getAssociatedSymbol(@NotNull Project project2) {
        if (project2 == null) {
            OCSymbolBase.$$$reportNull$$$0(22);
        }
        return null;
    }

    @Override
    public boolean processSameSymbols(Processor<OCSymbol> processor2, @NotNull Project project2) {
        if (project2 == null) {
            OCSymbolBase.$$$reportNull$$$0(23);
        }
        return OCGlobalProjectSymbolsCache.processTopLevelSymbols(project2, (Processor<OCSymbol>)((Processor)symbol -> symbol.getClass() != this.getClass() || processor2.process(symbol)), this.getName());
    }

    @Override
    @Nullable
    public VirtualFile getContainingFile() {
        return this.myFile;
    }

    @Override
    @Nullable
    public PsiFile getContainingPsiFile(@NotNull Project project2) {
        VirtualFile containingFile;
        if (project2 == null) {
            OCSymbolBase.$$$reportNull$$$0(24);
        }
        if ((containingFile = this.getContainingFile()) != null && containingFile.isValid()) {
            return PsiManager.getInstance((Project)project2).findFile(containingFile);
        }
        return null;
    }

    @Override
    @Nullable
    public OCFile getContainingOCFile(@NotNull Project project2) {
        PsiFile file;
        if (project2 == null) {
            OCSymbolBase.$$$reportNull$$$0(25);
        }
        return (file = this.getContainingPsiFile(project2)) instanceof OCFile ? (OCFile)file : null;
    }

    @Override
    public long getComplexOffset() {
        return this.myComplexOffset;
    }

    @Override
    public void setComplexOffset(long complexOffset) {
        this.myComplexOffset = complexOffset;
    }

    @Deprecated
    public PsiElement getTargetElement() {
        return new OCSymbolHolderVirtualPsiElement(this, this.getProject());
    }

    @Override
    @Deprecated
    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            OCSymbolBase.$$$reportNull$$$0(26);
        }
        return project2;
    }

    public void navigate(boolean requestFocus) {
        PsiNavigateUtil.navigate(this.locateDefinition(this.getProject()));
    }

    public boolean canNavigate() {
        return this.locateDefinition(this.getProject()) != null;
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @Override
    @Nullable
    public Icon getIcon(@NotNull Project project2) {
        if (project2 == null) {
            OCSymbolBase.$$$reportNull$$$0(27);
        }
        if (Registry.is((String)"psi.deferIconLoading")) {
            return IconDeferrer.getInstance().defer(this.getBaseIcon(), (Object)this, symbol -> {
                if (project2 == null) {
                    OCSymbolBase.$$$reportNull$$$0(38);
                }
                return this.computeFullIconNow(null, project2);
            });
        }
        return this.computeFullIconNow(null, project2);
    }

    @Override
    @Nullable
    public Icon getBaseIcon() {
        return this.getKind().getIcon();
    }

    @Override
    @Nullable
    public Icon computeFullIconNow(@Nullable T symbolElement, @NotNull Project project2) {
        if (project2 == null) {
            OCSymbolBase.$$$reportNull$$$0(28);
        }
        return this.getBaseIcon();
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                return OCSymbolBase.this.getPresentableText();
            }

            public String getLocationString() {
                return OCSymbolBase.this.getLocationString();
            }

            public Icon getIcon(boolean open) {
                return OCSymbolBase.this.getIcon(OCSymbolBase.this.getProject());
            }
        };
    }

    @Override
    public boolean isSameSymbol(@Nullable OCSymbol symbol, @NotNull Project project2) {
        if (project2 == null) {
            OCSymbolBase.$$$reportNull$$$0(29);
        }
        return this.equals(symbol);
    }

    public int hashCode() {
        int result = this.hashCodeExcludingOffset();
        result = 31 * result + this.getOffset();
        return result;
    }

    @Override
    public int compareTo(OCSymbol symbol) {
        return this.getPresentableName().compareTo(symbol.getPresentableName());
    }

    @Override
    public OCType getEffectiveType() {
        return this.getType();
    }

    @Override
    @NotNull
    public OCType getEffectiveResolvedType(@NotNull OCResolveContext context) {
        if (context == null) {
            OCSymbolBase.$$$reportNull$$$0(30);
        }
        OCType oCType = this.getResolvedType(context);
        if (oCType == null) {
            OCSymbolBase.$$$reportNull$$$0(31);
        }
        return oCType;
    }

    @Override
    public boolean isDeprecated() {
        return this.hasAttribute("deprecated");
    }

    @Override
    public String getDeprecatedMessage(@NotNull OCCompilationContext context) {
        if (context == null) {
            OCSymbolBase.$$$reportNull$$$0(32);
        }
        String message = this.getNameWithKindUppercase(context) + " is deprecated";
        String parameters = this.getAttributeParameters("deprecated");
        return parameters != null ? message + ": " + StringUtil.unquoteString((String)parameters) : message;
    }

    @Override
    public boolean isUnavailable() {
        return this.hasAttribute("unavailable") && !ATTRIBUTE_FORBIDDEN_BY_ARC_MESSAGE.equals(this.getAttributeParameters("unavailable"));
    }

    @Override
    public String getUnavailableMessage(@NotNull OCCompilationContext context) {
        if (context == null) {
            OCSymbolBase.$$$reportNull$$$0(33);
        }
        String message = this.getNameWithKindUppercase(context) + " is unavailable";
        String parameters = this.getAttributeParameters("unavailable");
        return parameters != null ? message + ": " + StringUtil.unquoteString((String)parameters) : message;
    }

    @Override
    public boolean isForbiddenByARC(@NotNull PsiElement context) {
        if (context == null) {
            OCSymbolBase.$$$reportNull$$$0(34);
        }
        return this.hasAttribute("unavailable") && ATTRIBUTE_FORBIDDEN_BY_ARC_MESSAGE.equals(this.getAttributeParameters("unavailable")) && OCCompilerFeatures.isArcEnabled(context.getContainingFile());
    }

    @Override
    public boolean isTransparentUnion() {
        return this.hasAttribute("transparent_union");
    }

    @Override
    public boolean hasAttribute(@NotNull String attribute) {
        if (attribute == null) {
            OCSymbolBase.$$$reportNull$$$0(35);
        }
        return OCAttributes.hasAttribute(this.getAttributes(), attribute);
    }

    @Override
    @Nullable
    public String getAttributeParameters(@NotNull String attribute) {
        if (attribute == null) {
            OCSymbolBase.$$$reportNull$$$0(36);
        }
        return OCAttributes.getAttributeParameter(this.getAttributes(), attribute);
    }

    @Override
    @NotNull
    public OCSymbol getDelegate() {
        OCSymbolBase oCSymbolBase = this;
        if (oCSymbolBase == null) {
            OCSymbolBase.$$$reportNull$$$0(37);
        }
        return oCSymbolBase;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 26: 
            case 31: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 26: 
            case 31: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 26: 
            case 31: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/OCSymbolBase";
                break;
            }
            case 5: 
            case 7: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 30: 
            case 32: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/OCSymbolBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymbolName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagOfStructLike";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignature";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameWithKindLowercase";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameWithKindUppercase";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveResolvedType";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 26: 
            case 31: 
            case 37: {
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "locateDefinition";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findParentDefinition";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSignature";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getNameWithKindLowercase";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getNameWithKindUppercase";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getKindLowercase";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getKindUppercase";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDefinitionSymbol";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processAssociatedSymbols";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedSymbol";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processSameSymbols";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getContainingPsiFile";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getContainingOCFile";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "computeFullIconNow";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isSameSymbol";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveResolvedType";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getDeprecatedMessage";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getUnavailableMessage";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isForbiddenByARC";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "hasAttribute";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeParameters";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getIcon$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 26: 
            case 31: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

