/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCSymbolGroupContext {
    public static final OCSymbolGroupContext CLASS_CONTEXT = new OCSymbolGroupContext("class", OCSymbolKind.INTERFACE, OCSymbolKind.IMPLEMENTATION, OCSymbolKind.COMPATIBILITY_ALIAS);
    public static final OCSymbolGroupContext PROTOCOL_CONTEXT = new OCSymbolGroupContext("protocol", OCSymbolKind.PROTOCOL);
    private static final OCSymbolGroupContext C_TYPE_CONTEXT = new OCSymbolGroupContext("type", OCSymbolKind.TYPEDEF, OCSymbolKind.STRUCT, OCSymbolKind.UNION, OCSymbolKind.ENUM, OCSymbolKind.BUILTIN_SYMBOL);
    private static final OCSymbolGroupContext OBJC_TYPE_CONTEXT = new OCSymbolGroupContext("type", OCSymbolKind.INTERFACE, OCSymbolKind.IMPLEMENTATION, OCSymbolKind.COMPATIBILITY_ALIAS, OCSymbolKind.USING_SYMBOL_ALIAS, OCSymbolKind.TYPEDEF, OCSymbolKind.STRUCT, OCSymbolKind.UNION, OCSymbolKind.ENUM, OCSymbolKind.BUILTIN_SYMBOL, OCSymbolKind.GENERIC_PARAMETER);
    private static final OCSymbolGroupContext CPP_TYPE_CONTEXT = new OCSymbolGroupContext("type", OCSymbolKind.TYPEDEF, OCSymbolKind.STRUCT, OCSymbolKind.UNION, OCSymbolKind.ENUM, OCSymbolKind.TEMPLATE_TYPE_PARAMETER, OCSymbolKind.SYMBOL_USING_SYMBOL, OCSymbolKind.USING_SYMBOL_ALIAS, OCSymbolKind.BUILTIN_SYMBOL);
    private static final OCSymbolGroupContext OBJCPP_TYPE_CONTEXT = new OCSymbolGroupContext("type", OCSymbolKind.INTERFACE, OCSymbolKind.IMPLEMENTATION, OCSymbolKind.COMPATIBILITY_ALIAS, OCSymbolKind.USING_SYMBOL_ALIAS, OCSymbolKind.TYPEDEF, OCSymbolKind.STRUCT, OCSymbolKind.UNION, OCSymbolKind.ENUM, OCSymbolKind.TEMPLATE_TYPE_PARAMETER, OCSymbolKind.SYMBOL_USING_SYMBOL, OCSymbolKind.BUILTIN_SYMBOL, OCSymbolKind.GENERIC_PARAMETER);
    public static final OCSymbolGroupContext CONSTRUCTOR_CONTEXT = new OCSymbolGroupContext("constructor", OCSymbolKind.CPP_CONSTRUCTOR_DECLARATION, OCSymbolKind.CPP_CONSTRUCTOR_PREDECLARATION, OCSymbolKind.TYPEDEF, OCSymbolKind.STRUCT, OCSymbolKind.UNION, OCSymbolKind.ENUM, OCSymbolKind.TEMPLATE_TYPE_PARAMETER, OCSymbolKind.SYMBOL_USING_SYMBOL, OCSymbolKind.USING_SYMBOL_ALIAS, OCSymbolKind.BUILTIN_SYMBOL);
    public static final OCSymbolGroupContext MACRO_OR_MACRO_PARAMETER_CONTEXT = new OCSymbolGroupContext("macro or macro parameter", OCSymbolKind.MACRO, OCSymbolKind.MACRO_PARAMETER, OCSymbolKind.BUILTIN_SYMBOL);
    public static final OCSymbolGroupContext MACRO_OR_UNDEF_OR_MACRO_PARAMETER_CONTEXT = new OCSymbolGroupContext("macro or macro parameter", OCSymbolKind.MACRO, OCSymbolKind.UNDEF_MACRO, OCSymbolKind.MACRO_PARAMETER);
    public static final OCSymbolGroupContext MACRO_CONTEXT = new OCSymbolGroupContext("macro", OCSymbolKind.MACRO, OCSymbolKind.BUILTIN_SYMBOL, OCSymbolKind.COMPATIBILITY_ALIAS);
    public static final OCSymbolGroupContext STRUCT_FIELD_CONTEXT = new OCSymbolGroupContext("struct field", OCSymbolKind.STRUCT_FIELD);
    public static final OCSymbolGroupContext LABEL_CONTEXT = new OCSymbolGroupContext(new OCSymbolContext(null, OCSymbolKind.LABEL, null));
    private final String myName;
    private final List<OCSymbolContext> mySymbolContexts;

    public static OCSymbolGroupContext typeContext(OCLanguageKind kind) {
        if (kind.isCpp()) {
            return kind.isObjC() ? OBJCPP_TYPE_CONTEXT : CPP_TYPE_CONTEXT;
        }
        return kind.isObjC() ? OBJC_TYPE_CONTEXT : C_TYPE_CONTEXT;
    }

    public OCSymbolGroupContext(String name2, OCSymbolKind ... symbolKinds) {
        this.myName = name2;
        this.mySymbolContexts = new ArrayList<OCSymbolContext>();
        for (OCSymbolKind symbolKind : symbolKinds) {
            this.mySymbolContexts.add(new OCSymbolContext(null, symbolKind, null));
        }
    }

    public OCSymbolGroupContext(OCSymbolKind ... symbolKinds) {
        this.myName = "";
        this.mySymbolContexts = new ArrayList<OCSymbolContext>();
        for (OCSymbolKind symbolKind : symbolKinds) {
            this.mySymbolContexts.add(new OCSymbolContext(null, symbolKind, null));
        }
    }

    public OCSymbolGroupContext(@NotNull OCSymbolContext symbolContext) {
        if (symbolContext == null) {
            OCSymbolGroupContext.$$$reportNull$$$0(0);
        }
        this.myName = symbolContext.getName();
        this.mySymbolContexts = new ArrayList<OCSymbolContext>();
        this.addSymbolContext(symbolContext);
    }

    public static OCSymbolGroupContext union(OCSymbolGroupContext group, OCSymbolContext ... symbols) {
        if (symbols == null) {
            OCSymbolGroupContext.$$$reportNull$$$0(1);
        }
        if (group == null) {
            return null;
        }
        OCSymbolGroupContext result = new OCSymbolGroupContext(new OCSymbolKind[0]);
        for (OCSymbolContext context : group.getSymbolContexts()) {
            result.addSymbolContext(context);
        }
        for (OCSymbolContext context : symbols) {
            result.addSymbolContext(context);
        }
        return result;
    }

    public static OCSymbolGroupContext union(OCSymbolGroupContext group, OCSymbolKind ... kinds) {
        if (group == null) {
            return null;
        }
        OCSymbolGroupContext result = new OCSymbolGroupContext(new OCSymbolKind[0]);
        for (OCSymbolContext context : group.getSymbolContexts()) {
            result.addSymbolContext(context);
        }
        for (OCSymbolKind kind : kinds) {
            result.addSymbolContext(kind);
        }
        return result;
    }

    public static OCSymbolGroupContext union(OCSymbolGroupContext group1, OCSymbolGroupContext group2) {
        OCSymbolGroupContext result = new OCSymbolGroupContext(new OCSymbolKind[0]);
        result.addSymbolContexts(group1.getSymbolContexts());
        result.addSymbolContexts(group2.getSymbolContexts());
        return result;
    }

    public void addSymbolContext(OCSymbolKind kind) {
        this.mySymbolContexts.add(new OCSymbolContext(null, kind, null));
    }

    public void addSymbolContext(@NotNull OCSymbolContext symbolContext) {
        if (symbolContext == null) {
            OCSymbolGroupContext.$$$reportNull$$$0(2);
        }
        this.mySymbolContexts.add(symbolContext);
    }

    public void addSymbolContexts(List<OCSymbolContext> symbolContexts) {
        this.mySymbolContexts.addAll(symbolContexts);
    }

    public List<OCSymbolContext> getSymbolContexts() {
        return this.mySymbolContexts;
    }

    public boolean isSuitableSymbol(OCSymbol symbol) {
        return this.isSuitableSymbolKind(symbol.getKind());
    }

    public boolean isSuitableSymbolKind(OCSymbolKind kind) {
        for (OCSymbolContext symbolContext : this.mySymbolContexts) {
            if (kind != symbolContext.getSymbolKind()) continue;
            return true;
        }
        return false;
    }

    public String getCannotResolveMessagePrefix(@NotNull Project project2) {
        if (project2 == null) {
            OCSymbolGroupContext.$$$reportNull$$$0(3);
        }
        if (this.mySymbolContexts.size() == 1) {
            return this.mySymbolContexts.get(0).getCannotResolveMessagePrefix(project2);
        }
        return "Can't resolve " + this.myName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbols";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/symbols/OCSymbolGroupContext";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "union";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addSymbolContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getCannotResolveMessagePrefix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

