/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCNamespaceQualifierOwner;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithDecltype;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolReferenceResolver;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithSubstitution;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceAliasSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCThisSelfSuperSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterTypeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLambdaExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCGenericParameterSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeResolveVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.ui.OCLongActionUtil;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCDebugUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCSymbolReference
implements Serializable,
DeepEqual.Equality<OCSymbolReference> {
    public static final int MAX_RESOLVE_NESTING_DEPTH = 256;
    public static final int MAX_DEPENDENT_RESOLVE_NESTING_DEPTH = 6;
    public static final OCElementType[] TYPE_TOKENS = new OCElementType[]{OCTokenTypes.STRUCT_KEYWORD, OCTokenTypes.ENUM_KEYWORD, OCTokenTypes.UNION_KEYWORD, OCTokenTypes.CLASS_KEYWORD};
    @NotNull
    protected OCQualifiedName myQualifiedName;
    @NotNull
    protected SymbolFilter myFilter;
    private static final Key<CachedValue<Map<ReferenceInfo, ResultInfo>>>[] RESOLVE_CACHES = new Key[6];

    @NotNull
    public SymbolFilter getFilter() {
        SymbolFilter symbolFilter = this.myFilter;
        if (symbolFilter == null) {
            OCSymbolReference.$$$reportNull$$$0(0);
        }
        return symbolFilter;
    }

    public OCSymbolReference(@NotNull OCQualifiedName qualifiedName, @NotNull SymbolFilter filter) {
        if (qualifiedName == null) {
            OCSymbolReference.$$$reportNull$$$0(1);
        }
        if (filter == null) {
            OCSymbolReference.$$$reportNull$$$0(2);
        }
        this.myQualifiedName = qualifiedName;
        this.myFilter = filter;
    }

    public OCSymbolReference() {
    }

    @NotNull
    public OCQualifiedName getQualifiedName() {
        OCQualifiedName oCQualifiedName = this.myQualifiedName;
        if (oCQualifiedName == null) {
            OCSymbolReference.$$$reportNull$$$0(3);
        }
        return oCQualifiedName;
    }

    @Nullable
    public abstract VirtualFile getVirtualFile();

    public abstract long getOffset();

    public abstract OCSymbolReference cloneWithOffset(@NotNull OCSymbolReference var1);

    public boolean processPossibleSymbols(Processor<OCSymbol> processor2, boolean filterByTemplates, @NotNull OCResolveContext context) {
        List<OCSymbol> symbols;
        if (context == null) {
            OCSymbolReference.$$$reportNull$$$0(4);
        }
        if ((symbols = this.resolveToSymbols(false, false, true, context)).isEmpty() && !filterByTemplates) {
            symbols = this.resolveToSymbols(false, false, false, context);
        }
        return ContainerUtil.process(symbols, processor2);
    }

    public boolean processPossibleSymbols(Processor<OCSymbol> processor2, @NotNull OCResolveContext context) {
        if (context == null) {
            OCSymbolReference.$$$reportNull$$$0(5);
        }
        return this.processPossibleSymbols(processor2, true, context);
    }

    @NotNull
    public List<OCSymbol> resolveToSymbols(@NotNull OCResolveContext context) {
        if (context == null) {
            OCSymbolReference.$$$reportNull$$$0(6);
        }
        List<OCSymbol> list = this.resolveToSymbols(context, false, true);
        if (list == null) {
            OCSymbolReference.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public List<OCSymbol> resolveToSymbols(boolean processTypedefs, boolean onlyTypes, @NotNull OCResolveContext context) {
        if (context == null) {
            OCSymbolReference.$$$reportNull$$$0(8);
        }
        List<OCSymbol> list = this.resolveToSymbols(processTypedefs, onlyTypes, true, context);
        if (list == null) {
            OCSymbolReference.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public List<OCSymbol> resolveToSymbols(boolean processTypedefs, boolean onlyTypes, boolean resolveSpecialization, @NotNull OCResolveContext context) {
        if (context == null) {
            OCSymbolReference.$$$reportNull$$$0(10);
        }
        List<OCSymbol> symbols = this.resolveToSymbols(context, onlyTypes, resolveSpecialization);
        List<OCSymbol> list = OCSymbolReference.lookupUsingsAndTypedefs(processTypedefs, onlyTypes, context, symbols, this, true, resolveSpecialization);
        if (list == null) {
            OCSymbolReference.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public static List<OCSymbol> lookupUsingsAndTypedefs(boolean processTypedefs, boolean onlyTypes, @NotNull OCResolveContext context, @NotNull List<OCSymbol> symbols, @NotNull OCSymbolReference reference, boolean processTypeParameters, boolean resolveSpecialization) {
        if (context == null) {
            OCSymbolReference.$$$reportNull$$$0(12);
        }
        if (symbols == null) {
            OCSymbolReference.$$$reportNull$$$0(13);
        }
        if (reference == null) {
            OCSymbolReference.$$$reportNull$$$0(14);
        }
        OCQualifiedName qualifiedName = reference.getQualifiedName();
        List<OCTypeArgument> args = null;
        if (qualifiedName instanceof OCQualifiedNameWithArguments) {
            args = ((OCQualifiedNameWithArguments)qualifiedName).getArguments();
        }
        UsingAndTypedefSymbolsResolver resolver = new UsingAndTypedefSymbolsResolver(processTypedefs, processTypeParameters, resolveSpecialization, onlyTypes, args, reference, context);
        ContainerUtil.process(symbols, (Processor)resolver);
        List<OCSymbol> list = resolver.getAnswer();
        if (list == null) {
            OCSymbolReference.$$$reportNull$$$0(15);
        }
        return list;
    }

    public static GlobalReference getDummyGlobalReference(@NotNull OCQualifiedName qualifiedName) {
        if (qualifiedName == null) {
            OCSymbolReference.$$$reportNull$$$0(16);
        }
        return new GlobalReference(qualifiedName, null, null, -1L, SymbolFilter.NONE);
    }

    public static GlobalReference getGlobalReference(@NotNull OCQualifiedName qualifiedName, @Nullable OCSymbolWithQualifiedName symbolContext, @Nullable VirtualFile file, long complexOffset) {
        if (qualifiedName == null) {
            OCSymbolReference.$$$reportNull$$$0(17);
        }
        return new GlobalReference(qualifiedName, symbolContext, file, complexOffset, SymbolFilter.NONE);
    }

    /*
     * WARNING - void declaration
     */
    public static GlobalReference getGlobalReference(@NotNull OCQualifiedName qualifiedName, @Nullable OCSymbolWithQualifiedName symbolContext, @Nullable VirtualFile file, long complexOffset, SymbolFilter symbolFilter) {
        void filter;
        if (qualifiedName == null) {
            OCSymbolReference.$$$reportNull$$$0(18);
        }
        return new GlobalReference(qualifiedName, symbolContext, file, complexOffset, (SymbolFilter)filter);
    }

    public static BaseClauseReference getBaseClauseReference(@NotNull OCQualifiedName qualifiedName, @Nullable OCSymbolWithQualifiedName symbolContext, @Nullable VirtualFile file, long complexOffset) {
        if (qualifiedName == null) {
            OCSymbolReference.$$$reportNull$$$0(19);
        }
        return new BaseClauseReference(qualifiedName, symbolContext, file, complexOffset, SymbolFilter.NONE);
    }

    /*
     * WARNING - void declaration
     */
    public static TemplateArgumentsReference getTemplateArgsReference(@NotNull OCQualifiedName qualifiedName, @Nullable OCSymbolWithQualifiedName symbolContext, @Nullable VirtualFile file, long complexOffset, boolean bl) {
        void specialization;
        if (qualifiedName == null) {
            OCSymbolReference.$$$reportNull$$$0(20);
        }
        return new TemplateArgumentsReference(qualifiedName, symbolContext, file, complexOffset, SymbolFilter.NONE, (boolean)specialization);
    }

    public static LocalReference getLocalReference(@NotNull OCQualifiedName qualifiedName, PsiElement localContext) {
        if (qualifiedName == null) {
            OCSymbolReference.$$$reportNull$$$0(21);
        }
        return new LocalReference(qualifiedName, localContext, SymbolFilter.NONE);
    }

    public static LocalReference getLocalReference(@NotNull OCQualifiedName qualifiedName, PsiElement localContext, SymbolFilter filter) {
        if (qualifiedName == null) {
            OCSymbolReference.$$$reportNull$$$0(22);
        }
        return new LocalReference(qualifiedName, localContext, filter);
    }

    public static LocalReference getLocalReference(String name2, PsiElement element) {
        return OCSymbolReference.getLocalReference(OCQualifiedName.with(name2), element, SymbolFilter.NONE);
    }

    public static LocalReference getLocalReference(@NotNull OCNamespaceQualifierOwner element, SymbolFilter filter) {
        if (element == null) {
            OCSymbolReference.$$$reportNull$$$0(23);
        }
        OCQualifiedName qualifiedName = OCSymbolReferenceResolver.getQualifiedName(element);
        return OCSymbolReference.getLocalReference(qualifiedName, element, filter);
    }

    /*
     * WARNING - void declaration
     */
    public static LambdaLocalReference getLambdaLocalReference(@NotNull OCQualifiedName qualifiedName, long offset, @NotNull OCLambdaExpressionSymbol lambda2, @NotNull OCSymbolReference oCSymbolReference) {
        void parentScopeReference;
        if (qualifiedName == null) {
            OCSymbolReference.$$$reportNull$$$0(24);
        }
        if (lambda2 == null) {
            OCSymbolReference.$$$reportNull$$$0(25);
        }
        if (oCSymbolReference == null) {
            OCSymbolReference.$$$reportNull$$$0(26);
        }
        return new LambdaLocalReference(qualifiedName, offset, lambda2, SymbolFilter.NONE, (OCSymbolReference)parentScopeReference);
    }

    public abstract OCSymbolReference getSymbolReferenceToQualifier();

    @NotNull
    protected SymbolKindFilter getFilterForQualifier() {
        SymbolKindFilter symbolKindFilter = this.myFilter == SymbolKindFilter.ONLY_NAMESPACE ? SymbolKindFilter.ONLY_NAMESPACE : SymbolKindFilter.ONLY_NAMESPACE_LIKE;
        if (symbolKindFilter == null) {
            OCSymbolReference.$$$reportNull$$$0(27);
        }
        return symbolKindFilter;
    }

    @NotNull
    public OCSymbolReference applyTypeArguments(List<OCTypeArgument> arguments) {
        OCSymbolReference oCSymbolReference = this.createReferenceInSameContext(new OCQualifiedNameWithArguments(this.getQualifiedName(), arguments));
        if (oCSymbolReference == null) {
            OCSymbolReference.$$$reportNull$$$0(28);
        }
        return oCSymbolReference;
    }

    @NotNull
    public abstract OCSymbolReference createReferenceInSameContext(@NotNull OCQualifiedName var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCSymbolReference that = (OCSymbolReference)o;
        if (!this.myQualifiedName.equals(that.myQualifiedName)) {
            return false;
        }
        return this.myFilter.equals(that.myFilter);
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull OCSymbolReference first, @NotNull OCSymbolReference second) {
        if (c == null) {
            OCSymbolReference.$$$reportNull$$$0(29);
        }
        if (first == null) {
            OCSymbolReference.$$$reportNull$$$0(30);
        }
        if (second == null) {
            OCSymbolReference.$$$reportNull$$$0(31);
        }
        return c.equalObjects(first.myQualifiedName, second.myQualifiedName);
    }

    public int hashCode() {
        return this.myQualifiedName.hashCode();
    }

    @NotNull
    List<OCSymbol> resolveToSymbols(@NotNull OCResolveContext context, boolean onlyTypes, boolean resolveSpecialization) {
        PsiFile file;
        if (context == null) {
            OCSymbolReference.$$$reportNull$$$0(32);
        }
        if ((file = context.getFile()) == null) {
            List<OCSymbol> list = Collections.emptyList();
            if (list == null) {
                OCSymbolReference.$$$reportNull$$$0(33);
            }
            return list;
        }
        boolean ignoreImports = context.isProcessNonImported();
        Object dependency = this.getCacheDependency(file.getProject());
        Map cache = (Map)OCSymbolReference.getCache(file, onlyTypes, ignoreImports, dependency).getValue();
        OCTypeSubstitution substitution = context.getSubstitution();
        substitution = substitution.getMinimalDependentSubstitution(this, context);
        ProgressManager.checkCanceled();
        ResultInfo cachedResolve = (ResultInfo)cache.get(new ReferenceInfo(this, substitution, resolveSpecialization));
        if (cachedResolve == null) {
            Set<OCTypeParameterSymbol> oldDependencies = context.getTypeDependencies();
            context.clearTypeDependencies();
            List<OCSymbol> results = this.doResolve(context, onlyTypes, resolveSpecialization);
            Set<OCTypeParameterSymbol> dependencies = context.getTypeDependencies();
            dependencies = !dependencies.isEmpty() ? dependencies : null;
            cachedResolve = new ResultInfo(results, dependencies);
            context.addTypeDependencies(oldDependencies);
            cache.put(new ReferenceInfo(this, substitution, resolveSpecialization), cachedResolve);
        } else if (cachedResolve.typeDependencies != null) {
            context.addTypeDependencies(cachedResolve.typeDependencies);
        }
        OCDebugUtil.tryDebugWaitForSymbols(cachedResolve.symbols);
        List<OCSymbol> list = Collections.unmodifiableList(cachedResolve.symbols);
        if (list == null) {
            OCSymbolReference.$$$reportNull$$$0(34);
        }
        return list;
    }

    protected Object getCacheDependency(@NotNull Project project2) {
        if (project2 == null) {
            OCSymbolReference.$$$reportNull$$$0(35);
        }
        return FileSymbolTablesCache.getInstance(project2).getOutOfBlockModificationTracker();
    }

    @NotNull
    private static CachedValue<Map<ReferenceInfo, ResultInfo>> getCache(@NotNull PsiFile file, boolean onlyTypes, boolean ignoreImports, @NotNull Object dependency) {
        Key<CachedValue<Map<ReferenceInfo, ResultInfo>>> cacheKey;
        CachedValue<Map<ReferenceInfo, ResultInfo>> cache;
        if (file == null) {
            OCSymbolReference.$$$reportNull$$$0(36);
        }
        if (dependency == null) {
            OCSymbolReference.$$$reportNull$$$0(37);
        }
        if ((cache = (CachedValue<Map<ReferenceInfo, ResultInfo>>)file.getUserData(cacheKey = OCSymbolReference.getCacheKey(onlyTypes, ignoreImports, dependency))) == null) {
            cache = OCSymbolReference.createCache(file.getProject(), dependency);
            file.putUserData(cacheKey, cache);
        }
        CachedValue<Map<ReferenceInfo, ResultInfo>> cachedValue = cache;
        if (cachedValue == null) {
            OCSymbolReference.$$$reportNull$$$0(38);
        }
        return cachedValue;
    }

    @NotNull
    private static CachedValue<Map<ReferenceInfo, ResultInfo>> createCache(Project project2, @NotNull Object dependency) {
        if (dependency == null) {
            OCSymbolReference.$$$reportNull$$$0(39);
        }
        CachedValue cachedValue = CachedValuesManager.getManager((Project)project2).createCachedValue(() -> {
            if (dependency == null) {
                OCSymbolReference.$$$reportNull$$$0(62);
            }
            ConcurrentMap cache = ContainerUtil.newConcurrentMap();
            return CachedValueProvider.Result.create((Object)cache, (Object[])new Object[]{dependency});
        }, false);
        if (cachedValue == null) {
            OCSymbolReference.$$$reportNull$$$0(40);
        }
        return cachedValue;
    }

    @NotNull
    private static Key<CachedValue<Map<ReferenceInfo, ResultInfo>>> getCacheKey(boolean onlyTypes, boolean ignoreImports, Object dependency) {
        int cacheIndex = (ignoreImports ? 0 : (onlyTypes ? 1 : 2)) * 2 + (dependency == PsiModificationTracker.MODIFICATION_COUNT ? 0 : 1);
        Key<CachedValue<Map<ReferenceInfo, ResultInfo>>> key = RESOLVE_CACHES[cacheIndex];
        if (key == null) {
            OCSymbolReference.$$$reportNull$$$0(41);
        }
        return key;
    }

    @NotNull
    public List<OCSymbol> doResolve(@NotNull OCResolveContext context, boolean onlyTypes, boolean resolveSpecialization) {
        List res;
        if (context == null) {
            OCSymbolReference.$$$reportNull$$$0(42);
        }
        List list = (res = (List)OCLongActionUtil.execWithTimeoutProgressInDispatch("progressbar.long.resolve.description", "cidr.resolve.in.ui.timeout", context.getProject(), () -> {
            if (context == null) {
                OCSymbolReference.$$$reportNull$$$0(61);
            }
            ProgressManager.checkCanceled();
            if (context.getNestingDepth() > 256) {
                return Collections.emptyList();
            }
            OCSymbolReferenceResolver referenceResolver = new OCSymbolReferenceResolver(onlyTypes, context);
            SymbolFilter filter = this.myFilter;
            NameWithToken nameWithToken = OCSymbolReference.removeTypeToken(this.myQualifiedName.getName());
            String name2 = nameWithToken.name;
            if (nameWithToken.typeToken != null) {
                filter = SymbolKindFilter.parse(nameWithToken.typeToken);
            }
            if (this.myQualifiedName instanceof OCQualifiedNameWithDecltype) {
                OCType resolvedType = ((OCQualifiedNameWithDecltype)this.myQualifiedName).getAutoType().resolve(context);
                if (resolvedType instanceof OCStructType) {
                    return Collections.singletonList(((OCStructType)resolvedType).getSymbol());
                }
                if (resolvedType instanceof OCTypeParameterType) {
                    OCTypeParameterSymbol symbol = ((OCTypeParameterType)resolvedType).getSymbol();
                    OCTypeParameterTypeSymbol qualifierTypeParameter = symbol instanceof OCTypeParameterTypeSymbol ? (OCTypeParameterTypeSymbol)symbol : null;
                    OCSymbolImpl candidate = new OCTypeParameterTypeSymbol(context.getProject(), null, 0L, name2, qualifierTypeParameter, null, Collections.emptyList(), null, false, true, true);
                    if (filter.accept(candidate)) {
                        return Collections.singletonList(candidate);
                    }
                    candidate = new OCDeclaratorSymbol(context.getProject(), name2, new OCMagicType(name2), OCSymbolKind.TEMPLATE_VALUE_PARAMETER);
                    if (filter.accept(candidate)) {
                        return Collections.singletonList(candidate);
                    }
                }
                return Collections.emptyList();
            }
            OCQualifiedName qualifiedName = this.myQualifiedName.getQualifier();
            boolean hasArguments = this.myQualifiedName instanceof OCQualifiedNameWithArguments;
            boolean skipImmediateContext = this instanceof BaseClauseReference;
            Object collectorResults = new SmartList();
            final Set set = OCTypeUtils.newSymbolWithSubstitutionSet();
            CommonProcessors.CollectProcessor<OCSymbol> collector = new CommonProcessors.CollectProcessor<OCSymbol>((Collection)collectorResults){

                protected boolean accept(OCSymbol symbol) {
                    return set.add(symbol);
                }
            };
            GlobalReference globalRef = (GlobalReference)OCSymbolReferenceResolver.getGlobalReferenceFromLocal(this);
            OCResolveUtil.ResolveFilteringProcessor<OCSymbol> processor2 = OCSymbolReferenceResolver.createResolveFilteringProcessor((Processor<OCSymbol>)collector, globalRef, context);
            if (qualifiedName != null) {
                if (qualifiedName.equals(OCQualifiedName.GLOBAL)) {
                    referenceResolver.processSymbolsForGlobalRef(name2, filter, null, skipImmediateContext, processor2, hasArguments, globalRef);
                } else {
                    OCSymbolReference qualifier = this.getSymbolReferenceToQualifier();
                    int templateSubstitutionsCnt = context.getTemplateSubstitutionsCnt();
                    List<OCSymbol> iterable = context.resolveToSymbols(qualifier, true, true, onlyTypes);
                    processor2.allowResolveBelowIf(context.getTemplateSubstitutionsCnt() > templateSubstitutionsCnt);
                    boolean old = OCResolveContext.setNonImportedFlag(context, false);
                    OCCommonProcessors.OrderedProcessor<OCSymbol> orderedProcessor = referenceResolver.getFilteredByKindProcessor(filter, processor2);
                    if (qualifier.getQualifiedName().equals(OCQualifiedName.with(name2))) {
                        for (OCSymbol symbol : iterable) {
                            if (!(symbol instanceof OCStructSymbol) || symbol.getName().equals(name2)) continue;
                            ((OCStructSymbol)symbol).processConstructors(orderedProcessor, context);
                        }
                    }
                    ContainerUtil.process(iterable, (Processor)new SymbolMembersProcessor(name2, orderedProcessor, false, onlyTypes, context, qualifier));
                    orderedProcessor.finish();
                    OCResolveContext.setNonImportedFlag(context, old);
                }
            } else if (this instanceof LocalReference) {
                PsiElement localContext = ((LocalReference)this).getLocalContext();
                if (localContext != null && localContext.isValid()) {
                    OCCommonProcessors.OrderedProcessor<OCSymbol> orderedProcessor = referenceResolver.getFilteredByKindProcessor(filter, (Processor<OCSymbol>)collector);
                    referenceResolver.processSymbolsForLocalRef(name2, localContext, orderedProcessor);
                    if (orderedProcessor.finish() && (this.myQualifiedName.myName == null || !ContainerUtil.exists((Iterable)collector.getResults(), OCResolveUtil::stopNameLookup))) {
                        GlobalReference globalReference = (GlobalReference)OCSymbolReferenceResolver.getGlobalReferenceFromLocal(OCQualifiedName.with(name2), localContext, filter);
                        OCSymbolWithQualifiedName symbolContext = globalReference.getSymbolContext();
                        referenceResolver.processSymbolsForGlobalRef(name2, filter, symbolContext, skipImmediateContext, processor2, hasArguments, globalReference);
                    }
                }
            } else {
                OCSymbolWithQualifiedName symbolContext = ((GlobalReference)this).getSymbolContext();
                referenceResolver.processSymbolsForGlobalRef(name2, filter, symbolContext, skipImmediateContext, (Processor<OCSymbol>)collector, hasArguments, (GlobalReference)this);
            }
            if (resolveSpecialization) {
                collectorResults = this.resolveWithTypeArguments(context, (List<OCSymbol>)collectorResults);
            }
            return collectorResults;
        })) == null ? Collections.emptyList() : res;
        if (list == null) {
            OCSymbolReference.$$$reportNull$$$0(43);
        }
        return list;
    }

    @NotNull
    public static NameWithToken removeTypeToken(@Nullable String name2) {
        String typeToken = null;
        if (name2 != null) {
            String nameWithoutTypeQualifiers = name2;
            boolean changes = true;
            while (changes) {
                changes = false;
                for (OCElementType oCElementType : OCTokenTypes.TYPE_QUALIFIERS.getTypes()) {
                    String tokenName = oCElementType.getName();
                    if (!nameWithoutTypeQualifiers.startsWith(tokenName + " ")) continue;
                    nameWithoutTypeQualifiers = nameWithoutTypeQualifiers.substring(tokenName.length() + 1);
                    changes = true;
                }
            }
            for (OCElementType oCElementType : TYPE_TOKENS) {
                if (!nameWithoutTypeQualifiers.startsWith(oCElementType.getName() + " ")) continue;
                name2 = name2.substring(0, name2.length() - nameWithoutTypeQualifiers.length()) + nameWithoutTypeQualifiers.substring(oCElementType.getName().length() + 1);
                typeToken = oCElementType.getName();
                break;
            }
        }
        NameWithToken nameWithToken = new NameWithToken(name2, typeToken);
        if (nameWithToken == null) {
            OCSymbolReference.$$$reportNull$$$0(44);
        }
        return nameWithToken;
    }

    @NotNull
    private List<OCSymbol> resolveWithTypeArguments(@NotNull OCResolveContext resolver, @NotNull List<OCSymbol> symbols) {
        if (resolver == null) {
            OCSymbolReference.$$$reportNull$$$0(45);
        }
        if (symbols == null) {
            OCSymbolReference.$$$reportNull$$$0(46);
        }
        if (!resolver.isObjc() || ContainerUtil.find(symbols, OCInterfaceSymbol.IS_GENERIC_OBJC_CLASS) == null) {
            List<OCSymbol> list = this.resolveTemplateSpecialization(resolver, symbols);
            if (list == null) {
                OCSymbolReference.$$$reportNull$$$0(47);
            }
            return list;
        }
        ArrayList<OCClassSymbol> genericSymbols = new ArrayList<OCClassSymbol>();
        ArrayList<OCSymbol> templateSymbols = new ArrayList<OCSymbol>();
        for (OCSymbol symbol : symbols) {
            if (symbol instanceof OCClassSymbol) {
                genericSymbols.add((OCClassSymbol)symbol);
                continue;
            }
            templateSymbols.add(symbol);
        }
        List list = ContainerUtil.concat(this.resolveGenerics(resolver, genericSymbols), this.resolveTemplateSpecialization(resolver, templateSymbols));
        if (list == null) {
            OCSymbolReference.$$$reportNull$$$0(48);
        }
        return list;
    }

    @NotNull
    private List<OCClassSymbol> resolveGenerics(@NotNull OCResolveContext resolver, @NotNull List<OCClassSymbol> symbols) {
        if (resolver == null) {
            OCSymbolReference.$$$reportNull$$$0(49);
        }
        if (symbols == null) {
            OCSymbolReference.$$$reportNull$$$0(50);
        }
        if (symbols.isEmpty()) {
            List<OCClassSymbol> list = symbols;
            if (list == null) {
                OCSymbolReference.$$$reportNull$$$0(51);
            }
            return list;
        }
        List<Object> arguments = this.myQualifiedName instanceof OCQualifiedNameWithArguments ? ((OCQualifiedNameWithArguments)this.myQualifiedName).getArguments() : Collections.emptyList();
        SmartList results = new SmartList();
        for (OCClassSymbol symbol : symbols) {
            if (!OCInterfaceSymbol.IS_GENERIC_OBJC_CLASS.value((Object)symbol)) {
                results.add(symbol);
                continue;
            }
            Map<OCTypeParameterSymbol, OCTypeArgument> substitutionMap = OCTypeUtils.newTypeParameterMap();
            Iterator<Object> typeArgumentIterator = arguments.iterator();
            for (OCGenericParameterSymbol typeParameter : ((OCInterfaceSymbol)symbol).getGenericParameters()) {
                OCTypeArgument argument;
                OCTypeArgument oCTypeArgument = argument = typeArgumentIterator.hasNext() ? (OCTypeArgument)typeArgumentIterator.next() : typeParameter.getDefaultValue();
                if (argument instanceof OCType) {
                    argument = ((OCType)argument).transformType(new OCTypeResolveVisitor(resolver));
                }
                substitutionMap.put(typeParameter, argument);
            }
            results.add(OCSimpleTypeSubstitution.create(substitutionMap).substitute(symbol));
        }
        SmartList smartList = results;
        if (smartList == null) {
            OCSymbolReference.$$$reportNull$$$0(52);
        }
        return smartList;
    }

    @NotNull
    private List<OCSymbol> resolveTemplateSpecialization(@NotNull OCResolveContext resolver, @NotNull List<OCSymbol> symbols) {
        if (resolver == null) {
            OCSymbolReference.$$$reportNull$$$0(53);
        }
        if (symbols == null) {
            OCSymbolReference.$$$reportNull$$$0(54);
        }
        if (symbols.isEmpty()) {
            List<OCSymbol> list = symbols;
            if (list == null) {
                OCSymbolReference.$$$reportNull$$$0(55);
            }
            return list;
        }
        if (!(this.myQualifiedName instanceof OCQualifiedNameWithArguments)) {
            if (resolver.isProcessNonImported()) {
                List<OCSymbol> list = symbols;
                if (list == null) {
                    OCSymbolReference.$$$reportNull$$$0(56);
                }
                return list;
            }
            if (this instanceof GlobalReference && symbols.size() == 1) {
                OCSymbol symbol = symbols.get(0);
                for (OCSymbolWithQualifiedName context = ((GlobalReference)this).getSymbolContext(); context != null; context = context.getParent()) {
                    if (!context.equals(symbol)) continue;
                    List<OCSymbol> list = symbols;
                    if (list == null) {
                        OCSymbolReference.$$$reportNull$$$0(57);
                    }
                    return list;
                }
            }
            List list = ContainerUtil.filter(symbols, s -> !(s instanceof OCStructSymbol) || ((OCStructSymbol)s).getTemplateSpecialization() == null);
            if (list == null) {
                OCSymbolReference.$$$reportNull$$$0(58);
            }
            return list;
        }
        List<OCTypeArgument> arguments = ((OCQualifiedNameWithArguments)this.myQualifiedName).getArguments();
        SmartList results = new SmartList();
        ArrayList<OCSymbol> candidates = new ArrayList<OCSymbol>(symbols);
        ArrayList<OCTemplateSymbol> templateSymbols = new ArrayList<OCTemplateSymbol>();
        for (OCSymbol candidate : candidates) {
            switch (OCSymbolReference.shouldCheckSpecialization(candidate)) {
                case ALWAYS_CHECK: {
                    templateSymbols.add((OCTemplateSymbol)candidate);
                    break;
                }
                case NEVER_CHECK: {
                    results.add(candidate);
                    break;
                }
            }
        }
        for (OCTemplateSymbol spec : OCSimpleTypeSubstitution.resolveTemplateSpecialization(templateSymbols, arguments, resolver)) {
            OCTemplateSymbol afterSubstitution = resolver.getSubstitution().substitute(spec, resolver);
            results.add(afterSubstitution);
        }
        SmartList smartList = results;
        if (smartList == null) {
            OCSymbolReference.$$$reportNull$$$0(59);
        }
        return smartList;
    }

    private static SpecializationCheckType shouldCheckSpecialization(@NotNull OCSymbol symbol) {
        OCSymbolKind kind;
        if (symbol == null) {
            OCSymbolReference.$$$reportNull$$$0(60);
        }
        if ((kind = symbol.getKind()) == OCSymbolKind.TEMPLATE_TYPE_PARAMETER || kind == OCSymbolKind.SYMBOL_USING_SYMBOL) {
            return SpecializationCheckType.NEVER_CHECK;
        }
        if (symbol instanceof OCTemplateSymbol) {
            return SpecializationCheckType.ALWAYS_CHECK;
        }
        return SpecializationCheckType.SKIP;
    }

    static {
        for (int i = 0; i < RESOLVE_CACHES.length; ++i) {
            OCSymbolReference.RESOLVE_CACHES[i] = Key.create((String)("SYMBOL_RESOLVE_CACHE_IN_FILE" + i));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 42: 
            case 45: 
            case 46: 
            case 49: 
            case 50: 
            case 53: 
            case 54: 
            case 60: 
            case 61: 
            case 62: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 42: 
            case 45: 
            case 46: 
            case 49: 
            case 50: 
            case 53: 
            case 54: 
            case 60: 
            case 61: 
            case 62: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/OCSymbolReference";
                break;
            }
            case 1: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 32: 
            case 42: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: 
            case 46: 
            case 50: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbols";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambda";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentScopeReference";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 37: 
            case 39: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 45: 
            case 49: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilter";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 42: 
            case 45: 
            case 46: 
            case 49: 
            case 50: 
            case 53: 
            case 54: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/OCSymbolReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToSymbols";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "lookupUsingsAndTypedefs";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterForQualifier";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "applyTypeArguments";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getCache";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createCache";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getCacheKey";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolve";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "removeTypeToken";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveWithTypeArguments";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveGenerics";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTemplateSpecialization";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processPossibleSymbols";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "resolveToSymbols";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lookupUsingsAndTypedefs";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDummyGlobalReference";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getGlobalReference";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getBaseClauseReference";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateArgsReference";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getLocalReference";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getLambdaLocalReference";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getCacheDependency";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getCache";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createCache";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "doResolve";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "resolveWithTypeArguments";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "resolveGenerics";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "resolveTemplateSpecialization";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "shouldCheckSpecialization";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doResolve$1";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createCache$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 42: 
            case 45: 
            case 46: 
            case 49: 
            case 50: 
            case 53: 
            case 54: 
            case 60: 
            case 61: 
            case 62: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class UsingAndTypedefSymbolsResolver
    implements Processor<OCSymbol> {
        private final Set<OCSymbol> myProcessedSymbols;
        private final ArrayList<OCSymbol> myAnswer;
        private OCSymbolReference myOriginalReference;
        @NotNull
        private OCResolveContext myMemoization;
        private final boolean myProcessTypdefs;
        private final boolean myProcessTypeParameters;
        private boolean myResolveSpecialization;
        private final boolean myOnlyTypes;
        private List<OCTypeArgument> myArguments;

        public UsingAndTypedefSymbolsResolver(boolean processTypedefs, boolean processTypeParameters, boolean resolveSpecialization, boolean onlyTypes, @Nullable List<OCTypeArgument> arguments, @Nullable OCSymbolReference originalReference, @NotNull OCResolveContext context) {
            if (context == null) {
                UsingAndTypedefSymbolsResolver.$$$reportNull$$$0(0);
            }
            this.myProcessedSymbols = OCTypeUtils.newSymbolWithSubstitutionSet();
            this.myAnswer = new ArrayList();
            this.myProcessTypdefs = processTypedefs;
            this.myProcessTypeParameters = processTypeParameters;
            this.myResolveSpecialization = resolveSpecialization;
            this.myOnlyTypes = onlyTypes;
            this.myOriginalReference = originalReference;
            this.myMemoization = context;
            this.myArguments = arguments;
        }

        public boolean process(OCSymbol symbol) {
            if (this.myProcessedSymbols.add(symbol)) {
                OCFile currentFile = (OCFile)this.myMemoization.getFile();
                if (currentFile == null) {
                    return true;
                }
                if (symbol instanceof OCUsingSymbol) {
                    OCFileSymbols.markImportNeeded(currentFile, symbol);
                    OCSymbolReference reference = ((OCUsingSymbol)symbol).getSymbolReference();
                    if (this.myArguments != null) {
                        reference = reference.applyTypeArguments(this.myArguments);
                    }
                    if (this.myOriginalReference != null) {
                        reference = reference.cloneWithOffset(this.myOriginalReference);
                    }
                    OCResolveContext contextForUsing = this.myMemoization.substitute(((OCUsingSymbol)symbol).getSubstitution());
                    List symbols = contextForUsing.doResolveToSymbols(reference, this.myOnlyTypes, false);
                    if (this.myResolveSpecialization) {
                        symbols = reference.resolveTemplateSpecialization(contextForUsing, symbols);
                    }
                    ContainerUtil.process(symbols, (Processor)this);
                } else if (symbol.getKind().isTypedefOrAlias() && this.myProcessTypdefs) {
                    OCFileSymbols.markImportNeeded(currentFile, symbol);
                    this.processType(symbol, symbol.getType());
                } else if (symbol instanceof OCNamespaceAliasSymbol && this.myProcessTypdefs) {
                    OCFileSymbols.markImportNeeded(currentFile, symbol);
                    OCSymbolReference reference = ((OCNamespaceAliasSymbol)symbol).getNamespaceReference();
                    ContainerUtil.process(this.myMemoization.doResolveToSymbols(reference, this.myOnlyTypes, true), (Processor)this);
                } else if (symbol instanceof OCTypeParameterSymbol && this.myProcessTypeParameters) {
                    OCTypeArgument argument = this.myMemoization.getSubstitution().getSubstitutionFor((OCTypeParameterSymbol)((Object)symbol));
                    if (symbol instanceof OCTypeParameterTypeSymbol && argument instanceof OCType) {
                        this.processType(symbol, (OCType)argument);
                        this.myMemoization.incTemplateSubstitutionsCnt();
                    } else {
                        this.myAnswer.add(symbol);
                    }
                } else {
                    this.myAnswer.add(symbol);
                }
            }
            return true;
        }

        protected void processType(OCSymbol symbol, OCType type) {
            if (type instanceof OCStructType) {
                this.myAnswer.addAll(((OCStructType)type).getStructs());
            } else if (type instanceof OCReferenceType) {
                OCSymbolReference reference = ((OCReferenceType)type).getReference(this.myMemoization).cloneWithOffset(this.myOriginalReference);
                OCResolveContext oldMemoization = this.myMemoization;
                if (symbol instanceof OCSymbolWithSubstitution) {
                    this.myMemoization = this.myMemoization.substitute(((OCSymbolWithSubstitution)((Object)symbol)).getSubstitution());
                }
                List symbols = this.myMemoization.doResolveToSymbols(reference, this.myOnlyTypes, false);
                if (this.myResolveSpecialization) {
                    symbols = reference.resolveTemplateSpecialization(this.myMemoization, symbols);
                }
                List<OCTypeArgument> oldArguments = this.myArguments;
                if (this.myArguments == null && reference.getQualifiedName() instanceof OCQualifiedNameWithArguments) {
                    this.myArguments = ((OCQualifiedNameWithArguments)reference.getQualifiedName()).getArguments();
                }
                ContainerUtil.process((List)symbols, (Processor)this);
                this.myArguments = oldArguments;
                this.myMemoization = oldMemoization;
            } else if (type instanceof OCAutoType) {
                OCExpressionSymbol expressionSymbol = ((OCAutoType)type).getExpressionSymbol();
                if (expressionSymbol != null) {
                    this.processType(expressionSymbol, expressionSymbol.getResolvedType(this.myMemoization.substitute(((OCAutoType)type).getSubstitution())));
                }
            } else if (type instanceof OCMagicType) {
                this.myAnswer.add(new OCTypeParameterTypeSymbol(this.myMemoization.getProject(), null, 0L, symbol.getName(), null, Collections.emptyList(), null, false, true, true));
            }
        }

        @NotNull
        public List<OCSymbol> getAnswer() {
            if (this.myAnswer.size() == 0) {
                List<OCSymbol> list = Collections.emptyList();
                if (list == null) {
                    UsingAndTypedefSymbolsResolver.$$$reportNull$$$0(1);
                }
                return list;
            }
            this.myAnswer.trimToSize();
            ArrayList<OCSymbol> arrayList = this.myAnswer;
            if (arrayList == null) {
                UsingAndTypedefSymbolsResolver.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/symbols/OCSymbolReference$UsingAndTypedefSymbolsResolver";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/symbols/OCSymbolReference$UsingAndTypedefSymbolsResolver";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnswer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SymbolMembersProcessor
    implements Processor<OCSymbol> {
        private final String myName;
        private final Processor<OCSymbol> myProcessor;
        private final boolean myOnlySimpleNamespaces;
        private final boolean myOnlyTypes;
        private OCResolveContext myMemoization;
        private OCSymbolReference myReference;
        private final THashSet<OCSymbol> myProcessed;

        public SymbolMembersProcessor(@Nullable String name2, Processor<OCSymbol> processor2, boolean onlySimpleNamespaces, boolean onlyTypes, @NotNull OCResolveContext context, @Nullable OCSymbolReference reference) {
            if (context == null) {
                SymbolMembersProcessor.$$$reportNull$$$0(0);
            }
            this.myName = name2;
            this.myProcessor = processor2;
            this.myOnlySimpleNamespaces = onlySimpleNamespaces;
            this.myOnlyTypes = onlyTypes;
            this.myMemoization = context;
            this.myReference = reference;
            this.myProcessed = new THashSet((TObjectHashingStrategy)new TObjectHashingStrategy<OCSymbol>(){

                public int computeHashCode(OCSymbol object) {
                    return object.hashCode();
                }

                public boolean equals(OCSymbol o1, OCSymbol o2) {
                    return o1 == o2;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean process(OCSymbol symbol) {
            if (!this.myProcessed.add((Object)symbol)) {
                return true;
            }
            OCResolveContext oldMemoization = this.myMemoization;
            try {
                this.myMemoization = this.myMemoization.useFor(symbol);
                if (symbol instanceof OCNamespaceSymbol) {
                    boolean bl = OCStructType.processMembersOfNamespace((OCNamespaceSymbol)symbol, this.myName, true, !this.myOnlySimpleNamespaces, true, this.myOnlyTypes, this.myProcessor, this.myReference, true, this.myMemoization);
                    return bl;
                }
                if (symbol instanceof OCTypeParameterSymbol) {
                    OCTypeParameterTypeSymbol qualifierTypeParameter;
                    OCTypeParameterTypeSymbol oCTypeParameterTypeSymbol = qualifierTypeParameter = symbol instanceof OCTypeParameterTypeSymbol ? (OCTypeParameterTypeSymbol)symbol : null;
                    if (!this.myProcessor.process((Object)new OCTypeParameterTypeSymbol(this.myMemoization.getProject(), null, 0L, this.myName, qualifierTypeParameter, null, Collections.emptyList(), null, false, true, true))) {
                        boolean bl = false;
                        return bl;
                    }
                    if (!this.myProcessor.process((Object)new OCDeclaratorSymbol(this.myMemoization.getProject(), this.myName, new OCMagicType(this.myName), OCSymbolKind.TEMPLATE_VALUE_PARAMETER))) {
                        boolean bl = false;
                        return bl;
                    }
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.myMemoization = oldMemoization;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/symbols/OCSymbolReference$SymbolMembersProcessor", "<init>"));
        }
    }

    public static class NameWithToken {
        public final String name;
        public final String typeToken;

        public NameWithToken(String name2, String typeToken) {
            this.name = name2;
            this.typeToken = typeToken;
        }
    }

    private static class ResultInfo {
        final List<OCSymbol> symbols;
        final Set<OCTypeParameterSymbol> typeDependencies;

        private ResultInfo(@NotNull List<OCSymbol> symbols, @Nullable Set<OCTypeParameterSymbol> typeDependencies) {
            if (symbols == null) {
                ResultInfo.$$$reportNull$$$0(0);
            }
            this.symbols = symbols;
            this.typeDependencies = typeDependencies;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbols", "com/jetbrains/cidr/lang/symbols/OCSymbolReference$ResultInfo", "<init>"));
        }
    }

    private static class ReferenceInfo {
        @NotNull
        final OCSymbolReference symbolReference;
        @NotNull
        final OCTypeSubstitution substitution;
        private final boolean resolveSpecialization;

        private ReferenceInfo(@NotNull OCSymbolReference symbolReference, @NotNull OCTypeSubstitution substitution, boolean resolveSpecialization) {
            if (symbolReference == null) {
                ReferenceInfo.$$$reportNull$$$0(0);
            }
            if (substitution == null) {
                ReferenceInfo.$$$reportNull$$$0(1);
            }
            this.symbolReference = symbolReference;
            this.substitution = substitution;
            this.resolveSpecialization = resolveSpecialization;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReferenceInfo info = (ReferenceInfo)o;
            if (this.resolveSpecialization != info.resolveSpecialization) {
                return false;
            }
            if (!this.symbolReference.equals(info.symbolReference)) {
                return false;
            }
            return this.substitution.equals(info.substitution);
        }

        public int hashCode() {
            int result = this.symbolReference.hashCode();
            result = 31 * result + this.substitution.hashCode();
            result = 31 * result + (this.resolveSpecialization ? 1 : 0);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "symbolReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "substitution";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/symbols/OCSymbolReference$ReferenceInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class LambdaLocalReference
    extends OCSymbolReference {
        private OCLambdaExpressionSymbol myLambda;
        private long myOffset;
        private OCSymbolReference myParentScopeReference;

        public LambdaLocalReference() {
        }

        /*
         * WARNING - void declaration
         */
        public LambdaLocalReference(@NotNull OCQualifiedName qualifiedName, long offset, @NotNull OCLambdaExpressionSymbol lambda2, @NotNull SymbolFilter filter, @NotNull OCSymbolReference oCSymbolReference) {
            void parentScopeReference;
            if (qualifiedName == null) {
                LambdaLocalReference.$$$reportNull$$$0(0);
            }
            if (lambda2 == null) {
                LambdaLocalReference.$$$reportNull$$$0(1);
            }
            if (filter == null) {
                LambdaLocalReference.$$$reportNull$$$0(2);
            }
            if (oCSymbolReference == null) {
                LambdaLocalReference.$$$reportNull$$$0(3);
            }
            super(qualifiedName, filter);
            this.myOffset = offset;
            this.myLambda = lambda2;
            this.myParentScopeReference = parentScopeReference;
        }

        @Override
        public OCSymbolReference getSymbolReferenceToQualifier() {
            SymbolKindFilter filter = this.getFilterForQualifier();
            return new LambdaLocalReference(this.getQualifiedName().getQualifier(), this.myOffset, this.myLambda, filter, this.myParentScopeReference);
        }

        @Override
        @Nullable
        public VirtualFile getVirtualFile() {
            return this.myLambda.getContainingFile();
        }

        @Override
        public long getOffset() {
            return this.myOffset;
        }

        @Override
        public OCSymbolReference cloneWithOffset(@NotNull OCSymbolReference reference) {
            if (reference == null) {
                LambdaLocalReference.$$$reportNull$$$0(4);
            }
            return this;
        }

        @Override
        @NotNull
        public OCSymbolReference createReferenceInSameContext(@NotNull OCQualifiedName name2) {
            if (name2 == null) {
                LambdaLocalReference.$$$reportNull$$$0(5);
            }
            LambdaLocalReference lambdaLocalReference = new LambdaLocalReference(name2, this.myOffset, this.myLambda, this.myFilter, this.myParentScopeReference);
            if (lambdaLocalReference == null) {
                LambdaLocalReference.$$$reportNull$$$0(6);
            }
            return lambdaLocalReference;
        }

        @Override
        public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull OCSymbolReference first, @NotNull OCSymbolReference second) {
            if (c == null) {
                LambdaLocalReference.$$$reportNull$$$0(7);
            }
            if (first == null) {
                LambdaLocalReference.$$$reportNull$$$0(8);
            }
            if (second == null) {
                LambdaLocalReference.$$$reportNull$$$0(9);
            }
            if (!super.deepEqualStep(c, first, second)) {
                return false;
            }
            LambdaLocalReference f = (LambdaLocalReference)first;
            LambdaLocalReference s = (LambdaLocalReference)second;
            if (!Comparing.equal((Object)f.myLambda, (Object)s.myLambda)) {
                return false;
            }
            return Comparing.equal((Object)f.myOffset, (Object)s.myOffset);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.myLambda != null ? this.myLambda.hashCode() : 0);
            result = (int)((long)(31 * result) + this.myOffset);
            result = 31 * result + (this.myParentScopeReference != null ? this.myParentScopeReference.hashCode() : 0);
            return result;
        }

        @Override
        @NotNull
        public List<OCSymbol> doResolve(@NotNull OCResolveContext context, boolean onlyTypes, boolean resolveSpecialization) {
            OCSymbol symbol;
            if (context == null) {
                LambdaLocalReference.$$$reportNull$$$0(10);
            }
            if (this.myLambda != null && this.myQualifiedName.getQualifier() == null && (symbol = OCResolveUtil.resolveLambdaLocalSymbolInTable(this.myLambda.getLocalVarsAndParams(), this.myQualifiedName, this.myOffset, context.getProject())) != null) {
                List<OCSymbol> list = Collections.singletonList(symbol);
                if (list == null) {
                    LambdaLocalReference.$$$reportNull$$$0(11);
                }
                return list;
            }
            List<OCSymbol> list = this.myParentScopeReference.doResolve(context, onlyTypes, resolveSpecialization);
            if (list == null) {
                LambdaLocalReference.$$$reportNull$$$0(12);
            }
            return list;
        }

        public String toString() {
            return "LAMBDA LOCAL (" + this.getQualifiedName() + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 11: 
                case 12: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 11: 
                case 12: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifiedName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lambda";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentScopeReference";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 6: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/symbols/OCSymbolReference$LambdaLocalReference";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "first";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "second";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/symbols/OCSymbolReference$LambdaLocalReference";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createReferenceInSameContext";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doResolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "cloneWithOffset";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createReferenceInSameContext";
                    break;
                }
                case 6: 
                case 11: 
                case 12: {
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "deepEqualStep";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "doResolve";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 11: 
                case 12: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class TemplateArgumentsReference
    extends GlobalReference {
        private boolean isSpecialization;

        public TemplateArgumentsReference() {
        }

        /*
         * WARNING - void declaration
         */
        public TemplateArgumentsReference(@NotNull OCQualifiedName qualifiedName, @Nullable OCSymbolWithQualifiedName symbolContext, @Nullable VirtualFile file, long complexOffset, SymbolFilter filter, boolean bl) {
            void specialization;
            if (qualifiedName == null) {
                TemplateArgumentsReference.$$$reportNull$$$0(0);
            }
            super(qualifiedName, symbolContext, file, complexOffset, filter);
            this.isSpecialization = specialization;
        }

        @Override
        public OCSymbolReference getSymbolReferenceToQualifier() {
            SymbolKindFilter filter = this.getFilterForQualifier();
            return new TemplateArgumentsReference(this.getQualifiedName().getQualifier(), this.getSymbolContext(), this.getVirtualFile(), this.getOffset(), filter, this.isSpecialization);
        }

        @Override
        @NotNull
        public OCSymbolReference createReferenceInSameContext(@NotNull OCQualifiedName name2) {
            if (name2 == null) {
                TemplateArgumentsReference.$$$reportNull$$$0(1);
            }
            TemplateArgumentsReference templateArgumentsReference = new TemplateArgumentsReference(name2, this.getSymbolContext(), this.getVirtualFile(), this.getOffset(), this.myFilter, this.isSpecialization);
            if (templateArgumentsReference == null) {
                TemplateArgumentsReference.$$$reportNull$$$0(2);
            }
            return templateArgumentsReference;
        }

        public boolean isSpecialization() {
            return this.isSpecialization;
        }

        @Override
        public String toString() {
            return "TEMPLATE (" + this.getQualifiedName() + "):" + this.getSymbolContext();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifiedName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/symbols/OCSymbolReference$TemplateArgumentsReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/symbols/OCSymbolReference$TemplateArgumentsReference";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createReferenceInSameContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createReferenceInSameContext";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class BaseClauseReference
    extends GlobalReference {
        public BaseClauseReference() {
        }

        /*
         * WARNING - void declaration
         */
        public BaseClauseReference(@NotNull OCQualifiedName qualifiedName, @Nullable OCSymbolWithQualifiedName symbolContext, @Nullable VirtualFile file, long complexOffset, SymbolFilter symbolFilter) {
            void filter;
            if (qualifiedName == null) {
                BaseClauseReference.$$$reportNull$$$0(0);
            }
            super(qualifiedName, symbolContext, file, complexOffset, (SymbolFilter)filter);
        }

        @Override
        public OCSymbolReference getSymbolReferenceToQualifier() {
            SymbolKindFilter filter = this.getFilterForQualifier();
            return new BaseClauseReference(this.getQualifiedName().getQualifier(), this.getSymbolContext(), this.getVirtualFile(), this.getOffset(), filter);
        }

        @Override
        @NotNull
        public OCSymbolReference createReferenceInSameContext(@NotNull OCQualifiedName name2) {
            if (name2 == null) {
                BaseClauseReference.$$$reportNull$$$0(1);
            }
            BaseClauseReference baseClauseReference = new BaseClauseReference(name2, this.getSymbolContext(), this.getVirtualFile(), this.getOffset(), this.myFilter);
            if (baseClauseReference == null) {
                BaseClauseReference.$$$reportNull$$$0(2);
            }
            return baseClauseReference;
        }

        @Override
        public String toString() {
            return "BASE CLAUSE (" + this.getQualifiedName() + "):" + this.getSymbolContext();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifiedName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/symbols/OCSymbolReference$BaseClauseReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/symbols/OCSymbolReference$BaseClauseReference";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createReferenceInSameContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createReferenceInSameContext";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class LocalReference
    extends OCSymbolReference {
        @Nullable
        private PsiElement myLocalContext;

        private LocalReference(@NotNull OCQualifiedName qualifiedName, @Nullable PsiElement localContext, SymbolFilter filter) {
            if (qualifiedName == null) {
                LocalReference.$$$reportNull$$$0(0);
            }
            super(qualifiedName, filter);
            this.myLocalContext = localContext;
        }

        @Override
        protected Object getCacheDependency(@NotNull Project project2) {
            if (project2 == null) {
                LocalReference.$$$reportNull$$$0(1);
            }
            return PsiModificationTracker.MODIFICATION_COUNT;
        }

        @Nullable
        public PsiElement getLocalContext() {
            return this.myLocalContext;
        }

        @Override
        @Nullable
        public VirtualFile getVirtualFile() {
            return this.myLocalContext == null ? null : OCElementUtil.getVirtualFile(this.myLocalContext);
        }

        @Override
        public long getOffset() {
            return this.myLocalContext != null ? OCSymbolOffsetUtil.getComplexOffset(this.myLocalContext) : -1L;
        }

        @Override
        public OCSymbolReference getSymbolReferenceToQualifier() {
            SymbolKindFilter filter = this.getFilterForQualifier();
            return new LocalReference(this.getQualifiedName().getQualifier(), this.myLocalContext, filter);
        }

        @Override
        @NotNull
        public OCSymbolReference createReferenceInSameContext(@NotNull OCQualifiedName name2) {
            if (name2 == null) {
                LocalReference.$$$reportNull$$$0(2);
            }
            LocalReference localReference = new LocalReference(name2, this.myLocalContext, this.myFilter);
            if (localReference == null) {
                LocalReference.$$$reportNull$$$0(3);
            }
            return localReference;
        }

        @Override
        public OCSymbolReference cloneWithOffset(@NotNull OCSymbolReference reference) {
            if (reference == null) {
                LocalReference.$$$reportNull$$$0(4);
            }
            return this;
        }

        @NotNull
        public OCSymbolReference cloneWithContext(PsiElement context) {
            LocalReference localReference = new LocalReference(this.myQualifiedName, context, this.myFilter);
            if (localReference == null) {
                LocalReference.$$$reportNull$$$0(5);
            }
            return localReference;
        }

        @Override
        public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull OCSymbolReference first, @NotNull OCSymbolReference second) {
            if (c == null) {
                LocalReference.$$$reportNull$$$0(6);
            }
            if (first == null) {
                LocalReference.$$$reportNull$$$0(7);
            }
            if (second == null) {
                LocalReference.$$$reportNull$$$0(8);
            }
            if (!super.deepEqualStep(c, first, second)) {
                return false;
            }
            LocalReference f = (LocalReference)first;
            LocalReference s = (LocalReference)second;
            return Comparing.equal((Object)f.myLocalContext, (Object)s.myLocalContext);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.myLocalContext != null ? this.myLocalContext.hashCode() : 0);
            return result;
        }

        @Override
        @NotNull
        public List<OCSymbol> doResolve(@NotNull OCResolveContext context, boolean onlyTypes, boolean resolveSpecialization) {
            OCSymbol thisSelfSuper;
            if (context == null) {
                LocalReference.$$$reportNull$$$0(9);
            }
            if (this.myLocalContext != null && (thisSelfSuper = OCThisSelfSuperSymbol.tryResolveThisSelfSuper(this.getQualifiedName().toString(), this.myLocalContext, context)) != null) {
                List<OCSymbol> list = Collections.singletonList(thisSelfSuper);
                if (list == null) {
                    LocalReference.$$$reportNull$$$0(10);
                }
                return list;
            }
            PsiElement oldElement = context.getElement();
            context.setElement(this.myLocalContext != null ? this.myLocalContext : oldElement);
            List<OCSymbol> symbols = super.doResolve(context, onlyTypes, resolveSpecialization);
            context.setElement(oldElement);
            List<OCSymbol> list = symbols;
            if (list == null) {
                LocalReference.$$$reportNull$$$0(11);
            }
            return list;
        }

        public String toString() {
            return "LOCAL (" + this.getQualifiedName() + "):" + this.myLocalContext;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: 
                case 10: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: 
                case 10: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifiedName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: 
                case 5: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/symbols/OCSymbolReference$LocalReference";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "first";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "second";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/symbols/OCSymbolReference$LocalReference";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createReferenceInSameContext";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "cloneWithContext";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doResolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getCacheDependency";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createReferenceInSameContext";
                    break;
                }
                case 3: 
                case 5: 
                case 10: 
                case 11: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "cloneWithOffset";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "deepEqualStep";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "doResolve";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: 
                case 10: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class UsingReference
    extends GlobalReference {
        private long myUsingOffset;
        private VirtualFile myUsingFile;

        /*
         * WARNING - void declaration
         */
        public UsingReference(@NotNull OCQualifiedName qualifiedName, @Nullable OCSymbolWithQualifiedName symbolContext, @Nullable VirtualFile usageFile, long usageOffset, SymbolFilter filter, @Nullable VirtualFile usingFile, long l) {
            void usingOffset;
            if (qualifiedName == null) {
                UsingReference.$$$reportNull$$$0(0);
            }
            super(qualifiedName, symbolContext, usageFile, usageOffset, filter);
            this.myUsingOffset = usingOffset;
            this.myUsingFile = usingFile;
        }

        public long getUsingOffset() {
            return this.myUsingOffset;
        }

        public VirtualFile getUsingFile() {
            return this.myUsingFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/jetbrains/cidr/lang/symbols/OCSymbolReference$UsingReference", "<init>"));
        }
    }

    public static class GlobalReference
    extends OCSymbolReference {
        @Nullable
        private transient Object myVirtualFileOrSymbolContext;
        private long myComplexOffset;

        public GlobalReference() {
        }

        /*
         * WARNING - void declaration
         */
        private GlobalReference(@NotNull OCQualifiedName qualifiedName, @Nullable Object virtualFileOrSymbolContext, long complexOffset, @NotNull SymbolFilter symbolFilter) {
            void filter;
            if (qualifiedName == null) {
                GlobalReference.$$$reportNull$$$0(0);
            }
            if (symbolFilter == null) {
                GlobalReference.$$$reportNull$$$0(1);
            }
            super(qualifiedName, (SymbolFilter)filter);
            this.myVirtualFileOrSymbolContext = virtualFileOrSymbolContext;
            this.myComplexOffset = complexOffset;
        }

        /*
         * WARNING - void declaration
         */
        public GlobalReference(@NotNull OCQualifiedName qualifiedName, @Nullable OCSymbolWithQualifiedName symbolContext, @Nullable VirtualFile file, long complexOffset, SymbolFilter symbolFilter) {
            void filter;
            if (qualifiedName == null) {
                GlobalReference.$$$reportNull$$$0(2);
            }
            super(qualifiedName, (SymbolFilter)filter);
            if (symbolContext == null) {
                this.myVirtualFileOrSymbolContext = file;
            } else {
                this.myVirtualFileOrSymbolContext = symbolContext;
                VirtualFile contextFile = symbolContext.getContainingFile();
                if (contextFile == null || !contextFile.equals(file)) {
                    complexOffset = -1L;
                }
            }
            this.myComplexOffset = complexOffset;
        }

        @Nullable
        public OCSymbolWithQualifiedName getSymbolContext() {
            return this.myVirtualFileOrSymbolContext instanceof OCSymbolWithQualifiedName ? (OCSymbolWithQualifiedName)this.myVirtualFileOrSymbolContext : null;
        }

        @Override
        @Nullable
        public VirtualFile getVirtualFile() {
            if (this.myVirtualFileOrSymbolContext instanceof VirtualFile) {
                return (VirtualFile)this.myVirtualFileOrSymbolContext;
            }
            if (this.getSymbolContext() != null) {
                return this.getSymbolContext().getContainingFile();
            }
            return null;
        }

        @Override
        public long getOffset() {
            return this.myComplexOffset;
        }

        @Override
        public OCSymbolReference cloneWithOffset(@NotNull OCSymbolReference reference) {
            if (reference == null) {
                GlobalReference.$$$reportNull$$$0(3);
            }
            OCQualifiedName name2 = this.myQualifiedName;
            if (this.myQualifiedName instanceof OCQualifiedNameWithArguments) {
                List<OCTypeArgument> arguments = ((OCQualifiedNameWithArguments)this.myQualifiedName).getArguments().stream().map(arg -> {
                    if (reference == null) {
                        GlobalReference.$$$reportNull$$$0(9);
                    }
                    return arg instanceof OCType ? OCTypeUtils.changeTypeReferences((OCType)arg, reference) : arg;
                }).collect(Collectors.toList());
                name2 = new OCQualifiedNameWithArguments(name2, arguments);
            }
            if (this.getVirtualFile() != null && !Comparing.equal((Object)this.getVirtualFile(), (Object)reference.getVirtualFile())) {
                return new GlobalReference(name2, this.myVirtualFileOrSymbolContext, -1L, this.myFilter);
            }
            if (reference.getOffset() > this.myComplexOffset || reference.getOffset() == -1L) {
                return new GlobalReference(name2, this.myVirtualFileOrSymbolContext, reference.getOffset(), this.myFilter);
            }
            return this;
        }

        public void setSymbolContext(@Nullable OCSymbolWithQualifiedName symbolContext) {
            VirtualFile oldVirtualFile = this.getVirtualFile();
            this.myVirtualFileOrSymbolContext = symbolContext;
            if (this.myComplexOffset != -1L) {
                OCLog.LOG.assertTrue(Comparing.equal((Object)oldVirtualFile, (Object)this.getVirtualFile()), (Object)"Virtual file changed but the complex offset is not updated");
            }
        }

        @Override
        public OCSymbolReference getSymbolReferenceToQualifier() {
            return new GlobalReference(this.getQualifiedName().getQualifier(), this.myVirtualFileOrSymbolContext, this.myComplexOffset, this.getFilterForQualifier());
        }

        @Override
        @NotNull
        public OCSymbolReference createReferenceInSameContext(@NotNull OCQualifiedName name2) {
            if (name2 == null) {
                GlobalReference.$$$reportNull$$$0(4);
            }
            GlobalReference globalReference = new GlobalReference(name2, this.myVirtualFileOrSymbolContext, this.myComplexOffset, this.myFilter);
            if (globalReference == null) {
                GlobalReference.$$$reportNull$$$0(5);
            }
            return globalReference;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            GlobalReference reference = (GlobalReference)o;
            if (this.myComplexOffset != reference.myComplexOffset) {
                return false;
            }
            return !(this.myVirtualFileOrSymbolContext != null ? !this.myVirtualFileOrSymbolContext.equals(reference.myVirtualFileOrSymbolContext) : reference.myVirtualFileOrSymbolContext != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.myVirtualFileOrSymbolContext != null ? this.myVirtualFileOrSymbolContext.hashCode() : 0);
            result = 31 * result + (int)(this.myComplexOffset ^ this.myComplexOffset >>> 32);
            return result;
        }

        public String toString() {
            return "GLOBAL (" + this.getQualifiedName() + "):" + this.myVirtualFileOrSymbolContext + ": " + OCSymbolOffsetUtil.getTextOffset(this.myComplexOffset);
        }

        @Override
        public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull OCSymbolReference first, @NotNull OCSymbolReference second) {
            if (c == null) {
                GlobalReference.$$$reportNull$$$0(6);
            }
            if (first == null) {
                GlobalReference.$$$reportNull$$$0(7);
            }
            if (second == null) {
                GlobalReference.$$$reportNull$$$0(8);
            }
            if (!super.deepEqualStep(c, first, second)) {
                return false;
            }
            GlobalReference f = (GlobalReference)first;
            GlobalReference s = (GlobalReference)second;
            if (f.myComplexOffset != s.myComplexOffset) {
                return false;
            }
            return !(this.myVirtualFileOrSymbolContext instanceof VirtualFile ? !Comparing.equal((Object)f.myVirtualFileOrSymbolContext, (Object)s.myVirtualFileOrSymbolContext) : !c.equalObjects(f.myVirtualFileOrSymbolContext, s.myVirtualFileOrSymbolContext));
        }

        @Nullable
        public Object getVirtualFileOrSymbolContext() {
            return this.myVirtualFileOrSymbolContext;
        }

        public void setVirtualFileOrSymbolContext(@Nullable Object virtualFileOrSymbolContext) {
            this.myVirtualFileOrSymbolContext = virtualFileOrSymbolContext;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifiedName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 3: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/symbols/OCSymbolReference$GlobalReference";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "first";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "second";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/symbols/OCSymbolReference$GlobalReference";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createReferenceInSameContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "cloneWithOffset";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createReferenceInSameContext";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "deepEqualStep";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$cloneWithOffset$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static enum SpecializationCheckType {
        ALWAYS_CHECK,
        NEVER_CHECK,
        SKIP;

    }

    public static enum SymbolKindFilter implements SymbolFilter
    {
        NONE,
        ONLY_NAMESPACE,
        ONLY_NAMESPACE_LIKE,
        ONLY_STRUCT,
        ONLY_ENUM,
        ONLY_UNION;


        public static SymbolFilter parse(String name2) {
            if (name2 == null) {
                return NONE;
            }
            if (name2.equals("struct") || name2.equals("class")) {
                return ONLY_STRUCT;
            }
            if (name2.equals("enum")) {
                return ONLY_ENUM;
            }
            if (name2.equals("union")) {
                return ONLY_UNION;
            }
            return NONE;
        }

        @Override
        public boolean accept(OCSymbol symbol) {
            OCSymbolKind kind = symbol.getKind();
            switch (this) {
                case NONE: {
                    return true;
                }
                case ONLY_NAMESPACE: {
                    return kind == OCSymbolKind.NAMESPACE || kind == OCSymbolKind.NAMESPACE_ALIAS;
                }
                case ONLY_NAMESPACE_LIKE: {
                    return kind.canBeNamespace() || kind == OCSymbolKind.USING_SYMBOL_ALIAS || kind == OCSymbolKind.SYMBOL_USING_SYMBOL;
                }
                case ONLY_STRUCT: {
                    return kind == OCSymbolKind.STRUCT || kind == OCSymbolKind.USING_SYMBOL_ALIAS || kind == OCSymbolKind.SYMBOL_USING_SYMBOL;
                }
                case ONLY_ENUM: {
                    return kind == OCSymbolKind.ENUM || kind == OCSymbolKind.USING_SYMBOL_ALIAS || kind == OCSymbolKind.SYMBOL_USING_SYMBOL;
                }
                case ONLY_UNION: {
                    return kind == OCSymbolKind.UNION || kind == OCSymbolKind.USING_SYMBOL_ALIAS || kind == OCSymbolKind.SYMBOL_USING_SYMBOL;
                }
            }
            return false;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }
    }

    public static class TrueSymbolFilter
    implements SymbolFilter {
        @Override
        public boolean accept(OCSymbol symbol) {
            return true;
        }

        public String toString() {
            return "*any symbol*";
        }
    }

    @FunctionalInterface
    public static interface SymbolFilter {
        public static final TrueSymbolFilter NONE = new TrueSymbolFilter();

        public boolean accept(OCSymbol var1);
    }
}

