/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.OCTestFrameworks;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolAttribute;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbolImpl;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFunctionSymbol
extends OCTemplateSymbolImpl<OCElement> {
    public static final String ATTRIBUTE_IMPLICIT_BRIDGING = "ImplicitBridging";
    public static final Set<String> ENTRY_POINTS = Collections.unmodifiableSet(ContainerUtil.newHashSet((Object[])new String[]{"main", "wmain", "WinMain", "wWinMain"}));
    private OCFunctionType myType;
    @NotNull
    private List<OCTypeParameterSymbol> myTemplateParameters;
    @Nullable
    private List<OCTypeArgument> myTemplateSpecialization;
    @NotNull
    private List<OCDeclaratorSymbol> myParameterSymbols;
    private OCSymbolKind myKind;
    private int myPropertiesAndAttributes;
    @NotNull
    private OCTypeSubstitution mySubstitution;

    public OCFunctionSymbol() {
        this.mySubstitution = OCTypeSubstitution.ID;
    }

    /*
     * WARNING - void declaration
     */
    public OCFunctionSymbol(@NotNull Project project2, @Nullable VirtualFile file, long offset, @Nullable OCSymbolWithQualifiedName container, @NotNull OCQualifiedName name2, @NotNull List<OCTypeParameterSymbol> templateParameters, @Nullable List<OCTypeArgument> templateSpecialization, int functionProperties, int functionAttributes, @NotNull List<String> attributes, @NotNull OCFunctionType type, @NotNull List<OCDeclaratorSymbol> parameterSymbols, OCSymbolKind kind, @Nullable OCVisibility oCVisibility) {
        void visibility;
        if (project2 == null) {
            OCFunctionSymbol.$$$reportNull$$$0(0);
        }
        if (name2 == null) {
            OCFunctionSymbol.$$$reportNull$$$0(1);
        }
        if (templateParameters == null) {
            OCFunctionSymbol.$$$reportNull$$$0(2);
        }
        if (attributes == null) {
            OCFunctionSymbol.$$$reportNull$$$0(3);
        }
        if (type == null) {
            OCFunctionSymbol.$$$reportNull$$$0(4);
        }
        if (parameterSymbols == null) {
            OCFunctionSymbol.$$$reportNull$$$0(5);
        }
        super(project2, file, offset, container, name2, attributes, (OCVisibility)visibility);
        this.mySubstitution = OCTypeSubstitution.ID;
        this.myType = type;
        this.myTemplateParameters = templateParameters;
        this.myTemplateSpecialization = templateSpecialization;
        this.myParameterSymbols = parameterSymbols;
        this.myKind = kind;
        this.myPropertiesAndAttributes = functionProperties | functionAttributes;
    }

    public OCFunctionSymbol(@NotNull OCFunctionSymbol origin) {
        if (origin == null) {
            OCFunctionSymbol.$$$reportNull$$$0(6);
        }
        this(origin, origin.getParent());
    }

    public OCFunctionSymbol(@NotNull OCFunctionSymbol origin, @Nullable OCSymbolWithQualifiedName parent) {
        if (origin == null) {
            OCFunctionSymbol.$$$reportNull$$$0(7);
        }
        super(origin.myProject, origin.getContainingFile(), origin.getComplexOffset(), parent, origin.getQualifiedName(), origin.getAttributes(), origin.getVisibility());
        this.mySubstitution = OCTypeSubstitution.ID;
        this.myType = origin.myType;
        this.myTemplateParameters = origin.myTemplateParameters;
        this.myTemplateSpecialization = origin.myTemplateSpecialization;
        this.myParameterSymbols = origin.myParameterSymbols;
        this.myKind = origin.myKind;
        this.myPropertiesAndAttributes = origin.myPropertiesAndAttributes;
        this.mySubstitution = origin.mySubstitution;
    }

    public OCFunctionSymbol(@NotNull OCFunctionSymbol origin, @NotNull OCTypeSubstitution substitution, @Nullable OCSymbolWithQualifiedName parent) {
        if (origin == null) {
            OCFunctionSymbol.$$$reportNull$$$0(8);
        }
        if (substitution == null) {
            OCFunctionSymbol.$$$reportNull$$$0(9);
        }
        this(origin, parent);
        this.mySubstitution = substitution;
    }

    @Override
    public boolean isConst() {
        return this.myType.isConst();
    }

    public boolean isVolatile() {
        return this.myType.isVolatile();
    }

    public boolean isConstexpr() {
        return this.hasAttribute(OCSymbolAttribute.CONSTEXPR);
    }

    public boolean isVirtual() {
        return this.hasAttribute(OCSymbolAttribute.VIRTUAL);
    }

    @Override
    public boolean isStatic() {
        return this.hasAttribute(OCSymbolAttribute.STATIC);
    }

    public boolean isExplicit() {
        return this.hasAttribute(OCSymbolAttribute.EXPLICIT);
    }

    public boolean isDefault() {
        return this.hasAttribute(OCSymbolAttribute.DEFAULT);
    }

    public boolean isDelete() {
        return this.hasAttribute(OCSymbolAttribute.DELETE);
    }

    @Override
    public boolean isFriend() {
        return this.hasAttribute(OCSymbolAttribute.FRIEND);
    }

    public boolean isFinal() {
        return this.hasAttribute(OCSymbolAttribute.FINAL);
    }

    public boolean isOverride() {
        return this.hasAttribute(OCSymbolAttribute.OVERRIDE);
    }

    public boolean isInline() {
        return this.hasAttribute(OCSymbolAttribute.INLINE);
    }

    public boolean isExtern() {
        return this.hasAttribute(OCSymbolAttribute.EXTERN);
    }

    public boolean isNoReturn() {
        return this.hasAttribute(OCSymbolAttribute.NORETURN) || super.hasAttribute("noreturn");
    }

    public boolean isPureVirtual() {
        return this.hasProperty(Property.IS_PURE_VIRTUAL);
    }

    public boolean isCppConversionOperator() {
        return this.hasProperty(Property.IS_CONVERSION_OPERATOR);
    }

    @Override
    public boolean isTemplateSymbol() {
        return this.hasProperty(Property.IS_TEMPLATE);
    }

    public boolean isCppOperator() {
        return this.hasProperty(Property.IS_OPERATOR);
    }

    public boolean isUDL() {
        return this.hasProperty(Property.IS_UDL);
    }

    public boolean isVararg() {
        return this.myType.isVararg();
    }

    public boolean hasAttribute(@NotNull OCSymbolAttribute attr) {
        if (attr == null) {
            OCFunctionSymbol.$$$reportNull$$$0(10);
        }
        return (this.myPropertiesAndAttributes & attr.getMask()) != 0;
    }

    public boolean hasProperty(@NotNull Property property) {
        if (property == null) {
            OCFunctionSymbol.$$$reportNull$$$0(11);
        }
        return (this.myPropertiesAndAttributes & property.getMask()) != 0;
    }

    public boolean isMember(@NotNull OCResolveContext context, boolean canBeStatic) {
        boolean ownedByStruct;
        if (context == null) {
            OCFunctionSymbol.$$$reportNull$$$0(12);
        }
        return (ownedByStruct = this.getResolvedOwner(context, false) instanceof OCStructSymbol) && !this.isFriend() && (canBeStatic || !this.isStatic());
    }

    public boolean isCppMemberOperator(@NotNull OCResolveContext context) {
        if (context == null) {
            OCFunctionSymbol.$$$reportNull$$$0(13);
        }
        return this.isCppOperator() && this.isMember(context, false);
    }

    public boolean isCppNonMemberOperator(@NotNull OCResolveContext context) {
        if (context == null) {
            OCFunctionSymbol.$$$reportNull$$$0(14);
        }
        return this.isCppOperator() && !this.isCppMemberOperator(context);
    }

    public void setType(OCFunctionType type) {
        this.myType = type;
    }

    @Nullable
    public OCFunctionDeclaration locateFunctionDefinition(@NotNull Project project2) {
        OCElement declarator;
        if (project2 == null) {
            OCFunctionSymbol.$$$reportNull$$$0(15);
        }
        PsiElement parent = (declarator = (OCElement)this.locateDefinition(project2)) != null ? declarator.getParent() : null;
        return parent instanceof OCFunctionDeclaration ? (OCFunctionDeclaration)parent : null;
    }

    @Override
    @NotNull
    public List<OCTypeParameterSymbol> getTemplateParameters() {
        List<OCTypeParameterSymbol> list = this.myTemplateParameters;
        if (list == null) {
            OCFunctionSymbol.$$$reportNull$$$0(16);
        }
        return list;
    }

    @Override
    @Nullable
    public List<OCTypeArgument> getTemplateSpecialization() {
        return this.myTemplateSpecialization;
    }

    public boolean isCppConstructor() {
        return this.getKind().isConstructorOrDestructor() && !this.isCppDestructor();
    }

    public boolean isCppDestructor() {
        return this.getName().startsWith("~");
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            OCFunctionSymbol.$$$reportNull$$$0(17);
        }
        if (first == null) {
            OCFunctionSymbol.$$$reportNull$$$0(18);
        }
        if (second == null) {
            OCFunctionSymbol.$$$reportNull$$$0(19);
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCFunctionSymbol f = (OCFunctionSymbol)first;
        OCFunctionSymbol s = (OCFunctionSymbol)second;
        if (f.myPropertiesAndAttributes != s.myPropertiesAndAttributes) {
            return false;
        }
        if (!Comparing.equal((Object)((Object)f.myKind), (Object)((Object)s.myKind))) {
            return false;
        }
        if (!c.equalLists(f.myParameterSymbols, s.myParameterSymbols)) {
            return false;
        }
        if (!c.equalObjects(f.mySubstitution, s.mySubstitution)) {
            return false;
        }
        if (!c.equalLists(f.myTemplateParameters, s.myTemplateParameters)) {
            return false;
        }
        if (!c.equalLists(f.myTemplateSpecialization, s.myTemplateSpecialization)) {
            return false;
        }
        return c.equalObjects(f.myType, s.myType);
    }

    @Nullable
    public OCFunctionSymbol getDeclarationInParent(@NotNull OCResolveContext context) {
        if (context == null) {
            OCFunctionSymbol.$$$reportNull$$$0(20);
        }
        if (this.isPredeclaration() && !this.isFriend()) {
            return this;
        }
        OCSymbolWithQualifiedName owner2 = this.getResolvedOwner(context);
        Ref result = new Ref(null);
        if (owner2 instanceof OCNamespaceSymbol) {
            OCType resolvedType = this.getResolvedType(context);
            ((OCNamespaceSymbol)owner2).processMembers(this.getName(), (Processor<OCSymbol>)((Processor)symbol -> {
                if (context == null) {
                    OCFunctionSymbol.$$$reportNull$$$0(47);
                }
                if (symbol instanceof OCFunctionSymbol) {
                    OCType symbolType = symbol.getType().resolve(context);
                    if (!new OCTypeEqualityVisitor(symbolType, true, context).equal(resolvedType)) {
                        return true;
                    }
                    result.set((Object)((OCFunctionSymbol)symbol));
                    return false;
                }
                return true;
            }));
        }
        return (OCFunctionSymbol)result.get();
    }

    public boolean resolveIsFriendOrStatic(@NotNull OCResolveContext context) {
        if (context == null) {
            OCFunctionSymbol.$$$reportNull$$$0(21);
        }
        if (this.isFriendOrStatic() || this.getQualifier() == null) {
            return this.isFriendOrStatic();
        }
        OCFunctionSymbol predef = this.getDeclarationInParent(context);
        return predef != null && predef.isFriendOrStatic();
    }

    public boolean resolveIsStatic(@NotNull OCResolveContext context) {
        if (context == null) {
            OCFunctionSymbol.$$$reportNull$$$0(22);
        }
        if (this.isStatic() || this.getQualifier() == null) {
            return this.isStatic();
        }
        OCFunctionSymbol predef = this.getDeclarationInParent(context);
        return predef != null && predef.isStatic();
    }

    @Override
    public void updateOffset(int start, int lengthShift) {
        super.updateOffset(start, lengthShift);
        for (OCTypeParameterSymbol templateParameter : this.myTemplateParameters) {
            ((OCSymbol)((Object)templateParameter)).updateOffset(start, lengthShift);
        }
        for (OCDeclaratorSymbol parameterSymbol : this.myParameterSymbols) {
            parameterSymbol.updateOffset(start, lengthShift);
        }
    }

    @Override
    public void compact() {
        super.compact();
        this.myType.compact();
        this.myTemplateParameters = ContainerUtil.trimToSize(this.myTemplateParameters);
        this.myTemplateSpecialization = ContainerUtil.trimToSize(this.myTemplateSpecialization);
        this.myParameterSymbols = ContainerUtil.trimToSize(this.myParameterSymbols);
        for (OCTypeParameterSymbol templateParameter : this.myTemplateParameters) {
            ((OCSymbol)((Object)templateParameter)).compact();
        }
        for (OCDeclaratorSymbol parameterSymbol : this.myParameterSymbols) {
            parameterSymbol.compact();
        }
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        OCSymbolKind oCSymbolKind = this.myKind;
        if (oCSymbolKind == null) {
            OCFunctionSymbol.$$$reportNull$$$0(23);
        }
        return oCSymbolKind;
    }

    @Override
    @Nullable
    public Icon getBaseIcon() {
        boolean nonVirtual = this.myParent instanceof OCStructSymbol && !this.isVirtual() && !this.isCppConstructor() && !this.isFriendOrStatic();
        return OCIcons.getFunctionIcon(this.isFriendOrStatic(), this.isPureVirtual(), nonVirtual, this.getVisibility());
    }

    @Override
    public Icon computeFullIconNow(@Nullable OCElement symbolElement, @NotNull Project project2) {
        Icon result;
        if (project2 == null) {
            OCFunctionSymbol.$$$reportNull$$$0(24);
        }
        if ((result = super.computeFullIconNow(symbolElement, project2)) == null) {
            return null;
        }
        if (symbolElement instanceof OCDeclarator) {
            PsiElement parent = symbolElement.getParent();
            symbolElement = parent instanceof OCFunctionDeclaration ? (OCFunctionDeclaration)parent : null;
        }
        return OCTestFrameworks.isTestMethodOrFunction(this, symbolElement, project2) ? OCIcons.getTestIcon(result) : result;
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    @Override
    @NotNull
    public OCTypeSubstitution getSubstitution() {
        OCTypeSubstitution oCTypeSubstitution = this.mySubstitution;
        if (oCTypeSubstitution == null) {
            OCFunctionSymbol.$$$reportNull$$$0(25);
        }
        return oCTypeSubstitution;
    }

    @NotNull
    public OCFunctionSymbol clearSubstitution() {
        OCFunctionSymbol result = new OCFunctionSymbol(this);
        result.mySubstitution = OCTypeSubstitution.ID;
        OCFunctionSymbol oCFunctionSymbol = result;
        if (oCFunctionSymbol == null) {
            OCFunctionSymbol.$$$reportNull$$$0(26);
        }
        return oCFunctionSymbol;
    }

    public int getFunctionAttributes() {
        return 0xFFFFFF & this.myPropertiesAndAttributes;
    }

    public int getFunctionProperties() {
        return 0xFF000000 & this.myPropertiesAndAttributes;
    }

    @Override
    @NotNull
    public OCFunctionType getType() {
        OCFunctionType oCFunctionType = (OCFunctionType)this.mySubstitution.substitute(this.myType);
        if (oCFunctionType == null) {
            OCFunctionSymbol.$$$reportNull$$$0(27);
        }
        return oCFunctionType;
    }

    @NotNull
    public OCFunctionType getTypeWithoutSubstitution() {
        OCFunctionType oCFunctionType = this.myType;
        if (oCFunctionType == null) {
            OCFunctionSymbol.$$$reportNull$$$0(28);
        }
        return oCFunctionType;
    }

    @NotNull
    public List<OCDeclaratorSymbol> getParameterSymbols() {
        List<OCDeclaratorSymbol> list = this.mySubstitution.substitute(this.myParameterSymbols);
        if (list == null) {
            OCFunctionSymbol.$$$reportNull$$$0(29);
        }
        return list;
    }

    @NotNull
    public List<OCDeclaratorSymbol> getParameterSymbols(@NotNull OCResolveContext context) {
        if (context == null) {
            OCFunctionSymbol.$$$reportNull$$$0(30);
        }
        ArrayList<OCDeclaratorSymbol> result = new ArrayList<OCDeclaratorSymbol>();
        for (OCDeclaratorSymbol param : this.mySubstitution.substitute(this.myParameterSymbols, context)) {
            OCType paramType = param.getType().getTerminalType();
            if (paramType instanceof OCVariadicType) {
                int expansionsCnt = OCArgumentsList.expandVariadicTypes(Collections.singletonList(paramType), context).size();
                for (int i = 0; i < expansionsCnt; ++i) {
                    result.add(param);
                }
                continue;
            }
            result.add(param);
        }
        ArrayList<OCDeclaratorSymbol> arrayList = result;
        if (arrayList == null) {
            OCFunctionSymbol.$$$reportNull$$$0(31);
        }
        return arrayList;
    }

    public int getNonInitializedParametersCount(@Nullable OCResolveContext context) {
        if (!(!this.myName.equals("operator++") && !this.myName.equals("operator--") || context != null && context.getElement() instanceof OCReferenceElement && ((OCReferenceElement)context.getElement()).getName().startsWith("operator"))) {
            return 0;
        }
        return OCTypeUtils.getNonInitializedParametersCount(this.getParameterSymbols(), context);
    }

    @Override
    public OCType getEffectiveType() {
        return this.mySubstitution.substitute(this.myType.getReturnType());
    }

    public OCType getEffectiveType(@NotNull PsiElement context) {
        if (context == null) {
            OCFunctionSymbol.$$$reportNull$$$0(32);
        }
        return OCTypeUtils.changeTypeReferences(this.getEffectiveType(), OCSymbolReference.getLocalReference(this.myName, context));
    }

    @Override
    @NotNull
    public OCType getEffectiveResolvedType(@NotNull OCResolveContext context) {
        OCType type;
        if (context == null) {
            OCFunctionSymbol.$$$reportNull$$$0(33);
        }
        OCType result = (type = this.getResolvedType(context)) instanceof OCFunctionType ? ((OCFunctionType)type).getReturnType() : type;
        OCType oCType = this.mySubstitution.substitute(result);
        if (oCType == null) {
            OCFunctionSymbol.$$$reportNull$$$0(34);
        }
        return oCType;
    }

    public boolean canBeCalledWithoutArguments() {
        return this.getNonInitializedParametersCount(null) == 0;
    }

    public boolean isSpecialConstructor(@NotNull OCResolveContext context) {
        if (context == null) {
            OCFunctionSymbol.$$$reportNull$$$0(35);
        }
        return this.isCppConstructor() && (OCResolveOverloadsUtil.isCopyOrMoveConstructorOrOperator(this, context) || this.getNonInitializedParametersCount(context) == 0);
    }

    public boolean isMainFunction() {
        return ENTRY_POINTS.contains(this.myName) && this.getQualifierParent() == null && this.getQualifier() == null;
    }

    @Override
    public String getKindUppercase(@NotNull OCCompilationContext context) {
        if (context == null) {
            OCFunctionSymbol.$$$reportNull$$$0(36);
        }
        return this.isCppDestructor() ? "Destructor" : super.getKindUppercase(context);
    }

    @Override
    @NotNull
    public String getSignature(@NotNull Project project2) {
        if (project2 == null) {
            OCFunctionSymbol.$$$reportNull$$$0(37);
        }
        StringBuilder buffer = new StringBuilder();
        String typeText = this.getType().getReturnType().getName();
        buffer.append(typeText);
        if (!typeText.endsWith("*")) {
            buffer.append(" ");
        }
        buffer.append(this.getName());
        buffer.append(this.getParametersSignature(project2));
        this.getType().getCVQualifiers().appendCVQualifiers(buffer);
        String string = buffer.toString();
        if (string == null) {
            OCFunctionSymbol.$$$reportNull$$$0(38);
        }
        return string;
    }

    @NotNull
    public String getParametersSignature(@NotNull Project project2) {
        if (project2 == null) {
            OCFunctionSymbol.$$$reportNull$$$0(39);
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append('(');
        boolean isFirst = true;
        for (OCDeclaratorSymbol param : this.getParameterSymbols()) {
            if (!isFirst) {
                buffer.append(", ");
            }
            buffer.append(param.getSignature(project2));
            isFirst = false;
        }
        buffer.append(')');
        String string = buffer.toString();
        if (string == null) {
            OCFunctionSymbol.$$$reportNull$$$0(40);
        }
        return string;
    }

    public String getNiceAttributes() {
        ArrayList<String> words = new ArrayList<String>();
        for (OCSymbolAttribute oCSymbolAttribute : OCSymbolAttribute.values()) {
            if (!this.hasAttribute(oCSymbolAttribute)) continue;
            words.add(oCSymbolAttribute.name().toLowerCase());
        }
        for (Enum enum_ : Property.values()) {
            if (!this.hasProperty((Property)enum_)) continue;
            words.add(enum_.name().substring(3));
        }
        return "\u300a" + StringUtil.join(words, (String)" ") + "\u300b";
    }

    @Override
    public String toString() {
        return (Object)((Object)this.getKind()) + this.getNiceAttributes() + "[" + this.getName() + "]@" + (this.getContainingFile() != null ? this.getContainingFile().getName() + ":" : "") + this.getOffset();
    }

    @Override
    @NotNull
    public String getPresentableText() {
        String string = this.getSignatureWithoutParamNames();
        if (string == null) {
            OCFunctionSymbol.$$$reportNull$$$0(41);
        }
        return string;
    }

    @NotNull
    public String getSignatureWithoutParamNames() {
        String string = this.getSignatureWithoutParamNamesImpl(false, true, null);
        if (string == null) {
            OCFunctionSymbol.$$$reportNull$$$0(42);
        }
        return string;
    }

    @NotNull
    public String getSignatureWithoutParamNames(boolean fullyQualifiedName, boolean addReturnType, @NotNull OCResolveContext context) {
        if (context == null) {
            OCFunctionSymbol.$$$reportNull$$$0(43);
        }
        String string = this.getSignatureWithoutParamNamesImpl(fullyQualifiedName, addReturnType, context);
        if (string == null) {
            OCFunctionSymbol.$$$reportNull$$$0(44);
        }
        return string;
    }

    @NotNull
    private String getSignatureWithoutParamNamesImpl(boolean fullyQualifiedName, boolean addReturnType, @Nullable OCResolveContext context) {
        StringBuilder buffer = new StringBuilder();
        if (fullyQualifiedName) {
            assert (context != null);
            buffer.append(this.getNameWithParent(context));
        } else {
            buffer.append(this.getName());
        }
        buffer.append(this.getParamsSignatureWithoutNames());
        this.getType().getCVQualifiers().appendCVQualifiers(buffer);
        if (addReturnType && !this.isCppConstructor()) {
            buffer.append(" : ");
            buffer.append(this.getType().getReturnType().getName());
        }
        String string = buffer.toString();
        if (string == null) {
            OCFunctionSymbol.$$$reportNull$$$0(45);
        }
        return string;
    }

    @NotNull
    public String getParamsSignatureWithoutNames() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('(');
        boolean isFirst = true;
        for (OCDeclaratorSymbol param : this.getParameterSymbols()) {
            if (!isFirst) {
                buffer.append(", ");
            }
            buffer.append(param.getType().getName());
            isFirst = false;
        }
        buffer.append(")");
        String string = buffer.toString();
        if (string == null) {
            OCFunctionSymbol.$$$reportNull$$$0(46);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 34: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 34: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateParameters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterSymbols";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitution";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 43: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 34: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/cpp/OCFunctionSymbol";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/cpp/OCFunctionSymbol";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateParameters";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitution";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "clearSubstitution";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeWithoutSubstitution";
                break;
            }
            case 29: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterSymbols";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveResolvedType";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignature";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersSignature";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 42: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignatureWithoutParamNames";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignatureWithoutParamNamesImpl";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getParamsSignatureWithoutNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasAttribute";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasProperty";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isMember";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isCppMemberOperator";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isCppNonMemberOperator";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "locateFunctionDefinition";
                break;
            }
            case 16: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 34: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: {
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationInParent";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "resolveIsFriendOrStatic";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "resolveIsStatic";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "computeFullIconNow";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getParameterSymbols";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveType";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveResolvedType";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isSpecialConstructor";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getKindUppercase";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getSignature";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getParametersSignature";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getSignatureWithoutParamNames";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getDeclarationInParent$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 34: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Property
    extends Enum<Property> {
        public static final /* enum */ Property IS_TEMPLATE = new Property();
        public static final /* enum */ Property IS_OPERATOR = new Property();
        public static final /* enum */ Property IS_PURE_VIRTUAL = new Property();
        public static final /* enum */ Property IS_CONVERSION_OPERATOR = new Property();
        public static final /* enum */ Property IS_UDL = new Property();
        public static final int DEFAULT = 0;
        private static final /* synthetic */ Property[] $VALUES;

        public static Property[] values() {
            return (Property[])$VALUES.clone();
        }

        public static Property valueOf(String name2) {
            return Enum.valueOf(Property.class, name2);
        }

        public int getMask() {
            assert (this.ordinal() < 8);
            return 1 << 31 - this.ordinal();
        }

        static {
            $VALUES = new Property[]{IS_TEMPLATE, IS_OPERATOR, IS_PURE_VIRTUAL, IS_CONVERSION_OPERATOR, IS_UDL};
        }
    }
}

