/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCSymbolImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCIncludeSymbol
extends OCSymbolImpl {
    private transient VirtualFile myTargetFile;
    private boolean myOnce;
    private boolean myNext;
    private IncludePath myIncludePath;
    private int myEndOffset;
    private List<String> myNamespace;

    public OCIncludeSymbol() {
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            OCIncludeSymbol.$$$reportNull$$$0(0);
        }
        if (first == null) {
            OCIncludeSymbol.$$$reportNull$$$0(1);
        }
        if (second == null) {
            OCIncludeSymbol.$$$reportNull$$$0(2);
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCIncludeSymbol f = (OCIncludeSymbol)first;
        OCIncludeSymbol s = (OCIncludeSymbol)second;
        if (f.myNext != s.myNext) {
            return false;
        }
        if (f.myOnce != s.myOnce) {
            return false;
        }
        if (f.myEndOffset != s.myEndOffset) {
            return false;
        }
        if (!Comparing.equal((Object)f.myIncludePath, (Object)s.myIncludePath)) {
            return false;
        }
        if (!Comparing.equal((Object)f.myTargetFile, (Object)s.myTargetFile)) {
            return false;
        }
        return Comparing.equal(f.myNamespace, s.myNamespace);
    }

    /*
     * WARNING - void declaration
     */
    public OCIncludeSymbol(@NotNull Project project2, @Nullable VirtualFile file, long offset, @Nullable VirtualFile targetFile, @NotNull IncludePath path, boolean once, boolean next, int endOffset, @Nullable List<String> list) {
        void namespace;
        if (project2 == null) {
            OCIncludeSymbol.$$$reportNull$$$0(3);
        }
        if (path == null) {
            OCIncludeSymbol.$$$reportNull$$$0(4);
        }
        super(project2, file, offset, path.getPath(), Collections.emptyList());
        this.myIncludePath = path;
        this.myTargetFile = targetFile;
        this.myOnce = once;
        this.myNext = next;
        this.myEndOffset = endOffset;
        this.myNamespace = ContainerUtil.isEmpty((Collection)namespace) ? Collections.emptyList() : new ArrayList(namespace);
    }

    @Nullable
    public VirtualFile getTargetFile() {
        return this.myTargetFile;
    }

    public void updateTargetFile(@Nullable VirtualFile targetFile) {
        this.myTargetFile = targetFile;
    }

    public boolean isOnce() {
        return this.myOnce;
    }

    public boolean isNext() {
        return this.myNext;
    }

    public String getRelativePath() {
        return this.getName();
    }

    public String getLastPathComponent() {
        String path = this.getRelativePath();
        int idx = path.lastIndexOf(47);
        return idx >= 0 ? path.substring(idx + 1) : path;
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        OCSymbolKind oCSymbolKind = OCSymbolKind.IMPORT;
        if (oCSymbolKind == null) {
            OCIncludeSymbol.$$$reportNull$$$0(5);
        }
        return oCSymbolKind;
    }

    @NotNull
    public IncludePath getIncludePath() {
        IncludePath includePath = this.myIncludePath;
        if (includePath == null) {
            OCIncludeSymbol.$$$reportNull$$$0(6);
        }
        return includePath;
    }

    public int getEndOffset() {
        return this.myEndOffset;
    }

    public void enterNamespace(@NotNull OCInclusionContext ctx) {
        if (ctx == null) {
            OCIncludeSymbol.$$$reportNull$$$0(7);
        }
        for (String name2 : this.myNamespace) {
            ctx.enterNamespace(name2);
        }
    }

    public void exitNamespace(@NotNull OCInclusionContext ctx) {
        if (ctx == null) {
            OCIncludeSymbol.$$$reportNull$$$0(8);
        }
        for (String ignore : this.myNamespace) {
            ctx.exitNamespace();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/cpp/OCIncludeSymbol";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctx";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/cpp/OCIncludeSymbol";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "enterNamespace";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "exitNamespace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class IncludePath {
        private String myPath;
        private boolean myAngleBrackets;
        public static final IncludePath EMPTY = new EmptyIncludePath();

        public IncludePath() {
        }

        public IncludePath(String path, boolean angleBrackets) {
            this.myPath = path;
            this.myAngleBrackets = angleBrackets;
        }

        public String toString() {
            return this.myAngleBrackets ? "<" + this.myPath + ">" : "\"" + this.myPath + "\"";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IncludePath)) {
                return false;
            }
            IncludePath path = (IncludePath)o;
            if (this.myAngleBrackets != path.myAngleBrackets) {
                return false;
            }
            return !(this.myPath != null ? !this.myPath.equals(path.myPath) : path.myPath != null);
        }

        public int hashCode() {
            int result = this.myPath != null ? this.myPath.hashCode() : 0;
            result = 31 * result + (this.myAngleBrackets ? 1 : 0);
            return result;
        }

        public String getPath() {
            return this.myPath;
        }

        public boolean isAngleBrackets() {
            return this.myAngleBrackets;
        }

        private static class EmptyIncludePath
        extends IncludePath {
            private EmptyIncludePath() {
                super("", false);
            }
        }
    }
}

