/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.lexer.OCLexer;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCSymbolImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.symtable.OCNamesInternary;
import com.jetbrains.cidr.lang.util.OCImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMacroSymbol
extends OCSymbolImpl<OCDefineDirective>
implements Iconable {
    public static final String VA_ARGS_PARAM_NAME = "__VA_ARGS__...";
    private OCImmutableList<String> myParameterNames;
    private String mySubstitution;
    private boolean myHasParameterList;

    public OCMacroSymbol() {
    }

    /*
     * WARNING - void declaration
     */
    public OCMacroSymbol(@NotNull Project project2, @Nullable VirtualFile file, long offset, String name2, @Nullable OCImmutableList<String> parameterNames, @NotNull String string) {
        void substitution;
        if (project2 == null) {
            OCMacroSymbol.$$$reportNull$$$0(0);
        }
        if (string == null) {
            OCMacroSymbol.$$$reportNull$$$0(1);
        }
        super(project2, file, offset, name2, Collections.emptyList());
        this.myHasParameterList = parameterNames != null;
        this.myParameterNames = this.myHasParameterList ? parameterNames : OCImmutableList.emptyList();
        this.mySubstitution = substitution;
    }

    public static OCMacroSymbol inclusionGuard(@NotNull String name2, @NotNull Project project2) {
        if (name2 == null) {
            OCMacroSymbol.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            OCMacroSymbol.$$$reportNull$$$0(3);
        }
        return new OCMacroSymbol(project2, null, 0L, OCNamesInternary.intern(name2), null, "");
    }

    @NotNull
    public OCImmutableList<String> getParameterNames() {
        OCImmutableList<String> oCImmutableList = this.myParameterNames;
        if (oCImmutableList == null) {
            OCMacroSymbol.$$$reportNull$$$0(4);
        }
        return oCImmutableList;
    }

    @NotNull
    public List<String> getUserFriendlyParameterNames() {
        List list = ContainerUtil.map(this.myParameterNames, name2 -> VA_ARGS_PARAM_NAME.equals(name2) ? "..." : name2);
        if (list == null) {
            OCMacroSymbol.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    @NotNull
    public String getSubstitution() {
        String string = this.mySubstitution;
        if (string == null) {
            OCMacroSymbol.$$$reportNull$$$0(6);
        }
        return string;
    }

    public int getSubstitutionHash() {
        return this.mySubstitution.hashCode();
    }

    public boolean hasParameterList() {
        return this.myHasParameterList;
    }

    public String getParametersSignature() {
        if (!this.myHasParameterList) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append('(');
        boolean isFirst = true;
        Iterator iterator = this.myParameterNames.iterator();
        while (iterator.hasNext()) {
            String param = (String)iterator.next();
            if (!isFirst) {
                buffer.append(", ");
            }
            buffer.append(param);
            isFirst = false;
        }
        buffer.append(')');
        return buffer.toString();
    }

    public boolean isVararg() {
        return this.myParameterNames.size() > 0 && this.myParameterNames.get(this.myParameterNames.size() - 1).endsWith("...");
    }

    public String getPresentableSignature() {
        return this.getName() + this.getParametersSignature();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("#define ").append(this.myName);
        if (this.myHasParameterList) {
            builder.append('(');
            StringUtil.join(this.myParameterNames, (String)", ", (StringBuilder)builder);
            builder.append(')');
        }
        builder.append(' ').append(this.mySubstitution);
        return builder.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static OCMacroSymbol parseFromDirectiveContent(CharSequence content, OCFile file, long offset, @NotNull Project project2) {
        if (project2 == null) {
            OCMacroSymbol.$$$reportNull$$$0(7);
        }
        OCLexer contentLexer = new OCLexer(OCLexerSettings.forLanguage(OCLanguageKind.C).build());
        contentLexer.start(content);
        while (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(contentLexer.getTokenType())) {
            contentLexer.advance();
        }
        IElementType tt = contentLexer.getTokenType();
        if (tt == OCTokenTypes.IDENTIFIER || OCTokenTypes.KEYWORDS.contains(tt)) {
            void project3;
            IElementType t;
            ArrayList<String> params;
            String name2 = OCNamesInternary.intern(LexerUtil.getTokenText((Lexer)contentLexer).toString());
            contentLexer.advance();
            if (contentLexer.getTokenType() == OCTokenTypes.LPAR) {
                IElementType t2;
                params = new ArrayList<String>();
                contentLexer.advance();
                while ((t2 = contentLexer.getTokenType()) == OCTokenTypes.COMMA || t2 == OCTokenTypes.IDENTIFIER || OCTokenTypes.KEYWORDS.contains(t2) || OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(t2) || t2 == OCTokenTypes.ELLIPSIS) {
                    if (t2 == OCTokenTypes.IDENTIFIER || OCTokenTypes.KEYWORDS.contains(t2)) {
                        String paramName = OCNamesInternary.intern(LexerUtil.getTokenText((Lexer)contentLexer).toString());
                        contentLexer.advance();
                        while (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(contentLexer.getTokenType())) {
                            contentLexer.advance();
                        }
                        if (contentLexer.getTokenType() == OCTokenTypes.ELLIPSIS) {
                            contentLexer.advance();
                            paramName = paramName + "...";
                        }
                        params.add(paramName);
                        continue;
                    }
                    if (t2 == OCTokenTypes.ELLIPSIS) {
                        contentLexer.advance();
                        params.add(VA_ARGS_PARAM_NAME);
                        continue;
                    }
                    contentLexer.advance();
                }
                if (contentLexer.getTokenType() == OCTokenTypes.RPAR) {
                    contentLexer.advance();
                }
            } else {
                params = null;
            }
            if (contentLexer.getTokenType() == TokenType.WHITE_SPACE) {
                contentLexer.advance();
            }
            StringBuilder replacement = new StringBuilder();
            while ((t = contentLexer.getTokenType()) != null) {
                CharSequence token = LexerUtil.getTokenText((Lexer)contentLexer);
                if (t == TokenType.WHITE_SPACE) {
                    replacement.append(token.toString().replace('\\', ' '));
                } else if (t == OCTokenTypes.EOL_ESCAPE) {
                    replacement.append(' ');
                } else {
                    replacement.append(token);
                }
                contentLexer.advance();
            }
            OCImmutableList<String> parameterNames = params == null ? null : new OCImmutableList<String>(params);
            return new OCMacroSymbol((Project)project3, OCInclusionContextUtil.getVirtualFile(file), offset, name2, parameterNames, OCNamesInternary.intern(replacement.toString().trim()));
        }
        return null;
    }

    public Icon getIcon(int flags) {
        return this.getBaseIcon();
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        OCSymbolKind oCSymbolKind = OCSymbolKind.MACRO;
        if (oCSymbolKind == null) {
            OCMacroSymbol.$$$reportNull$$$0(8);
        }
        return oCSymbolKind;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            OCMacroSymbol.$$$reportNull$$$0(9);
        }
        if (first == null) {
            OCMacroSymbol.$$$reportNull$$$0(10);
        }
        if (second == null) {
            OCMacroSymbol.$$$reportNull$$$0(11);
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCMacroSymbol f = (OCMacroSymbol)first;
        OCMacroSymbol s = (OCMacroSymbol)second;
        if (f.myHasParameterList != s.myHasParameterList) {
            return false;
        }
        if (!Comparing.equal((String)f.mySubstitution, (String)s.mySubstitution)) {
            return false;
        }
        return Comparing.equal(f.myParameterNames, s.myParameterNames);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitution";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/cpp/OCMacroSymbol";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/cpp/OCMacroSymbol";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterNames";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserFriendlyParameterNames";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitution";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "inclusionGuard";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseFromDirectiveContent";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

