/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Producer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.OCTestFrameworks;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCCompilerGeneratedConstructorSymbol;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.symbols.ComplexTextRange;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolAttribute;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbolImpl;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.FindConstructorResult;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.visitors.OCTypeResolveVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCStructSymbol
extends OCNamespaceSymbol
implements OCTemplateSymbol<PsiElement> {
    private OCSymbolKind mySymbolKind;
    @NotNull
    private List<Pair<OCType, OCVisibility>> myBaseCppClasses;
    @NotNull
    private List<OCTypeParameterSymbol> myTemplateParameters;
    @Nullable
    private List<OCTypeArgument> myTemplateSpecialization;
    @NotNull
    private OCTypeSubstitution mySubstitution;
    @Nullable
    private ComplexTextRange myScope;
    @Nullable
    private List<OCType> myBefriendedTypes;
    private int myPropertiesAndAttributes;

    public OCStructSymbol() {
        this.mySubstitution = OCTypeSubstitution.ID;
    }

    /*
     * WARNING - void declaration
     */
    public OCStructSymbol(@NotNull Project project2, @Nullable VirtualFile file, long offset, @Nullable OCSymbolWithQualifiedName parent, @NotNull OCQualifiedName name2, @NotNull List<String> attributes, @NotNull OCSymbolKind kind, @NotNull List<Pair<OCType, OCVisibility>> baseClasses, @NotNull List<OCTypeParameterSymbol> templateParameters, @Nullable List<OCTypeArgument> templateSpecialization, @Nullable List<OCSymbol> membersList, @Nullable MostlySingularMultiMap<String, OCSymbol> members, ComplexTextRange scope, @Nullable OCVisibility visibility, int classProperties, int n) {
        void classAttributes;
        if (project2 == null) {
            OCStructSymbol.$$$reportNull$$$0(0);
        }
        if (name2 == null) {
            OCStructSymbol.$$$reportNull$$$0(1);
        }
        if (attributes == null) {
            OCStructSymbol.$$$reportNull$$$0(2);
        }
        if (kind == null) {
            OCStructSymbol.$$$reportNull$$$0(3);
        }
        if (baseClasses == null) {
            OCStructSymbol.$$$reportNull$$$0(4);
        }
        if (templateParameters == null) {
            OCStructSymbol.$$$reportNull$$$0(5);
        }
        super(project2, file, offset, parent, name2, attributes, membersList, members, null, false, visibility);
        this.mySubstitution = OCTypeSubstitution.ID;
        assert (kind == OCSymbolKind.STRUCT || kind == OCSymbolKind.UNION || kind == OCSymbolKind.ENUM);
        this.mySymbolKind = kind;
        this.myBaseCppClasses = baseClasses;
        this.myTemplateParameters = templateParameters;
        this.myTemplateSpecialization = templateSpecialization;
        this.myScope = scope;
        this.myPropertiesAndAttributes = classProperties | classAttributes;
    }

    public OCStructSymbol(@NotNull OCStructSymbol origin, @NotNull OCTypeSubstitution substitution) {
        if (origin == null) {
            OCStructSymbol.$$$reportNull$$$0(6);
        }
        if (substitution == null) {
            OCStructSymbol.$$$reportNull$$$0(7);
        }
        this(origin, substitution, origin.getParent());
    }

    public OCStructSymbol(@NotNull OCStructSymbol origin, @NotNull OCTypeSubstitution substitution, @Nullable OCSymbolWithQualifiedName parent) {
        if (origin == null) {
            OCStructSymbol.$$$reportNull$$$0(8);
        }
        if (substitution == null) {
            OCStructSymbol.$$$reportNull$$$0(9);
        }
        super(origin.myProject, origin.myFile, origin.myComplexOffset, parent, origin.getQualifiedName(), origin.getAttributes(), origin.getMembersList(), origin.getMembers(), null, false, origin.myVisibility);
        this.mySubstitution = OCTypeSubstitution.ID;
        this.mySymbolKind = origin.getKind();
        this.myBaseCppClasses = origin.myBaseCppClasses;
        this.myTemplateParameters = origin.myTemplateParameters;
        this.myTemplateSpecialization = origin.myTemplateSpecialization;
        this.mySubstitution = substitution;
        this.myScope = origin.getScope();
        this.myBefriendedTypes = origin.myBefriendedTypes;
        this.myPropertiesAndAttributes = origin.myPropertiesAndAttributes;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            OCStructSymbol.$$$reportNull$$$0(10);
        }
        if (first == null) {
            OCStructSymbol.$$$reportNull$$$0(11);
        }
        if (second == null) {
            OCStructSymbol.$$$reportNull$$$0(12);
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCStructSymbol f = (OCStructSymbol)first;
        OCStructSymbol s = (OCStructSymbol)second;
        if (!c.equalLists(f.myBefriendedTypes, s.myBefriendedTypes)) {
            return false;
        }
        if (f.myPropertiesAndAttributes != s.myPropertiesAndAttributes) {
            return false;
        }
        if (!Comparing.equal((Object)f.myScope, (Object)s.myScope)) {
            return false;
        }
        if (!Comparing.equal((Object)((Object)f.mySymbolKind), (Object)((Object)s.mySymbolKind))) {
            return false;
        }
        if (!c.equalLists(f.myBaseCppClasses, s.myBaseCppClasses)) {
            return false;
        }
        if (!c.equalObjects(f.mySubstitution, s.mySubstitution)) {
            return false;
        }
        if (!c.equalLists(f.myTemplateParameters, s.myTemplateParameters)) {
            return false;
        }
        return c.equalLists(f.myTemplateSpecialization, s.myTemplateSpecialization);
    }

    @Override
    public void updateOffset(int start, int lengthShift) {
        super.updateOffset(start, lengthShift);
        for (OCTypeParameterSymbol parameter : this.myTemplateParameters) {
            ((OCSymbol)((Object)parameter)).updateOffset(start, lengthShift);
        }
    }

    @Override
    public void compact() {
        super.compact();
        this.myBaseCppClasses = ContainerUtil.trimToSize(this.myBaseCppClasses);
        this.myTemplateParameters = ContainerUtil.trimToSize(this.myTemplateParameters);
        this.myTemplateSpecialization = ContainerUtil.trimToSize(this.myTemplateSpecialization);
        for (OCTypeParameterSymbol parameter : this.myTemplateParameters) {
            ((OCSymbol)((Object)parameter)).compact();
        }
        this.myBefriendedTypes = ContainerUtil.trimToSize(this.myBefriendedTypes);
    }

    @Override
    public boolean isFriend() {
        return this.hasAttribute(OCSymbolAttribute.FRIEND);
    }

    public boolean isFinal() {
        return this.hasAttribute(OCSymbolAttribute.FINAL);
    }

    public boolean isEnumClass() {
        return this.hasProperty(Property.IS_ENUM_CLASS);
    }

    @Override
    public boolean isQualifiedContainer() {
        return this.hasProperty(Property.IS_QUALIFIED_CONTAINER);
    }

    public boolean isEnum() {
        return this.getKind() == OCSymbolKind.ENUM;
    }

    @Override
    public boolean isTemplateSymbol() {
        return this.myTemplateParameters.size() != 0 || this.myTemplateSpecialization != null;
    }

    public boolean isInnerClass() {
        for (OCSymbolWithQualifiedName parent = this.myParent; parent != null; parent = parent.getParent()) {
            if (!(parent instanceof OCStructSymbol)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttribute(@NotNull OCSymbolAttribute attr) {
        if (attr == null) {
            OCStructSymbol.$$$reportNull$$$0(13);
        }
        return (this.myPropertiesAndAttributes & attr.getMask()) != 0;
    }

    public boolean hasProperty(@NotNull Property prop) {
        if (prop == null) {
            OCStructSymbol.$$$reportNull$$$0(14);
        }
        return (this.myPropertiesAndAttributes & prop.getMask()) != 0;
    }

    @Override
    @NotNull
    public List<OCTypeParameterSymbol> getTemplateParameters() {
        List<OCTypeParameterSymbol> list = this.myTemplateParameters;
        if (list == null) {
            OCStructSymbol.$$$reportNull$$$0(15);
        }
        return list;
    }

    @Override
    @Nullable
    public List<OCTypeArgument> getTemplateSpecialization() {
        return this.myTemplateSpecialization;
    }

    @Nullable
    public List<OCType> getBefriendedTypes() {
        return this.myBefriendedTypes;
    }

    @Override
    @NotNull
    public OCTypeSubstitution getSubstitution() {
        OCTypeSubstitution oCTypeSubstitution = this.mySubstitution;
        if (oCTypeSubstitution == null) {
            OCStructSymbol.$$$reportNull$$$0(16);
        }
        return oCTypeSubstitution;
    }

    @Override
    public boolean isVariadicTemplate() {
        return OCTemplateSymbolImpl.isVariadicTemplate(this);
    }

    @Override
    public boolean isSpecialization() {
        return this.getTemplateSpecialization() != null;
    }

    @Override
    public boolean isExplicitInstantiation() {
        return this.isTemplateSymbol() && this.getTemplateParameters().isEmpty();
    }

    @Override
    public int getRequiredTemplateArgumentsCnt() {
        return OCTemplateSymbolImpl.getRequiredTemplateArgumentsCnt(this);
    }

    @Override
    public boolean isGlobal() {
        return this.myScope == null;
    }

    @Override
    public boolean isPredeclaration() {
        return this.getMembers() == null;
    }

    @Override
    public boolean isDefinition() {
        return !this.isPredeclaration();
    }

    public void addBefriendedType(@NotNull OCType type) {
        if (type == null) {
            OCStructSymbol.$$$reportNull$$$0(17);
        }
        if (this.myBefriendedTypes == null) {
            this.myBefriendedTypes = new ArrayList<OCType>(1);
        }
        this.myBefriendedTypes.add(type);
    }

    public String getNiceAttributes() {
        ArrayList<String> words = new ArrayList<String>();
        for (OCSymbolAttribute oCSymbolAttribute : OCSymbolAttribute.values()) {
            if (!this.hasAttribute(oCSymbolAttribute)) continue;
            words.add(oCSymbolAttribute.name().toLowerCase());
        }
        for (Enum enum_ : Property.values()) {
            if (!this.hasProperty((Property)enum_)) continue;
            words.add(enum_.name().substring(3));
        }
        return "\u300a" + StringUtil.join(words, (String)" ") + "\u300b";
    }

    @Override
    public String toString() {
        return (Object)((Object)this.getKind()) + this.getNiceAttributes() + "[" + this.getName() + "]@" + this.getOffset();
    }

    @Override
    public String getKindUppercase(@NotNull OCCompilationContext context) {
        OCSymbolKind kind;
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(18);
        }
        if ((kind = this.getKind()) == OCSymbolKind.STRUCT && context.isCpp()) {
            return "Class";
        }
        return super.getKindUppercase(context);
    }

    @Override
    public boolean processMembers(@Nullable String memberName, @NotNull Processor<OCSymbol> processor2) {
        if (processor2 == null) {
            OCStructSymbol.$$$reportNull$$$0(19);
        }
        Processor inner = this.mySubstitution != OCTypeSubstitution.ID ? symbol -> {
            if (processor2 == null) {
                OCStructSymbol.$$$reportNull$$$0(72);
            }
            return processor2.process((Object)this.mySubstitution.substitute(symbol, this, false));
        } : processor2;
        return super.processMembers(memberName, (Processor<OCSymbol>)inner);
    }

    public boolean processFields(@NotNull Processor<OCDeclaratorSymbol> processor2) {
        if (processor2 == null) {
            OCStructSymbol.$$$reportNull$$$0(20);
        }
        return this.processMembers((String)null, new OCCommonProcessors.TypeFilteredProcessor(processor2, OCDeclaratorSymbol.class));
    }

    public boolean processFunctions(@Nullable String name2, @NotNull Processor<OCFunctionSymbol> processor2) {
        if (processor2 == null) {
            OCStructSymbol.$$$reportNull$$$0(21);
        }
        return this.processMembers(name2, new OCCommonProcessors.TypeFilteredProcessor(processor2, OCFunctionSymbol.class));
    }

    @Nullable
    public OCDeclaratorSymbol findField(String name2) {
        MostlySingularMultiMap<String, OCSymbol> members = this.getMembers();
        if (members == null) {
            return null;
        }
        CommonProcessors.FindFirstProcessor<OCSymbol> finder = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return symbol.getDelegate() instanceof OCDeclaratorSymbol;
            }
        };
        members.processForKey((Object)name2, (Processor)finder);
        OCDeclaratorSymbol result = (OCDeclaratorSymbol)finder.getFoundValue();
        return result != null ? (OCDeclaratorSymbol)result.getDelegate() : null;
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        OCSymbolKind oCSymbolKind = this.mySymbolKind;
        if (oCSymbolKind == null) {
            OCStructSymbol.$$$reportNull$$$0(22);
        }
        return oCSymbolKind;
    }

    @Override
    @NotNull
    public OCStructType getType() {
        OCStructType oCStructType = new OCStructType(this);
        if (oCStructType == null) {
            OCStructSymbol.$$$reportNull$$$0(23);
        }
        return oCStructType;
    }

    @Override
    @Nullable
    public ComplexTextRange getScope() {
        return this.myScope;
    }

    @Override
    public void setScope(@NotNull ComplexTextRange scope) {
        if (scope == null) {
            OCStructSymbol.$$$reportNull$$$0(24);
        }
        this.myScope = scope;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = this.getType().getName();
        if (string == null) {
            OCStructSymbol.$$$reportNull$$$0(25);
        }
        return string;
    }

    @Override
    public Icon computeFullIconNow(@Nullable PsiElement symbolElement, @NotNull Project project2) {
        Icon result;
        if (project2 == null) {
            OCStructSymbol.$$$reportNull$$$0(26);
        }
        if ((result = super.computeFullIconNow(symbolElement, project2)) == null) {
            return null;
        }
        return OCTestFrameworks.isTestClassOrStruct(this, symbolElement, project2) ? OCIcons.getTestIcon(result) : result;
    }

    private boolean processAllMembersWithName(String name2, Processor<OCSymbol> processor2, @NotNull OCResolveContext context) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(27);
        }
        if (!this.isGlobal()) {
            return this.processMembers(name2, processor2);
        }
        OCSymbol definition = this.getDefinitionSymbol(context.getProject());
        Processor _processor = symbol -> {
            if (context == null) {
                OCStructSymbol.$$$reportNull$$$0(71);
            }
            if (!symbol.getClass().equals(OCFunctionSymbol.class)) {
                return true;
            }
            OCSymbolWithQualifiedName resolvedQualifiedName = ((OCSymbolWithQualifiedName)symbol).getResolvedOwner(context);
            if (resolvedQualifiedName == null || !resolvedQualifiedName.equals(definition)) {
                return true;
            }
            return processor2.process(symbol);
        };
        return OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(context.getProject(), (Processor<OCSymbol>)_processor, name2);
    }

    public boolean processConstructors(Processor<? super OCFunctionSymbol> processor2) {
        return this.processConstructors(processor2, false, false, false, null);
    }

    public boolean processConstructors(Processor<? super OCFunctionSymbol> processor2, @NotNull OCResolveContext context) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(28);
        }
        return this.processConstructors(processor2, false, true, false, context);
    }

    public boolean processConstructors(Processor<? super OCFunctionSymbol> processor2, boolean includeOutOfClassDefinitions, @NotNull OCResolveContext context) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(29);
        }
        return this.processConstructors(processor2, includeOutOfClassDefinitions, false, false, context);
    }

    private boolean processConstructors(Processor<? super OCFunctionSymbol> processor2, boolean includeOutOfClassDefinitions, boolean includeUsingBaseConstructors, boolean includeImplicitCtors, @Nullable OCResolveContext context) {
        Processor memberProcessor = symbol -> {
            if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppConstructor()) {
                return processor2.process((Object)((OCFunctionSymbol)symbol));
            }
            return true;
        };
        if (includeUsingBaseConstructors && context != null && !this.processConstructorsFromUsings((Processor<OCSymbol>)memberProcessor, context)) {
            return false;
        }
        if (includeImplicitCtors && context != null && this.processConstructors((Processor<? super OCFunctionSymbol>)new CommonProcessors.FindFirstProcessor(), context) && !processor2.process((Object)new OCCompilerGeneratedConstructorSymbol(this, OCCompilerGeneratedConstructorSymbol.Kind.DefaultCtor, context.getProject()))) {
            return false;
        }
        if (includeOutOfClassDefinitions) {
            assert (context != null);
            return this.processAllMembersWithName(this.myName, (Processor<OCSymbol>)memberProcessor, context);
        }
        return this.processMembers(this.myName, (Processor<OCSymbol>)memberProcessor);
    }

    public boolean processConstructorsFromUsings(@NotNull Processor<OCSymbol> processor2, @NotNull OCResolveContext context) {
        if (processor2 == null) {
            OCStructSymbol.$$$reportNull$$$0(30);
        }
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(31);
        }
        return this.processMembers((String)null, (Processor<OCSymbol>)((Processor)symbol -> {
            if (processor2 == null) {
                OCStructSymbol.$$$reportNull$$$0(67);
            }
            if (context == null) {
                OCStructSymbol.$$$reportNull$$$0(68);
            }
            if (symbol instanceof OCUsingSymbol) {
                OCSymbolReference reference = ((OCUsingSymbol)symbol).getSymbolReference();
                OCQualifiedName name2 = reference.getQualifiedName();
                OCQualifiedName qualifier = name2.getQualifier();
                Processor ctorProcessor = c -> {
                    if (processor2 == null) {
                        OCStructSymbol.$$$reportNull$$$0(69);
                    }
                    if (context == null) {
                        OCStructSymbol.$$$reportNull$$$0(70);
                    }
                    return processor2.process((Object)this.mySubstitution.substitute(new OCCompilerGeneratedConstructorSymbol(this, c.getParameterSymbols(), context.getProject()), context));
                };
                if (qualifier != null && qualifier.getNameWithParent().equals(name2.getName())) {
                    for (OCSymbol baseClass : reference.getSymbolReferenceToQualifier().resolveToSymbols(true, true, true, context.substitute(this.getSubstitution()))) {
                        if (!this.isSameSymbol(baseClass, context) && (!(baseClass instanceof OCStructSymbol) || ((OCStructSymbol)baseClass).processConstructors((Processor<? super OCFunctionSymbol>)ctorProcessor, false, true, true, context))) continue;
                        return false;
                    }
                }
                return reference.processPossibleSymbols((Processor<OCSymbol>)((Processor)s -> !(s instanceof OCFunctionSymbol) || !((OCFunctionSymbol)s).isCppConstructor() || ctorProcessor.process((Object)((OCFunctionSymbol)s))), context.substitute(((OCUsingSymbol)symbol).getSubstitution()));
            }
            return true;
        }));
    }

    public boolean processDestructors(Processor<OCFunctionSymbol> processor2, boolean includeOutOfClassDefinitions, @NotNull OCResolveContext context) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(32);
        }
        Processor memberProcessor = symbol -> {
            if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppDestructor()) {
                return processor2.process((Object)((OCFunctionSymbol)symbol));
            }
            return true;
        };
        if (includeOutOfClassDefinitions) {
            return this.processAllMembersWithName("~" + this.myName, (Processor<OCSymbol>)memberProcessor, context);
        }
        return this.processMembers("~" + this.myName, (Processor<OCSymbol>)memberProcessor);
    }

    public boolean hasDefaultConstructor(@NotNull OCResolveContext context) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(33);
        }
        class MyProcessor
        implements Processor<OCFunctionSymbol> {
            boolean wasConstructor;
            boolean wasDefaultConstructor;

            MyProcessor() {
            }

            public boolean process(OCFunctionSymbol symbol) {
                this.wasConstructor = true;
                this.wasDefaultConstructor |= symbol.canBeCalledWithoutArguments();
                return true;
            }

            public boolean hasDefaultConstructor() {
                return !this.wasConstructor || this.wasDefaultConstructor;
            }
        }
        MyProcessor processor2 = new MyProcessor();
        this.processConstructors(processor2, context);
        return processor2.hasDefaultConstructor();
    }

    public boolean hasDeclaredConstructor(@NotNull OCResolveContext context) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(34);
        }
        return !this.processConstructors((Processor<? super OCFunctionSymbol>)new CommonProcessors.FindFirstProcessor(), context);
    }

    @Nullable
    public OCFunctionSymbol getDefaultConstructor(@NotNull OCResolveContext context) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(35);
        }
        CommonProcessors.FindFirstProcessor<OCFunctionSymbol> finder = new CommonProcessors.FindFirstProcessor<OCFunctionSymbol>(){

            protected boolean accept(OCFunctionSymbol symbol) {
                return symbol.canBeCalledWithoutArguments();
            }
        };
        this.processConstructors((Processor<? super OCFunctionSymbol>)finder, context);
        return (OCFunctionSymbol)finder.getFoundValue();
    }

    public boolean hasTrivialDestructor(@NotNull OCResolveContext context) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(36);
        }
        return this.hasTrivialDestructor(new HashMap<OCStructSymbol, Optional<Boolean>>(), context);
    }

    private boolean hasTrivialDestructor(@NotNull HashMap<OCStructSymbol, Optional<Boolean>> processingSymbols, @NotNull OCResolveContext context) {
        if (processingSymbols == null) {
            OCStructSymbol.$$$reportNull$$$0(37);
        }
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(38);
        }
        if (processingSymbols.containsKey(this)) {
            Optional<Boolean> hasTrivialDestructor = processingSymbols.get(this);
            return hasTrivialDestructor.orElse(false);
        }
        OCStructType myType = this.getType();
        OCSymbolKind kind = this.getKind();
        if (kind != OCSymbolKind.STRUCT && kind != OCSymbolKind.UNION) {
            return true;
        }
        Processor dtorProcessor = dtor -> !dtor.isVirtual() && dtor.isDefault();
        BaseClassProcessor baseClassProcessor = (symbol, visibility) -> {
            if (processingSymbols == null) {
                OCStructSymbol.$$$reportNull$$$0(65);
            }
            if (context == null) {
                OCStructSymbol.$$$reportNull$$$0(66);
            }
            if (symbol instanceof OCStructSymbol) {
                return ((OCStructSymbol)symbol).hasTrivialDestructor(processingSymbols, context);
            }
            return false;
        };
        Processor fieldsProcessor = field -> {
            OCType type;
            if (context == null) {
                OCStructSymbol.$$$reportNull$$$0(63);
            }
            if (processingSymbols == null) {
                OCStructSymbol.$$$reportNull$$$0(64);
            }
            if ((type = field.getType().resolve(context)) instanceof OCStructType) {
                return ((OCStructType)type).getSymbol().hasTrivialDestructor(processingSymbols, context);
            }
            return !type.isUnknown();
        };
        processingSymbols.put(this, Optional.empty());
        boolean hasTrivialDestructor = !this.isPredeclaration() && !myType.isMagicInside(context) && this.processDestructors((Processor<OCFunctionSymbol>)dtorProcessor, false, context) && this.processBaseClasses(context, baseClassProcessor) && this.processFields((Processor<OCDeclaratorSymbol>)fieldsProcessor);
        processingSymbols.put(this, Optional.of(hasTrivialDestructor));
        return hasTrivialDestructor;
    }

    public boolean hasBaseClasses() {
        return !this.myBaseCppClasses.isEmpty();
    }

    public boolean isPOD(boolean checkInnerStructs, @NotNull OCResolveContext context) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(39);
        }
        if (this.mySymbolKind != OCSymbolKind.STRUCT && this.mySymbolKind != OCSymbolKind.ENUM) {
            return false;
        }
        if (this.hasBaseClasses()) {
            return false;
        }
        return OCStructSymbol.isPOD(this, new HashSet<OCSymbol>(), checkInnerStructs, context);
    }

    public boolean isPOD(@NotNull OCResolveContext context) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(40);
        }
        return this.isPOD(true, context);
    }

    private static boolean isPOD(OCStructSymbol symbol, Set<OCSymbol> processed, boolean checkInnerStructs, @NotNull OCResolveContext context) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(41);
        }
        boolean[] pod = new boolean[]{true};
        symbol.processMembers((String)null, (Processor<OCSymbol>)((Processor)symbol12 -> {
            if (context == null) {
                OCStructSymbol.$$$reportNull$$$0(61);
            }
            if (!processed.add((OCSymbol)symbol12)) {
                return true;
            }
            if (symbol12 instanceof OCStructSymbol) {
                if (checkInnerStructs && !OCStructSymbol.isPOD((OCStructSymbol)symbol12, processed, true, context)) {
                    pod[0] = false;
                    return false;
                }
            } else if (symbol12 instanceof OCDeclaratorSymbol) {
                OCVisibility vis = ((OCDeclaratorSymbol)symbol12).getVisibility();
                if (vis != null && vis != OCVisibility.HACK_MORE_VISIBLE_THAN_PUBLIC && vis != OCVisibility.PUBLIC) {
                    pod[0] = false;
                    return false;
                }
                OCType type = symbol12.getType().resolve(context);
                if (checkInnerStructs && type instanceof OCStructType && symbol12.getKind() != OCSymbolKind.TYPEDEF && ContainerUtil.exists(((OCStructType)type).getStructs(), symbol1 -> {
                    if (context == null) {
                        OCStructSymbol.$$$reportNull$$$0(62);
                    }
                    return !OCStructSymbol.isPOD(symbol1, processed, true, context);
                })) {
                    pod[0] = false;
                    return false;
                }
            }
            return true;
        }));
        return pod[0];
    }

    public boolean hasMemberFunctions() {
        return !this.processFunctions(null, (Processor<OCFunctionSymbol>)new CommonProcessors.FindFirstProcessor());
    }

    @NotNull
    public Collection<OCType> getBaseCppClasses(@NotNull PsiElement context) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(42);
        }
        Collection<OCType> collection = this.getBaseCppClasses(OCResolveContext.forPsi(context));
        if (collection == null) {
            OCStructSymbol.$$$reportNull$$$0(43);
        }
        return collection;
    }

    @NotNull
    public Collection<OCType> getBaseCppClasses(@NotNull OCResolveContext context) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(44);
        }
        List list = ContainerUtil.map(this.myBaseCppClasses, pair2 -> {
            if (context == null) {
                OCStructSymbol.$$$reportNull$$$0(60);
            }
            return this.mySubstitution.substitute((OCType)pair2.first, context);
        });
        if (list == null) {
            OCStructSymbol.$$$reportNull$$$0(45);
        }
        return list;
    }

    @NotNull
    public Collection<Pair<OCType, OCVisibility>> getBaseCppClassesWithVisibility(@NotNull OCResolveContext context) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(46);
        }
        List list = ContainerUtil.map(this.myBaseCppClasses, pair2 -> {
            if (context == null) {
                OCStructSymbol.$$$reportNull$$$0(59);
            }
            OCType type = this.mySubstitution.substitute((OCType)pair2.first, context);
            return new Pair((Object)type, pair2.second);
        });
        if (list == null) {
            OCStructSymbol.$$$reportNull$$$0(47);
        }
        return list;
    }

    public boolean processBaseClasses(@NotNull OCResolveContext context, BaseClassProcessor processor2) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(48);
        }
        for (Pair<OCType, OCVisibility> pair2 : this.myBaseCppClasses) {
            OCType type = this.mySubstitution.substitute((OCType)pair2.first, context);
            OCType resolved = type.accept(new OCTypeResolveVisitor(context));
            if (OCStructSymbol.processBaseClass(resolved.isUnknown() ? type : resolved, (OCVisibility)((Object)pair2.second), processor2, context)) continue;
            return false;
        }
        return true;
    }

    private static boolean processBaseClass(OCType type, OCVisibility visibility, BaseClassProcessor processor2, @NotNull OCResolveContext context) {
        block5: {
            block6: {
                block4: {
                    if (context == null) {
                        OCStructSymbol.$$$reportNull$$$0(49);
                    }
                    ProgressManager.checkCanceled();
                    if (!(type instanceof OCStructType)) break block4;
                    for (OCStructSymbol symbol : ((OCStructType)type).getStructs()) {
                        if (processor2.process(symbol, visibility)) continue;
                        return false;
                    }
                    break block5;
                }
                if (!(type instanceof OCReferenceType)) break block6;
                for (OCSymbol baseSymbol : context.resolveToSymbols(((OCReferenceType)type).getReference(context), true, true)) {
                    ProgressManager.checkCanceled();
                    if (processor2.process(baseSymbol, visibility)) continue;
                    return false;
                }
                break block5;
            }
            if (!(type instanceof OCExpansionPackType)) break block5;
            for (OCTypeArgument typeArgument : ((OCExpansionPackType)type).getExpansions()) {
                if (!(typeArgument instanceof OCType) || OCStructSymbol.processBaseClass((OCType)typeArgument, visibility, processor2, context)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean processAllBaseClasses(BaseClassProcessor processor2, @NotNull OCResolveContext context) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(50);
        }
        return this.processAllBaseClasses(context, processor2, true);
    }

    public boolean processAllBaseClasses(@NotNull OCResolveContext context, BaseClassProcessor processor2, boolean skipFirstVisibility) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(51);
        }
        Set processed = OCTypeUtils.newSymbolWithSubstitutionSet();
        Stack<OCStructSymbol> structsWorkset = new Stack<OCStructSymbol>();
        Stack visibilityWorkset = new Stack();
        structsWorkset.add(this);
        visibilityWorkset.add(null);
        while (!structsWorkset.isEmpty()) {
            OCStructSymbol symbol = (OCStructSymbol)structsWorkset.pop();
            OCVisibility visibility = (OCVisibility)((Object)visibilityWorkset.pop());
            if (processed.contains(symbol)) continue;
            processed.add(symbol);
            if (symbol.processBaseClasses(context, (baseSymbol, baseVisibility) -> {
                baseVisibility = visibility == null ? (skipFirstVisibility ? OCVisibility.PUBLIC : baseVisibility) : OCVisibility.leastVisible(visibility, baseVisibility);
                if (!processor2.process(baseSymbol, baseVisibility)) {
                    return false;
                }
                if (baseSymbol instanceof OCStructSymbol) {
                    structsWorkset.push((OCStructSymbol)baseSymbol);
                    visibilityWorkset.push(baseVisibility);
                }
                return true;
            })) continue;
            return false;
        }
        return true;
    }

    public boolean isAncestor(OCStructSymbol struct, @NotNull OCResolveContext context) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(52);
        }
        return this.resolvedNamesEqual(struct, context) || !struct.processAllBaseClasses((symbol, visibility) -> {
            if (context == null) {
                OCStructSymbol.$$$reportNull$$$0(58);
            }
            return !(symbol instanceof OCStructSymbol) || !this.resolvedNamesEqual((OCSymbolWithQualifiedName)symbol, context);
        }, context);
    }

    @NotNull
    public List<OCTypeArgument> getTemplateArguments(@NotNull OCResolveContext context) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(53);
        }
        ArrayList<OCTypeArgument> result = new ArrayList<OCTypeArgument>();
        List<OCTypeArgument> specialization = this.getTemplateSpecialization();
        if (specialization != null) {
            for (OCTypeArgument spec : specialization) {
                if (spec instanceof OCType) {
                    OCType substitution = ((OCType)spec).transformType(new OCTypeResolveVisitor(context.substituteFirst(this.getSubstitution()), false));
                    if (substitution instanceof OCStructType && ((OCStructType)substitution).getSymbol().equals(this)) continue;
                    result.add(substitution);
                    continue;
                }
                result.add(spec);
            }
        } else {
            for (OCTypeParameterSymbol param : this.getTemplateParameters()) {
                OCTypeArgument argument = this.getSubstitution().getSubstitutionFor(param);
                if (argument instanceof OCExpansionPackType) {
                    result.addAll(((OCExpansionPackType)argument).getExpansions());
                    continue;
                }
                if (argument != null) {
                    result.add(argument);
                    continue;
                }
                result.add(new OCTypeParameterType(param));
            }
        }
        ArrayList<OCTypeArgument> arrayList = result;
        if (arrayList == null) {
            OCStructSymbol.$$$reportNull$$$0(54);
        }
        return arrayList;
    }

    public FindConstructorResult findConstructor(@NotNull OCArgumentsList<?> arguments, @NotNull OCResolveContext context, boolean allowImplicitConversions, final @Nullable Producer<Boolean> isExplicitCall, boolean isListInitialization, @NotNull OCStructType type) {
        if (arguments == null) {
            OCStructSymbol.$$$reportNull$$$0(55);
        }
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(56);
        }
        if (type == null) {
            OCStructSymbol.$$$reportNull$$$0(57);
        }
        CommonProcessors.CollectProcessor<OCSymbol> collector = new CommonProcessors.CollectProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return symbol instanceof OCFunctionSymbol;
            }
        };
        this.processConstructors((Processor<? super OCFunctionSymbol>)collector, context);
        Collection symbols = collector.getResults();
        symbols.add(this);
        Collection filtered = isExplicitCall != null ? ContainerUtil.filter((Collection)symbols, (Condition)new Condition<OCSymbol>(){
            Boolean myExplicitConstructorCall;

            public boolean value(OCSymbol symbol) {
                if (!(symbol instanceof OCFunctionSymbol) || !((OCFunctionSymbol)symbol).isExplicit()) {
                    return true;
                }
                if (this.myExplicitConstructorCall == null) {
                    this.myExplicitConstructorCall = (Boolean)isExplicitCall.produce();
                }
                return this.myExplicitConstructorCall;
            }
        }) : symbols;
        return OCResolveOverloadsUtil.resolveConstructorOverloads(type, filtered, arguments, allowImplicitConversions, isListInitialization, context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 16: 
            case 22: 
            case 23: 
            case 25: 
            case 43: 
            case 45: 
            case 47: 
            case 54: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 16: 
            case 22: 
            case 23: 
            case 25: 
            case 43: 
            case 45: 
            case 47: 
            case 54: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClasses";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateParameters";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitution";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prop";
                break;
            }
            case 15: 
            case 16: 
            case 22: 
            case 23: 
            case 25: 
            case 43: 
            case 45: 
            case 47: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol";
                break;
            }
            case 17: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 18: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 66: 
            case 68: 
            case 70: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 30: 
            case 67: 
            case 69: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 37: 
            case 64: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingSymbols";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateParameters";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitution";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 43: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseCppClasses";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseCppClassesWithVisibility";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "hasAttribute";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "hasProperty";
                break;
            }
            case 15: 
            case 16: 
            case 22: 
            case 23: 
            case 25: 
            case 43: 
            case 45: 
            case 47: 
            case 54: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addBefriendedType";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getKindUppercase";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processMembers";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processFields";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processFunctions";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setScope";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "computeFullIconNow";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "processAllMembersWithName";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processConstructors";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processConstructorsFromUsings";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "processDestructors";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "hasDefaultConstructor";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "hasDeclaredConstructor";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultConstructor";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "hasTrivialDestructor";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isPOD";
                break;
            }
            case 42: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getBaseCppClasses";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getBaseCppClassesWithVisibility";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "processBaseClasses";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "processBaseClass";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "processAllBaseClasses";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateArguments";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "findConstructor";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isAncestor$15";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getBaseCppClassesWithVisibility$13";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getBaseCppClasses$12";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isPOD$11";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$10";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "lambda$hasTrivialDestructor$9";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "lambda$hasTrivialDestructor$8";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processConstructorsFromUsings$5";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$3";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processAllMembersWithName$1";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processMembers$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 16: 
            case 22: 
            case 23: 
            case 25: 
            case 43: 
            case 45: 
            case 47: 
            case 54: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface BaseClassProcessor {
        public boolean process(OCSymbol var1, OCVisibility var2);
    }

    public static final class Property
    extends Enum<Property> {
        public static final /* enum */ Property IS_ENUM_CLASS = new Property();
        public static final /* enum */ Property IS_QUALIFIED_CONTAINER = new Property();
        public static final int DEFAULT = 0;
        private static final /* synthetic */ Property[] $VALUES;

        public static Property[] values() {
            return (Property[])$VALUES.clone();
        }

        public static Property valueOf(String name2) {
            return Enum.valueOf(Property.class, name2);
        }

        public int getMask() {
            assert (this.ordinal() < 8);
            return 1 << 31 - this.ordinal();
        }

        static {
            $VALUES = new Property[]{IS_ENUM_CLASS, IS_QUALIFIED_CONTAINER};
        }
    }
}

