/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.psi.impl.OCFileImpl;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.names.OCTypeNameVisitor;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCDebugUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCSymbolWithQualifiedName<T extends PsiElement>
extends OCSymbolImpl<T>
implements OCSymbolWithParent<T, OCSymbolWithQualifiedName<T>> {
    @NotNull
    private OCQualifiedName myQualifiedName;
    @Nullable
    protected OCSymbolWithQualifiedName myParent;
    @Nullable
    protected OCVisibility myVisibility;
    public static final Condition<OCSymbol> WITHOUT_QUALIFIER = symbol -> !(symbol instanceof OCSymbolWithQualifiedName) || ((OCSymbolWithQualifiedName)symbol).getQualifier() == null;

    public OCSymbolWithQualifiedName() {
    }

    /*
     * WARNING - void declaration
     */
    public OCSymbolWithQualifiedName(@NotNull Project project2, @Nullable VirtualFile file, long offset, @Nullable OCSymbolWithQualifiedName parent, @NotNull OCQualifiedName qualifiedName, @NotNull List<String> attributes, @Nullable OCVisibility oCVisibility) {
        void visibility;
        if (project2 == null) {
            OCSymbolWithQualifiedName.$$$reportNull$$$0(0);
        }
        if (qualifiedName == null) {
            OCSymbolWithQualifiedName.$$$reportNull$$$0(1);
        }
        if (attributes == null) {
            OCSymbolWithQualifiedName.$$$reportNull$$$0(2);
        }
        super(project2, file, offset, qualifiedName.getName(), attributes);
        this.myParent = parent;
        this.myQualifiedName = qualifiedName;
        this.myVisibility = visibility;
    }

    @Nullable
    public OCQualifiedName getQualifier() {
        return this.myQualifiedName.getQualifier();
    }

    @NotNull
    public OCQualifiedName getQualifiedName() {
        OCQualifiedName oCQualifiedName = this.myQualifiedName;
        if (oCQualifiedName == null) {
            OCSymbolWithQualifiedName.$$$reportNull$$$0(3);
        }
        return oCQualifiedName;
    }

    @Override
    @NotNull
    public String getNameWithParent(@NotNull OCResolveContext context) {
        if (context == null) {
            OCSymbolWithQualifiedName.$$$reportNull$$$0(4);
        }
        if (this.myQualifiedName.getQualifier() != null) {
            String string = this.myQualifiedName.getFullName(context);
            if (string == null) {
                OCSymbolWithQualifiedName.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (this.myParent != null) {
            String string = this.myParent.getName() + "::" + this.myName;
            if (string == null) {
                OCSymbolWithQualifiedName.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = this.myName;
        if (string == null) {
            OCSymbolWithQualifiedName.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public OCVisibility getVisibility() {
        return this.myVisibility;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            OCSymbolWithQualifiedName.$$$reportNull$$$0(8);
        }
        if (first == null) {
            OCSymbolWithQualifiedName.$$$reportNull$$$0(9);
        }
        if (second == null) {
            OCSymbolWithQualifiedName.$$$reportNull$$$0(10);
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCSymbolWithQualifiedName f = (OCSymbolWithQualifiedName)first;
        OCSymbolWithQualifiedName s = (OCSymbolWithQualifiedName)second;
        if (f.myVisibility != s.myVisibility) {
            return false;
        }
        if (!c.equalObjects(f.myQualifiedName, s.myQualifiedName)) {
            return false;
        }
        return c.equalObjects(f.myParent, s.myParent);
    }

    @Deprecated
    public boolean resolvedNamesEqual(OCSymbolWithQualifiedName symbol) {
        if (this.equals(symbol)) {
            return true;
        }
        OCQualifiedName qualifiedName = symbol.getQualifiedName();
        if (!Comparing.equal((String)this.myQualifiedName.getName(), (String)qualifiedName.getName())) {
            return false;
        }
        if (this.isPredeclaration() || symbol.isPredeclaration()) {
            return true;
        }
        OCResolveContext context = OCResolveContext.forSymbol(this, this.getProject());
        if (symbol instanceof OCStructSymbol && ((OCStructSymbol)symbol).isSpecialization() || this instanceof OCStructSymbol && ((OCStructSymbol)this).isSpecialization()) {
            return Comparing.equal((Object)this.getResolvedQualifiedNameWithoutInlineNamespaces(context), (Object)symbol.getResolvedQualifiedNameWithoutInlineNamespaces(context));
        }
        return Comparing.equal((Object)this.getResolvedQualifiedNameWithoutArguments(context), (Object)symbol.getResolvedQualifiedNameWithoutArguments(context));
    }

    public boolean resolvedNamesEqual(OCSymbolWithQualifiedName symbol, @Nullable OCResolveContext context) {
        if (context == null) {
            return this.resolvedNamesEqual(symbol);
        }
        if (DeepEqual.equalObjects(this, symbol)) {
            return true;
        }
        OCQualifiedName qualifiedName = symbol.getQualifiedName();
        if (!Comparing.equal((String)this.myQualifiedName.getName(), (String)qualifiedName.getName())) {
            return false;
        }
        if (this.isPredeclaration() || symbol.isPredeclaration()) {
            return true;
        }
        OCQualifiedName n1 = this.getResolvedQualifiedName(false, context, true, true, true, true, true);
        OCQualifiedName n2 = symbol.getResolvedQualifiedName(false, context, true, true, true, true, true);
        return OCQualifiedName.areResolvedNamesEquals(n1, n2, context);
    }

    @Nullable
    public OCQualifiedName getResolvedQualifiedName(@NotNull OCResolveContext context) {
        if (context == null) {
            OCSymbolWithQualifiedName.$$$reportNull$$$0(11);
        }
        return this.getResolvedQualifiedName(false, context, true, true, true, true, true);
    }

    @Nullable
    public OCQualifiedName getResolvedQualifiedNameWithoutInlineNamespaces(@NotNull OCResolveContext context) {
        if (context == null) {
            OCSymbolWithQualifiedName.$$$reportNull$$$0(12);
        }
        return this.getResolvedQualifiedName(true, context, true, false, true, true, true);
    }

    @Nullable
    public OCQualifiedName getResolvedQualifiedNameWithoutArguments(@NotNull OCResolveContext context) {
        if (context == null) {
            OCSymbolWithQualifiedName.$$$reportNull$$$0(13);
        }
        return this.getResolvedQualifiedName(false, false, context);
    }

    @Nullable
    public OCQualifiedName getResolvedQualifiedName(boolean withoutInlineNamespaces, boolean appendArguments, @NotNull OCResolveContext context) {
        if (context == null) {
            OCSymbolWithQualifiedName.$$$reportNull$$$0(14);
        }
        return this.getResolvedQualifiedName(withoutInlineNamespaces, context, true, appendArguments, true, true, true);
    }

    @Nullable
    public OCQualifiedName getResolvedQualifiedName(boolean withoutInlineNamespaces, @NotNull OCResolveContext context, boolean processTypesOnly, boolean appendArguments, boolean resolveArguments, boolean removeDefaultArguments, boolean treatNonMemberOperators) {
        if (context == null) {
            OCSymbolWithQualifiedName.$$$reportNull$$$0(15);
        }
        return this.getResolvedQualifiedName(withoutInlineNamespaces, context, processTypesOnly, appendArguments, resolveArguments, removeDefaultArguments, treatNonMemberOperators, true, null);
    }

    @Nullable
    public OCQualifiedName getResolvedQualifiedName(boolean withoutInlineNamespaces, @NotNull OCResolveContext context, boolean processTypesOnly, boolean appendArguments, boolean resolveArguments, boolean removeDefaultArguments, boolean treatNonMemberOperators, boolean longest, @Nullable Consumer<OCSymbolWithQualifiedName> observer) {
        if (context == null) {
            OCSymbolWithQualifiedName.$$$reportNull$$$0(16);
        }
        OCQualifiedName result = null;
        if (this.myQualifiedName.isAbsolute()) {
            result = this.myQualifiedName;
        } else {
            OCStructSymbol operatorParent = treatNonMemberOperators ? context.getNonMemberOperatorParent(this) : null;
            OCQualifiedName qualifier = this.myQualifiedName.getQualifier();
            OCSymbolWithQualifiedName baseParent = this.getQualifierParent();
            if (qualifier != null && operatorParent == null) {
                OCSymbolReference.GlobalReference reference = OCSymbolReference.getGlobalReference(qualifier, baseParent, this.getContainingFile(), this.getComplexOffset(), OCSymbolReference.SymbolKindFilter.ONLY_NAMESPACE_LIKE);
                List<OCSymbol> possibleSymbols = context.resolveToSymbols(reference, true, processTypesOnly);
                for (OCSymbol possibleSymbol : possibleSymbols) {
                    if (!(possibleSymbol instanceof OCNamespaceSymbol)) continue;
                    OCNamespaceSymbol parent = (OCNamespaceSymbol)possibleSymbol;
                    OCQualifiedName resolvedQualifier = parent.getResolvedQualifiedName(withoutInlineNamespaces, context, processTypesOnly, appendArguments, true, removeDefaultArguments, treatNonMemberOperators, longest, observer);
                    OCQualifiedName name2 = OCQualifiedName.with(resolvedQualifier, this.myName);
                    if (result != null && (!longest || result.getDepth() >= name2.getDepth()) && (longest || result.getDepth() <= name2.getDepth())) continue;
                    result = name2;
                }
            } else {
                OCSymbolWithQualifiedName parent;
                OCSymbolWithQualifiedName oCSymbolWithQualifiedName = parent = operatorParent != null ? operatorParent : baseParent;
                while (withoutInlineNamespaces && parent instanceof OCNamespaceSymbol && ((OCNamespaceSymbol)parent).isInlineNamespace() || parent instanceof OCStructSymbol && parent.isTransparentUnion()) {
                    parent = parent.myParent;
                }
                result = parent == null ? OCQualifiedName.with(OCQualifiedName.GLOBAL, this.myQualifiedName.getName()) : OCQualifiedName.with(parent.getResolvedQualifiedName(withoutInlineNamespaces, context, processTypesOnly, appendArguments, true, removeDefaultArguments, treatNonMemberOperators, longest, observer), this.myName);
            }
        }
        if (observer != null) {
            observer.consume((Object)this);
        }
        if (this instanceof OCTemplateSymbol && appendArguments) {
            List<OCTypeArgument> arguments = OCTypeNameVisitor.getTypeArguments((OCTemplateSymbol)((Object)this), resolveArguments, false, removeDefaultArguments, context);
            if (!(result == null || arguments.isEmpty() && ((OCTemplateSymbol)((Object)this)).getTemplateSpecialization() == null)) {
                return new OCQualifiedNameWithArguments(result, arguments);
            }
        }
        return result;
    }

    public void setQualifier(OCQualifiedName qualifier) {
        this.myQualifiedName = this.myQualifiedName.changeQualifier(qualifier);
    }

    public boolean isLocalInFile(@NotNull OCResolveContext context) {
        if (context == null) {
            OCSymbolWithQualifiedName.$$$reportNull$$$0(17);
        }
        if ((this instanceof OCDeclaratorSymbol || this instanceof OCFunctionSymbol) && this.isFriendOrStatic() && this.myFile != null && OCFileImpl.isSourceCodeFile(this.myFile.getName())) {
            OCSymbolKind kind = this.getResolvedKind(context);
            return kind.isGlobalVariable() || kind.isFunction() && this.myParent == null;
        }
        return false;
    }

    public boolean isConst() {
        return false;
    }

    public boolean isStatic() {
        return false;
    }

    public final boolean isFriendOrStatic() {
        return this.isStatic() || this.isFriend();
    }

    public boolean isFriend() {
        return false;
    }

    @Nullable
    public OCSymbolWithQualifiedName getQualifierParent() {
        OCSymbolWithQualifiedName result = this.getParent();
        if (this.isFriend()) {
            while (result instanceof OCStructSymbol) {
                result = result.getParent();
            }
        }
        return result;
    }

    @Override
    @Nullable
    public Icon getBaseIcon() {
        return OCIcons.getVisibilityIcon(this.getVisibility(), super.getBaseIcon());
    }

    public static boolean isFriend(OCSymbol symbol) {
        return symbol instanceof OCSymbolWithQualifiedName && ((OCSymbolWithQualifiedName)symbol).isFriend();
    }

    @Nullable
    public OCSymbolWithQualifiedName getResolvedOwner(@NotNull OCResolveContext context) {
        if (context == null) {
            OCSymbolWithQualifiedName.$$$reportNull$$$0(18);
        }
        return this.getResolvedOwner(context, true);
    }

    @Nullable
    public OCSymbolWithQualifiedName getResolvedOwner(@NotNull OCResolveContext context, boolean checkNonMemberOperators) {
        OCStructSymbol operatorParent;
        if (context == null) {
            OCSymbolWithQualifiedName.$$$reportNull$$$0(19);
        }
        if (checkNonMemberOperators && (operatorParent = context.getNonMemberOperatorParent(this)) != null) {
            return operatorParent;
        }
        OCQualifiedName qualifier = this.myQualifiedName.getQualifier();
        OCSymbolWithQualifiedName baseParent = this.getQualifierParent();
        if (qualifier != null) {
            OCSymbolReference.GlobalReference reference = OCSymbolReference.getGlobalReference(qualifier, baseParent, this.getContainingFile(), this.getComplexOffset(), OCSymbolReference.SymbolKindFilter.ONLY_NAMESPACE_LIKE);
            List<OCSymbol> possibleSymbols = reference.resolveToSymbols(true, true, true, context);
            for (OCSymbol possibleSymbol : possibleSymbols) {
                OCNamespaceSymbol namespace;
                if (!(possibleSymbol instanceof OCNamespaceSymbol) || (namespace = (OCNamespaceSymbol)possibleSymbol).isPredeclaration()) continue;
                CommonProcessors.FindFirstProcessor processor2 = new CommonProcessors.FindFirstProcessor();
                namespace.processMembers(this.myName, (Processor<OCSymbol>)processor2);
                if (!processor2.isFound()) continue;
                return namespace;
            }
            return null;
        }
        return baseParent;
    }

    @Override
    @Nullable
    public OCSymbolWithQualifiedName getParent() {
        return this.myParent;
    }

    public OCSymbol dropSubstitution() {
        return OCTypeSubstitution.cloneWithSubstitution(this, OCTypeSubstitution.ID, this.getParent());
    }

    @Override
    @Nullable
    public OCSymbol getDefinitionSymbol(@NotNull Project project2) {
        if (project2 == null) {
            OCSymbolWithQualifiedName.$$$reportNull$$$0(20);
        }
        if (this.isPredeclaration()) {
            CommonProcessors.FindFirstProcessor processor2 = new CommonProcessors.FindFirstProcessor();
            this.processSameSymbols((Processor<OCSymbol>)new FilteringProcessor(OCSymbol.NON_PREDIFINITION_CONDITION, (Processor)processor2), project2);
            return (OCSymbol)processor2.getFoundValue();
        }
        return this;
    }

    @Override
    public String getKindUppercase(@NotNull OCCompilationContext context) {
        if (context == null) {
            OCSymbolWithQualifiedName.$$$reportNull$$$0(21);
        }
        OCResolveContext resolveContext = OCResolveContext.forSymbol(this, context.getProject());
        return this.getResolvedKind(resolveContext).getNameUppercase();
    }

    public OCSymbolKind getResolvedKind(@NotNull OCResolveContext context) {
        OCSymbolKind actualKind;
        if (context == null) {
            OCSymbolWithQualifiedName.$$$reportNull$$$0(22);
        }
        if ((actualKind = this.getKind()).isGlobalVariable() && this.getQualifier() != null) {
            OCSymbolReference.GlobalReference reference = OCSymbolReference.getGlobalReference(this.getQualifier(), this.getParent(), this.getContainingFile(), this.getComplexOffset(), OCSymbolReference.SymbolKindFilter.ONLY_NAMESPACE_LIKE);
            List<OCSymbol> possibleSymbols = reference.resolveToSymbols(true, true, context);
            for (OCSymbol possibleSymbol : possibleSymbols) {
                if (!possibleSymbol.getKind().isStructLike()) continue;
                actualKind = OCSymbolKind.STRUCT_FIELD;
                break;
            }
        }
        return actualKind;
    }

    @Override
    public boolean processSameSymbols(Processor<OCSymbol> processor2, @NotNull Project project2) {
        if (project2 == null) {
            OCSymbolWithQualifiedName.$$$reportNull$$$0(23);
        }
        return this.processSameSymbols(processor2, null, project2);
    }

    public boolean processSameSymbols(final Processor<OCSymbol> processor2, @Nullable PsiFile file, @NotNull Project project2) {
        if (project2 == null) {
            OCSymbolWithQualifiedName.$$$reportNull$$$0(24);
        }
        final Class<?> myClass = this.getClass();
        OCDebugUtil.tryDebugWaitForSymbol(this);
        if (!processor2.process((Object)this)) {
            return false;
        }
        if (!this.isGlobal() || this.isUnnamed()) {
            return true;
        }
        final OCResolveContext context = OCResolveContext.forSymbol(this, project2);
        Processor<OCSymbol> _processor = new Processor<OCSymbol>(){
            private OCQualifiedName myResolvedName;
            private OCType myResolvedType;

            public boolean process(OCSymbol symbol) {
                ProgressManager.checkCanceled();
                if (symbol.equals(OCSymbolWithQualifiedName.this)) {
                    return true;
                }
                if (!symbol.getClass().equals(myClass)) {
                    return true;
                }
                if (!(symbol instanceof OCSymbolWithQualifiedName)) {
                    return true;
                }
                if (this.myResolvedName == null) {
                    this.myResolvedName = OCSymbolWithQualifiedName.this.getResolvedQualifiedNameWithoutArguments(context);
                    if (this.myResolvedName == null) {
                        return false;
                    }
                }
                if (this.myResolvedType == null) {
                    this.myResolvedType = OCSymbolWithQualifiedName.this.getType().resolve(context);
                }
                if (!OCSymbolWithQualifiedName.this.isSameSymbol((OCSymbolWithQualifiedName)symbol, this.myResolvedName, this.myResolvedType, context)) {
                    return true;
                }
                OCDebugUtil.tryDebugWaitForSymbol(symbol);
                return processor2.process((Object)symbol);
            }
        };
        if (file != null) {
            OCQualifiedName name2 = this.getResolvedQualifiedName(context);
            if (name2 != null) {
                OCSymbolReference.GlobalReference ref = OCSymbolReference.getDummyGlobalReference(name2);
                return ref.processPossibleSymbols((Processor<OCSymbol>)((Processor)symbol -> symbol.equals(this) || processor2.process(symbol)), OCResolveContext.forPsi((PsiElement)file));
            }
            return true;
        }
        if (!this.isSynthetic()) {
            VirtualFile containingFile = this.getContainingFile();
            OCCommonProcessors.OrderedProcessor<OCSymbol> orderedProcessor = new OCCommonProcessors.OrderedProcessor<OCSymbol>(_processor, symbol -> containingFile != null && containingFile.equals(symbol.getContainingFile()), Conditions.alwaysTrue());
            OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project2, orderedProcessor, this.myName);
            return orderedProcessor.finish();
        }
        return true;
    }

    @Override
    public boolean processAssociatedSymbols(Processor<OCSymbol> processor2, @NotNull Project project2) {
        OCSymbol definitionSymbol;
        if (project2 == null) {
            OCSymbolWithQualifiedName.$$$reportNull$$$0(25);
        }
        if (this.isPredeclaration() && (definitionSymbol = this.getDefinitionSymbol(project2)) != null && !processor2.process((Object)definitionSymbol)) {
            return false;
        }
        VirtualFile containingFile = this.getContainingFile();
        OCCommonProcessors.OrderedProcessor<OCSymbol> orderedProcessor = new OCCommonProcessors.OrderedProcessor<OCSymbol>(symbol -> symbol == this || processor2.process(symbol), symbol -> {
            VirtualFile curContainingFile = symbol.getContainingFile();
            return containingFile != null && curContainingFile != null && containingFile.getNameWithoutExtension().equals(curContainingFile.getNameWithoutExtension());
        }, Conditions.alwaysTrue());
        OCSearchUtil.processPredeclarations(this, orderedProcessor, project2);
        return orderedProcessor.finish();
    }

    @Override
    public boolean isSameSymbol(@Nullable OCSymbol symbol, @NotNull Project project2) {
        if (project2 == null) {
            OCSymbolWithQualifiedName.$$$reportNull$$$0(26);
        }
        return this.isSameSymbol(symbol, OCResolveContext.forSymbol(this, project2));
    }

    public boolean isSameSymbol(@Nullable OCSymbol symbol, @NotNull OCResolveContext context) {
        if (context == null) {
            OCSymbolWithQualifiedName.$$$reportNull$$$0(27);
        }
        if (symbol instanceof OCSymbolWithQualifiedName) {
            return this.isSameSymbol((OCSymbolWithQualifiedName)symbol, this.getResolvedQualifiedName(false, context, true, false, true, true, true), this.getType().resolve(context), context);
        }
        return false;
    }

    public static boolean isSameSymbol(@Nullable OCSymbolWithQualifiedName symbol1, @Nullable OCSymbolWithQualifiedName symbol2, @NotNull OCResolveContext context) {
        if (context == null) {
            OCSymbolWithQualifiedName.$$$reportNull$$$0(28);
        }
        return symbol1 == null && symbol2 == null || symbol1 != null && symbol2 != null && symbol1.isSameSymbol((OCSymbol)symbol2, context);
    }

    private static boolean canBeEqual(@Nullable OCType t1, @Nullable OCType t2, boolean checkCV) {
        if (t1 == null || t2 == null) {
            return t1 == t2;
        }
        if (checkCV && t1.getCVQualifiers() != t2.getCVQualifiers()) {
            return false;
        }
        if (t1 instanceof OCReferenceType || t2 instanceof OCReferenceType) {
            return true;
        }
        if (t1 instanceof OCUnknownType || t2 instanceof OCUnknownType) {
            return false;
        }
        if (t1 instanceof OCMagicType || t2 instanceof OCMagicType) {
            return true;
        }
        if (t1 instanceof OCVoidType || t2 instanceof OCVoidType) {
            return t1 instanceof OCVoidType && t2 instanceof OCVoidType;
        }
        if (t1 instanceof OCObjectType || t2 instanceof OCObjectType) {
            return t1 instanceof OCObjectType && t2 instanceof OCObjectType;
        }
        if (t1 instanceof OCStructType || t2 instanceof OCStructType) {
            return t1 instanceof OCStructType && t2 instanceof OCStructType;
        }
        if (t1 instanceof OCNumericType || t2 instanceof OCNumericType) {
            return t1 instanceof OCNumericType && t2 instanceof OCNumericType && ((OCNumericType)t1).getCTypeId() == ((OCNumericType)t2).getCTypeId();
        }
        if (t1 instanceof OCFunctionType || t2 instanceof OCFunctionType) {
            if (!(t1 instanceof OCFunctionType) || !(t2 instanceof OCFunctionType)) {
                return false;
            }
            OCFunctionType ft1 = (OCFunctionType)t1;
            OCFunctionType ft2 = (OCFunctionType)t2;
            if (ft1.isVararg() != ft2.isVararg()) {
                return false;
            }
            List<OCType> types1 = ft1.getParameterTypes();
            List<OCType> types2 = ft2.getParameterTypes();
            if (types1.size() != types2.size()) {
                return false;
            }
            for (int i = 0; i < types1.size(); ++i) {
                if (OCSymbolWithQualifiedName.canBeEqual(types1.get(i), types2.get(i), false)) continue;
                return false;
            }
            return true;
        }
        if (t1 instanceof OCCppReferenceType) {
            if (!(t2 instanceof OCCppReferenceType)) {
                return false;
            }
            if (((OCCppReferenceType)t1).isRvalueRef() != ((OCCppReferenceType)t2).isRvalueRef()) {
                return false;
            }
            if (((OCCppReferenceType)t1).isReferenceToConst() != ((OCCppReferenceType)t2).isReferenceToConst()) {
                return false;
            }
            return OCSymbolWithQualifiedName.canBeEqual(((OCCppReferenceType)t1).getRefType(), ((OCCppReferenceType)t2).getRefType(), checkCV);
        }
        if (t1 instanceof OCPointerType) {
            if (!(t2 instanceof OCPointerType)) {
                return false;
            }
            return OCSymbolWithQualifiedName.canBeEqual(((OCPointerType)t1).getRefType(), ((OCPointerType)t2).getRefType(), checkCV);
        }
        return true;
    }

    private boolean isSameSymbol(OCSymbolWithQualifiedName symbol, @Nullable OCQualifiedName resolvedName, OCType resolvedType, @NotNull OCResolveContext context) {
        boolean friends;
        if (context == null) {
            OCSymbolWithQualifiedName.$$$reportNull$$$0(29);
        }
        if (this.equals(symbol)) {
            return true;
        }
        if (this.getKind().isLocal() || symbol.getKind().isLocal()) {
            return false;
        }
        if (resolvedName == null) {
            return false;
        }
        OCResolveContext otherContext = OCResolveContext.forSymbol(symbol, context.getProject());
        if (!Comparing.equal((Object)this.getContainingFile(), (Object)symbol.getContainingFile()) && this.isLocalInFile(context) && symbol.isLocalInFile(otherContext)) {
            return false;
        }
        boolean bl = friends = this.isFriend() || symbol.isFriend();
        if (friends && !this.getName().equals(symbol.getName())) {
            return false;
        }
        if (symbol instanceof OCFunctionSymbol) {
            if (this instanceof OCFunctionSymbol) {
                if (((OCFunctionSymbol)symbol).isFriend() && symbol.isPredeclaration() && ((OCFunctionSymbol)symbol).isCppOperator()) {
                    return false;
                }
                if (!OCSymbolWithQualifiedName.canBeEqual(((OCFunctionSymbol)this).getTypeWithoutSubstitution(), ((OCFunctionSymbol)symbol).getTypeWithoutSubstitution(), true)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (!resolvedName.equals(symbol.getResolvedQualifiedName(false, otherContext, true, false, true, true, true))) {
            return false;
        }
        if (symbol instanceof OCFunctionSymbol) {
            if (((OCFunctionSymbol)symbol).getParameterSymbols().size() != ((OCFunctionSymbol)this).getParameterSymbols().size()) {
                return ((OCFunctionSymbol)symbol).getType().hasNoParameters() && ((OCFunctionSymbol)this).getType().hasNoParameters();
            }
            OCType symbolType = symbol.getResolvedType(otherContext);
            OCTypeEqualityAfterResolvingVisitor typeEqualityVisitor = new OCTypeEqualityAfterResolvingVisitor(symbolType, true, context);
            if (resolvedType instanceof OCFunctionType && symbolType instanceof OCFunctionType) {
                return typeEqualityVisitor.isFunctionSignatureEqual(resolvedType);
            }
            return resolvedType.accept(typeEqualityVisitor);
        }
        return true;
    }

    @Override
    @Nullable
    public String getLocationString() {
        String result;
        if (this.isGlobal() && (result = this.guessLocationString()) != null) {
            return result;
        }
        return this.myFile == null ? null : this.myFile.getName();
    }

    @Nullable
    private String guessLocationString() {
        String result;
        ArrayList<String> guessedNameParts = new ArrayList<String>(2);
        boolean global = false;
        for (OCQualifiedName qualifier = this.myQualifiedName.getQualifier(); qualifier != null; qualifier = qualifier.getQualifier()) {
            if (qualifier == OCQualifiedName.GLOBAL) {
                global = true;
                break;
            }
            guessedNameParts.add(qualifier.getName());
        }
        if (!global) {
            for (OCSymbolWithQualifiedName parent = this.getQualifierParent(); parent != null; parent = parent.getQualifierParent()) {
                if (parent instanceof OCNamespaceSymbol && ((OCNamespaceSymbol)parent).isInlineNamespace()) continue;
                guessedNameParts.add(parent.getName());
            }
        }
        if (!(result = ContainerUtil.reverse(guessedNameParts).stream().filter(s -> s != null && !s.isEmpty() && !s.equals("<unnamed>") && !OCSymbolWithQualifiedName.isPossibleVersioningNamespace(s)).collect(Collectors.joining("::"))).isEmpty()) {
            return result;
        }
        return null;
    }

    private static boolean isPossibleVersioningNamespace(@NotNull String s) {
        if (s == null) {
            OCSymbolWithQualifiedName.$$$reportNull$$$0(30);
        }
        return s.startsWith("__") || s.startsWith("_") && s.length() > 1 && Character.isUpperCase(s.charAt(1));
    }

    @Override
    public OCSymbol getAssociatedSymbol(@NotNull Project project2) {
        if (project2 == null) {
            OCSymbolWithQualifiedName.$$$reportNull$$$0(31);
        }
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        this.processAssociatedSymbols((Processor<OCSymbol>)finder, project2);
        return (OCSymbol)finder.getFoundValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/cpp/OCSymbolWithQualifiedName";
                break;
            }
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/cpp/OCSymbolWithQualifiedName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameWithParent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNameWithParent";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedQualifiedName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedQualifiedNameWithoutInlineNamespaces";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedQualifiedNameWithoutArguments";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isLocalInFile";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedOwner";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDefinitionSymbol";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getKindUppercase";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedKind";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processSameSymbols";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processAssociatedSymbols";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isSameSymbol";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isPossibleVersioningNamespace";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedSymbol";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

