/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.psi.OCCastKind;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCastExpressionSymbol
extends OCExpressionSymbol {
    private OCExpressionSymbol myOperand;
    private OCType myType;
    private OCCastKind myCastKind;

    public OCCastExpressionSymbol() {
    }

    /*
     * WARNING - void declaration
     */
    public OCCastExpressionSymbol(@NotNull Project project2, @Nullable VirtualFile file, long offset, @Nullable OCExpressionSymbol operand, @NotNull OCType type, @NotNull OCCastKind oCCastKind) {
        void castKind;
        if (project2 == null) {
            OCCastExpressionSymbol.$$$reportNull$$$0(0);
        }
        if (type == null) {
            OCCastExpressionSymbol.$$$reportNull$$$0(1);
        }
        if (oCCastKind == null) {
            OCCastExpressionSymbol.$$$reportNull$$$0(2);
        }
        super(project2, file, offset);
        this.myOperand = operand;
        this.myType = type;
        this.myCastKind = castKind;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            OCCastExpressionSymbol.$$$reportNull$$$0(3);
        }
        if (first == null) {
            OCCastExpressionSymbol.$$$reportNull$$$0(4);
        }
        if (second == null) {
            OCCastExpressionSymbol.$$$reportNull$$$0(5);
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCCastExpressionSymbol firstSymbol = (OCCastExpressionSymbol)first;
        OCCastExpressionSymbol secondSymbol = (OCCastExpressionSymbol)second;
        if (!c.equalObjects(firstSymbol.myOperand, secondSymbol.myOperand)) {
            return false;
        }
        return c.equalObjects(firstSymbol.myType, secondSymbol.myType);
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        if (evaluator == null) {
            OCCastExpressionSymbol.$$$reportNull$$$0(6);
        }
        return this.myOperand != null ? (T)evaluator.evalCast(this.myType, this.myOperand.evaluate(evaluator)) : null;
    }

    @Override
    @NotNull
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        if (context == null) {
            OCCastExpressionSymbol.$$$reportNull$$$0(7);
        }
        OCType oCType = this.myType.resolve(context);
        if (oCType == null) {
            OCCastExpressionSymbol.$$$reportNull$$$0(8);
        }
        return oCType;
    }

    @NotNull
    public OCType getCastType() {
        OCType oCType = this.myType;
        if (oCType == null) {
            OCCastExpressionSymbol.$$$reportNull$$$0(9);
        }
        return oCType;
    }

    @Nullable
    public OCExpressionSymbol getOperand() {
        return this.myOperand;
    }

    @NotNull
    public OCCastKind getCastKind() {
        OCCastKind oCCastKind = this.myCastKind;
        if (oCCastKind == null) {
            OCCastExpressionSymbol.$$$reportNull$$$0(10);
        }
        return oCCastKind;
    }

    @Contract(value="null -> false")
    public static boolean isConstCast(OCExpressionSymbol expr) {
        return expr instanceof OCCastExpressionSymbol && ((OCCastExpressionSymbol)expr).getCastKind() == OCCastKind.CONST_CAST;
    }

    @Contract(value="null -> false")
    public static boolean isReinterpretCast(OCExpressionSymbol expr) {
        return expr instanceof OCCastExpressionSymbol && ((OCCastExpressionSymbol)expr).getCastKind() == OCCastKind.REINTERPRET_CAST;
    }

    @Contract(value="null -> false")
    public static boolean isDynamicCast(OCExpressionSymbol expr) {
        return expr instanceof OCCastExpressionSymbol && ((OCCastExpressionSymbol)expr).getCastKind() == OCCastKind.DYNAMIC_CAST;
    }

    @Contract(value="null -> false")
    public static boolean isStaticCast(OCExpressionSymbol expr) {
        return expr instanceof OCCastExpressionSymbol && ((OCCastExpressionSymbol)expr).getCastKind() == OCCastKind.STATIC_CAST;
    }

    @Contract(value="null -> false")
    public static boolean isCStyleCast(OCExpressionSymbol expr) {
        return expr instanceof OCCastExpressionSymbol && ((OCCastExpressionSymbol)expr).getCastKind() == OCCastKind.C_STYLE_CAST;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = "(" + this.myType.getName() + ")" + (this.myOperand != null ? this.myOperand.getPresentableName() : "...");
        if (string == null) {
            OCCastExpressionSymbol.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "castKind";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/expression/OCCastExpressionSymbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/expression/OCCastExpressionSymbol";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCastType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCastKind";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedType";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

