/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCInitializerListExpressionSymbol
extends OCExpressionSymbol {
    public static final int ITEMS_IN_PRESENTATION = 3;
    private List<OCExpressionSymbol> myInitializers;

    public OCInitializerListExpressionSymbol() {
    }

    /*
     * WARNING - void declaration
     */
    public OCInitializerListExpressionSymbol(@NotNull Project project2, @Nullable VirtualFile file, long offset, List<OCExpressionSymbol> list) {
        void initializers;
        if (project2 == null) {
            OCInitializerListExpressionSymbol.$$$reportNull$$$0(0);
        }
        super(project2, file, offset);
        this.myInitializers = initializers;
    }

    @Override
    public void compact() {
        super.compact();
        this.myInitializers = ContainerUtil.trimToSize(this.myInitializers);
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            OCInitializerListExpressionSymbol.$$$reportNull$$$0(1);
        }
        if (first == null) {
            OCInitializerListExpressionSymbol.$$$reportNull$$$0(2);
        }
        if (second == null) {
            OCInitializerListExpressionSymbol.$$$reportNull$$$0(3);
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCInitializerListExpressionSymbol firstSymbol = (OCInitializerListExpressionSymbol)first;
        OCInitializerListExpressionSymbol secondSymbol = (OCInitializerListExpressionSymbol)second;
        return c.equalObjects(firstSymbol.myInitializers, secondSymbol.myInitializers);
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        if (evaluator == null) {
            OCInitializerListExpressionSymbol.$$$reportNull$$$0(4);
        }
        return this.myInitializers.size() == 1 ? (T)this.myInitializers.get(0).evaluate(evaluator) : null;
    }

    @Override
    @NotNull
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        if (context == null) {
            OCInitializerListExpressionSymbol.$$$reportNull$$$0(5);
        }
        if (!OCCompilerFeatures.supportsInitializerLists(context.getFile())) {
            OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
            if (oCUnknownType == null) {
                OCInitializerListExpressionSymbol.$$$reportNull$$$0(6);
            }
            return oCUnknownType;
        }
        OCType oCType = OCInitializerListExpressionSymbol.getCompoundInitializerType(OCArgumentsList.expandVariadicExpressions(this.myInitializers, context), context).resolve(context);
        if (oCType == null) {
            OCInitializerListExpressionSymbol.$$$reportNull$$$0(7);
        }
        return oCType;
    }

    @NotNull
    public List<OCExpressionSymbol> getInitializers() {
        List<OCExpressionSymbol> list = this.myInitializers != null ? this.myInitializers : Collections.emptyList();
        if (list == null) {
            OCInitializerListExpressionSymbol.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    private static OCType getCompoundInitializerType(@NotNull OCArgumentsList<? extends OCTypeOwner> arguments, @NotNull OCResolveContext context) {
        if (arguments == null) {
            OCInitializerListExpressionSymbol.$$$reportNull$$$0(9);
        }
        if (context == null) {
            OCInitializerListExpressionSymbol.$$$reportNull$$$0(10);
        }
        OCType type = null;
        for (OCType exprType : arguments.getTypes()) {
            type = type == null ? exprType : type.getLeastCommonType(exprType, context);
        }
        List<OCTypeArgument> typeArguments = type != null ? Collections.singletonList(type) : Collections.emptyList();
        OCReferenceType oCReferenceType = OCReferenceType.fromQualifiedName(new OCQualifiedNameWithArguments(OCQualifiedName.parse("std::initializer_list"), typeArguments));
        if (oCReferenceType == null) {
            OCInitializerListExpressionSymbol.$$$reportNull$$$0(11);
        }
        return oCReferenceType;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = "{" + this.myInitializers.stream().limit(3L).map(OCSymbol::getPresentableName).collect(Collectors.joining(", ")) + (this.myInitializers.size() > 3 ? ", ..." : "") + "}";
        if (string == null) {
            OCInitializerListExpressionSymbol.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluator";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/expression/OCInitializerListExpressionSymbol";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/expression/OCInitializerListExpressionSymbol";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitializers";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompoundInitializerType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedType";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCompoundInitializerType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

