/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.psi.impl.OCLiteralExpressionImpl;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCNamesInternary;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLiteralExpressionSymbol
extends OCExpressionSymbol {
    @NotNull
    private Object myValue;
    private IElementType myTokenType;
    private Object myChildTextElements;

    public OCLiteralExpressionSymbol() {
    }

    public OCLiteralExpressionSymbol(@NotNull Project project2, @NotNull Object value, IElementType tokenType, @Nullable List<String> textElements) {
        if (project2 == null) {
            OCLiteralExpressionSymbol.$$$reportNull$$$0(0);
        }
        if (value == null) {
            OCLiteralExpressionSymbol.$$$reportNull$$$0(1);
        }
        super(project2, null, 0L);
        this.myValue = value;
        this.myTokenType = tokenType;
        this.myChildTextElements = textElements != null && textElements.size() == 1 ? OCNamesInternary.intern(textElements.get(0)) : textElements;
    }

    @NotNull
    public Object getValue() {
        Object object = this.myValue;
        if (object == null) {
            OCLiteralExpressionSymbol.$$$reportNull$$$0(2);
        }
        return object;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            OCLiteralExpressionSymbol.$$$reportNull$$$0(3);
        }
        if (first == null) {
            OCLiteralExpressionSymbol.$$$reportNull$$$0(4);
        }
        if (second == null) {
            OCLiteralExpressionSymbol.$$$reportNull$$$0(5);
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCLiteralExpressionSymbol firstSymbol = (OCLiteralExpressionSymbol)first;
        OCLiteralExpressionSymbol secondSymbol = (OCLiteralExpressionSymbol)second;
        return c.equalObjects(firstSymbol.myValue, secondSymbol.myValue);
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        if (evaluator == null) {
            OCLiteralExpressionSymbol.$$$reportNull$$$0(6);
        }
        if (this.myValue instanceof Boolean) {
            return evaluator.evalBool((Boolean)this.myValue);
        }
        if (this.myValue instanceof Number) {
            return evaluator.evalInteger((Number)this.myValue);
        }
        return null;
    }

    @Override
    @NotNull
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        if (context == null) {
            OCLiteralExpressionSymbol.$$$reportNull$$$0(7);
        }
        PsiFile file = context.getFile();
        List<String> childTextElements = this.myChildTextElements instanceof String ? Collections.singletonList((String)this.myChildTextElements) : (List<String>)this.myChildTextElements;
        OCType oCType = file != null ? OCLiteralExpressionImpl.getLiteralType(this.myTokenType, childTextElements, file) : OCUnknownType.INSTANCE;
        if (oCType == null) {
            OCLiteralExpressionSymbol.$$$reportNull$$$0(8);
        }
        return oCType;
    }

    @Override
    @Nullable
    public OCTypeArgument evaluateToTypeArgument(@NotNull OCResolveContext resolver) {
        if (resolver == null) {
            OCLiteralExpressionSymbol.$$$reportNull$$$0(9);
        }
        return new OCExpressionTypeArgument(this);
    }

    @NotNull
    public IElementType getTokenType() {
        IElementType iElementType = this.myTokenType;
        if (iElementType == null) {
            OCLiteralExpressionSymbol.$$$reportNull$$$0(10);
        }
        return iElementType;
    }

    @Override
    public boolean isLiteral() {
        return true;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        if (this.myChildTextElements instanceof List) {
            String string = StringUtil.join((Collection)((List)this.myChildTextElements), (String)" ");
            if (string == null) {
                OCLiteralExpressionSymbol.$$$reportNull$$$0(11);
            }
            return string;
        }
        if (this.myChildTextElements instanceof String) {
            String string = (String)this.myChildTextElements;
            if (string == null) {
                OCLiteralExpressionSymbol.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = this.myValue.toString();
        if (string == null) {
            OCLiteralExpressionSymbol.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/expression/OCLiteralExpressionSymbol";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/expression/OCLiteralExpressionSymbol";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenType";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "evaluateToTypeArgument";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

