/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCUnaryExpressionSymbolBase
extends OCExpressionSymbol {
    protected OCElementType myOperator;
    protected OCExpressionSymbol myOperand;

    public OCUnaryExpressionSymbolBase() {
    }

    /*
     * WARNING - void declaration
     */
    public OCUnaryExpressionSymbolBase(@NotNull Project project2, @Nullable VirtualFile file, long offset, @NotNull OCElementType operator, @NotNull OCExpressionSymbol oCExpressionSymbol) {
        void operand;
        if (project2 == null) {
            OCUnaryExpressionSymbolBase.$$$reportNull$$$0(0);
        }
        if (operator == null) {
            OCUnaryExpressionSymbolBase.$$$reportNull$$$0(1);
        }
        if (oCExpressionSymbol == null) {
            OCUnaryExpressionSymbolBase.$$$reportNull$$$0(2);
        }
        super(project2, file, offset);
        this.myOperator = operator;
        this.myOperand = operand;
    }

    @NotNull
    public abstract OCOperatorReference.OperatorPlacement getOperatorPlacement();

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            OCUnaryExpressionSymbolBase.$$$reportNull$$$0(3);
        }
        if (first == null) {
            OCUnaryExpressionSymbolBase.$$$reportNull$$$0(4);
        }
        if (second == null) {
            OCUnaryExpressionSymbolBase.$$$reportNull$$$0(5);
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCUnaryExpressionSymbolBase firstSymbol = (OCUnaryExpressionSymbolBase)first;
        OCUnaryExpressionSymbolBase secondSymbol = (OCUnaryExpressionSymbolBase)second;
        if (firstSymbol.myOperator != secondSymbol.myOperator) {
            return false;
        }
        return c.equalObjects(firstSymbol.myOperand, secondSymbol.myOperand);
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        if (evaluator == null) {
            OCUnaryExpressionSymbolBase.$$$reportNull$$$0(6);
        }
        return evaluator.evalUnary(this.myOperator, this.myOperand.evaluate(evaluator));
    }

    protected abstract OCType getResolvedType(OCType var1, @NotNull OCResolveContext var2);

    @Override
    @NotNull
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        OCFunctionSymbol symbol;
        OCType opType;
        if (context == null) {
            OCUnaryExpressionSymbolBase.$$$reportNull$$$0(7);
        }
        if ((opType = this.myOperand.getResolvedType(context)) instanceof OCTypeParameterType) {
            context.addTypeDependency(((OCTypeParameterType)opType).getSymbol());
        }
        if ((symbol = OCOperatorReference.resolveOperator(this.myOperator.getName(), this.getOperatorPlacement(), Collections.singletonList(opType), Collections.singletonList(this.myOperand), context)) != null) {
            OCType oCType = symbol.getType().getReturnType().resolve(context);
            if (oCType == null) {
                OCUnaryExpressionSymbolBase.$$$reportNull$$$0(8);
            }
            return oCType;
        }
        OCType oCType = this.getResolvedType(opType, context);
        if (oCType == null) {
            OCUnaryExpressionSymbolBase.$$$reportNull$$$0(9);
        }
        return oCType;
    }

    @Nullable
    public OCType getCustomReturnType(@NotNull OCResolveContext context) {
        if (context == null) {
            OCUnaryExpressionSymbolBase.$$$reportNull$$$0(10);
        }
        return this.getInfo((OCResolveContext)context).customReturnType;
    }

    @NotNull
    private Info getInfo(@NotNull OCResolveContext context) {
        OCFunctionSymbol symbol;
        if (context == null) {
            OCUnaryExpressionSymbolBase.$$$reportNull$$$0(11);
        }
        OCType opType = this.myOperand.getResolvedType(context);
        OCType customReturnType = null;
        if (opType != null && (symbol = this.tryResolveOperator(context, opType)) != null) {
            customReturnType = symbol.getType().getReturnType().resolve(context);
        }
        Info info = new Info(opType, customReturnType);
        if (info == null) {
            OCUnaryExpressionSymbolBase.$$$reportNull$$$0(12);
        }
        return info;
    }

    @Nullable
    public OCFunctionSymbol tryResolveOperator(@NotNull OCResolveContext context) {
        if (context == null) {
            OCUnaryExpressionSymbolBase.$$$reportNull$$$0(13);
        }
        OCType opType = this.myOperand.getResolvedType(context);
        return this.tryResolveOperator(context, opType);
    }

    @Nullable
    private OCFunctionSymbol tryResolveOperator(@NotNull OCResolveContext context, @Nullable OCType opType) {
        if (context == null) {
            OCUnaryExpressionSymbolBase.$$$reportNull$$$0(14);
        }
        if (opType instanceof OCTypeParameterType) {
            context.addTypeDependency(((OCTypeParameterType)opType).getSymbol());
        }
        if (opType != null) {
            return OCOperatorReference.resolveOperator(this.myOperator.getName(), this.getOperatorPlacement(), Collections.singletonList(opType), Collections.singletonList(this.myOperand), context);
        }
        return null;
    }

    public OCElementType getOperator() {
        return this.myOperator;
    }

    public OCExpressionSymbol getOperand() {
        return this.myOperand;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = this.myOperator.getName() + this.myOperand.getPresentableName();
        if (string == null) {
            OCUnaryExpressionSymbolBase.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluator";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/expression/OCUnaryExpressionSymbolBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/expression/OCUnaryExpressionSymbolBase";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfo";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedType";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 15: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCustomReturnType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getInfo";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "tryResolveOperator";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Info {
        @Nullable
        public final OCType opType;
        @Nullable
        public final OCType customReturnType;

        private Info(@Nullable OCType opType, @Nullable OCType customReturnType) {
            this.opType = opType;
            this.customReturnType = customReturnType;
        }
    }
}

