/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.objc;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.OCTestFrameworks;
import com.jetbrains.cidr.lang.psi.OCClassDeclarationBase;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCNamesInternary;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import icons.CidrLangIcons;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCClassSymbolImpl
extends OCSymbolWithQualifiedName<OCClassDeclarationBase>
implements OCClassSymbol {
    private String myCategoryName;
    private MostlySingularMultiMap<String, OCMemberSymbol> myMembers;
    private List<String> myProtocolNames;
    private OCReferenceType mySuperType;

    /*
     * WARNING - void declaration
     */
    public OCClassSymbolImpl(@NotNull Project project2, @Nullable VirtualFile file, long offset, @NotNull String name2, @NotNull List<String> attributes, @Nullable String categoryName, @Nullable MostlySingularMultiMap<String, OCMemberSymbol> members, @NotNull List<String> protocolNames, @Nullable OCReferenceType oCReferenceType) {
        void superType;
        if (project2 == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(0);
        }
        if (name2 == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(1);
        }
        if (attributes == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(2);
        }
        if (protocolNames == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(3);
        }
        super(project2, file, offset, null, OCQualifiedName.interned(name2), attributes, null);
        this.myCategoryName = OCNamesInternary.intern(categoryName);
        this.myMembers = members;
        this.myProtocolNames = protocolNames;
        this.mySuperType = superType;
    }

    public OCClassSymbolImpl() {
    }

    @Override
    @Nullable
    public String getCategoryName() {
        return this.myCategoryName;
    }

    @Override
    public void setSuperType(@NotNull OCReferenceType type) {
        if (type == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(4);
        }
        assert (this.mySuperType == null) : "Super type is already set";
        this.mySuperType = type;
    }

    @Override
    @NotNull
    public OCReferenceType getSuperType() {
        assert (this.mySuperType != null) : "Super type has to be set in symbol builder";
        OCReferenceType oCReferenceType = this.mySuperType;
        if (oCReferenceType == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(5);
        }
        return oCReferenceType;
    }

    @Override
    @NotNull
    public String getSuperClassName() {
        String string = StringUtil.notNullize((String)this.getSuperType().getReference().getQualifiedName().getName());
        if (string == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    public void updateOffset(int start, int lengthShift) {
        super.updateOffset(start, lengthShift);
        if (this.myMembers != null) {
            this.myMembers.processAllValues(member -> {
                member.updateOffset(start, lengthShift);
                return true;
            });
        }
    }

    @Override
    public void compact() {
        super.compact();
        if (this.myMembers != null) {
            this.myMembers.processAllValues(member -> {
                member.compact();
                return true;
            });
        }
    }

    @Override
    @NotNull
    public List<String> getProtocolNames() {
        List<String> list = this.myProtocolNames;
        if (list == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    public boolean isDefinition() {
        return false;
    }

    @Override
    public boolean isPredeclaration() {
        return this.myMembers == null;
    }

    @Override
    public int getMembersCount() {
        return this.myMembers != null ? this.myMembers.size() : 0;
    }

    @Override
    public int hashCodeExcludingOffset() {
        int result = super.hashCodeExcludingOffset();
        result = 31 * result + this.getMembersCount();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.getMembersCount() == ((OCClassSymbol)o).getMembersCount();
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(8);
        }
        if (first == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(9);
        }
        if (second == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(10);
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCClassSymbolImpl f = (OCClassSymbolImpl)first;
        OCClassSymbolImpl s = (OCClassSymbolImpl)second;
        if (!Comparing.equal((String)f.myCategoryName, (String)s.myCategoryName)) {
            return false;
        }
        if (!Comparing.equal(f.myProtocolNames, s.myProtocolNames)) {
            return false;
        }
        if (!c.equalObjects(f.mySuperType, s.mySuperType)) {
            return false;
        }
        return c.equalMultiMaps(f.myMembers, s.myMembers);
    }

    @Override
    public boolean processMembers(String memberName, @NotNull Processor<OCMemberSymbol> processor2) {
        if (processor2 == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(11);
        }
        if (this.myMembers == null) {
            return true;
        }
        if (memberName == null) {
            return this.myMembers.processAllValues(processor2);
        }
        return this.myMembers.processForKey((Object)memberName, processor2);
    }

    @Override
    public <T extends OCMemberSymbol> boolean processMembers(Class<T> memberClass, Processor<? super T> processor2) {
        return this.processMembers(null, memberClass, processor2);
    }

    @Override
    public <T extends OCMemberSymbol> boolean processMembers(@Nullable String memberName, @NotNull Class<? extends T> memberClass, Processor<? super T> processor2) {
        if (memberClass == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(12);
        }
        if (this.myMembers == null) {
            return true;
        }
        Processor myProcessor = member -> {
            if (memberClass == null) {
                OCClassSymbolImpl.$$$reportNull$$$0(38);
            }
            return !memberClass.isAssignableFrom(member.getClass()) || processor2.process(member);
        };
        if (memberName == null) {
            return this.myMembers.processAllValues(myProcessor);
        }
        return this.myMembers.processForKey((Object)memberName, myProcessor);
    }

    @Override
    public <T extends OCMemberSymbol> boolean processMembersInAllCategories(@Nullable String memberName, Class<? extends T> memberClass, Processor<? super T> processor2, @NotNull Project project2) {
        if (project2 == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(13);
        }
        return this.processMembersInAllCategories(memberName, memberClass, processor2, true, project2);
    }

    @Override
    public <T extends OCMemberSymbol> boolean processMembersInAllCategories(@Nullable String memberName, Class<? extends T> memberClass, Processor<? super T> processor2, boolean fromSameParentClass, @NotNull Project project2) {
        if (project2 == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(14);
        }
        return this.processCategories((Processor<? super OCClassSymbol>)((Processor)clazz -> clazz.processMembers(memberName, memberClass, processor2)), fromSameParentClass, null, project2);
    }

    @Override
    public <T extends OCMemberSymbol> boolean processMembers(@Nullable String categoryName, @Nullable String memberName, @NotNull Class<? extends T> memberClass, @NotNull Processor<? super T> processor2, boolean fromSameParentClass, @NotNull Project project2) {
        if (memberClass == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(15);
        }
        if (processor2 == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(16);
        }
        if (project2 == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(17);
        }
        return this.processCategories((Processor<? super OCClassSymbol>)((Processor)clazz -> {
            if (memberClass == null) {
                OCClassSymbolImpl.$$$reportNull$$$0(36);
            }
            if (processor2 == null) {
                OCClassSymbolImpl.$$$reportNull$$$0(37);
            }
            return !Comparing.equal((String)categoryName, (String)clazz.getCategoryName()) || clazz.processMembers(memberName, memberClass, processor2);
        }), fromSameParentClass, null, project2);
    }

    @Override
    public boolean processAllMethods(@Nullable String methodName, @NotNull Processor<OCMethodSymbol> processor2, @Nullable Set<String> baseProtocols, @Nullable PsiElement context) {
        boolean isAmongBaseProtocols;
        if (processor2 == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(18);
        }
        boolean bl = isAmongBaseProtocols = this instanceof OCProtocolSymbol && baseProtocols != null && baseProtocols.contains(this.getName());
        if (!this.processMembers(methodName, OCMethodSymbol.class, symbol -> {
            if (processor2 == null) {
                OCClassSymbolImpl.$$$reportNull$$$0(35);
            }
            return isAmongBaseProtocols && !symbol.isOptional() || processor2.process(symbol);
        })) {
            return false;
        }
        if (isAmongBaseProtocols) {
            baseProtocols.addAll(this.myProtocolNames);
        }
        for (String protocolName : this.myProtocolNames) {
            CommonProcessors.FindFirstProcessor<OCSymbol> resolver = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

                protected boolean accept(OCSymbol symbol) {
                    return symbol instanceof OCProtocolSymbol && !symbol.isPredeclaration();
                }
            };
            OCResolveUtil.processGlobalSymbols(protocolName, context, (Processor<OCSymbol>)resolver);
            if (!resolver.isFound() || ((OCProtocolSymbol)resolver.getFoundValue()).processAllMethods(methodName, processor2, baseProtocols, context)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean processCategories(Processor<? super OCClassSymbol> processor2, boolean fromSameParentClass, @Nullable PsiElement context, @NotNull Project project2) {
        if (project2 == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(19);
        }
        if (!processor2.process((Object)this)) {
            return false;
        }
        Processor filterProcessor = symbol -> {
            if (!(!(symbol instanceof OCClassSymbol) || fromSameParentClass && !symbol.getClass().equals(this.getClass()) || symbol.isPredeclaration() || symbol.equals(this))) {
                return processor2.process((Object)((OCClassSymbol)symbol));
            }
            return true;
        };
        if (context == null) {
            return OCGlobalProjectSymbolsCache.processTopLevelSymbols(project2, (Processor<OCSymbol>)filterProcessor, this.myName);
        }
        return OCResolveUtil.processGlobalSymbols(this.myName, null, (OCFile)context.getContainingFile(), this.getOffset(), (Processor<OCSymbol>)filterProcessor);
    }

    @Override
    public boolean processSameSymbols(Processor<OCSymbol> processor2, @NotNull Project project2) {
        if (project2 == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(20);
        }
        return OCGlobalProjectSymbolsCache.processTopLevelSymbols(project2, (Processor<OCSymbol>)((Processor)symbol -> {
            if (project2 == null) {
                OCClassSymbolImpl.$$$reportNull$$$0(34);
            }
            return !this.isSameSymbol((OCSymbol)symbol, project2) || processor2.process(symbol);
        }), this.myName);
    }

    @Override
    @Nullable
    public OCClassSymbol getDefinitionSymbol(@NotNull Project project2) {
        if (project2 == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(21);
        }
        return (OCClassSymbol)super.getDefinitionSymbol(project2);
    }

    @Override
    @Nullable
    public OCInterfaceSymbol getInterface(@NotNull Project project2) {
        if (project2 == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(22);
        }
        return null;
    }

    @Override
    @Nullable
    public OCClassSymbol getInterfaceOrProtocol(@NotNull Project project2) {
        if (project2 == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(23);
        }
        return this.getInterface(project2);
    }

    @Override
    @Nullable
    public OCImplementationSymbol getImplementation(@NotNull Project project2) {
        if (project2 == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(24);
        }
        return null;
    }

    @Override
    @Nullable
    public OCInterfaceSymbol getMainInterface(@NotNull Project project2) {
        if (project2 == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(25);
        }
        return this.getMainSymbol(this.getInterface(project2), project2);
    }

    @Override
    @Nullable
    public OCImplementationSymbol getMainImplementation(@NotNull Project project2) {
        if (project2 == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(26);
        }
        return this.getMainSymbol(this.getImplementation(project2), project2);
    }

    protected MostlySingularMultiMap<String, OCMemberSymbol> getMembers() {
        return this.myMembers;
    }

    @Nullable
    private <T extends OCClassSymbol> T getMainSymbol(@Nullable T symbol, @NotNull Project project2) {
        if (project2 == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(27);
        }
        if (symbol == null) {
            return null;
        }
        if (this.myCategoryName == null) {
            return symbol;
        }
        CommonProcessors.FindFirstProcessor<OCClassSymbol> finder = new CommonProcessors.FindFirstProcessor<OCClassSymbol>(){

            protected boolean accept(OCClassSymbol each) {
                return each.getCategoryName() == null;
            }
        };
        symbol.processCategories((Processor<OCClassSymbol>)finder, true, null, project2);
        return (T)((OCClassSymbol)finder.getFoundValue());
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = OCCodeInsightUtil.getClassNameWithCategory(super.getPresentableName(), this.myCategoryName);
        if (string == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(28);
        }
        return string;
    }

    @Override
    @Nullable
    public Icon getBaseIcon() {
        return this.myCategoryName == null ? super.getBaseIcon() : CidrLangIcons.CodeAssistantClassExtension;
    }

    @Override
    public Icon computeFullIconNow(@Nullable OCClassDeclarationBase symbolElement, @NotNull Project project2) {
        Icon result;
        if (project2 == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(29);
        }
        Icon icon = result = this.myCategoryName == null ? super.computeFullIconNow(symbolElement, project2) : CidrLangIcons.CodeAssistantClassExtension;
        if (result == null) {
            return null;
        }
        return OCTestFrameworks.isTestClassOrStruct(this, symbolElement, project2) ? OCIcons.getTestIcon(result) : result;
    }

    @Override
    @NotNull
    public OCType getType() {
        OCReferenceType oCReferenceType = OCReferenceType.fromText(this.getName());
        if (oCReferenceType == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(30);
        }
        return oCReferenceType;
    }

    @Override
    @Nullable
    public OCObjectType getResolvedType(@NotNull OCResolveContext context, boolean ignoringImports) {
        OCType type;
        if (context == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(31);
        }
        return (type = super.getResolvedType(context, ignoringImports)) instanceof OCObjectType ? (OCObjectType)type : null;
    }

    @Override
    public boolean isSameClass(OCClassSymbol symbol) {
        return Comparing.equal((String)this.myName, (String)symbol.getName()) && this instanceof OCProtocolSymbol == symbol instanceof OCProtocolSymbol;
    }

    @Override
    public boolean isSameSymbol(OCSymbol symbol, @NotNull Project project2) {
        if (project2 == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(32);
        }
        return symbol instanceof OCClassSymbolImpl && this.isSameClass((OCClassSymbolImpl)symbol);
    }

    @Override
    public boolean isSameCategory(OCSymbol symbol) {
        if (symbol instanceof OCClassSymbolImpl && this.myName.equals(symbol.getName())) {
            String myCategory = this.myCategoryName == null ? "" : this.myCategoryName;
            String hisCategory = ((OCClassSymbol)symbol).getCategoryName() == null ? "" : ((OCClassSymbol)symbol).getCategoryName();
            return myCategory.equals(hisCategory);
        }
        return false;
    }

    @Override
    public boolean isSubclass(final OCClassSymbol ancestor, final @NotNull Project project2) {
        if (project2 == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(33);
        }
        final String ancestorName = ancestor.getName();
        if (this.isSameClass(ancestor) || ancestorName.equals("id")) {
            return true;
        }
        boolean ancestorIsInLibraries = OCSearchScope.isInLibraries(ancestor, project2);
        if (!ancestorIsInLibraries && ancestor.getCategoryName() != null) {
            OCInterfaceSymbol mainInterface = ancestor.getMainInterface(project2);
            ancestorIsInLibraries = OCSearchScope.isInLibraries(mainInterface, project2);
        }
        class DFS {
            Set<OCClassSymbol> processedClasses = new HashSet<OCClassSymbol>();
            Stack<OCClassSymbol> stack = new Stack();
            boolean wasProcessed;

            DFS() {
            }

            <T extends OCClassSymbol> boolean traverse(String name2, Class<T> clazz) {
                if (name2.equals(ancestorName) && clazz == OCProtocolSymbol.class == ancestor instanceof OCProtocolSymbol) {
                    return true;
                }
                this.wasProcessed = false;
                OCGlobalProjectSymbolsCache.processTopLevelSymbols(project2, new OCCommonProcessors.TypeFilteredProcessor(t -> {
                    if (!t.isPredeclaration()) {
                        this.wasProcessed = true;
                        if (!this.processedClasses.contains(t)) {
                            this.processedClasses.add((OCClassSymbol)t);
                            this.stack.push((OCClassSymbol)t);
                        }
                    }
                    return true;
                }, clazz), name2);
                return false;
            }
        }
        DFS dfs = new DFS();
        if (this instanceof OCProtocolSymbol) {
            if (dfs.traverse(this.getName(), OCProtocolSymbol.class)) {
                return true;
            }
        } else {
            if (dfs.traverse(this.getName(), OCInterfaceSymbol.class)) {
                return true;
            }
            if (!dfs.wasProcessed && dfs.traverse(this.getName(), OCImplementationSymbol.class)) {
                return true;
            }
        }
        while (!dfs.stack.isEmpty()) {
            OCClassSymbol curClass = dfs.stack.pop();
            if (!ancestorIsInLibraries && OCSearchScope.isInLibraries(curClass, project2)) continue;
            if (curClass instanceof OCInterfaceSymbol || curClass instanceof OCImplementationSymbol) {
                if (dfs.traverse(curClass.getSuperClassName(), OCInterfaceSymbol.class)) {
                    return true;
                }
                if (!dfs.wasProcessed && dfs.traverse(curClass.getSuperClassName(), OCImplementationSymbol.class)) {
                    return true;
                }
            }
            for (String protocolName : curClass.getProtocolNames()) {
                if (!dfs.traverse(protocolName, OCProtocolSymbol.class)) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 28: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 28: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocolNames";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/objc/OCClassSymbolImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 11: 
            case 16: 
            case 18: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 12: 
            case 15: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberClass";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/objc/OCClassSymbolImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperClassName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtocolNames";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setSuperType";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 28: 
            case 30: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processMembers";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processMembersInAllCategories";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processAllMethods";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processCategories";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processSameSymbols";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDefinitionSymbol";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getInterface";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getInterfaceOrProtocol";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getImplementation";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getMainInterface";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getMainImplementation";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getMainSymbol";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "computeFullIconNow";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedType";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isSameSymbol";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isSubclass";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processSameSymbols$7";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processAllMethods$5";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processMembers$4";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processMembers$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 28: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

