/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.objc;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.OCTestFrameworks;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMethodSymbolImpl
extends OCMemberSymbolImpl
implements OCMethodSymbol {
    private boolean myStatic;
    private boolean myOptional;
    private boolean myVararg;
    private OCType myReturnType;
    private OCSymbol myOriginalSymbol;
    private List<OCMethodSymbol.SelectorPartSymbol> mySelectors;
    private OCTypeSubstitution mySubstitution;

    public OCMethodSymbolImpl() {
        this.mySubstitution = OCTypeSubstitution.ID;
    }

    public OCMethodSymbolImpl(@NotNull OCMethodSymbolImpl origin, @NotNull OCTypeSubstitution substitution) {
        if (origin == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(0);
        }
        if (substitution == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(1);
        }
        this(origin.myProject, origin.getContainingFile(), origin.getComplexOffset(), origin.getName(), origin.getAttributes(), origin.myParent, origin.myStatic, origin.myOptional, origin.myVararg, origin.myReturnType, ContainerUtil.newArrayList(origin.mySelectors), origin.myOriginalSymbol);
        this.mySubstitution = substitution;
    }

    /*
     * WARNING - void declaration
     */
    public OCMethodSymbolImpl(@NotNull Project project2, VirtualFile file, long offset, @Nullable String name2, @NotNull List<String> attributes, @NotNull OCClassSymbol parent, boolean isStatic, boolean isOptional, boolean isVararg, @NotNull OCType returnType, @NotNull List<OCMethodSymbol.SelectorPartSymbol> selectors, @Nullable OCSymbol oCSymbol) {
        void originalSymbol;
        if (project2 == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(2);
        }
        if (attributes == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(3);
        }
        if (parent == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(4);
        }
        if (returnType == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(5);
        }
        if (selectors == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(6);
        }
        super(project2, file, offset, name2, attributes, parent);
        this.mySubstitution = OCTypeSubstitution.ID;
        this.myStatic = isStatic;
        this.myOriginalSymbol = originalSymbol;
        this.myReturnType = returnType;
        this.myOptional = isOptional;
        this.myVararg = isVararg;
        this.mySelectors = ContainerUtil.trimToSize(selectors);
        for (OCMethodSymbol.SelectorPartSymbol selector : selectors) {
            OCDeclaratorSymbol parameter = selector.getParameterWithoutSubstitution();
            if (parameter == null) continue;
            parameter.setParentMethod(this);
        }
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(7);
        }
        if (first == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(8);
        }
        if (second == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(9);
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCMethodSymbolImpl f = (OCMethodSymbolImpl)first;
        OCMethodSymbolImpl s = (OCMethodSymbolImpl)second;
        if (f.myOptional != s.myOptional) {
            return false;
        }
        if (f.myStatic != s.myStatic) {
            return false;
        }
        if (f.myVararg != s.myVararg) {
            return false;
        }
        if (!c.equalObjects(f.myOriginalSymbol, s.myOriginalSymbol)) {
            return false;
        }
        if (!c.equalObjects(f.myReturnType, s.myReturnType)) {
            return false;
        }
        if (!c.equalObjects(f.mySubstitution, s.mySubstitution)) {
            return false;
        }
        return c.equalLists(f.mySelectors, s.mySelectors);
    }

    @Override
    public void updateOffset(int start, int lengthShift) {
        super.updateOffset(start, lengthShift);
        for (OCMethodSymbol.SelectorPartSymbol selector : this.mySelectors) {
            OCDeclaratorSymbol param = selector.getParameter();
            if (param == null) continue;
            param.updateOffset(start, lengthShift);
        }
    }

    @Override
    public void compact() {
        super.compact();
        for (OCMethodSymbol.SelectorPartSymbol selector : this.mySelectors) {
            OCDeclaratorSymbol param = selector.getParameter();
            if (param == null) continue;
            param.compact();
        }
    }

    @Override
    protected Class<? extends PsiElement> getPsiElementClass() {
        return this.getOriginalSymbol() == null ? OCMethod.class : OCDeclarator.class;
    }

    @Override
    @NotNull
    public OCType getReturnType(@Nullable OCObjectType receiverType, @NotNull Project project2) {
        if (project2 == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(10);
        }
        if (this.myReturnType instanceof OCReferenceType && this.myReturnType.getName().equals("instancetype")) {
            if (receiverType != null && receiverType.getClassSymbol() != null && receiverType.getClassSymbol().isSubclass(this.getParent(), project2)) {
                OCType oCType = OCPointerType.to(receiverType).cloneWithNullability(this.myReturnType.getNullability());
                if (oCType == null) {
                    OCMethodSymbolImpl.$$$reportNull$$$0(11);
                }
                return oCType;
            }
            OCPointerType type = OCPointerType.to(this.getParent().getType());
            OCType clone = type.cloneWithAliasName("instancetype");
            clone.attachNullability(this.myReturnType.getNullability());
            OCType oCType = clone;
            if (oCType == null) {
                OCMethodSymbolImpl.$$$reportNull$$$0(12);
            }
            return oCType;
        }
        OCType oCType = this.mySubstitution.substitute(this.myReturnType);
        if (oCType == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(13);
        }
        return oCType;
    }

    @Override
    @NotNull
    public OCType getReturnType(@NotNull Project project2) {
        if (project2 == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(14);
        }
        OCType oCType = this.getReturnType(null, project2);
        if (oCType == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(15);
        }
        return oCType;
    }

    @Override
    public boolean isStatic() {
        return this.myStatic;
    }

    @Override
    public boolean isOptional() {
        return this.myOptional;
    }

    @Override
    public boolean isVararg() {
        return this.myVararg;
    }

    @Override
    public boolean isFactoryMethod() {
        String className = StringUtil.trimStart((String)this.getParent().getName(), (String)"NS");
        String selector = this.getName();
        if (this.isStatic()) {
            List classWords = NameUtil.nameToWordsLowerCase((String)className);
            List selectorWords = NameUtil.nameToWordsLowerCase((String)selector);
            String word = (String)ContainerUtil.getFirstItem((List)selectorWords);
            if ("default".equalsIgnoreCase(word) || "common".equalsIgnoreCase(word) || "shared".equalsIgnoreCase(word) || "main".equalsIgnoreCase(word)) {
                selectorWords.remove(0);
            }
            if (classWords.isEmpty() || selectorWords.isEmpty()) {
                return false;
            }
            block0: for (int wordCount = 1; wordCount <= Math.min(classWords.size(), selectorWords.size()); ++wordCount) {
                for (int i = 0; i < wordCount; ++i) {
                    String classWord = (String)classWords.get(classWords.size() - wordCount + i);
                    String selectorWord = (String)selectorWords.get(i);
                    if (!selectorWord.equals(classWord)) continue block0;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isConstructorMethod() {
        return !this.isStatic() && OCElementUtil.startsWithWord(this.getName(), "init");
    }

    @Override
    public boolean isClassConstructorMethod() {
        return this.isStatic() && OCElementUtil.startsWithWord(this.getName(), "objectWith");
    }

    @Override
    public boolean isPredeclaration() {
        return !(this.getParent() instanceof OCImplementationSymbol);
    }

    @Override
    @Nullable
    public OCMethodSymbol getDefinitionSymbol(@NotNull Project project2) {
        if (project2 == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(16);
        }
        if (this.isPredeclaration()) {
            return this.getAssociatedSymbol(project2);
        }
        return this;
    }

    @Override
    @Nullable
    public Icon getBaseIcon() {
        return this.doComputeIcon();
    }

    @Override
    public Icon computeFullIconNow(@Nullable PsiElement symbolElement, @NotNull Project project2) {
        Icon result;
        if (project2 == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(17);
        }
        if ((result = this.doComputeIconFullAndNow(project2)) == null) {
            return null;
        }
        return OCTestFrameworks.isTestMethodOrFunction(this, symbolElement, project2) ? OCIcons.getTestIcon(result) : result;
    }

    private Icon doComputeIcon() {
        OCPropertySymbol property = this.getGeneratedFromProperty();
        return property != null ? property.getBaseIcon() : OCIcons.getMethodIcon(this.isStatic(), this.isOptional(), false);
    }

    private Icon doComputeIconFullAndNow(@NotNull Project project2) {
        OCPropertySymbol associatedProperty;
        OCMethodSymbol associatedMethod;
        OCPropertySymbol property;
        if (project2 == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(18);
        }
        if ((property = this.getGeneratedFromProperty()) != null) {
            return property.computeFullIconNow(null, project2);
        }
        if (this.myParent instanceof OCImplementationSymbol && (associatedMethod = this.getAssociatedSymbol(this.myParent.getContainingOCFile(project2), project2)) != null && (associatedProperty = associatedMethod.getGeneratedFromProperty()) != null) {
            return associatedProperty.computeFullIconNow(null, project2);
        }
        return OCIcons.getMethodIcon(this.isStatic(), this.isOptional(), false);
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        OCSymbolKind oCSymbolKind = OCSymbolKind.METHOD;
        if (oCSymbolKind == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(19);
        }
        return oCSymbolKind;
    }

    @Override
    public boolean isGetter(@NotNull OCResolveContext context) {
        if (context == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(20);
        }
        return OCNameSuggester.isObjCGetter(this.myName) && !this.getEffectiveResolvedType(context).isVoid();
    }

    @Override
    public boolean isSetter(@NotNull OCResolveContext context) {
        if (context == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(21);
        }
        return OCNameSuggester.isObjCSetter(this.myName) && this.getEffectiveResolvedType(context).isVoid();
    }

    @Override
    public OCPropertySymbol getGeneratedFromProperty() {
        OCSymbol originalSymbol = this.getOriginalSymbol();
        return originalSymbol instanceof OCPropertySymbol ? (OCPropertySymbol)originalSymbol : null;
    }

    @Override
    public OCSymbol getOriginalSymbol() {
        return this.myOriginalSymbol;
    }

    @Override
    public boolean isSynthetic() {
        return this.getOriginalSymbol() != null;
    }

    @Override
    public boolean isForbiddenByARC(@NotNull PsiElement context) {
        if (context == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(22);
        }
        return super.isForbiddenByARC(context) || "dealloc".equals(this.myName) && OCCompilerFeatures.isArcEnabled(context.getContainingFile());
    }

    @Override
    public boolean isAccessorWithAliasedName(@NotNull Project project2) {
        OCPropertySymbol property;
        if (project2 == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(23);
        }
        if ((property = this.getGeneratedFromProperty()) == null) {
            return false;
        }
        OCResolveContext context = OCResolveContext.forSymbol(this, project2);
        if (this.isGetter(context)) {
            return property.getAttributeValue(OCPropertySymbol.PropertyAttribute.GETTER) != null;
        }
        if (this.isSetter(context)) {
            return property.getAttributeValue(OCPropertySymbol.PropertyAttribute.SETTER) != null;
        }
        return false;
    }

    @Override
    @NotNull
    public OCTypeSubstitution getSubstitution() {
        OCTypeSubstitution oCTypeSubstitution = this.mySubstitution;
        if (oCTypeSubstitution == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(24);
        }
        return oCTypeSubstitution;
    }

    @Override
    @NotNull
    public List<OCMethodSymbol.SelectorPartSymbol> getSelectors() {
        List list = this.mySubstitution == OCTypeSubstitution.ID ? this.mySelectors : ContainerUtil.map(this.mySelectors, symbol -> new SelectorPartSymbolImpl((SelectorPartSymbolImpl)symbol, this.mySubstitution));
        if (list == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(25);
        }
        return list;
    }

    @Override
    @NotNull
    public List<OCDeclaratorSymbol> getParameterSymbols() {
        List list = ContainerUtil.map(this.mySelectors, symbol -> this.mySubstitution.substitute(symbol.getParameter()));
        if (list == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(26);
        }
        return list;
    }

    @Override
    @NotNull
    public String getSignature(@NotNull Project project2) {
        if (project2 == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(27);
        }
        String string = (this.myStatic ? "+" : "-") + this.myName;
        if (string == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(28);
        }
        return string;
    }

    @Override
    @NotNull
    public String getNameWithParent(@NotNull OCResolveContext context) {
        if (context == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(29);
        }
        String string = (this.myStatic ? "+" : "-") + "[" + this.myParent.getName() + " " + this.getName() + "]";
        if (string == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(30);
        }
        return string;
    }

    @Override
    @Nullable
    public OCMethodSymbol getAssociatedSymbol(@NotNull Project project2) {
        if (project2 == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(31);
        }
        return this.getAssociatedSymbol(null, project2);
    }

    @Override
    @Nullable
    public OCMethodSymbol getAssociatedSymbol(@Nullable PsiElement context, @NotNull Project project2) {
        OCClassSymbol parentAssociate;
        if (project2 == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(32);
        }
        if ((parentAssociate = (OCClassSymbol)this.getParent().getAssociatedSymbol(project2)) == null) {
            return null;
        }
        CommonProcessors.FindFirstProcessor<OCMethodSymbol> processor2 = new CommonProcessors.FindFirstProcessor<OCMethodSymbol>(){

            protected boolean accept(OCMethodSymbol methodSymbol) {
                return methodSymbol.isStatic() == OCMethodSymbolImpl.this.isStatic();
            }
        };
        parentAssociate.processCategories((Processor<? super OCClassSymbol>)((Processor)arg_0 -> this.lambda$getAssociatedSymbol$2((CommonProcessors.FindFirstProcessor)processor2, arg_0)), true, context, project2);
        return (OCMethodSymbol)processor2.getFoundValue();
    }

    @Override
    public boolean processSameSymbols(Processor<OCSymbol> processor2, @NotNull Project project2) {
        if (project2 == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(33);
        }
        return this.myParent.processMembersInAllCategories(this.myName, this.getClass(), methodSymbol -> methodSymbol.isStatic() != this.isStatic() || processor2.process((Object)this.mySubstitution.substitute(methodSymbol)), false, project2);
    }

    @Override
    @NotNull
    public OCType getEffectiveResolvedType(@NotNull OCResolveContext context) {
        if (context == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(34);
        }
        OCType oCType = this.getReturnType(context.getProject()).resolve(context);
        if (oCType == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(35);
        }
        return oCType;
    }

    @Override
    public OCType getEffectiveType() {
        return this.getReturnType(this.getProject());
    }

    private /* synthetic */ boolean lambda$getAssociatedSymbol$2(CommonProcessors.FindFirstProcessor processor2, OCClassSymbol symbol) {
        return this.mySubstitution.substitute(symbol).processMembers(this.getName(), OCMethodSymbol.class, processor2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitution";
                break;
            }
            case 2: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 27: 
            case 31: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectors";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/objc/OCMethodSymbolImpl";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/objc/OCMethodSymbolImpl";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnType";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitution";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectors";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterSymbols";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignature";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameWithParent";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveResolvedType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
            case 10: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 35: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDefinitionSymbol";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "computeFullIconNow";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "doComputeIconFullAndNow";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isGetter";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isSetter";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isForbiddenByARC";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isAccessorWithAliasedName";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getSignature";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getNameWithParent";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedSymbol";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processSameSymbols";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveResolvedType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SelectorPartSymbolImpl
    implements OCMethodSymbol.SelectorPartSymbol {
        @Nullable
        private String selectorName;
        @Nullable
        private OCDeclaratorSymbol parameter;
        @NotNull
        private OCTypeSubstitution substitution;

        public SelectorPartSymbolImpl() {
            this.substitution = OCTypeSubstitution.ID;
        }

        public SelectorPartSymbolImpl(@Nullable OCDeclaratorSymbol parameter, @Nullable String selectorName) {
            this.substitution = OCTypeSubstitution.ID;
            this.parameter = parameter;
            this.selectorName = selectorName;
        }

        public SelectorPartSymbolImpl(@NotNull SelectorPartSymbolImpl origin, @NotNull OCTypeSubstitution substitution) {
            if (origin == null) {
                SelectorPartSymbolImpl.$$$reportNull$$$0(0);
            }
            if (substitution == null) {
                SelectorPartSymbolImpl.$$$reportNull$$$0(1);
            }
            this(origin.parameter, origin.selectorName);
            this.substitution = OCTypeSubstitution.compose(origin.substitution, substitution);
        }

        @Override
        @Nullable
        public OCDeclaratorSymbol getParameter() {
            return this.substitution.substitute(this.parameter);
        }

        @Override
        @Nullable
        public OCDeclaratorSymbol getParameterWithoutSubstitution() {
            return this.parameter;
        }

        @Override
        @NotNull
        public OCTypeSubstitution getSubstitution() {
            OCTypeSubstitution oCTypeSubstitution = this.substitution;
            if (oCTypeSubstitution == null) {
                SelectorPartSymbolImpl.$$$reportNull$$$0(2);
            }
            return oCTypeSubstitution;
        }

        @Override
        @Nullable
        public String getSelectorName() {
            return this.selectorName;
        }

        public boolean equals(Object o) {
            return DeepEqual.equalObjects(this, o);
        }

        @Override
        public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull OCMethodSymbol.SelectorPartSymbol first, @NotNull OCMethodSymbol.SelectorPartSymbol second) {
            if (c == null) {
                SelectorPartSymbolImpl.$$$reportNull$$$0(3);
            }
            if (first == null) {
                SelectorPartSymbolImpl.$$$reportNull$$$0(4);
            }
            if (second == null) {
                SelectorPartSymbolImpl.$$$reportNull$$$0(5);
            }
            if (!Comparing.equal((String)first.getSelectorName(), (String)second.getSelectorName())) {
                return false;
            }
            if (!c.equalObjects(first.getSubstitution(), second.getSubstitution())) {
                return false;
            }
            return c.equalObjects(first.getParameter(), second.getParameter());
        }

        public int hashCode() {
            int result = this.selectorName != null ? this.selectorName.hashCode() : 0;
            result = 31 * result + (this.parameter != null ? this.parameter.hashCode() : 0);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "origin";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "substitution";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/symbols/objc/OCMethodSymbolImpl$SelectorPartSymbolImpl";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "first";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "second";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/symbols/objc/OCMethodSymbolImpl$SelectorPartSymbolImpl";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubstitution";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "deepEqualStep";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

