/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.objc;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCPropertySymbolImpl
extends OCMemberSymbolImpl
implements OCPropertySymbol {
    private OCType myType;
    @Nullable
    private EnumSet<OCPropertySymbol.PropertyAttribute> myAttributesSet;
    private EnumMap<OCPropertySymbol.PropertyAttribute, String> myStringAttributes;
    private boolean myOptional;
    private OCTypeSubstitution mySubstitution;

    public OCPropertySymbolImpl() {
        this.mySubstitution = OCTypeSubstitution.ID;
    }

    /*
     * WARNING - void declaration
     */
    public OCPropertySymbolImpl(@NotNull Project project2, VirtualFile file, long offset, String name2, @NotNull List<String> attributes, OCClassSymbol parent, @NotNull OCType type, boolean isOptional, @Nullable EnumSet<OCPropertySymbol.PropertyAttribute> propertyAttributesSet, EnumMap<OCPropertySymbol.PropertyAttribute, String> enumMap) {
        void propertyStringAttributes;
        if (project2 == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(0);
        }
        if (attributes == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(1);
        }
        if (type == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(2);
        }
        super(project2, file, offset, name2, attributes, parent);
        this.mySubstitution = OCTypeSubstitution.ID;
        this.myType = type;
        this.myOptional = isOptional;
        this.myStringAttributes = propertyStringAttributes;
        this.myAttributesSet = propertyAttributesSet != null && !propertyAttributesSet.isEmpty() ? propertyAttributesSet : null;
    }

    public OCPropertySymbolImpl(@NotNull OCPropertySymbolImpl origin, @NotNull OCTypeSubstitution substitution) {
        if (origin == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(3);
        }
        if (substitution == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(4);
        }
        this(origin.myProject, origin.getContainingFile(), origin.getComplexOffset(), origin.getName(), origin.getAttributes(), origin.getParent(), origin.myType, origin.myOptional, origin.myAttributesSet, origin.myStringAttributes);
        this.mySubstitution = substitution;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(5);
        }
        if (first == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(6);
        }
        if (second == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(7);
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCPropertySymbolImpl f = (OCPropertySymbolImpl)first;
        OCPropertySymbolImpl s = (OCPropertySymbolImpl)second;
        if (!Comparing.equal(f.myAttributesSet, s.myAttributesSet)) {
            return false;
        }
        if (!Comparing.equal(f.myStringAttributes, s.myStringAttributes)) {
            return false;
        }
        if (!c.equalObjects(f.mySubstitution, s.mySubstitution)) {
            return false;
        }
        return c.equalObjects(f.myType, s.myType);
    }

    public static OCPropertySymbol.PropertySemantics getDefaultSemanticsForType(OCType type, PsiElement context) {
        if ("NSString *".equals(type.getName()) || type instanceof OCBlockPointerType) {
            return OCPropertySymbol.PropertySemantics.COPY;
        }
        if (type.isPointerToObjectCompatible()) {
            return OCCompilerFeatures.isArcEnabled(context.getContainingFile()) ? OCPropertySymbol.PropertySemantics.STRONG : OCPropertySymbol.PropertySemantics.RETAIN;
        }
        return OCPropertySymbol.PropertySemantics.ASSIGN;
    }

    @Nullable
    public static OCPropertySymbol.PropertyAttribute parseAttribute(@NotNull String string) {
        if (string == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(8);
        }
        for (OCPropertySymbol.PropertyAttribute attribute : OCPropertySymbol.PropertyAttribute.values()) {
            if (!string.equals(attribute.getTokenName())) continue;
            return attribute;
        }
        return null;
    }

    @Override
    @NotNull
    public OCType getType() {
        OCType oCType = this.mySubstitution.substitute(this.myType);
        if (oCType == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(9);
        }
        return oCType;
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        OCSymbolKind oCSymbolKind = OCSymbolKind.PROPERTY;
        if (oCSymbolKind == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(10);
        }
        return oCSymbolKind;
    }

    @Override
    public boolean hasAttribute(OCPropertySymbol.PropertyAttribute attribute) {
        return this.myAttributesSet != null && this.myAttributesSet.contains((Object)attribute) || this.myStringAttributes.containsKey((Object)attribute);
    }

    @Override
    public String getAttributeValue(OCPropertySymbol.PropertyAttribute attribute) {
        return this.myStringAttributes.get((Object)attribute);
    }

    @Override
    public OCPropertySymbol.PropertyAttribute getAttributeOfGroup(OCPropertySymbol.PropertyAttribute defaultAttribute, OCType type, PsiElement context) {
        if (this.myAttributesSet != null) {
            for (OCPropertySymbol.PropertyAttribute attribute : this.myAttributesSet) {
                if (attribute.getGroup() != defaultAttribute.getGroup()) continue;
                return attribute;
            }
        }
        if (defaultAttribute.getGroup() == OCPropertySymbol.PropertyAttribute.ASSIGN.getGroup()) {
            if (type.isPointerToObjectCompatible() && OCCompilerFeatures.isArcEnabled(context.getContainingFile())) {
                return OCPropertySymbol.PropertyAttribute.STRONG;
            }
            return OCPropertySymbol.PropertyAttribute.ASSIGN;
        }
        return defaultAttribute;
    }

    @Override
    @Nullable
    public Icon getBaseIcon() {
        return OCIcons.getPropertyIcon(this.isStatic(), this.isOptional());
    }

    @Override
    public boolean isStatic() {
        return this.hasAttribute(OCPropertySymbol.PropertyAttribute.CLASS);
    }

    @Override
    public boolean isOptional() {
        return this.myOptional;
    }

    @Override
    public boolean isReadonly() {
        return this.hasAttribute(OCPropertySymbol.PropertyAttribute.READONLY);
    }

    @Override
    public boolean isRetained() {
        return this.hasAttribute(OCPropertySymbol.PropertyAttribute.RETAIN) || this.hasAttribute(OCPropertySymbol.PropertyAttribute.COPY);
    }

    @Override
    @NotNull
    public String getGetterName() {
        String getter = this.getAttributeValue(OCPropertySymbol.PropertyAttribute.GETTER);
        String string = getter != null ? getter : this.myName;
        if (string == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    @NotNull
    public String getSetterName() {
        String setter = this.getAttributeValue(OCPropertySymbol.PropertyAttribute.SETTER);
        String string = setter != null ? setter + ':' : OCNameSuggester.getObjCSetterFromGetter(this.myName);
        if (string == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    @NotNull
    public OCTypeSubstitution getSubstitution() {
        OCTypeSubstitution oCTypeSubstitution = this.mySubstitution;
        if (oCTypeSubstitution == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(13);
        }
        return oCTypeSubstitution;
    }

    @Override
    public boolean processAccessorMethods(Processor<? super OCMethodSymbol> processor2, boolean searchSubclasses, @NotNull Project project2) {
        if (project2 == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(14);
        }
        OCCommonProcessors.OrderedProcessor<? super OCMethodSymbol> methodProcessor = new OCCommonProcessors.OrderedProcessor<OCMethodSymbol>(processor2, methodSymbol -> {
            if (project2 == null) {
                OCPropertySymbolImpl.$$$reportNull$$$0(21);
            }
            return methodSymbol.isGetter(OCResolveContext.forSymbol(this, project2));
        }, Conditions.alwaysTrue());
        this.getParent().processMembers(null, OCMethodSymbol.class, symbol -> {
            if (project2 == null) {
                OCPropertySymbolImpl.$$$reportNull$$$0(20);
            }
            if (symbol.getGeneratedFromProperty() == this) {
                if (searchSubclasses) {
                    return OCSearchUtil.processMembersHierarchy(symbol, symbol1 -> {
                        if (symbol1.getGeneratedFromProperty() == null) {
                            return methodProcessor.process((OCMethodSymbol)symbol1);
                        }
                        return true;
                    }, false, true, project2);
                }
                OCMethodSymbol methAssociate = symbol.getAssociatedSymbol(project2);
                if (methAssociate != null) {
                    return methodProcessor.process(methAssociate);
                }
                return true;
            }
            return true;
        });
        return methodProcessor.finish();
    }

    @Override
    public boolean processSynthesizes(Processor<? super OCSynthesizeSymbol> processor2, @NotNull Project project2) {
        OCImplementationSymbol implementation;
        if (project2 == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(15);
        }
        if ((implementation = this.getParent().getImplementation(project2)) == null) {
            return false;
        }
        return implementation.processMembers(OCSynthesizeSymbol.class, symbol -> !this.getName().equals(symbol.getName()) || processor2.process(symbol));
    }

    @Override
    @Nullable
    public OCInstanceVariableSymbol getAssociatedIvar(@NotNull Project project2) {
        if (project2 == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(16);
        }
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        this.processSynthesizes((Processor<? super OCSynthesizeSymbol>)finder, project2);
        if (!finder.isFound()) {
            if (OCCompilerFeatures.supportsAutosynthesis(this.getContainingOCFile(project2))) {
                String ivarName = OCNameSuggester.getClang4ImplicitIvarName(this.myName);
                CommonProcessors.FindFirstProcessor ivarFinder = new CommonProcessors.FindFirstProcessor();
                OCCommonProcessors.OrderedProcessor orderedProcessor = new OCCommonProcessors.OrderedProcessor(ivarFinder, (Condition<T>[])new Condition[]{symbol -> {
                    if (project2 == null) {
                        OCPropertySymbolImpl.$$$reportNull$$$0(19);
                    }
                    return !symbol.isClang4ImplicitIvar(project2);
                }, Conditions.alwaysTrue()});
                this.myParent.processMembersInAllCategories(ivarName, OCInstanceVariableSymbol.class, orderedProcessor, false, project2);
                orderedProcessor.finish();
                return (OCInstanceVariableSymbol)ivarFinder.getFoundValue();
            }
            return null;
        }
        return ((OCSynthesizeSymbol)finder.getFoundValue()).getIvarSymbol(project2);
    }

    @Override
    public boolean hasAllAccessorsImplemented(final boolean treatSynthesizeAsAccessors, @NotNull Project project2) {
        OCImplementationSymbol implementation;
        if (project2 == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(17);
        }
        if ((implementation = this.getParent().getImplementation(project2)) == null) {
            return false;
        }
        final String getter = this.getGetterName();
        final String setter = this.getSetterName();
        final OCResolveContext context = OCResolveContext.forSymbol(this, project2);
        return !implementation.processMembers((String)null, new Processor<OCMemberSymbol>(){
            boolean wasGetter;
            boolean wasSetter;

            public boolean process(OCMemberSymbol symbol) {
                if (treatSynthesizeAsAccessors && symbol instanceof OCSynthesizeSymbol && OCPropertySymbolImpl.this.myName.equals(symbol.getName())) {
                    return false;
                }
                if (symbol instanceof OCMethodSymbol) {
                    if (getter.equals(symbol.getName()) && ((OCMethodSymbol)symbol).isGetter(context)) {
                        this.wasGetter = true;
                    }
                    if (setter.equals(symbol.getName()) && ((OCMethodSymbol)symbol).isSetter(context)) {
                        this.wasSetter = true;
                    }
                    return !this.wasGetter || !OCPropertySymbolImpl.this.isReadonly() && !this.wasSetter;
                }
                return true;
            }
        });
    }

    @Override
    @Nullable
    public OCPropertySymbol getAssociatedPropertyInPrivateCategory(@NotNull Project project2) {
        if (project2 == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(18);
        }
        if ("".equals(this.getParent().getCategoryName())) {
            return null;
        }
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        this.getParent().processMembers("", this.getName(), OCPropertySymbol.class, finder, true, project2);
        return (OCPropertySymbol)finder.getFoundValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitution";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/objc/OCPropertySymbolImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/objc/OCPropertySymbolImpl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getGetterName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSetterName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitution";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseAttribute";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processAccessorMethods";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processSynthesizes";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedIvar";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "hasAllAccessorsImplemented";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedPropertyInPrivateCategory";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getAssociatedIvar$4";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processAccessorMethods$2";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processAccessorMethods$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

