/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.objc;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CommonProcessors;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSynthesizeSymbol
extends OCMemberSymbolImpl {
    private boolean mySynthesize;
    private boolean myStatic;
    private String myIvarName;

    public OCSynthesizeSymbol() {
    }

    /*
     * WARNING - void declaration
     */
    public OCSynthesizeSymbol(@NotNull Project project2, VirtualFile file, long offset, String name2, @NotNull List<String> attributes, OCClassSymbol parent, boolean isSynthesize, boolean isStatic, String string) {
        void ivarName;
        if (project2 == null) {
            OCSynthesizeSymbol.$$$reportNull$$$0(0);
        }
        if (attributes == null) {
            OCSynthesizeSymbol.$$$reportNull$$$0(1);
        }
        super(project2, file, offset, name2, attributes, parent);
        this.mySynthesize = isSynthesize;
        this.myStatic = isStatic;
        this.myIvarName = ivarName;
    }

    public boolean isSynthesize() {
        return this.mySynthesize;
    }

    @Override
    public boolean isStatic() {
        return this.myStatic;
    }

    public String getIvarName() {
        return this.myIvarName != null ? this.myIvarName : this.myName;
    }

    public boolean hasIvar() {
        return this.myIvarName != null;
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        OCSymbolKind oCSymbolKind = OCSymbolKind.SYNTHESIZE;
        if (oCSymbolKind == null) {
            OCSynthesizeSymbol.$$$reportNull$$$0(2);
        }
        return oCSymbolKind;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            OCSynthesizeSymbol.$$$reportNull$$$0(3);
        }
        if (first == null) {
            OCSynthesizeSymbol.$$$reportNull$$$0(4);
        }
        if (second == null) {
            OCSynthesizeSymbol.$$$reportNull$$$0(5);
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCSynthesizeSymbol f = (OCSynthesizeSymbol)first;
        OCSynthesizeSymbol s = (OCSynthesizeSymbol)second;
        if (f.mySynthesize != s.mySynthesize) {
            return false;
        }
        if (f.myStatic != s.myStatic) {
            return false;
        }
        return Comparing.equal((String)f.myIvarName, (String)s.myIvarName);
    }

    @Nullable
    public OCPropertySymbol getAssociatedProperty(@NotNull Project project2) {
        OCInterfaceSymbol interf;
        if (project2 == null) {
            OCSynthesizeSymbol.$$$reportNull$$$0(6);
        }
        if ((interf = this.getParent().getInterface(project2)) == null) {
            return null;
        }
        final String propertyName = this.getName();
        CommonProcessors.FindFirstProcessor<OCPropertySymbol> processor2 = new CommonProcessors.FindFirstProcessor<OCPropertySymbol>(){

            protected boolean accept(OCPropertySymbol symbol) {
                return Comparing.equal((String)propertyName, (String)symbol.getName());
            }
        };
        interf.processMembers(propertyName, OCPropertySymbol.class, processor2);
        if (!processor2.isFound()) {
            interf.processMembers("", propertyName, OCPropertySymbol.class, processor2, true, project2);
        }
        return (OCPropertySymbol)processor2.getFoundValue();
    }

    @Nullable
    public OCInstanceVariableSymbol getIvarSymbol(final @NotNull Project project2) {
        if (project2 == null) {
            OCSynthesizeSymbol.$$$reportNull$$$0(7);
        }
        OCClassSymbol impl = this.getParent();
        CommonProcessors.FindFirstProcessor<OCInstanceVariableSymbol> finder = new CommonProcessors.FindFirstProcessor<OCInstanceVariableSymbol>(){

            protected boolean accept(OCInstanceVariableSymbol symbol) {
                return Comparing.equal((String)OCSynthesizeSymbol.this.getIvarName(), (String)symbol.getName()) && !symbol.isClang4ImplicitIvar(project2);
            }
        };
        OCCommonProcessors.OrderedProcessor processor2 = new OCCommonProcessors.OrderedProcessor(finder, true, (Condition<T>[])new Condition[]{ivar -> ivar.getGeneratedFromProperty() == null, Conditions.alwaysTrue()});
        OCInterfaceSymbol intf = impl.getInterface(project2);
        if (intf != null) {
            intf.processMembersInAllCategories(this.getIvarName(), OCInstanceVariableSymbol.class, processor2, project2);
        }
        impl.processMembers(this.getIvarName(), OCInstanceVariableSymbol.class, processor2);
        processor2.finish();
        return (OCInstanceVariableSymbol)finder.getFoundValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/objc/OCSynthesizeSymbol";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/objc/OCSynthesizeSymbol";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedProperty";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getIvarSymbol";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

