/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolTablesBuildingActivity;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.workspace.OCDeprecatedWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGlobalProjectSymbolsCache<T extends OCSymbol, S extends Symbols<T>>
extends AbstractProjectComponent {
    private final CachedValue<S> myGlobalSymbols;
    private final Object myGlobalSymbolsLock;
    private final CachedValue<MultiValuesMap<String, T>> myGlobalShortNames;
    private final Object myGlobalShortNamesLock;

    protected <Impl extends AbstractGlobalProjectSymbolsCache> AbstractGlobalProjectSymbolsCache(@NotNull Class<Impl> clazz, Project project2) {
        if (clazz == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(0);
        }
        super(project2);
        CachedValuesManager manager = CachedValuesManager.getManager((Project)project2);
        this.myGlobalSymbolsLock = new Object();
        this.myGlobalSymbols = manager.createCachedValue(() -> {
            if (!FileSymbolTablesCache.areSymbolsLoaded(project2)) {
                throw IndexNotReadyException.create();
            }
            S symbols = this.buildGlobalSymbols(project2);
            SimpleModificationTracker changeTracker = FileSymbolTablesCache.getInstance(project2).getOutOfBlockModificationTracker();
            return CachedValueProvider.Result.create(symbols, (Object[])new Object[]{OCSymbolTablesBuildingActivity.getInstance(project2).getModificationTracker(), changeTracker});
        }, false);
        this.myGlobalShortNamesLock = new Object();
        this.myGlobalShortNames = manager.createCachedValue(() -> {
            if (clazz == null) {
                AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(20);
            }
            assert (FileSymbolTablesCache.areSymbolsLoaded(project2)) : "Symbols must be loaded";
            MultiValuesMap result = new MultiValuesMap();
            AbstractGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(clazz, project2, symbol -> {
                result.put((Object)symbol.getName(), symbol);
                return true;
            }, null);
            SimpleModificationTracker changeTracker = FileSymbolTablesCache.getInstance(project2).getOutOfBlockModificationTracker();
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{OCSymbolTablesBuildingActivity.getInstance(project2).getModificationTracker(), changeTracker});
        }, false);
    }

    @Nullable
    protected static <Impl extends AbstractGlobalProjectSymbolsCache, T extends OCSymbol> T findNearestTopLevelSymbol(@NotNull Class<Impl> clazz, Project project2, @Nullable String name2, @Nullable Condition<? super T> condition, @Nullable VirtualFile contextFile) {
        if (clazz == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(1);
        }
        OCWorkspace workspace = OCWorkspace.getInstance(project2);
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        OCCommonProcessors.OrderedProcessor orderedProcessor = new OCCommonProcessors.OrderedProcessor<T>((Processor)finder, true, new Condition[]{symbol -> contextFile != null && Comparing.equal((Object)symbol.getContainingFile(), (Object)contextFile), symbol -> {
            VirtualFile file = symbol.getContainingFile();
            return contextFile != null && file != null && Comparing.equal((String)file.getNameWithoutExtension(), (String)contextFile.getNameWithoutExtension());
        }, symbol -> {
            VirtualFile file = symbol.getContainingFile();
            return contextFile != null && file != null && Comparing.equal((Object)file.getParent(), (Object)contextFile.getParent());
        }, symbol -> {
            VirtualFile symbolFile = symbol.getContainingFile();
            return workspace instanceof OCDeprecatedWorkspace && ((OCDeprecatedWorkspace)workspace).areFromSameProject(contextFile, symbolFile);
        }, Conditions.alwaysTrue()}){

            @Override
            public Collection<T> sort(Collection<T> collection) {
                ArrayList list = new ArrayList(collection);
                Collections.sort(list, (o1, o2) -> o1.hashCode() - o2.hashCode());
                return list;
            }
        };
        AbstractGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(clazz, project2, symbol -> {
            if (condition != null && !condition.value(symbol)) {
                return true;
            }
            if (workspace instanceof OCDeprecatedWorkspace && ((OCDeprecatedWorkspace)workspace).isFromWrongSDK((OCSymbol)symbol, contextFile)) {
                return true;
            }
            return orderedProcessor.process(symbol);
        }, name2, true);
        orderedProcessor.finish();
        return (T)((OCSymbol)finder.getFoundValue());
    }

    @NotNull
    public static <T> T getInstance(@NotNull Class<T> clazz, @NotNull Project project2) {
        if (clazz == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(3);
        }
        Object object = project2.getComponent(clazz);
        if (object == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(4);
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected S getGlobalSymbols() {
        Object object = this.myGlobalSymbolsLock;
        // MONITORENTER : object
        Symbols symbols = (Symbols)this.myGlobalSymbols.getValue();
        // MONITOREXIT : object
        if (symbols != null) return (S)symbols;
        AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(5);
        return (S)symbols;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected MultiValuesMap<String, T> getGlobalShortNames() {
        Object object = this.myGlobalShortNamesLock;
        // MONITORENTER : object
        MultiValuesMap multiValuesMap = (MultiValuesMap)this.myGlobalShortNames.getValue();
        // MONITOREXIT : object
        if (multiValuesMap != null) return multiValuesMap;
        AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(6);
        return multiValuesMap;
    }

    protected abstract S buildGlobalSymbols(Project var1);

    protected static <Impl extends AbstractGlobalProjectSymbolsCache, T extends OCSymbol> boolean processTopLevelSymbols(@NotNull Class<Impl> clazz, @NotNull Project project2, Processor<? super T> processor2, @Nullable String name2) {
        if (clazz == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(7);
        }
        if (project2 == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(8);
        }
        return AbstractGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(clazz, project2, processor2, name2, true);
    }

    protected static <Impl extends AbstractGlobalProjectSymbolsCache, T extends OCSymbol> boolean processTopLevelAndMemberSymbols(@NotNull Class<Impl> clazz, Project project2, Processor<? super T> processor2, @Nullable String name2) {
        if (clazz == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(9);
        }
        return AbstractGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(clazz, project2, processor2, name2, false);
    }

    protected static <Impl extends AbstractGlobalProjectSymbolsCache, T extends OCSymbol> boolean processByQualifiedName(@NotNull Class<Impl> clazz, Project project2, Processor<? super T> processor2, @NotNull String name2) {
        Collection iterable;
        if (clazz == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(10);
        }
        if (name2 == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(11);
        }
        return (iterable = ((AbstractGlobalProjectSymbolsCache)((Object)AbstractGlobalProjectSymbolsCache.getInstance(clazz, project2))).getGlobalShortNames().get((Object)name2)) == null || ContainerUtil.process((Iterable)iterable, processor2);
    }

    protected static <Impl extends AbstractGlobalProjectSymbolsCache> boolean processAliasNamesForType(@NotNull Class<Impl> clazz, @NotNull Project project2, @NotNull String name2, @NotNull Processor<String> processor2) {
        if (clazz == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(12);
        }
        if (project2 == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(13);
        }
        if (name2 == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(14);
        }
        if (processor2 == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(15);
        }
        FileSymbolTablesCache.getInstance(project2).ensurePendingFilesProcessed();
        return ((AbstractGlobalProjectSymbolsCache)((Object)AbstractGlobalProjectSymbolsCache.getInstance(clazz, project2))).getGlobalSymbols().processAliasNamesForType(name2, processor2);
    }

    public static <Impl extends AbstractGlobalProjectSymbolsCache, T extends OCSymbol> boolean processTopLevelAndMemberSymbols(@NotNull Class<Impl> clazz, @NotNull Project project2, @NotNull Processor<? super T> processor2, @Nullable String name2, boolean topLevelOnly) {
        if (clazz == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(16);
        }
        if (project2 == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(17);
        }
        if (processor2 == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(18);
        }
        FileSymbolTablesCache.getInstance(project2).ensurePendingFilesProcessed();
        Object symbols = ((AbstractGlobalProjectSymbolsCache)((Object)AbstractGlobalProjectSymbolsCache.getInstance(clazz, project2))).getGlobalSymbols();
        if (topLevelOnly) {
            return symbols.processTopLevel(processor2, name2);
        }
        return symbols.processAllSymbols(processor2, name2);
    }

    public static <Impl extends AbstractGlobalProjectSymbolsCache> Set<String> getAllSymbolNames(@NotNull Class<Impl> clazz, Project project2) {
        if (clazz == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(19);
        }
        return ((AbstractGlobalProjectSymbolsCache)((Object)AbstractGlobalProjectSymbolsCache.getInstance(clazz, project2))).getGlobalShortNames().keySet();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 3: 
            case 8: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/symtable/AbstractGlobalProjectSymbolsCache";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/AbstractGlobalProjectSymbolsCache";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalSymbols";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalShortNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findNearestTopLevelSymbol";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processTopLevelSymbols";
                break;
            }
            case 9: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processTopLevelAndMemberSymbols";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processByQualifiedName";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processAliasNamesForType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getAllSymbolNames";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface Symbols<T>
    extends Processor<T> {
        public boolean processAliasNamesForType(@NotNull String var1, @NotNull Processor<String> var2);

        public boolean processTopLevel(Processor<? super T> var1, @Nullable String var2);

        public boolean processAllSymbols(Processor<? super T> var1, @Nullable String var2);
    }
}

