/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContextSignature
implements Serializable {
    public static final int NO_EXACT_DEFINITION_MARKER = Integer.MAX_VALUE;
    private static final int[] EMPTY_HASHES = new int[0];
    public final List<String> myDefined;
    public final int[] myDefinedHashes;
    public final List<String> myNotDefined;
    @NotNull
    public final List<String> myNamespace;
    public int myDistinctiveDefinedCount;
    public int myDistinctiveNotDefinedCount;
    @Nullable
    public final OCLanguageKind myLanguageKind;

    public ContextSignature(@Nullable OCLanguageKind kind, Map<String, Integer> definitions, Set<String> notDefined, @NotNull List<String> namespace) {
        if (namespace == null) {
            ContextSignature.$$$reportNull$$$0(0);
        }
        this.myDistinctiveDefinedCount = 0;
        this.myDistinctiveNotDefinedCount = 0;
        this.myLanguageKind = kind;
        int defSize = definitions.size();
        this.myDefined = defSize == 0 ? Collections.emptyList() : new ArrayList(defSize);
        this.myDefinedHashes = defSize == 0 ? EMPTY_HASHES : new int[defSize];
        int curDef = 0;
        for (Map.Entry<String, Integer> e : definitions.entrySet()) {
            this.myDefined.add(e.getKey());
            Integer hash = e.getValue();
            this.myDefinedHashes[curDef] = hash == null ? Integer.MAX_VALUE : ContextSignature.packedHash(hash);
            ++curDef;
        }
        this.myNotDefined = notDefined.isEmpty() ? Collections.emptyList() : new ArrayList<String>(notDefined);
        this.myNamespace = namespace.isEmpty() ? Collections.emptyList() : new ArrayList<String>(namespace);
    }

    public ContextSignature() {
        this(null, Collections.emptyMap(), Collections.emptySet(), Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCompatible(@NotNull OCImmutableInclusionContext ctx) {
        if (ctx == null) {
            ContextSignature.$$$reportNull$$$0(1);
        }
        if (ctx.getLanguageKind() != this.myLanguageKind) {
            return false;
        }
        List<String> namespace = ctx.getCurrentNamespace();
        if (!namespace.equals(this.myNamespace)) {
            return false;
        }
        ContextSignature contextSignature = this;
        synchronized (contextSignature) {
            int i;
            for (i = 0; i < this.myDistinctiveDefinedCount; ++i) {
                if (ContextSignature.checkDefined(ctx, this.myDefined.get(i), this.myDefinedHashes[i])) continue;
                return false;
            }
            for (i = 0; i < this.myDistinctiveNotDefinedCount; ++i) {
                if (!ContextSignature.isDefined(ctx, this.myNotDefined.get(i))) continue;
                return false;
            }
            int definedSize = this.myDefined.size();
            for (int i2 = this.myDistinctiveDefinedCount; i2 < definedSize; ++i2) {
                if (ContextSignature.checkDefined(ctx, this.myDefined.get(i2), this.myDefinedHashes[i2])) continue;
                Collections.swap(this.myDefined, this.myDistinctiveDefinedCount, i2);
                ArrayUtil.swap((int[])this.myDefinedHashes, (int)this.myDistinctiveDefinedCount, (int)i2);
                ++this.myDistinctiveDefinedCount;
                return false;
            }
            int notDefinedSize = this.myNotDefined.size();
            for (int i3 = this.myDistinctiveNotDefinedCount; i3 < notDefinedSize; ++i3) {
                if (!ContextSignature.isDefined(ctx, this.myNotDefined.get(i3))) continue;
                Collections.swap(this.myNotDefined, this.myDistinctiveNotDefinedCount, i3);
                ++this.myDistinctiveNotDefinedCount;
                return false;
            }
        }
        return true;
    }

    private static boolean isDefined(@NotNull OCImmutableInclusionContext ctx, @NotNull String def) {
        if (ctx == null) {
            ContextSignature.$$$reportNull$$$0(2);
        }
        if (def == null) {
            ContextSignature.$$$reportNull$$$0(3);
        }
        return ctx.getDefinition(def, OCImmutableInclusionContext.SignaturePart.NO) != null;
    }

    public static boolean checkDefined(@NotNull OCImmutableInclusionContext ctx, String def, int defHash) {
        boolean ok;
        if (ctx == null) {
            ContextSignature.$$$reportNull$$$0(4);
        }
        boolean shouldCheckExactDefinition = defHash != Integer.MAX_VALUE;
        OCMacroSymbol ctxDef = ctx.getDefinition(def, OCImmutableInclusionContext.SignaturePart.NO);
        boolean bl = ok = ctxDef != null;
        if (ok && shouldCheckExactDefinition) {
            ok = defHash == ContextSignature.packedHash(ctxDef.getSubstitutionHash());
        }
        return ok;
    }

    private static int packedHash(int hash) {
        return hash == Integer.MAX_VALUE ? hash - 1 : hash;
    }

    public boolean sameSignature(@NotNull ContextSignature other) {
        Map d2;
        HashSet nd2;
        if (other == null) {
            ContextSignature.$$$reportNull$$$0(5);
        }
        if (!Comparing.equal((Object)this.myLanguageKind, (Object)other.myLanguageKind)) {
            return false;
        }
        HashSet nd1 = ContainerUtil.newHashSet(this.myNotDefined);
        if (!Comparing.equal((Object)nd1, (Object)(nd2 = ContainerUtil.newHashSet(other.myNotDefined)))) {
            return false;
        }
        Map d1 = ContainerUtil.newHashMap(this.myDefined, ContextSignature.toIntList(this.myDefinedHashes));
        return Comparing.equal((Object)d1, (Object)(d2 = ContainerUtil.newHashMap(other.myDefined, ContextSignature.toIntList(other.myDefinedHashes))));
    }

    @NotNull
    private static ArrayList<Integer> toIntList(int[] array) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i : array) {
            list.add(i);
        }
        ArrayList<Integer> arrayList = list;
        if (arrayList == null) {
            ContextSignature.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctx";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "def";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/symtable/ContextSignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/ContextSignature";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toIntList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isCompatible";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isDefined";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkDefined";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sameSignature";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

