/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCModuleResolver;
import com.jetbrains.cidr.lang.preprocessor.OCParsingNameScope;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.ProjectAndVirtualFileOwner;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUndefMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCModuleImportSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.ContextSignature;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolTablesBuildingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.SymbolTableProvider;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import gnu.trove.THashSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSymbolTable
implements Serializable,
ProjectAndVirtualFileOwner {
    private static boolean ourShouldCompactSymbols = true;
    private static final Key<Map<Class, Pair<Integer, Integer>>> DEBUG_STATS_KEY = Key.create((String)"FileSymbolTable.STATS_KEY");
    private static final Logger LOG = Logger.getInstance(FileSymbolTable.class);
    private final ArrayList<OCSymbol> myContents;
    private ContextSignature mySignature;
    private volatile int myPackStamp;
    private transient VirtualFile myFile;
    private transient Project myProject;
    private volatile transient int myUsingCount;

    public FileSymbolTable() {
        this.myContents = new ArrayList();
    }

    public FileSymbolTable(@NotNull VirtualFile file, @NotNull Project project2, @NotNull ContextSignature signature) {
        if (file == null) {
            FileSymbolTable.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            FileSymbolTable.$$$reportNull$$$0(1);
        }
        if (signature == null) {
            FileSymbolTable.$$$reportNull$$$0(2);
        }
        this.myContents = new ArrayList();
        this.myFile = file;
        this.mySignature = signature;
        this.myProject = project2;
    }

    public void compact() {
        this.myContents.trimToSize();
    }

    @NotNull
    public ContextSignature getSignature() {
        ContextSignature contextSignature = this.mySignature;
        if (contextSignature == null) {
            FileSymbolTable.$$$reportNull$$$0(3);
        }
        return contextSignature;
    }

    @Override
    public VirtualFile getContainingFile() {
        return this.myFile;
    }

    @NotNull
    public List<OCSymbol> getContents() {
        ArrayList<OCSymbol> arrayList = this.myContents;
        if (arrayList == null) {
            FileSymbolTable.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            FileSymbolTable.$$$reportNull$$$0(5);
        }
        return project2;
    }

    public void internSymbols(Function<OCSymbol, OCSymbol> internator) {
        for (int i = 0; i < this.myContents.size(); ++i) {
            OCSymbol each = this.myContents.get(i);
            OCSymbol replacement = (OCSymbol)internator.fun((Object)each);
            this.incInterned(each, false);
            if (each != replacement) {
                this.incInterned(each, true);
                this.myContents.set(i, replacement);
                continue;
            }
            if (!ourShouldCompactSymbols) continue;
            each.compact();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incInterned(OCSymbol each, boolean interned) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        HashMap stats = (HashMap)this.myProject.getUserData(DEBUG_STATS_KEY);
        if (stats == null) {
            stats = new HashMap();
            this.myProject.putUserData(DEBUG_STATS_KEY, stats);
        }
        HashMap hashMap = stats;
        synchronized (hashMap) {
            Pair s = (Pair)stats.get(each.getClass());
            if (s == null) {
                s = new Pair((Object)0, (Object)0);
            }
            s = interned ? new Pair((Object)((Integer)s.first + 1), s.second) : new Pair(s.first, (Object)((Integer)s.second + 2));
            stats.put(each.getClass(), s);
            if (each instanceof OCNamespaceSymbol) {
                ((OCNamespaceSymbol)each).processMembers((String)null, (Processor<OCSymbol>)((Processor)symbol -> {
                    this.incInterned((OCSymbol)symbol, false);
                    this.incInterned((OCSymbol)symbol, true);
                    return true;
                }));
            } else if (each instanceof OCClassSymbol) {
                ((OCClassSymbol)each).processMembers(null, OCMemberSymbol.class, symbol -> {
                    this.incInterned((OCSymbol)symbol, false);
                    this.incInterned((OCSymbol)symbol, true);
                    return true;
                });
            }
        }
    }

    public static void reportStats(@NotNull Project project2) {
        Map stats;
        if (project2 == null) {
            FileSymbolTable.$$$reportNull$$$0(6);
        }
        if ((stats = (Map)project2.getUserData(DEBUG_STATS_KEY)) == null) {
            return;
        }
        project2.putUserData(DEBUG_STATS_KEY, null);
        for (Map.Entry each : stats.entrySet()) {
            LOG.debug(((Class)each.getKey()).getSimpleName() + ": interned=" + ((Pair)each.getValue()).first + " count=" + ((Pair)each.getValue()).second);
        }
    }

    public void updateOffsets(int start, int lengthShift, THashSet<OCSymbol> processed) {
        for (OCSymbol symbol : this.myContents) {
            if (!processed.add((Object)symbol)) continue;
            symbol.updateOffset(start, lengthShift);
        }
    }

    @Override
    public void init(@Nullable Project project2, @Nullable VirtualFile file) {
        this.myFile = file;
        this.myProject = project2;
    }

    @Nullable
    public static FileSymbolTable forFile(@NotNull PsiFile file, @NotNull OCInclusionContext context) {
        if (file == null) {
            FileSymbolTable.$$$reportNull$$$0(7);
        }
        if (context == null) {
            FileSymbolTable.$$$reportNull$$$0(8);
        }
        Project project2 = file.getProject();
        OCSymbolTablesBuildingActivity.getInstance(project2).assertParsingAndSymbolBuildingAllowed();
        file = file.getOriginalFile();
        FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(project2);
        return cache.forFile(file, context);
    }

    @Nullable
    public <T extends OCSymbol> T findSymbol(@NotNull PsiElement element, @NotNull Class<T> symbolClass) {
        if (element == null) {
            FileSymbolTable.$$$reportNull$$$0(9);
        }
        if (symbolClass == null) {
            FileSymbolTable.$$$reportNull$$$0(10);
        }
        return this.findSymbol(element, null, symbolClass);
    }

    @Nullable
    public <T extends OCSymbol> T findSymbol(@NotNull PsiElement element, @Nullable String symbolName, @NotNull Class<T> symbolClass) {
        if (element == null) {
            FileSymbolTable.$$$reportNull$$$0(11);
        }
        if (symbolClass == null) {
            FileSymbolTable.$$$reportNull$$$0(12);
        }
        String lookupName = symbolName != null ? symbolName : OCElementUtil.getSymbolName(element);
        long offset = element instanceof OCElement ? ((OCElement)element).getComplexOffset() : OCSymbolOffsetUtil.getComplexOffset(element.getTextOffset(), 0);
        return this.findSymbol(lookupName, offset, symbolClass);
    }

    @Nullable
    public <T extends OCSymbol> T findSymbol(@Nullable String symbolName, @NotNull Class<T> symbolClass) {
        if (symbolClass == null) {
            FileSymbolTable.$$$reportNull$$$0(13);
        }
        return this.findSymbol(symbolName, -1L, symbolClass);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private <T extends OCSymbol> T findSymbol(final @Nullable String symbolName, final long complexOffset, @NotNull Class<T> clazz) {
        void symbolClass;
        if (clazz == null) {
            FileSymbolTable.$$$reportNull$$$0(14);
        }
        OCSymbol[] result = new OCSymbol[1];
        OCSymbol[] possible = new OCSymbol[1];
        Processor<OCSymbol> processor2 = new Processor<OCSymbol>((Class)symbolClass, result, possible){
            final /* synthetic */ Class val$symbolClass;
            final /* synthetic */ OCSymbol[] val$result;
            final /* synthetic */ OCSymbol[] val$possible;
            {
                this.val$symbolClass = clazz;
                this.val$result = oCSymbolArray;
                this.val$possible = oCSymbolArray2;
            }

            public boolean process(OCSymbol symbol) {
                symbol = symbol.getDelegate();
                if ((complexOffset == -1L || symbol.getOffset() == OCSymbolOffsetUtil.getTextOffset(complexOffset)) && (symbolName == null || Comparing.equal((String)symbolName, (String)symbol.getName())) && this.val$symbolClass.isAssignableFrom(symbol.getClass())) {
                    if (complexOffset == -1L || symbol.getComplexOffset() == complexOffset) {
                        this.val$result[0] = symbol;
                        return false;
                    }
                    this.val$possible[0] = symbol;
                }
                if (symbol instanceof OCNamespaceSymbol) {
                    return ((OCNamespaceSymbol)symbol).processMembers((String)null, this);
                }
                if (symbol instanceof OCClassSymbol) {
                    1 this_ = this;
                    return ((OCClassSymbol)symbol).processMembers(symbolName, (Processor<OCMemberSymbol>)((Processor)symbol1 -> this_.process(symbol1)));
                }
                return true;
            }
        };
        ContainerUtil.process(this.myContents, (Processor)processor2);
        if (result[0] != null) {
            return (T)result[0];
        }
        return (T)possible[0];
    }

    public boolean processFile(Processor<OCSymbol> processor2) {
        for (OCSymbol symbol : this.myContents) {
            ProgressManager.checkCanceled();
            if (processor2.process(symbol.getDelegate())) continue;
            return false;
        }
        return true;
    }

    public boolean processFile(Processor<OCSymbol> processor2, int afterOffset, int beforeOffset) {
        return OCResolveUtil.processSymbolsFromList((Processor<OCSymbol>)((Processor)symbol -> processor2.process(symbol.getDelegate())), this.myContents, afterOffset, beforeOffset);
    }

    public boolean processIncludes(Processor<OCSymbol> processor2) {
        for (OCSymbol item : this.myContents) {
            if (!(item instanceof OCIncludeSymbol) && !(item instanceof OCModuleImportSymbol) || processor2.process((Object)item)) continue;
            return false;
        }
        return true;
    }

    public boolean processSymbols(@NotNull Processor<OCSymbol> processor2, @Nullable String symbolName, @Nullable Map<OCSymbol, VirtualFile> importsMap, @NotNull OCInclusionContext context) {
        if (processor2 == null) {
            FileSymbolTable.$$$reportNull$$$0(15);
        }
        if (context == null) {
            FileSymbolTable.$$$reportNull$$$0(16);
        }
        return this.processSymbols(processor2, symbolName, (Set<FileSymbolTable>)new THashSet(), importsMap, null, context, null);
    }

    public boolean shallowProcessSymbols(@NotNull Processor<OCSymbol> processor2) {
        if (processor2 == null) {
            FileSymbolTable.$$$reportNull$$$0(17);
        }
        for (OCSymbol content : this.myContents) {
            if (!(content instanceof OCSymbol) || processor2.process(content.getDelegate())) continue;
            return false;
        }
        return false;
    }

    public boolean processSymbols(@NotNull Processor<OCSymbol> processor2, @Nullable String symbolName, @NotNull Set<FileSymbolTable> processedTables, @Nullable Map<OCSymbol, VirtualFile> importsMap, @Nullable VirtualFile firstImportLink, @NotNull OCInclusionContext context, @Nullable VirtualFile breakOn) {
        if (processor2 == null) {
            FileSymbolTable.$$$reportNull$$$0(18);
        }
        if (processedTables == null) {
            FileSymbolTable.$$$reportNull$$$0(19);
        }
        if (context == null) {
            FileSymbolTable.$$$reportNull$$$0(20);
        }
        return this.processSymbols(processor2, symbolName, processedTables, importsMap, firstImportLink, context, breakOn, false);
    }

    public boolean processSymbols(@NotNull Processor<OCSymbol> processor2, @Nullable String symbolName, @NotNull Set<FileSymbolTable> processedTables, @Nullable Map<OCSymbol, VirtualFile> importsMap, @Nullable VirtualFile firstImportLink, @NotNull OCInclusionContext context, @Nullable VirtualFile breakOn, boolean processImportSymbols) {
        if (processor2 == null) {
            FileSymbolTable.$$$reportNull$$$0(21);
        }
        if (processedTables == null) {
            FileSymbolTable.$$$reportNull$$$0(22);
        }
        if (context == null) {
            FileSymbolTable.$$$reportNull$$$0(23);
        }
        if (this.isEmpty()) {
            return true;
        }
        if (!processedTables.add(this)) {
            return true;
        }
        FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(this.myProject);
        class Builder
        implements Processor<OCSymbol> {
            private boolean done = false;
            private OCParsingNameScope myNameScope;
            final /* synthetic */ boolean val$processImportSymbols;
            final /* synthetic */ Processor val$processor;
            final /* synthetic */ OCInclusionContext val$context;
            final /* synthetic */ String val$symbolName;
            final /* synthetic */ Set val$processedTables;
            final /* synthetic */ VirtualFile val$breakOn;
            final /* synthetic */ VirtualFile val$firstImportLink;
            final /* synthetic */ Map val$importsMap;
            final /* synthetic */ FileSymbolTablesCache val$cache;

            Builder(OCParsingNameScope nameScope) {
                this.val$processImportSymbols = bl;
                this.val$processor = processor2;
                this.val$context = oCInclusionContext;
                this.val$symbolName = string;
                this.val$processedTables = set;
                this.val$breakOn = virtualFile;
                this.val$firstImportLink = virtualFile2;
                this.val$importsMap = map2;
                this.val$cache = fileSymbolTablesCache;
                this.myNameScope = nameScope;
            }

            public boolean process(OCSymbol symbol) {
                ProgressManager.checkCanceled();
                if (symbol instanceof OCModuleImportSymbol) {
                    if (this.done) {
                        return true;
                    }
                    if (this.val$processImportSymbols && !this.val$processor.process((Object)symbol)) {
                        return false;
                    }
                    return OCModuleResolver.processModuleImports(this.val$context, ((OCModuleImportSymbol)symbol).getNameParts(), (Processor<VirtualFile>)((Processor)file -> this.processInclude((VirtualFile)file, true)));
                }
                if (symbol instanceof OCIncludeSymbol) {
                    OCIncludeSymbol include = (OCIncludeSymbol)symbol;
                    if (this.done) {
                        return true;
                    }
                    include.enterNamespace(this.val$context);
                    VirtualFile includeFile = include.getTargetFile();
                    boolean once = include.isOnce();
                    if (this.val$processImportSymbols && !this.val$processor.process((Object)symbol)) {
                        return false;
                    }
                    if (!this.processInclude(includeFile, once)) {
                        return false;
                    }
                    include.exitNamespace(this.val$context);
                    return true;
                }
                if (this.done) {
                    return true;
                }
                if (this.val$symbolName != null && !this.val$symbolName.equals(symbol.getName())) {
                    return true;
                }
                this.updateImportsMap(symbol);
                this.updateContext(symbol);
                return this.val$processor.process((Object)symbol);
            }

            private boolean processInclude(@Nullable VirtualFile includeFile, boolean once) {
                FileSymbolTable table = this.findTableForInclude(includeFile, once);
                if (this.val$processedTables.contains(table)) {
                    return true;
                }
                if (this.val$breakOn != null && Comparing.equal((Object)includeFile, (Object)this.val$breakOn)) {
                    return false;
                }
                if (table != null) {
                    VirtualFile link;
                    VirtualFile virtualFile = link = this.val$firstImportLink == null ? includeFile : this.val$firstImportLink;
                    if (!table.processSymbols((Processor<OCSymbol>)this.val$processor, this.val$symbolName, this.val$processedTables, this.val$importsMap, link, this.val$context, this.val$breakOn, this.val$processImportSymbols)) {
                        return false;
                    }
                }
                return true;
            }

            @Nullable
            private FileSymbolTable findTableForInclude(@Nullable VirtualFile includeFile, boolean once) {
                PsiFile psiFile;
                if (includeFile != null && includeFile.isValid() && SymbolTableProvider.isSourceFile(psiFile = PsiManager.getInstance((Project)FileSymbolTable.this.myProject).findFile(includeFile)) && this.val$context.reserveInclude(includeFile, once)) {
                    return this.val$cache.forFile(psiFile, this.val$context);
                }
                return null;
            }

            private void updateImportsMap(@NotNull OCSymbol symbol) {
                if (symbol == null) {
                    Builder.$$$reportNull$$$0(0);
                }
                if (this.val$importsMap != null && this.val$firstImportLink != null) {
                    this.val$importsMap.put(symbol, this.val$firstImportLink);
                    if (symbol instanceof OCMembersContainer) {
                        ((OCMembersContainer)((Object)symbol)).processMembers(null, symbol1 -> {
                            this.updateImportsMap((OCSymbol)symbol1);
                            return true;
                        });
                    }
                }
            }

            private void updateContext(OCSymbol symbol) {
                if (symbol instanceof OCMacroSymbol) {
                    this.val$context.define((OCMacroSymbol)symbol);
                } else if (symbol instanceof OCUndefMacroSymbol) {
                    this.val$context.undef(symbol.getName());
                } else {
                    OCSymbolKind kind = symbol.getKind();
                    boolean isCPP = this.val$context.getLanguageKind().isCpp();
                    if (isCPP && symbol instanceof OCNamespaceSymbol && !((OCNamespaceSymbol)symbol).isPredefinition()) {
                        OCParsingNameScope inner = this.myNameScope.defineNamespace(symbol.getName());
                        Builder innerProcessor = new Builder(inner);
                        ((OCNamespaceSymbol)symbol).processMembers((String)null, (Processor<OCSymbol>)((Processor)symbol12 -> {
                            innerProcessor.updateContext((OCSymbol)symbol12);
                            return true;
                        }));
                    }
                    if (kind.isType()) {
                        if (kind == OCSymbolKind.PROTOCOL) {
                            this.myNameScope.defineProtocol(symbol.getName());
                        } else if (kind.isClass() || kind == OCSymbolKind.COMPATIBILITY_ALIAS) {
                            this.myNameScope.defineInterface(symbol.getName());
                        } else {
                            boolean isTemplate = isCPP && kind.isStructLike() && ((OCStructSymbol)symbol).isTemplateSymbol();
                            this.myNameScope.defineType(symbol.getName(), isTemplate);
                        }
                    } else if (isCPP) {
                        if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).getQualifiedName().getQualifier() == null) {
                            if (!symbol.getKind().isConstructorOrDestructor() && ((OCFunctionSymbol)symbol).isTemplateSymbol()) {
                                this.myNameScope.defineValue(symbol.getName(), true);
                            }
                        } else if (symbol instanceof OCUsingSymbol) {
                            if (symbol.getKind() == OCSymbolKind.NAMESPACE_USING_SYMBOL) {
                                this.myNameScope.defineNamespaceUsing(((OCUsingSymbol)symbol).getSymbolReference().getQualifiedName().flatten());
                            } else {
                                this.myNameScope.defineSymbolUsing(((OCUsingSymbol)symbol).getSymbolReference().getQualifiedName().flatten());
                            }
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTable$1Builder", "updateImportsMap"));
            }
        }
        return this.processFile(new Builder(context.getNameScope()));
    }

    public boolean isEmpty() {
        return this.myContents.isEmpty();
    }

    public void append(OCSymbol symbol) {
        this.myContents.add(symbol);
    }

    public void appendAll(@NotNull List<OCSymbol> symbols) {
        if (symbols == null) {
            FileSymbolTable.$$$reportNull$$$0(24);
        }
        this.myContents.addAll(symbols);
    }

    public void sortSymbols() {
        FileSymbolTable.sortSymbols(this.myContents);
    }

    private static void sortSymbols(@Nullable List<OCSymbol> symbols) {
        if (symbols != null) {
            symbols.sort(Comparator.comparingLong(OCSymbol::getComplexOffset));
            for (OCSymbol symbol : symbols) {
                if (!(symbol instanceof OCNamespaceSymbol)) continue;
                FileSymbolTable.sortSymbols(((OCNamespaceSymbol)symbol).getMembersList());
            }
        }
    }

    public int incUsageCount() {
        return ++this.myUsingCount;
    }

    public int getUsageCount() {
        return this.myUsingCount;
    }

    public void resetUsageCount() {
        this.myUsingCount = 1;
    }

    public int getPackStamp() {
        return this.myPackStamp;
    }

    public void setPackStamp(int packStamp) {
        this.myPackStamp = packStamp;
    }

    public static void setShouldCompactSymbols(boolean value) {
        ourShouldCompactSymbols = value;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTable";
                break;
            }
            case 8: 
            case 16: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolClass";
                break;
            }
            case 15: 
            case 17: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processedTables";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbols";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignature";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContents";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "reportStats";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "forFile";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findSymbol";
                break;
            }
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processSymbols";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "shallowProcessSymbols";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "appendAll";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

