/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.FastInput;
import com.esotericsoftware.kryo.io.FastOutput;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.DefaultSerializers;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.cidr.lang.CustomHeaderProvider;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCKeywordElementType;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCastKind;
import com.jetbrains.cidr.lang.psi.OCExceptionSpecificationKind;
import com.jetbrains.cidr.lang.psi.impl.OCBlockExpressionImpl;
import com.jetbrains.cidr.lang.symbols.ComplexTextRange;
import com.jetbrains.cidr.lang.symbols.OCDelegatingSymbol;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithDecltype;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.ProjectAndVirtualFileOwner;
import com.jetbrains.cidr.lang.symbols.cpp.OCAliasUsingSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCLabelSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCLocalFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceAliasSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCThisSelfSuperSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterTypeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUndefMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCArrayIndexExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCBinaryExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCCallExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCCastExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCCommaExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCConditionalExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCInitializerListExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLambdaExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLiteralExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCNewExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCNoexceptExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCPostfixExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCPrefixExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCQualifiedExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCReferenceExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCSizeofExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCThrowExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCUnaryExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCUnknownExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCVariadicPackExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCCompatibilityAliasSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCGenericParameterSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCGenericParameterSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCModuleImportSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.ContextSignature;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesPack;
import com.jetbrains.cidr.lang.symbols.symtable.NeverSerializer;
import com.jetbrains.cidr.lang.symbols.symtable.OCJavaSerializer;
import com.jetbrains.cidr.lang.symbols.symtable.OCSerializer;
import com.jetbrains.cidr.lang.symbols.symtable.SerializerProvider;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.CTypeId;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCBracedInitListType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCNullability;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCStructuredBindingType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.util.OCExceptionSpecificationInfo;
import com.jetbrains.cidr.lang.util.OCImmutableList;
import com.jetbrains.cidr.lang.util.OCNumber;
import gnu.trove.TObjectIntHashMap;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSymbolTableSerializer
extends OCSerializer {
    private static final int CHUNK_SIZE = 65536;
    private VirtualFile myCurrentFile;
    private Project myProject;

    public FileSymbolTableSerializer(Project project2) {
        this.myProject = project2;
    }

    @Override
    protected void registerSerializers() {
        Kryo myKryo = this.getKryo();
        myKryo.register(FileSymbolTablesPack.class, (Serializer)new FileSymbolTablesPack.FileSymbolsPackSerializer(myKryo));
        myKryo.register(TObjectIntHashMap.class, (Serializer)new OCJavaSerializer());
        myKryo.register(ContextSignature.class, (Serializer)new FieldSerializer<ContextSignature>(myKryo, ContextSignature.class){

            protected ContextSignature create(Kryo kryo, Input input, Class<ContextSignature> type) {
                return new ContextSignature();
            }
        });
        myKryo.register(FileSymbolTable.class, (Serializer)new ProjectAndFileOwnerSerializer<FileSymbolTable>(FileSymbolTable.class){

            @Override
            public FileSymbolTable createInstance(Kryo kryo, Input input, Class type) {
                return new FileSymbolTable();
            }
        });
        myKryo.register(OCQualifiedName.class, (Serializer)new Serializer<OCQualifiedName>(true){

            public void write(Kryo kryo, Output output, OCQualifiedName object) {
                kryo.writeClassAndObject(output, (Object)object.getQualifier());
                kryo.writeObjectOrNull(output, (Object)object.getName(), String.class);
            }

            public OCQualifiedName read(Kryo kryo, Input input, Class<OCQualifiedName> type) {
                OCQualifiedName qualifier = (OCQualifiedName)kryo.readClassAndObject(input);
                String name2 = (String)kryo.readObjectOrNull(input, String.class);
                return OCQualifiedName.interned(qualifier, name2);
            }
        });
        myKryo.register(OCQualifiedNameWithArguments.class, (Serializer)new FieldSerializer<OCQualifiedNameWithArguments>(myKryo, OCQualifiedNameWithArguments.class){

            protected OCQualifiedNameWithArguments create(Kryo kryo, Input input, Class<OCQualifiedNameWithArguments> type) {
                return new OCQualifiedNameWithArguments();
            }
        });
        myKryo.register(OCQualifiedNameWithDecltype.class, (Serializer)new FieldSerializer<OCQualifiedNameWithDecltype>(myKryo, OCQualifiedNameWithDecltype.class){

            protected OCQualifiedNameWithDecltype create(Kryo kryo, Input input, Class<OCQualifiedNameWithDecltype> type) {
                return new OCQualifiedNameWithDecltype();
            }
        });
        myKryo.register(OCImplementationSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCImplementationSymbol>(OCImplementationSymbol.class){

            @Override
            public OCImplementationSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCImplementationSymbol();
            }
        });
        myKryo.register(OCInterfaceSymbolImpl.class, (Serializer)new ProjectAndFileOwnerSerializer<OCInterfaceSymbolImpl>(OCInterfaceSymbolImpl.class){

            @Override
            public OCInterfaceSymbolImpl createInstance(Kryo kryo, Input input, Class type) {
                return new OCInterfaceSymbolImpl();
            }
        });
        myKryo.register(OCProtocolSymbolImpl.class, (Serializer)new ProjectAndFileOwnerSerializer<OCProtocolSymbolImpl>(OCProtocolSymbolImpl.class){

            @Override
            public OCProtocolSymbolImpl createInstance(Kryo kryo, Input input, Class type) {
                return new OCProtocolSymbolImpl();
            }
        });
        myKryo.register(OCLabelSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCLabelSymbol>(OCLabelSymbol.class){

            @Override
            public OCLabelSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCLabelSymbol();
            }
        });
        myKryo.register(OCMacroParameterSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCMacroParameterSymbol>(OCMacroParameterSymbol.class){

            @Override
            public OCMacroParameterSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCMacroParameterSymbol();
            }
        });
        myKryo.register(OCMacroSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCMacroSymbol>(OCMacroSymbol.class){

            @Override
            public OCMacroSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCMacroSymbol();
            }
        });
        myKryo.register(OCInstanceVariableSymbolImpl.class, (Serializer)new ProjectAndFileOwnerSerializer<OCInstanceVariableSymbolImpl>(OCInstanceVariableSymbolImpl.class){

            @Override
            public OCInstanceVariableSymbolImpl createInstance(Kryo kryo, Input input, Class type) {
                return new OCInstanceVariableSymbolImpl();
            }
        });
        myKryo.register(OCMethodSymbolImpl.class, (Serializer)new ProjectAndFileOwnerSerializer<OCMethodSymbolImpl>(OCMethodSymbolImpl.class){

            @Override
            public OCMethodSymbolImpl createInstance(Kryo kryo, Input input, Class type) {
                return new OCMethodSymbolImpl();
            }
        });
        myKryo.register(OCPropertySymbolImpl.class, (Serializer)new ProjectAndFileOwnerSerializer<OCPropertySymbolImpl>(OCPropertySymbolImpl.class){

            @Override
            public OCPropertySymbolImpl createInstance(Kryo kryo, Input input, Class type) {
                return new OCPropertySymbolImpl();
            }
        });
        myKryo.register(OCSynthesizeSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCSynthesizeSymbol>(OCSynthesizeSymbol.class){

            @Override
            public OCSynthesizeSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCSynthesizeSymbol();
            }
        });
        myKryo.register(OCDeclaratorSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCDeclaratorSymbol>(OCDeclaratorSymbol.class){

            @Override
            public OCDeclaratorSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCDeclaratorSymbol();
            }
        });
        myKryo.register(OCFunctionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCFunctionSymbol>(OCFunctionSymbol.class){

            @Override
            public OCFunctionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCFunctionSymbol();
            }
        });
        myKryo.register(OCLocalFunctionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCLocalFunctionSymbol>(OCLocalFunctionSymbol.class){

            @Override
            public OCLocalFunctionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCLocalFunctionSymbol();
            }
        });
        myKryo.register(OCNamespaceSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCNamespaceSymbol>(OCNamespaceSymbol.class){

            @Override
            public OCNamespaceSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCNamespaceSymbol();
            }
        });
        myKryo.register(OCNamespaceAliasSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCNamespaceAliasSymbol>(OCNamespaceAliasSymbol.class){

            @Override
            public OCNamespaceAliasSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCNamespaceAliasSymbol();
            }
        });
        myKryo.register(OCStructSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCStructSymbol>(OCStructSymbol.class){

            @Override
            public OCStructSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCStructSymbol();
            }
        });
        myKryo.register(OCDelegatingSymbol.class, new Serializer(){

            public void write(Kryo kryo, Output output, Object object) {
                OCSymbol delegate = ((OCDelegatingSymbol)object).getRawDelegate();
                kryo.writeClass(output, delegate.getClass());
                kryo.writeObject(output, delegate);
            }

            public Object read(Kryo kryo, Input input, Class type) {
                Registration registration = kryo.readClass(input);
                return new OCDelegatingSymbol((OCSymbol)kryo.readObject(input, registration.getType()));
            }
        });
        myKryo.register(OCTypeParameterTypeSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCTypeParameterTypeSymbol>(OCTypeParameterTypeSymbol.class){

            @Override
            public OCTypeParameterTypeSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCTypeParameterTypeSymbol();
            }
        });
        myKryo.register(OCTypeParameterValueSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCTypeParameterValueSymbol>(OCTypeParameterValueSymbol.class){

            @Override
            public OCTypeParameterValueSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCTypeParameterValueSymbol();
            }
        });
        myKryo.register(OCBinaryExpressionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCBinaryExpressionSymbol>(OCBinaryExpressionSymbol.class){

            @Override
            public OCBinaryExpressionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCBinaryExpressionSymbol();
            }
        });
        myKryo.register(OCUnaryExpressionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCUnaryExpressionSymbol>(OCUnaryExpressionSymbol.class){

            @Override
            public OCUnaryExpressionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCUnaryExpressionSymbol();
            }
        });
        myKryo.register(OCPrefixExpressionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCPrefixExpressionSymbol>(OCPrefixExpressionSymbol.class){

            @Override
            public OCPrefixExpressionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCPrefixExpressionSymbol();
            }
        });
        myKryo.register(OCPostfixExpressionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCPostfixExpressionSymbol>(OCPostfixExpressionSymbol.class){

            @Override
            public OCPostfixExpressionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCPostfixExpressionSymbol();
            }
        });
        myKryo.register(OCConditionalExpressionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCConditionalExpressionSymbol>(OCConditionalExpressionSymbol.class){

            @Override
            public OCConditionalExpressionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCConditionalExpressionSymbol();
            }
        });
        myKryo.register(OCCallExpressionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCCallExpressionSymbol>(OCCallExpressionSymbol.class){

            @Override
            public OCCallExpressionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCCallExpressionSymbol();
            }
        });
        myKryo.register(OCArrayIndexExpressionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCArrayIndexExpressionSymbol>(OCArrayIndexExpressionSymbol.class){

            @Override
            public OCArrayIndexExpressionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCArrayIndexExpressionSymbol();
            }
        });
        myKryo.register(OCCastExpressionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCCastExpressionSymbol>(OCCastExpressionSymbol.class){

            @Override
            public OCCastExpressionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCCastExpressionSymbol();
            }
        });
        myKryo.register(OCNewExpressionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCNewExpressionSymbol>(OCNewExpressionSymbol.class){

            @Override
            public OCNewExpressionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCNewExpressionSymbol();
            }
        });
        myKryo.register(OCSizeofExpressionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCSizeofExpressionSymbol>(OCSizeofExpressionSymbol.class){

            @Override
            public OCSizeofExpressionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCSizeofExpressionSymbol();
            }
        });
        myKryo.register(OCNoexceptExpressionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCNoexceptExpressionSymbol>(OCNoexceptExpressionSymbol.class){

            @Override
            public OCNoexceptExpressionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCNoexceptExpressionSymbol();
            }
        });
        myKryo.register(OCThrowExpressionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCThrowExpressionSymbol>(OCThrowExpressionSymbol.class){

            @Override
            public OCThrowExpressionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCThrowExpressionSymbol();
            }
        });
        myKryo.register(OCLiteralExpressionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCLiteralExpressionSymbol>(OCLiteralExpressionSymbol.class){

            @Override
            public OCLiteralExpressionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCLiteralExpressionSymbol();
            }
        });
        myKryo.register(OCInitializerListExpressionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCInitializerListExpressionSymbol>(OCInitializerListExpressionSymbol.class){

            @Override
            public OCInitializerListExpressionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCInitializerListExpressionSymbol();
            }
        });
        myKryo.register(OCCommaExpressionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCCommaExpressionSymbol>(OCCommaExpressionSymbol.class){

            @Override
            public OCCommaExpressionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCCommaExpressionSymbol();
            }
        });
        myKryo.register(OCLambdaExpressionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCLambdaExpressionSymbol>(OCLambdaExpressionSymbol.class){

            @Override
            public OCLambdaExpressionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCLambdaExpressionSymbol();
            }
        });
        myKryo.register(OCReferenceExpressionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCReferenceExpressionSymbol>(OCReferenceExpressionSymbol.class){

            @Override
            public OCReferenceExpressionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCReferenceExpressionSymbol();
            }
        });
        myKryo.register(OCQualifiedExpressionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCQualifiedExpressionSymbol>(OCQualifiedExpressionSymbol.class){

            @Override
            public OCQualifiedExpressionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCQualifiedExpressionSymbol();
            }
        });
        myKryo.register(OCUnknownExpressionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCUnknownExpressionSymbol>(OCUnknownExpressionSymbol.class){

            @Override
            public OCUnknownExpressionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCUnknownExpressionSymbol();
            }
        });
        myKryo.register(OCUndefMacroSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCUndefMacroSymbol>(OCUndefMacroSymbol.class){

            @Override
            public OCUndefMacroSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCUndefMacroSymbol();
            }
        });
        myKryo.register(OCUsingSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCUsingSymbol>(OCUsingSymbol.class){

            @Override
            public OCUsingSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCUsingSymbol();
            }
        });
        myKryo.register(OCAliasUsingSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCAliasUsingSymbol>(OCAliasUsingSymbol.class){

            @Override
            public OCAliasUsingSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCAliasUsingSymbol();
            }
        });
        myKryo.register(OCCompatibilityAliasSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCCompatibilityAliasSymbol>(OCCompatibilityAliasSymbol.class){

            @Override
            public OCCompatibilityAliasSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCCompatibilityAliasSymbol();
            }
        });
        myKryo.register(OCBlockExpressionImpl.OCBlockSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCBlockExpressionImpl.OCBlockSymbol>(OCBlockExpressionImpl.OCBlockSymbol.class){

            @Override
            public OCBlockExpressionImpl.OCBlockSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCBlockExpressionImpl.OCBlockSymbol();
            }
        });
        myKryo.register(OCThisSelfSuperSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCThisSelfSuperSymbol>(OCThisSelfSuperSymbol.class){

            @Override
            public OCThisSelfSuperSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCThisSelfSuperSymbol();
            }
        });
        myKryo.register(OCPunctuatorElementType.class, (Serializer)new Serializer<OCPunctuatorElementType>(){

            public void write(Kryo kryo, Output output, OCPunctuatorElementType elementType) {
                output.writeString(elementType.toString());
            }

            public OCPunctuatorElementType read(Kryo kryo, Input input, Class<OCPunctuatorElementType> type) {
                return (OCPunctuatorElementType)OCTokenTypes.ourNameToTokenType.get(input.readString());
            }
        });
        myKryo.register(OCElementType.class, (Serializer)new Serializer<OCElementType>(){

            public void write(Kryo kryo, Output output, OCElementType elementType) {
                output.writeString(elementType.toString());
            }

            public OCElementType read(Kryo kryo, Input input, Class<OCElementType> type) {
                return OCTokenTypes.ourNameToTokenType.get(input.readString());
            }
        });
        myKryo.register(OCKeywordElementType.class, (Serializer)new Serializer<OCKeywordElementType>(){

            public void write(Kryo kryo, Output output, OCKeywordElementType elementType) {
                output.writeString(elementType.toString());
            }

            public OCKeywordElementType read(Kryo kryo, Input input, Class<OCKeywordElementType> type) {
                return (OCKeywordElementType)OCTokenTypes.ourNameToTokenType.get(input.readString());
            }
        });
        myKryo.register(OCMethodSymbolImpl.SelectorPartSymbolImpl.class, (Serializer)new FieldSerializer<OCMethodSymbolImpl.SelectorPartSymbolImpl>(myKryo, OCMethodSymbolImpl.SelectorPartSymbolImpl.class){

            protected OCMethodSymbolImpl.SelectorPartSymbolImpl create(Kryo kryo, Input input, Class<OCMethodSymbolImpl.SelectorPartSymbolImpl> type) {
                return new OCMethodSymbolImpl.SelectorPartSymbolImpl();
            }
        });
        myKryo.register(OCSymbolReference.SymbolFilter.class, (Serializer)new FieldSerializer(myKryo, OCSymbolReference.SymbolFilter.class));
        myKryo.register(OCSymbolReference.TrueSymbolFilter.class, (Serializer)new FieldSerializer<OCSymbolReference.TrueSymbolFilter>(myKryo, OCSymbolReference.TrueSymbolFilter.class){

            protected OCSymbolReference.TrueSymbolFilter create(Kryo kryo, Input input, Class<OCSymbolReference.TrueSymbolFilter> type) {
                return new OCSymbolReference.TrueSymbolFilter();
            }

            public OCSymbolReference.TrueSymbolFilter read(Kryo kryo, Input input, Class<OCSymbolReference.TrueSymbolFilter> type) {
                return OCSymbolReference.SymbolFilter.NONE;
            }
        });
        myKryo.register(OCSymbolReference.SymbolKindFilter.class, (Serializer)new DefaultSerializers.EnumSerializer(OCSymbolReference.SymbolKindFilter.class));
        myKryo.register(OCSymbolReference.GlobalReference.class, (Serializer)new FieldSerializer<OCSymbolReference.GlobalReference>(myKryo, OCSymbolReference.GlobalReference.class){

            protected OCSymbolReference.GlobalReference create(Kryo kryo, Input input, Class<OCSymbolReference.GlobalReference> type) {
                return new OCSymbolReference.GlobalReference();
            }

            public OCSymbolReference.GlobalReference read(Kryo kryo, Input input, Class<OCSymbolReference.GlobalReference> type) {
                OCSymbolReference.GlobalReference object = (OCSymbolReference.GlobalReference)super.read(kryo, input, type);
                FileSymbolTableSerializer.readContextOrFileForGlobalReference(kryo, input, object, FileSymbolTableSerializer.this.myCurrentFile);
                return object;
            }

            public void write(Kryo kryo, Output output, OCSymbolReference.GlobalReference object) {
                super.write(kryo, output, (Object)object);
                FileSymbolTableSerializer.writeContextOrFileForGlobalReference(kryo, output, object);
            }
        });
        myKryo.register(OCSymbolReference.BaseClauseReference.class, (Serializer)new FieldSerializer<OCSymbolReference.BaseClauseReference>(myKryo, OCSymbolReference.BaseClauseReference.class){

            protected OCSymbolReference.BaseClauseReference create(Kryo kryo, Input input, Class<OCSymbolReference.BaseClauseReference> type) {
                return new OCSymbolReference.BaseClauseReference();
            }

            public OCSymbolReference.BaseClauseReference read(Kryo kryo, Input input, Class<OCSymbolReference.BaseClauseReference> type) {
                OCSymbolReference.BaseClauseReference object = (OCSymbolReference.BaseClauseReference)super.read(kryo, input, type);
                FileSymbolTableSerializer.readContextOrFileForGlobalReference(kryo, input, object, FileSymbolTableSerializer.this.myCurrentFile);
                return object;
            }

            public void write(Kryo kryo, Output output, OCSymbolReference.BaseClauseReference object) {
                super.write(kryo, output, (Object)object);
                FileSymbolTableSerializer.writeContextOrFileForGlobalReference(kryo, output, object);
            }
        });
        myKryo.register(OCSymbolReference.TemplateArgumentsReference.class, (Serializer)new FieldSerializer<OCSymbolReference.TemplateArgumentsReference>(myKryo, OCSymbolReference.TemplateArgumentsReference.class){

            protected OCSymbolReference.TemplateArgumentsReference create(Kryo kryo, Input input, Class<OCSymbolReference.TemplateArgumentsReference> type) {
                return new OCSymbolReference.TemplateArgumentsReference();
            }

            public OCSymbolReference.TemplateArgumentsReference read(Kryo kryo, Input input, Class<OCSymbolReference.TemplateArgumentsReference> type) {
                OCSymbolReference.TemplateArgumentsReference object = (OCSymbolReference.TemplateArgumentsReference)super.read(kryo, input, type);
                FileSymbolTableSerializer.readContextOrFileForGlobalReference(kryo, input, object, FileSymbolTableSerializer.this.myCurrentFile);
                return object;
            }

            public void write(Kryo kryo, Output output, OCSymbolReference.TemplateArgumentsReference object) {
                super.write(kryo, output, (Object)object);
                FileSymbolTableSerializer.writeContextOrFileForGlobalReference(kryo, output, object);
            }
        });
        myKryo.register(OCSymbolReference.LambdaLocalReference.class, (Serializer)new FieldSerializer<OCSymbolReference.LambdaLocalReference>(myKryo, OCSymbolReference.LambdaLocalReference.class){

            protected OCSymbolReference.LambdaLocalReference create(Kryo kryo, Input input, Class<OCSymbolReference.LambdaLocalReference> type) {
                return new OCSymbolReference.LambdaLocalReference();
            }
        });
        myKryo.register(OCSymbolReference.LocalReference.class, (Serializer)new NeverSerializer(myKryo, OCSymbolReference.LocalReference.class));
        myKryo.register(PsiElement.class, (Serializer)new NeverSerializer(myKryo, PsiElement.class));
        myKryo.register(OCExpressionTypeArgument.class, (Serializer)new FieldSerializer<OCExpressionTypeArgument>(myKryo, OCExpressionTypeArgument.class){

            protected OCExpressionTypeArgument create(Kryo kryo, Input input, Class<OCExpressionTypeArgument> type) {
                return new OCExpressionTypeArgument();
            }
        });
        myKryo.register(OCCppReferenceType.class, (Serializer)new FieldSerializer<OCCppReferenceType>(myKryo, OCCppReferenceType.class){

            protected OCCppReferenceType create(Kryo kryo, Input input, Class<OCCppReferenceType> type) {
                return new OCCppReferenceType();
            }
        });
        myKryo.register(OCEllipsisType.class, new OCSerializer.SingletonSerializer<OCEllipsisType>(OCEllipsisType.instance()));
        myKryo.register(OCFunctionType.class, (Serializer)new FieldSerializer<OCFunctionType>(myKryo, OCFunctionType.class){

            protected OCFunctionType create(Kryo kryo, Input input, Class<OCFunctionType> type) {
                return new OCFunctionType();
            }
        });
        myKryo.register(OCMagicType.class, (Serializer)new FieldSerializer<OCMagicType>(myKryo, OCMagicType.class){

            protected OCMagicType create(Kryo kryo, Input input, Class<OCMagicType> type) {
                return new OCMagicType();
            }

            public void write(Kryo kryo, Output output, OCMagicType object) {
                FileSymbolTableSerializer.this.LOG.assertTrue(object != OCMagicType.SEVERAL_UNRELATED_STRUCTS, (Object)"Don't serialize SEVERAL_SUBSTITUTIONS");
                super.write(kryo, output, (Object)object);
            }
        });
        myKryo.register(OCUnknownType.class, new OCSerializer.SingletonSerializer<OCUnknownType>(OCUnknownType.INSTANCE));
        myKryo.register(OCBracedInitListType.class, new OCSerializer.SingletonSerializer<OCBracedInitListType>(OCBracedInitListType.INSTANCE));
        myKryo.register(OCIntType.class, (Serializer)new FieldSerializer<OCIntType>(myKryo, OCIntType.class){

            protected OCIntType create(Kryo kryo, Input input, Class<OCIntType> type) {
                return new OCIntType();
            }
        });
        myKryo.register(CTypeId.class, (Serializer)new DefaultSerializers.EnumSerializer(CTypeId.class));
        myKryo.register(OCRealType.class, (Serializer)new FieldSerializer<OCRealType>(myKryo, OCRealType.class){

            protected OCRealType create(Kryo kryo, Input input, Class<OCRealType> type) {
                return new OCRealType();
            }
        });
        myKryo.register(OCObjectType.class, (Serializer)new FieldSerializer<OCObjectType>(myKryo, OCObjectType.class){

            protected OCObjectType create(Kryo kryo, Input input, Class<OCObjectType> type) {
                return new OCObjectType();
            }
        });
        myKryo.register(OCIdType.class, (Serializer)new FieldSerializer<OCIdType>(myKryo, OCIdType.class){

            protected OCIdType create(Kryo kryo, Input input, Class<OCIdType> type) {
                return new OCIdType();
            }
        });
        myKryo.register(OCIdType.IDInterfaceSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCIdType.IDInterfaceSymbol>(OCIdType.IDInterfaceSymbol.class){

            @Override
            public OCIdType.IDInterfaceSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCIdType.IDInterfaceSymbol();
            }
        });
        myKryo.register(OCPointerType.class, (Serializer)new FieldSerializer<OCPointerType>(myKryo, OCPointerType.class){

            protected OCPointerType create(Kryo kryo, Input input, Class<OCPointerType> type) {
                return new OCPointerType();
            }
        });
        myKryo.register(OCPointerType.LengthOrNull.class, (Serializer)new FieldSerializer<OCPointerType.LengthOrNull>(myKryo, OCPointerType.LengthOrNull.class){

            protected OCPointerType.LengthOrNull create(Kryo kryo, Input input, Class<OCPointerType.LengthOrNull> type) {
                return new OCPointerType.LengthOrNull(null);
            }
        });
        myKryo.register(OCBlockPointerType.class, (Serializer)new FieldSerializer<OCBlockPointerType>(myKryo, OCBlockPointerType.class){

            protected OCBlockPointerType create(Kryo kryo, Input input, Class<OCBlockPointerType> type) {
                return new OCBlockPointerType();
            }
        });
        myKryo.register(OCReferenceType.class, (Serializer)new FieldSerializer<OCReferenceType>(myKryo, OCReferenceType.class){

            protected OCReferenceType create(Kryo kryo, Input input, Class<OCReferenceType> type) {
                return new OCReferenceType();
            }
        });
        myKryo.register(OCStructType.class, (Serializer)new FieldSerializer<OCStructType>(myKryo, OCStructType.class){

            protected OCStructType create(Kryo kryo, Input input, Class<OCStructType> type) {
                return new OCStructType();
            }
        });
        myKryo.register(OCVoidType.class, (Serializer)new Serializer<OCVoidType>(){

            public void write(Kryo kryo, Output output, OCVoidType object) {
                output.writeBoolean(object.isConst());
                output.writeBoolean(object.isVolatile());
            }

            public OCVoidType read(Kryo kryo, Input input, Class<OCVoidType> type) {
                return OCVoidType.instance(input.readBoolean(), input.readBoolean());
            }
        });
        myKryo.register(OCAutoType.class, (Serializer)new FieldSerializer<OCAutoType>(myKryo, OCAutoType.class){

            public OCAutoType create(Kryo kryo, Input input, Class<OCAutoType> type) {
                return new OCAutoType();
            }
        });
        myKryo.register(OCStructuredBindingType.class, (Serializer)new FieldSerializer<OCStructuredBindingType>(myKryo, OCStructuredBindingType.class){

            public OCStructuredBindingType create(Kryo kryo, Input input, Class<OCStructuredBindingType> type) {
                return new OCStructuredBindingType();
            }
        });
        myKryo.register(OCArrayType.class, (Serializer)new FieldSerializer<OCArrayType>(myKryo, OCArrayType.class){

            protected OCArrayType create(Kryo kryo, Input input, Class<OCArrayType> type) {
                return new OCArrayType();
            }
        });
        myKryo.register(OCExpansionPackType.class, (Serializer)new FieldSerializer<OCExpansionPackType>(myKryo, OCExpansionPackType.class){

            protected OCExpansionPackType create(Kryo kryo, Input input, Class<OCExpansionPackType> type) {
                return new OCExpansionPackType();
            }
        });
        myKryo.register(OCVariadicType.class, (Serializer)new FieldSerializer<OCVariadicType>(myKryo, OCVariadicType.class){

            protected OCVariadicType create(Kryo kryo, Input input, Class<OCVariadicType> type) {
                return new OCVariadicType();
            }
        });
        myKryo.register(OCVariadicPackExpressionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCVariadicPackExpressionSymbol>(OCVariadicPackExpressionSymbol.class){

            @Override
            public OCVariadicPackExpressionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCVariadicPackExpressionSymbol();
            }
        });
        myKryo.register(OCSimpleTypeSubstitution.class, (Serializer)new FieldSerializer<OCSimpleTypeSubstitution>(myKryo, OCSimpleTypeSubstitution.class){

            protected OCSimpleTypeSubstitution create(Kryo kryo, Input input, Class<OCSimpleTypeSubstitution> type) {
                return new OCSimpleTypeSubstitution();
            }

            public OCSimpleTypeSubstitution read(Kryo kryo, Input input, Class<OCSimpleTypeSubstitution> type) {
                boolean isId = input.readBoolean();
                if (isId) {
                    return OCTypeSubstitution.ID;
                }
                return (OCSimpleTypeSubstitution)super.read(kryo, input, type);
            }

            public void write(Kryo kryo, Output output, OCSimpleTypeSubstitution object) {
                boolean isId = object == OCTypeSubstitution.ID;
                output.writeBoolean(isId);
                if (!isId) {
                    super.write(kryo, output, (Object)object);
                }
            }
        });
        myKryo.register(ARCAttribute.class, (Serializer)new DefaultSerializers.EnumSerializer(ARCAttribute.class));
        myKryo.register(OCSymbolKind.class, (Serializer)new DefaultSerializers.EnumSerializer(OCSymbolKind.class));
        myKryo.register(OCCastKind.class, (Serializer)new DefaultSerializers.EnumSerializer(OCCastKind.class));
        myKryo.register(OCExceptionSpecificationKind.class, (Serializer)new DefaultSerializers.EnumSerializer(OCExceptionSpecificationKind.class));
        myKryo.register(OCNullability.class, (Serializer)new DefaultSerializers.EnumSerializer(OCNullability.class));
        myKryo.register(OCModuleImportSymbol.class, (Serializer)new FieldSerializer<OCModuleImportSymbol>(myKryo, OCModuleImportSymbol.class){

            protected OCModuleImportSymbol create(Kryo kryo, Input input, Class<OCModuleImportSymbol> type) {
                return new OCModuleImportSymbol();
            }
        });
        myKryo.register(OCExceptionSpecificationInfo.class, (Serializer)new FieldSerializer(myKryo, OCExceptionSpecificationInfo.class){

            protected Object create(Kryo kryo, Input input, Class type) {
                return new OCExceptionSpecificationInfo();
            }
        });
        myKryo.register(OCIncludeSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCIncludeSymbol>(OCIncludeSymbol.class){

            @Override
            public OCIncludeSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCIncludeSymbol();
            }

            @Override
            public void write(Kryo kryo, Output output, OCIncludeSymbol object) {
                String path;
                int id;
                super.write(kryo, output, object);
                VirtualFile targetFile = object.getTargetFile();
                if (targetFile != null && targetFile.isValid()) {
                    if (targetFile instanceof VirtualFileWithId) {
                        id = ((VirtualFileWithId)targetFile).getId();
                        path = targetFile.getPath();
                    } else {
                        id = -1;
                        path = CustomHeaderProvider.provideSerializationPathForFile(targetFile);
                        if (path == null) {
                            FileSymbolTableSerializer.this.LOG.error("only LocalVirtualFiles are supported: " + targetFile.getClass() + ": " + targetFile);
                        }
                    }
                } else {
                    id = -1;
                    path = null;
                }
                output.writeInt(id, true);
                output.writeString(path);
            }

            public OCIncludeSymbol read(Kryo kryo, Input input, Class<OCIncludeSymbol> type) {
                OCIncludeSymbol include = (OCIncludeSymbol)super.read(kryo, input, type);
                int fileId = input.readInt(true);
                String path = input.readString();
                VirtualFile targetFile = null;
                if (fileId != -1) {
                    targetFile = PersistentFS.getInstance().findFileById(fileId);
                }
                if (!(path == null || targetFile != null && FileUtil.pathsEqual((String)path, (String)targetFile.getPath()) || (targetFile = LocalFileSystem.getInstance().findFileByPath(path)) != null)) {
                    targetFile = CustomHeaderProvider.getCustomHeaderFile(path, FileSymbolTableSerializer.this.myProject, FileSymbolTableSerializer.this.myCurrentFile);
                }
                include.updateTargetFile(targetFile);
                return include;
            }
        });
        myKryo.register(OCIncludeSymbol.IncludePath.class, (Serializer)new FieldSerializer<OCIncludeSymbol.IncludePath>(myKryo, OCIncludeSymbol.IncludePath.class){

            protected OCIncludeSymbol.IncludePath create(Kryo kryo, Input input, Class<OCIncludeSymbol.IncludePath> type) {
                return new OCIncludeSymbol.IncludePath();
            }
        });
        myKryo.register(OCIncludeSymbol.IncludePath.EMPTY.getClass(), new OCSerializer.SingletonSerializer<OCIncludeSymbol.IncludePath>(OCIncludeSymbol.IncludePath.EMPTY));
        myKryo.register(EnumMap.class, (Serializer)new OCJavaSerializer());
        myKryo.register(OCPropertySymbol.PropertyAttribute.class, (Serializer)new DefaultSerializers.EnumSerializer(OCPropertySymbol.PropertyAttribute.class));
        myKryo.register(OCVisibility.class, (Serializer)new DefaultSerializers.EnumSerializer(OCVisibility.class));
        myKryo.register(Pair.class, (Serializer)new FieldSerializer<Pair>(myKryo, Pair.class){

            protected Pair create(Kryo kryo, Input input, Class<Pair> type) {
                return new Pair(null, null);
            }
        });
        myKryo.register(MostlySingularMultiMap.class, (Serializer)new FieldSerializer<MostlySingularMultiMap>(myKryo, MostlySingularMultiMap.class){

            protected MostlySingularMultiMap create(Kryo kryo, Input input, Class<MostlySingularMultiMap> type) {
                return new MostlySingularMultiMap();
            }
        });
        myKryo.register(ComplexTextRange.class, (Serializer)new Serializer<ComplexTextRange>(){

            public void write(Kryo kryo, Output output, ComplexTextRange object) {
                output.writeLong(object.getStartOffset(), true);
                output.writeLong(object.getEndOffset(), true);
            }

            public ComplexTextRange read(Kryo kryo, Input input, Class<ComplexTextRange> type) {
                long startOffset = input.readLong(true);
                long endOffset = input.readLong(true);
                return new ComplexTextRange(startOffset, endOffset);
            }
        });
        myKryo.register(OCNumber.class, (Serializer)new Serializer<OCNumber>(){

            public void write(Kryo kryo, Output output, OCNumber object) {
                output.writeByte(object.getSizeInBytes());
                output.writeBoolean(object.isSigned());
                byte[] bytes = object.toByteArray();
                output.writeByte(bytes.length);
                if (bytes.length > 0) {
                    output.write(bytes);
                }
            }

            public OCNumber read(Kryo kryo, Input input, Class<OCNumber> type) {
                byte sizeInBytes = input.readByte();
                boolean isSigned = input.readBoolean();
                byte length = input.readByte();
                byte[] bytes = new byte[length];
                input.readBytes(bytes);
                return new OCNumber(bytes, (int)sizeInBytes, isSigned);
            }
        });
        myKryo.register(FileSymbolTablesCache.MetaData.class, (Serializer)new FieldSerializer<FileSymbolTablesCache.MetaData>(myKryo, FileSymbolTablesCache.MetaData.class){

            protected FileSymbolTablesCache.MetaData create(Kryo kryo, Input input, Class<FileSymbolTablesCache.MetaData> type) {
                return new FileSymbolTablesCache.MetaData();
            }
        });
        myKryo.register(OCGenericParameterSymbol.Covariance.class, (Serializer)new DefaultSerializers.EnumSerializer(OCGenericParameterSymbol.Covariance.class));
        myKryo.register(OCGenericParameterSymbolImpl.class, (Serializer)new ProjectAndFileOwnerSerializer<OCGenericParameterSymbolImpl>(OCGenericParameterSymbolImpl.class){

            @Override
            public OCGenericParameterSymbolImpl createInstance(Kryo kryo, Input input, Class type) {
                return new OCGenericParameterSymbolImpl();
            }
        });
        myKryo.register(OCImmutableList.class, (Serializer)new FieldSerializer<OCImmutableList>(myKryo, OCImmutableList.class){

            public void write(Kryo kryo, Output output, OCImmutableList l) {
                boolean hasElements = l.size() > 0;
                output.writeBoolean(hasElements);
                if (hasElements) {
                    super.write(kryo, output, (Object)l);
                }
            }

            public OCImmutableList read(Kryo kryo, Input input, Class<OCImmutableList> type) {
                boolean hasElements = input.readBoolean();
                return hasElements ? (OCImmutableList)((Object)super.read(kryo, input, type)) : OCImmutableList.emptyList();
            }

            protected OCImmutableList create(Kryo kryo, Input input, Class<OCImmutableList> type) {
                return new OCImmutableList(Collections.emptyList());
            }
        });
        this.registerCustomSerializers();
    }

    private static void writeContextOrFileForGlobalReference(Kryo kryo, Output output, OCSymbolReference.GlobalReference object) {
        Object fileOrContext = object.getVirtualFileOrSymbolContext();
        boolean storesVirtualFile = fileOrContext instanceof VirtualFile;
        output.writeBoolean(storesVirtualFile);
        if (!storesVirtualFile) {
            kryo.writeClassAndObject(output, fileOrContext);
        }
    }

    private static void readContextOrFileForGlobalReference(Kryo kryo, Input input, OCSymbolReference.GlobalReference object, VirtualFile file) {
        boolean storesVirtualFile = input.readBoolean();
        if (storesVirtualFile) {
            object.setVirtualFileOrSymbolContext(file);
        } else {
            Object symbol = kryo.readClassAndObject(input);
            if (symbol != null) {
                OCLog.LOG.assertTrue(symbol instanceof OCSymbolWithQualifiedName, (Object)("Wrong symbol in reference: " + symbol.getClass()));
            }
            object.setVirtualFileOrSymbolContext(symbol);
        }
    }

    private void registerCustomSerializers() {
        for (SerializerProvider provider2 : (SerializerProvider[])SerializerProvider.EP_NAME.getExtensions()) {
            provider2.registerSerializers(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public FileSymbolTablesPack readSymbolTables(@NotNull DataInputStream dis, @NotNull VirtualFile file) {
        if (dis == null) {
            FileSymbolTableSerializer.$$$reportNull$$$0(0);
        }
        if (file == null) {
            FileSymbolTableSerializer.$$$reportNull$$$0(1);
        }
        this.myCurrentFile = file;
        FastInput input = new FastInput((InputStream)dis, 65536);
        try {
            FileSymbolTablesPack fileSymbolTablesPack = (FileSymbolTablesPack)this.getKryo().readObject((Input)input, FileSymbolTablesPack.class);
            return fileSymbolTablesPack;
        }
        catch (Exception e) {
            this.LOG.error((Throwable)e);
            FileSymbolTablesPack fileSymbolTablesPack = null;
            return fileSymbolTablesPack;
        }
        finally {
            StreamUtil.closeStream((Closeable)input);
        }
    }

    public void writeSymbolTables(@NotNull DataOutputStream dos, @NotNull FileSymbolTablesPack pack) {
        if (dos == null) {
            FileSymbolTableSerializer.$$$reportNull$$$0(2);
        }
        if (pack == null) {
            FileSymbolTableSerializer.$$$reportNull$$$0(3);
        }
        this.writeObject(dos, pack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(DataOutputStream dos, Object object) {
        FastOutput output = new FastOutput((OutputStream)dos, 65536);
        try {
            this.getKryo().writeObject((Output)output, object);
            output.flush();
        }
        catch (Exception e) {
            this.LOG.error((Throwable)e);
        }
        finally {
            StreamUtil.closeStream((Closeable)output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public FileSymbolTablesCache.MetaData readMetaData(@NotNull DataInputStream dis) {
        if (dis == null) {
            FileSymbolTableSerializer.$$$reportNull$$$0(4);
        }
        FastInput input = new FastInput((InputStream)dis, 65536);
        try {
            FileSymbolTablesCache.MetaData metaData = (FileSymbolTablesCache.MetaData)this.getKryo().readObject((Input)input, FileSymbolTablesCache.MetaData.class);
            return metaData;
        }
        catch (Exception e) {
            this.LOG.error((Throwable)e);
            FileSymbolTablesCache.MetaData metaData = null;
            return metaData;
        }
        finally {
            StreamUtil.closeStream((Closeable)input);
        }
    }

    public void writeMetaData(@NotNull DataOutputStream dos, @NotNull FileSymbolTablesCache.MetaData metaData) {
        if (dos == null) {
            FileSymbolTableSerializer.$$$reportNull$$$0(5);
        }
        if (metaData == null) {
            FileSymbolTableSerializer.$$$reportNull$$$0(6);
        }
        this.writeObject(dos, metaData);
    }

    public static Map<String, OCElementType> getNameToElementTypeMap(TokenSet tokenSet) {
        HashMap<String, OCElementType> result = new HashMap<String, OCElementType>();
        for (IElementType type : tokenSet.getTypes()) {
            result.put(type.toString(), (OCElementType)type);
        }
        assert (result.size() == tokenSet.getTypes().length);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dis";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dos";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pack";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTableSerializer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "readSymbolTables";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "writeSymbolTables";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "readMetaData";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "writeMetaData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public abstract class ProjectAndFileOwnerSerializer<T extends ProjectAndVirtualFileOwner>
    extends FieldSerializer<T> {
        public ProjectAndFileOwnerSerializer(Class<T> symbolClass) {
            super(FileSymbolTableSerializer.this.getKryo(), symbolClass);
        }

        public void write(Kryo kryo, Output output, T object) {
            output.writeBoolean(object.getProject() != null);
            output.writeBoolean(object.getContainingFile() != null);
            super.write(kryo, output, object);
        }

        public final T create(Kryo kryo, Input input, Class type) {
            boolean hasProject = input.readBoolean();
            boolean hasFile = input.readBoolean();
            T result = this.createInstance(kryo, input, type);
            result.init(hasProject ? FileSymbolTableSerializer.this.myProject : null, hasFile ? FileSymbolTableSerializer.this.myCurrentFile : null);
            return result;
        }

        public abstract T createInstance(Kryo var1, Input var2, Class var3);
    }
}

