/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolTablesBuildingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.SymbolTableProvider;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackers;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileSymbolTableUpdater {
    private final Object myLock = new Object();
    private final Project myProject;
    private final UpdateQueue myRootQueue = new UpdateQueue();
    private final UpdateQueue myIncludeQueue = new UpdateQueue();
    private final AtomicBoolean myHugeUpdateRequested = new AtomicBoolean();
    private final ThreadLocal<UpdateQueue> myParentQueue = new ThreadLocal();
    private final CachedValue<Boolean> myQueueUpdater;

    public FileSymbolTableUpdater(Project project2) {
        this.myProject = project2;
        OCWorkspaceModificationTrackers trackers = OCWorkspaceModificationTrackers.getInstance(project2);
        this.myQueueUpdater = CachedValuesManager.getManager((Project)project2).createCachedValue(() -> new CachedValueProvider.Result((Object)this.rebuildQueues(), new Object[]{trackers.getProjectFilesListTracker(), trackers.getSourceFilesListTracker(), trackers.getBuildSettingsChangesTracker()}), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensurePendingFilesProcessed(@Nullable ProgressIndicator indicator, boolean ensureOnlySourceFilesProcessed) {
        UpdateQueue parentQueue = this.myParentQueue.get();
        if (parentQueue == this.myRootQueue) {
            throw new IllegalStateException("Nested updates are not allowed for root files.");
        }
        if (parentQueue != null && !ensureOnlySourceFilesProcessed) {
            throw new IllegalStateException("Nested update may not process included files.");
        }
        if (indicator != null) {
            indicator.checkCanceled();
        }
        boolean isDispatchThread = ApplicationManager.getApplication().isDispatchThread();
        while (true) {
            VirtualFile file = null;
            UpdateQueue queue = null;
            Object object = this.myLock;
            synchronized (object) {
                while (file == null) {
                    if (indicator != null) {
                        indicator.checkCanceled();
                    }
                    this.myQueueUpdater.getValue();
                    if (isDispatchThread && ensureOnlySourceFilesProcessed && this.tryHugeUpdate()) {
                        return;
                    }
                    if (!(this.myRootQueue.hasUnprocessedFiles() || !ensureOnlySourceFilesProcessed && this.myIncludeQueue.hasUnprocessedFiles())) {
                        return;
                    }
                    file = this.myRootQueue.startProcessingNext();
                    queue = this.myRootQueue;
                    if (file == null && !ensureOnlySourceFilesProcessed) {
                        file = this.myIncludeQueue.startProcessingNext();
                        queue = this.myIncludeQueue;
                    }
                    if (file != null) continue;
                    try {
                        this.myLock.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            boolean ok = false;
            this.myParentQueue.set(queue);
            try {
                if (indicator != null) {
                    indicator.checkCanceled();
                }
                if (queue == this.myRootQueue) {
                    FileSymbolTableUpdater.updateRoot(file, this.myProject, indicator);
                } else {
                    FileSymbolTableUpdater.updateInclude(file, this.myProject);
                }
                ok = true;
                continue;
            }
            finally {
                this.myParentQueue.set(parentQueue);
                Object object2 = this.myLock;
                synchronized (object2) {
                    queue.finishProcessing(file, ok);
                    this.myLock.notifyAll();
                }
                continue;
            }
            break;
        }
    }

    private boolean rebuildQueues() {
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(this.myRootQueue.size() + this.myIncludeQueue.size());
        files.addAll(this.myRootQueue.removeAllFilesToUpdate());
        files.addAll(this.myIncludeQueue.removeAllFilesToUpdate());
        for (VirtualFile file : files) {
            this.addFileInner(file);
        }
        return true;
    }

    private static void updateInclude(VirtualFile file, Project project2) {
        PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(file);
        FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(project2);
        if (SymbolTableProvider.isSourceFile(psiFile) && cache.allTablesForFileCount(file) == 0) {
            cache.forFile(psiFile, OCInclusionContextUtil.calculateHeaderContext(psiFile, null));
        }
    }

    private static void updateRoot(VirtualFile file, Project project2, ProgressIndicator indicator) {
        for (OCResolveConfiguration config : OCInclusionContextUtil.getAllBuildConfigurationsForIndexing(file, project2)) {
            OCImportGraph.buildSymbolAndRootHeaderCache(config, file, null, indicator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileForUpdate(@NotNull VirtualFile file) {
        if (file == null) {
            FileSymbolTableUpdater.$$$reportNull$$$0(0);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.addFileInner(file);
            this.myLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilesForUpdate(Collection<VirtualFile> files, boolean clearCaches) {
        Object object = this.myLock;
        synchronized (object) {
            if (clearCaches) {
                FileSymbolTablesCache.getInstance(this.myProject).removeFilesFromCache(files);
            }
            for (VirtualFile file : files) {
                this.addFileInner(file);
            }
            this.myLock.notifyAll();
        }
    }

    private void addFileInner(@NotNull VirtualFile file) {
        if (file == null) {
            FileSymbolTableUpdater.$$$reportNull$$$0(1);
        }
        if (!file.isValid()) {
            return;
        }
        if (this.isInclude(file)) {
            this.myIncludeQueue.add(file);
        } else {
            this.myRootQueue.add(file);
        }
    }

    private boolean isInclude(@NotNull VirtualFile file) {
        if (file == null) {
            FileSymbolTableUpdater.$$$reportNull$$$0(2);
        }
        return OCInclusionContextUtil.isNeedToFindRoot(file, this.myProject);
    }

    private boolean tryHugeUpdate() {
        int fileScore = this.myRootQueue.filesToUpdateSize();
        if (fileScore < 20) {
            return false;
        }
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(this.myRootQueue.removeAllFilesToUpdate());
        this.myHugeUpdateRequested.set(false);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (this.myHugeUpdateRequested.getAndSet(true)) {
                return;
            }
            OCSymbolTablesBuildingActivity.getInstance(this.myProject).buildSymbolsForFiles(files);
        }, ModalityState.NON_MODAL);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "file";
        objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTableUpdater";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addFileForUpdate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addFileInner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isInclude";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class UpdateQueue {
        private final Set<VirtualFile> myFilesToUpdate = new THashSet();
        private int myFilesInProgressCount;

        private UpdateQueue() {
        }

        public void add(VirtualFile file) {
            this.myFilesToUpdate.add(file);
        }

        public VirtualFile startProcessingNext() {
            Iterator<VirtualFile> it = this.myFilesToUpdate.iterator();
            while (it.hasNext()) {
                VirtualFile file = it.next();
                it.remove();
                if (!file.isValid()) continue;
                ++this.myFilesInProgressCount;
                return file;
            }
            return null;
        }

        public boolean hasUnprocessedFiles() {
            return this.myFilesToUpdate.size() > 0 || this.myFilesInProgressCount > 0;
        }

        public void finishProcessing(VirtualFile file, boolean isProcessed) {
            --this.myFilesInProgressCount;
            if (!isProcessed) {
                this.myFilesToUpdate.add(file);
            }
        }

        public int filesToUpdateSize() {
            return this.myFilesToUpdate.size();
        }

        public Collection<VirtualFile> removeAllFilesToUpdate() {
            ArrayList<VirtualFile> result = new ArrayList<VirtualFile>(this.myFilesToUpdate.size());
            Iterator<VirtualFile> it = this.myFilesToUpdate.iterator();
            while (it.hasNext()) {
                VirtualFile file = it.next();
                if (file.isValid()) {
                    result.add(file);
                }
                it.remove();
            }
            return result;
        }

        public int size() {
            return this.myFilesToUpdate.size();
        }
    }
}

