/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Consumer;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.Function;
import com.intellij.util.PlatformUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.lang.CompoundRuntimeException;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCLocalBlock;
import com.jetbrains.cidr.lang.psi.impl.OCEagerBlockStatementImpl;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCModuleImportSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTableSerializer;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTableUpdater;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesPack;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolTablesBuildingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.SerializerProvider;
import com.jetbrains.cidr.lang.symbols.symtable.SymbolTableProvider;
import com.jetbrains.cidr.lang.ui.OCResolveContextPanel;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationListener;
import com.jetbrains.cidr.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.modulemap.resolve.ModuleMapResolveService;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapModuleSymbol;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileTime;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSymbolTablesCache
extends AbstractProjectComponent {
    private static final Logger LOG = Logger.getInstance((String)"com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache");
    private static final boolean INVALIDATE_WITH_PSI_ONLY = PlatformUtils.isCLion() || Registry.is((String)"cidr.indexer.invalidateUsingPsi", (boolean)false);
    private static final int SERIALIZATION_INDEX_VERSION = 159;
    private static Boolean ourShouldBuildCachesInTests = null;
    private static Boolean ourDoNotReloadExistingSymbolsInTests = null;
    private static Boolean ourForceSymbolsLoadedInTests = null;
    private static final Map<String, FileAttribute> ourFileCacheAttributes = new HashMap<String, FileAttribute>();
    private static final FileAttribute ourFileTablesMetaAttribute = new FileAttribute("objc_file_symbol_tables_meta_attribute", FileSymbolTablesCache.getVersion(), false);
    private static final String TABLES_KEY_PREFIX = "objc_file_symbol_tables_attribute";
    private final ConcurrentMap<VirtualFile, FileSymbolTablesPack> myCache = ContainerUtil.newConcurrentMap();
    private FileSymbolTableUpdater myTableUpdater;
    private final Set<VirtualFile> myPendingReparses = new THashSet();
    private final Set<VirtualFile> myPendingPSIResets = new THashSet();
    private static final int PARALLEL_SERIALIZERS = Runtime.getRuntime().availableProcessors();
    private final FileSymbolTableSerializer[] mySerializers;
    private final SimpleModificationTracker myOutOfBlockModificationTracker;
    private final SimpleModificationTracker myOCOutOfBlockModificationTracker = new SimpleModificationTracker();
    private final AtomicBoolean mySymbolsLoaded = new AtomicBoolean(false);
    private final Object myFileAndContextDependencyLock = new Object();
    private final Map<Thread, VirtualFile> myContextToAwaitingFile = new THashMap();
    private final Map<VirtualFile, Thread> myFileToProcessingContext = new THashMap();

    private static int getVersion() {
        int result = 159;
        for (SerializerProvider provider2 : (SerializerProvider[])SerializerProvider.EP_NAME.getExtensions()) {
            result *= 10;
            result += provider2.getClass().getName().hashCode();
            result += provider2.getVersion();
        }
        return result;
    }

    @NotNull
    public static FileSymbolTablesCache getInstance(@NotNull Project project2) {
        if (project2 == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(0);
        }
        FileSymbolTablesCache fileSymbolTablesCache = (FileSymbolTablesCache)((Object)project2.getComponent(FileSymbolTablesCache.class));
        if (fileSymbolTablesCache == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(1);
        }
        return fileSymbolTablesCache;
    }

    public FileSymbolTablesCache(Project project2, MessageBus bus, PsiManager psiManager) {
        super(project2);
        this.myTableUpdater = new FileSymbolTableUpdater(project2);
        this.mySerializers = new FileSymbolTableSerializer[PARALLEL_SERIALIZERS];
        for (int i = 0; i < PARALLEL_SERIALIZERS; ++i) {
            this.mySerializers[i] = new FileSymbolTableSerializer(project2);
        }
        final PsiModificationTrackerImpl psiTracker = (PsiModificationTrackerImpl)psiManager.getModificationTracker();
        this.myOutOfBlockModificationTracker = new SimpleModificationTracker(){

            public void incModificationCount() {
                super.incModificationCount();
                psiTracker.incOutOfCodeBlockModificationCounter();
            }
        };
        if (psiManager instanceof PsiManagerImpl) {
            ((PsiManagerImpl)psiManager).addTreeChangePreprocessor((PsiTreeChangePreprocessor)new OCCodeBlockModificationListener());
        }
        MessageBusConnection connection = bus.connect();
        connection.subscribe(OCWorkspaceModificationListener.TOPIC, (Object)new OCWorkspaceModificationListener(){

            @Override
            public void buildSettingsChanged() {
                OCSymbolTablesBuildingActivity.getInstance(FileSymbolTablesCache.this.myProject).rebuildSymbols();
            }

            @Override
            public void projectFilesChanged() {
                OCInclusionContextUtil.invalidateHeaderRootAndActiveConfigurationForAllExcept(null, FileSymbolTablesCache.this.myProject);
            }

            @Override
            public void sourceFilesChanged() {
                OCInclusionContextUtil.invalidateHeaderRootAndActiveConfigurationForAllExcept(null, FileSymbolTablesCache.this.myProject);
            }

            @Override
            public void selectedResolveConfigurationChanged() {
                OCInclusionContextUtil.invalidateHeaderRootAndActiveConfigurationForAllExcept(null, FileSymbolTablesCache.this.myProject);
                FileSymbolTablesCache.this.scheduleReparseCachedPsiFiles();
            }
        });
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){
            int stack = 0;
            HashSet<String> dirtyNames;

            public void before(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (this.stack++ == 0) {
                    this.dirtyNames = new HashSet();
                }
                for (VFileEvent vFileEvent : events) {
                    String prop;
                    if (!(vFileEvent instanceof VFilePropertyChangeEvent) || !"name".equals(prop = ((VFilePropertyChangeEvent)vFileEvent).getPropertyName()) && !"symlink".equals(prop)) continue;
                    this.invalidateRecursively(vFileEvent.getFile());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    3.$$$reportNull$$$0(1);
                }
                try {
                    for (VFileEvent vFileEvent : events) {
                        if (vFileEvent instanceof VFilePropertyChangeEvent) {
                            String prop = ((VFilePropertyChangeEvent)vFileEvent).getPropertyName();
                            if (!"name".equals(prop) && !"symlink".equals(prop)) continue;
                            this.invalidateRecursively(vFileEvent.getFile());
                            continue;
                        }
                        if (vFileEvent instanceof VFileCopyEvent) {
                            this.invalidateRecursively(((VFileCopyEvent)vFileEvent).getNewParent().findChild(((VFileCopyEvent)vFileEvent).getNewChildName()));
                            continue;
                        }
                        this.invalidateRecursively(vFileEvent.getFile());
                    }
                }
                finally {
                    if (--this.stack == 0) {
                        HashSet<String> toInvalidate = this.dirtyNames;
                        this.dirtyNames = null;
                        if (!toInvalidate.isEmpty()) {
                            FileSymbolTablesCache.this.invalidateDirtyIncludes(toInvalidate);
                            FileSymbolTablesCache.this.myOutOfBlockModificationTracker.incModificationCount();
                        }
                    }
                }
            }

            private void invalidateRecursively(@Nullable VirtualFile file) {
                if (file == null) {
                    return;
                }
                if (file.isDirectory()) {
                    for (VirtualFile child : ((NewVirtualFile)file).getCachedChildren()) {
                        this.invalidateRecursively(child);
                    }
                } else if (file.getFileType() == OCFileType.INSTANCE) {
                    if (FileSymbolTablesCache.this.clearCache(file)) {
                        FileSymbolTablesCache.this.addFileToCache(file);
                    }
                    this.dirtyNames.add(file.getName());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "events";
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesCache$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "before";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "after";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            StartupManager.getInstance((Project)project2).registerPostStartupActivity(() -> OCSymbolTablesBuildingActivity.getInstance(project2).rebuildSymbols());
        }
    }

    @NotNull
    public SimpleModificationTracker getOutOfBlockModificationTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myOutOfBlockModificationTracker;
        if (simpleModificationTracker == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(2);
        }
        return simpleModificationTracker;
    }

    @NotNull
    public ModificationTracker getOCOutOfBlockModificationTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myOCOutOfBlockModificationTracker;
        if (simpleModificationTracker == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(3);
        }
        return simpleModificationTracker;
    }

    public void incOCOutOfCodeBlockTracker() {
        this.myOCOutOfBlockModificationTracker.incModificationCount();
    }

    public void projectOpened() {
        StatusBar statusbar = WindowManager.getInstance().getStatusBar(this.myProject);
        if (statusbar != null) {
            statusbar.addWidget((StatusBarWidget)new OCResolveContextPanel(this.myProject), "before ReadOnlyAttribute", (Disposable)this.myProject);
        }
    }

    public boolean shouldBuildTables() {
        return ourShouldBuildCachesInTests != Boolean.FALSE;
    }

    @NotNull
    public static Couple<Boolean> setShouldBuildTablesInTests(@Nullable Boolean build, @Nullable Boolean doNotReloadExistingSymbols) {
        Couple prev = Couple.of((Object)ourShouldBuildCachesInTests, (Object)ourDoNotReloadExistingSymbolsInTests);
        ourShouldBuildCachesInTests = build;
        ourDoNotReloadExistingSymbolsInTests = doNotReloadExistingSymbols;
        Couple couple = prev;
        if (couple == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(4);
        }
        return couple;
    }

    public void invalidateDirtyIncludes(Set<String> dirtyNames) {
        this.invalidateDirtyIncludes(dirtyNames, false);
    }

    public void invalidateDirtyIncludes(Set<String> dirtyNames, boolean isRelativePath) {
        ModuleMapManager moduleMapManager = ModuleMapManager.getInstance(this.getProject());
        ModuleMapResolveService moduleMapResolveService = ModuleMapResolveService.getInstance(this.getProject());
        THashSet pendingInvalidation = ContainerUtil.newTroveSet();
        for (FileSymbolTable table : this.allTables()) {
            PsiFile psiFile;
            VirtualFile file = table.getContainingFile();
            if (file == null || !file.isValid() || (psiFile = PsiManager.getInstance((Project)table.getProject()).findFile(file)) == null) continue;
            table.processIncludes((Processor<OCSymbol>)((Processor)arg_0 -> FileSymbolTablesCache.lambda$invalidateDirtyIncludes$1(dirtyNames, isRelativePath, (Set)pendingInvalidation, psiFile, moduleMapManager, moduleMapResolveService, arg_0)));
        }
        this.invalidateDirtyIncludeFiles((Collection<PsiFile>)pendingInvalidation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateDirtyIncludeFiles(Collection<PsiFile> dirtyFiles) {
        if (!dirtyFiles.isEmpty()) {
            THashSet invalidatedFiles = ContainerUtil.newTroveSet();
            for (PsiFile psiFile : dirtyFiles) {
                this.invalidate(psiFile, true, (Set<VirtualFile>)invalidatedFiles, true);
                Set<VirtualFile> set = this.myPendingReparses;
                synchronized (set) {
                    this.myPendingReparses.add(FileSymbolTablesCache.key(psiFile));
                }
            }
            OCImportGraph.invalidateHeaderRootsCache(this.myProject);
            OCInclusionContextUtil.invalidateHeaderRootAndActiveConfigurationForAllExcept(null, this.myProject);
        }
        this.schedulePSIUpdates();
    }

    public void compact() {
        for (FileSymbolTablesPack pack : this.myCache.values()) {
            pack.compactSynchronized();
        }
    }

    @NotNull
    public Collection<VirtualFile> getFilesToBuildTablesFor() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        LinkedHashSet<VirtualFile> result = new LinkedHashSet<VirtualFile>();
        OCWorkspace workspace = OCWorkspace.getInstance(this.myProject);
        Collection<VirtualFile> allSourceFiles = OCSearchScope.getExplicitlySpecifiedProjectSourceFiles(this.myProject);
        result.addAll(allSourceFiles);
        result.addAll(workspace.getLibraryFilesToBuildSymbols());
        List list = ContainerUtil.filter(result, file -> SymbolTableProvider.isSourceFile(file));
        if (list == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(5);
        }
        return list;
    }

    public Set<VirtualFile> getCachedFiles() {
        return this.myCache.keySet();
    }

    public void addFileToCache(@Nullable VirtualFile file) {
        if (file == null) {
            return;
        }
        this.myTableUpdater.addFileForUpdate(file);
    }

    public void addFilesToCache(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(6);
        }
        this.myTableUpdater.addFilesForUpdate(files, false);
    }

    public void removeFilesFromCache(@NotNull Iterable<VirtualFile> files) {
        if (files == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(7);
        }
        for (VirtualFile each : files) {
            this.clearCache(each);
        }
    }

    public void removeAllChildrenFromCache(@Nullable VirtualFile root) {
        if (root == null) {
            return;
        }
        for (VirtualFile file : this.myCache.keySet()) {
            if (file == null || !VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) continue;
            this.clearCache(file);
        }
    }

    @Nullable
    @Contract(value="null -> null")
    private static VirtualFile key(@Nullable PsiFile file) {
        return OCInclusionContextUtil.getVirtualFile(file);
    }

    public FileSymbolTable calcTableUsingPSI(@NotNull PsiFile file, @NotNull VirtualFile virtualFile, @NotNull OCInclusionContext context) {
        if (file == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(8);
        }
        if (virtualFile == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(9);
        }
        if (context == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(10);
        }
        return SymbolTableProvider.getProvider(file).calcTableUsingPSI(file, virtualFile, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Nullable
    FileSymbolTable forFile(@NotNull PsiFile file, @NotNull OCInclusionContext context) {
        boolean deadlock;
        Ref outTimeStamp;
        if (file == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(11);
        }
        if (context == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(12);
        }
        ProgressManager.checkCanceled();
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            LOG.error("deadlock may occur if 'FileSymbolTablesCache.forFile' is called outside of read-action");
        }
        if (!this.shouldBuildTables()) {
            return null;
        }
        VirtualFile virtualFile = FileSymbolTablesCache.key(file);
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        FileSymbolTablesPack pack = this.packForFile(virtualFile);
        FileSymbolTable table = pack.findConformingTable(context, 0, (Ref<Integer>)(outTimeStamp = new Ref()));
        if (table != null) {
            return table;
        }
        int checkedPackTimeStamp = (Integer)outTimeStamp.get();
        if (context.getInclusionLevel() >= OCInclusionContext.getMaxInclusionLevel(this.myProject)) {
            return null;
        }
        Thread currentThread = Thread.currentThread();
        Object object = this.myFileAndContextDependencyLock;
        synchronized (object) {
            this.myContextToAwaitingFile.put(currentThread, virtualFile);
            deadlock = this.checkForDeadlock(currentThread);
            if (deadlock) {
                this.myContextToAwaitingFile.remove(currentThread);
            }
        }
        if (deadlock) {
            return SymbolTableProvider.getProvider(file).calcTable(file, virtualFile, context);
        }
        object = pack;
        synchronized (object) {
            boolean alreadyInProcessingStack;
            Object currentlyProcessedBy;
            Object object2 = this.myFileAndContextDependencyLock;
            synchronized (object2) {
                this.myContextToAwaitingFile.remove(currentThread);
                currentlyProcessedBy = this.myFileToProcessingContext.get(virtualFile);
                if (currentlyProcessedBy != null && currentlyProcessedBy != currentThread) {
                    LOG.error("File is processed by another thread, deadlock detection failed! " + file.getName());
                }
                boolean bl = alreadyInProcessingStack = currentlyProcessedBy != null;
                if (!alreadyInProcessingStack) {
                    this.myFileToProcessingContext.put(virtualFile, currentThread);
                }
            }
            ProgressManager.checkCanceled();
            FileSymbolTable t = pack.findConformingTable(context, checkedPackTimeStamp, null);
            if (t != null) {
                currentlyProcessedBy = t;
                return currentlyProcessedBy;
            }
            OCSymbolTablesBuildingActivity.getInstance(this.myProject).assertParsingAndSymbolBuildingAllowed(currentThread);
            FileSymbolTable answer = SymbolTableProvider.getProvider(file).calcTable(file, virtualFile, context);
            context.addProcessedFile(virtualFile);
            pack.addCompactSynchronized(answer);
            FileSymbolTable fileSymbolTable = answer;
            return fileSymbolTable;
            finally {
                if (!alreadyInProcessingStack) {
                    Object object3 = this.myFileAndContextDependencyLock;
                    synchronized (object3) {
                        this.myFileToProcessingContext.remove(virtualFile);
                    }
                }
            }
        }
    }

    @Nullable
    public FileSymbolTable findForFile(@NotNull VirtualFile file, @NotNull OCInclusionContext context) {
        if (file == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(13);
        }
        if (context == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(14);
        }
        FileSymbolTablesPack pack = this.packForFile(file);
        return pack.findConformingTable(context, 0, null);
    }

    private boolean checkForDeadlock(@NotNull Thread context) {
        if (context == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(15);
        }
        Thread thread = context;
        while (thread != null) {
            VirtualFile lock = this.myContextToAwaitingFile.get(thread);
            if (lock == null) {
                return false;
            }
            Thread next = this.myFileToProcessingContext.get(lock);
            if (next == thread) {
                return false;
            }
            if (next == context) {
                return true;
            }
            thread = next;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleReparseFile(OCFile file) {
        Set<VirtualFile> set = this.myPendingReparses;
        synchronized (set) {
            VirtualFile key = FileSymbolTablesCache.key(file);
            if (key != null) {
                this.myPendingReparses.add(key);
            }
        }
        this.schedulePSIUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCachedFilesToReparse() {
        Set<VirtualFile> set = this.myPendingReparses;
        synchronized (set) {
            for (PsiFile file : PsiManagerEx.getInstanceEx((Project)this.myProject).getFileManager().getAllCachedFiles()) {
                VirtualFile key = FileSymbolTablesCache.key(file);
                if (key == null) continue;
                this.myPendingReparses.add(key);
            }
        }
    }

    private void scheduleReparseCachedPsiFiles() {
        this.addCachedFilesToReparse();
        this.schedulePSIUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedulePSIUpdates() {
        Set<VirtualFile> set = this.myPendingReparses;
        synchronized (set) {
            if (!this.myPendingPSIResets.isEmpty() || !this.myPendingReparses.isEmpty()) {
                ApplicationManager.getApplication().invokeLater(() -> this.updateDirtyFilesPSI(), ModalityState.NON_MODAL);
            }
        }
    }

    public void reparseCachedPsiFiles() {
        this.addCachedFilesToReparse();
        this.updateDirtyFilesPSI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDirtyFilesPSI() {
        if (this.myProject.isDisposed()) {
            return;
        }
        ArrayList<VirtualFile> toReparse = new ArrayList<VirtualFile>();
        ArrayList<VirtualFile> toResetPSI = new ArrayList<VirtualFile>();
        FileManager fileManager = PsiManagerEx.getInstanceEx((Project)this.myProject).getFileManager();
        Set<VirtualFile> set = this.myPendingReparses;
        synchronized (set) {
            this.myPendingPSIResets.removeAll(this.myPendingReparses);
            toResetPSI.addAll(this.myPendingPSIResets);
            this.myPendingPSIResets.clear();
            for (VirtualFile virtualFile : this.myPendingReparses) {
                PsiFile file;
                if (!virtualFile.isValid()) continue;
                FileViewProvider pp = fileManager.findCachedViewProvider(virtualFile);
                PsiFile psiFile = file = pp == null ? null : fileManager.findFile(virtualFile);
                if (file == null) continue;
                FileSymbolTablesCache.processDirtyFile(toReparse, file, virtualFile);
            }
            this.myPendingReparses.clear();
        }
        if (!toResetPSI.isEmpty()) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                for (VirtualFile file : toResetPSI) {
                    fileManager.setViewProvider(file, null);
                }
            });
        }
        if (!toReparse.isEmpty()) {
            FileContentUtilCore.reparseFiles(toReparse);
        }
        if (!toResetPSI.isEmpty() || !toReparse.isEmpty()) {
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
        }
    }

    private static void processDirtyFile(@NotNull List<VirtualFile> dirty, @NotNull PsiFile file, @NotNull VirtualFile virtualFile) {
        if (dirty == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(16);
        }
        if (file == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(17);
        }
        if (virtualFile == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(18);
        }
        if (SymbolTableProvider.isSourceFile(virtualFile) && file instanceof PsiFileImpl) {
            FileElement node = ((PsiFileImpl)file).getTreeElement();
            if (node != null && node.isParsed()) {
                dirty.add(virtualFile);
            } else {
                ((PsiFileImpl)file).clearCaches();
            }
        }
    }

    private void validate(PsiFile file, int start, int lengthShift) {
        VirtualFile key = FileSymbolTablesCache.key(file);
        if (key != null) {
            this.packForFile(key).updateOffsetsSynchronized(start, lengthShift);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidate(@Nullable PsiFile file, boolean reparse, Set<VirtualFile> processed, boolean withIncludingFiles) {
        VirtualFile key = FileSymbolTablesCache.key(file);
        if (key == null || !processed.add(key)) {
            return;
        }
        this.clearCache(key);
        if (file.isPhysical()) {
            this.myTableUpdater.addFileForUpdate(key);
        }
        if (withIncludingFiles) {
            Collection<OCResolveConfiguration> configs2;
            Set<VirtualFile> dirtySet = reparse ? this.myPendingReparses : this.myPendingPSIResets;
            OCWorkspace workspace = OCWorkspace.getInstance(this.myProject);
            if (!OCInclusionContextUtil.isNeedToFindRoot(file)) {
                for (OCResolveConfiguration config : workspace.getConfigurations()) {
                    OCImportGraph.invalidateRootHeadersCache(config, key);
                }
            }
            if (!(configs2 = OCInclusionContext.getBuildConfigurationByPchFile(key, this.myProject)).isEmpty()) {
                Runnable runnable2 = () -> {
                    if (this.myProject.isDisposed()) {
                        return;
                    }
                    for (OCResolveConfiguration config : configs2) {
                        OCInclusionContext.onPrecompiledContextChange(config);
                    }
                    Collection<VirtualFile> sourceFiles = OCSearchScope.getExplicitlySpecifiedProjectSourceFiles(this.myProject);
                    this.myTableUpdater.addFilesForUpdate(sourceFiles, true);
                    Set<VirtualFile> set = this.myPendingReparses;
                    synchronized (set) {
                        dirtySet.addAll(sourceFiles);
                    }
                };
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    runnable2.run();
                } else {
                    ApplicationManager.getApplication().invokeLater(runnable2, ModalityState.NON_MODAL);
                }
            }
            if (file instanceof OCFile) {
                THashSet includingFiles = new THashSet();
                if (!INVALIDATE_WITH_PSI_ONLY) {
                    Collection<VirtualFile> immediateIncludingFiles = OCImportGraph.findImmediateIncludingFiles(this.myProject, key, false);
                    includingFiles.addAll(PsiUtilCore.toPsiFiles((PsiManager)PsiManager.getInstance((Project)this.myProject), immediateIncludingFiles));
                }
                includingFiles.addAll(((OCFile)file).resetIncludingFiles());
                for (PsiFile including : includingFiles) {
                    this.invalidate(including, reparse, processed, true);
                    Set<VirtualFile> set = this.myPendingReparses;
                    synchronized (set) {
                        dirtySet.add(FileSymbolTablesCache.key(including));
                    }
                }
            }
        }
    }

    public void ensurePendingFilesProcessed() {
        this.ensurePendingFilesProcessed(null, false);
    }

    public void ensurePendingFilesProcessed(@Nullable ProgressIndicator indicator, boolean ensureOnlySourceFilesProcessed) {
        this.myTableUpdater.ensurePendingFilesProcessed(indicator, ensureOnlySourceFilesProcessed);
    }

    @NotNull
    public List<FileSymbolTable> allTablesForFile(OCFile file) {
        VirtualFile virtualFile = FileSymbolTablesCache.key(file);
        if (virtualFile == null) {
            List<FileSymbolTable> list = Collections.emptyList();
            if (list == null) {
                FileSymbolTablesCache.$$$reportNull$$$0(19);
            }
            return list;
        }
        ArrayList<FileSymbolTable> arrayList = this.packForFile(virtualFile).getTablesSynchronized();
        if (arrayList == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    @NotNull
    public List<FileSymbolTable> allTablesForFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(21);
        }
        ArrayList<FileSymbolTable> arrayList = this.packForFile(virtualFile).getTablesSynchronized();
        if (arrayList == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    public int allTablesForFileCount(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(23);
        }
        return this.packForFile(virtualFile).getTablesCountSynchronized();
    }

    @NotNull
    private FileSymbolTablesPack packForFile(@NotNull VirtualFile virtualFile) {
        FileSymbolTablesPack pack;
        if (virtualFile == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(24);
        }
        if ((pack = (FileSymbolTablesPack)this.myCache.get(virtualFile)) != null) {
            FileSymbolTablesPack fileSymbolTablesPack = pack;
            if (fileSymbolTablesPack == null) {
                FileSymbolTablesCache.$$$reportNull$$$0(25);
            }
            return fileSymbolTablesPack;
        }
        FileSymbolTablesPack newPack = new FileSymbolTablesPack();
        FileSymbolTablesPack prev = this.myCache.putIfAbsent(virtualFile, newPack);
        FileSymbolTablesPack fileSymbolTablesPack = prev == null ? newPack : prev;
        if (fileSymbolTablesPack == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(26);
        }
        return fileSymbolTablesPack;
    }

    public List<FileSymbolTable> allTables() {
        ArrayList<FileSymbolTable> result = new ArrayList<FileSymbolTable>();
        for (VirtualFile file : this.myCache.keySet()) {
            result.addAll(this.allTablesForFile(file));
        }
        return result;
    }

    public void clearAllTables() {
        ArrayList packs = new ArrayList(this.myCache.values());
        this.myCache.clear();
        for (FileSymbolTablesPack pack : packs) {
            pack.onRemove();
        }
    }

    private boolean clearCache(@NotNull VirtualFile each) {
        FileSymbolTablesPack pack;
        if (each == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(27);
        }
        if ((pack = (FileSymbolTablesPack)this.myCache.remove(each)) != null) {
            pack.onRemove();
        }
        return pack != null;
    }

    @Nullable
    private static FileSymbolTablesPack readTablesForFile(@NotNull FileSymbolTableSerializer serializer, @NotNull String projectLocationHash, @NotNull VirtualFile file) throws IOException {
        FileAttribute attribute;
        DataInputStream dis;
        if (serializer == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(28);
        }
        if (projectLocationHash == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(29);
        }
        if (file == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(30);
        }
        if (ourDoNotReloadExistingSymbolsInTests == Boolean.TRUE) {
            return null;
        }
        MetaData metaData = FileSymbolTablesCache.readMetaData(serializer, file);
        boolean metaDataChanged = false;
        Iterator iterator = metaData.projectKeysWithPaths.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (metaData.isFileUpToDate && metaData.checkProjectExistsForKey(key)) continue;
            iterator.remove();
            FileAttribute attribute2 = FileSymbolTablesCache.getFileCacheAttributeForProjectKey(key);
            DataOutputStream dos = attribute2.writeAttribute(file);
            Throwable throwable = null;
            if (dos != null) {
                if (throwable != null) {
                    try {
                        dos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    dos.close();
                }
            }
            metaDataChanged = true;
        }
        if (metaDataChanged) {
            FileSymbolTablesCache.writeMetaData(serializer, file, metaData);
        }
        if ((dis = (attribute = FileSymbolTablesCache.getFileCacheAttribute(projectLocationHash)).readAttribute(file)) == null || dis.available() == 0) {
            return null;
        }
        long savedTimestamp = dis.readLong();
        if (savedTimestamp == file.getTimeStamp()) {
            return serializer.readSymbolTables(dis, file);
        }
        return null;
    }

    void serializeTables(@NotNull String projectLocationHash, @NotNull Set<VirtualFile> tables, @NotNull ProgressIndicator indicator) {
        if (projectLocationHash == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(31);
        }
        if (tables == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(32);
        }
        if (indicator == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(33);
        }
        AtomicInteger counter = new AtomicInteger();
        int size = tables.size();
        ConcurrentLinkedQueue<VirtualFile> queue = new ConcurrentLinkedQueue<VirtualFile>(tables);
        FileAttribute cacheAttribute = FileSymbolTablesCache.getFileCacheAttribute(projectLocationHash);
        String keyForSerialization = FileSymbolTablesCache.getKeyForSerialization(projectLocationHash);
        String basePath = this.myProject.getBasePath();
        this.serializeParallel(indicator, (Consumer<FileSymbolTableSerializer>)((Consumer)serializer -> {
            VirtualFile file;
            if (indicator == null) {
                FileSymbolTablesCache.$$$reportNull$$$0(59);
            }
            boolean ok = true;
            while (ok && (file = (VirtualFile)queue.poll()) != null) {
                indicator.checkCanceled();
                VirtualFile finalFile = file;
                ok = (Boolean)ReadAction.compute(() -> {
                    if (indicator == null) {
                        FileSymbolTablesCache.$$$reportNull$$$0(60);
                    }
                    indicator.checkCanceled();
                    if (FileSymbolTablesCache.shouldSerializeTable(finalFile)) {
                        try {
                            MetaData metaData = FileSymbolTablesCache.readMetaData(serializer, finalFile);
                            metaData.projectKeysWithPaths.put(keyForSerialization, basePath);
                            FileSymbolTablesCache.writeMetaData(serializer, finalFile, metaData);
                            try (DataOutputStream dos = cacheAttribute.writeAttribute(finalFile);){
                                dos.writeLong(finalFile.getTimeStamp());
                                FileSymbolTablesPack pack = this.packForFile(finalFile);
                                Object object = pack.getTablesAccessLock();
                                synchronized (object) {
                                    serializer.writeSymbolTables(dos, pack);
                                }
                            }
                        }
                        catch (IOException e) {
                            LOG.error("Can't serialize file symbol table", (Throwable)e);
                            return false;
                        }
                    }
                    return true;
                });
                indicator.setFraction((double)counter.incrementAndGet() / (double)size);
            }
        }));
    }

    public static boolean areSymbolsLoaded(@NotNull Project project2) {
        if (project2 == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(34);
        }
        if (ourForceSymbolsLoadedInTests != null) {
            return ourForceSymbolsLoadedInTests;
        }
        FileSymbolTablesCache instance2 = (FileSymbolTablesCache)((Object)project2.getComponent(FileSymbolTablesCache.class));
        if (instance2 == null) {
            return true;
        }
        if (!instance2.shouldBuildTables()) {
            return true;
        }
        return instance2.mySymbolsLoaded.get();
    }

    public static int getIndexingThreadCount() {
        return FileSymbolTablesCache.getIndexingThreadCount(Registry.intValue((String)"cidr.indexer.thread.count"));
    }

    static int getIndexingThreadCount(int userValue) {
        int cpuCount = Runtime.getRuntime().availableProcessors();
        if (userValue <= 0) {
            userValue = cpuCount + userValue;
        }
        return Math.min(cpuCount, Math.max(1, userValue));
    }

    public static void forceSymbolsLoadedInTests(@Nullable Boolean force) {
        ourForceSymbolsLoadedInTests = force;
    }

    public static Boolean getForceSymbolsLoadedInTests() {
        return ourForceSymbolsLoadedInTests;
    }

    void notifySymbolsLoaded() {
        this.mySymbolsLoaded.getAndSet(true);
    }

    void notifySymbolsUnloaded() {
        this.mySymbolsLoaded.getAndSet(false);
    }

    public Project getProject() {
        return this.myProject;
    }

    public void removeUnusedTables() {
        for (FileSymbolTablesPack pack : this.myCache.values()) {
            pack.removeUnusedTables();
        }
    }

    @NotNull
    public Collection<VirtualFile> getFilesWithChangedTables() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (Map.Entry entry : this.myCache.entrySet()) {
            if (!((FileSymbolTablesPack)entry.getValue()).isChanged()) continue;
            result.add((VirtualFile)entry.getKey());
        }
        ArrayList<VirtualFile> arrayList = result;
        if (arrayList == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(35);
        }
        return arrayList;
    }

    @NotNull
    public Collection<VirtualFile> getFilesWithUsedTables() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (Map.Entry entry : this.myCache.entrySet()) {
            if (!((FileSymbolTablesPack)entry.getValue()).hasUsedTables()) continue;
            result.add((VirtualFile)entry.getKey());
        }
        ArrayList<VirtualFile> arrayList = result;
        if (arrayList == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(36);
        }
        return arrayList;
    }

    @NotNull
    private static MetaData readMetaData(FileSymbolTableSerializer serializer, VirtualFile file) throws IOException {
        DataInputStream dis = ourFileTablesMetaAttribute.readAttribute(file);
        if (dis == null || dis.available() == 0) {
            MetaData metaData = new MetaData();
            if (metaData == null) {
                FileSymbolTablesCache.$$$reportNull$$$0(37);
            }
            return metaData;
        }
        long metaIndicesVersion = dis.readLong();
        long metaFileTimestamp = dis.readLong();
        boolean isUpToDate = metaIndicesVersion == FileSymbolTablesCache.getGlobalIndicesVersion();
        isUpToDate = isUpToDate && metaFileTimestamp == file.getTimeStamp();
        MetaData metaData = serializer.readMetaData(dis);
        if (metaData == null) {
            MetaData metaData2 = new MetaData();
            if (metaData2 == null) {
                FileSymbolTablesCache.$$$reportNull$$$0(38);
            }
            return metaData2;
        }
        metaData.isFileUpToDate = isUpToDate;
        MetaData metaData3 = metaData;
        if (metaData3 == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(39);
        }
        return metaData3;
    }

    private static void writeMetaData(FileSymbolTableSerializer serializer, VirtualFile file, MetaData metaData) throws IOException {
        try (DataOutputStream dos = ourFileTablesMetaAttribute.writeAttribute(file);){
            dos.writeLong(FileSymbolTablesCache.getGlobalIndicesVersion());
            dos.writeLong(file.getTimeStamp());
            serializer.writeMetaData(dos, metaData);
        }
    }

    public static long getGlobalIndicesVersion() throws IOException {
        File file = FileSymbolTablesCache.getStorageMarker();
        if (!file.exists()) {
            file.createNewFile();
        }
        BasicFileAttributeView view = Files.getFileAttributeView(file.toPath(), BasicFileAttributeView.class, new LinkOption[0]);
        FileTime time = view.readAttributes().creationTime();
        return time.toMillis();
    }

    public static void invalidateCaches() {
        FileUtil.delete((File)FileSymbolTablesCache.getStorageMarker());
    }

    private static File getStorageMarker() {
        return new File(FileUtil.toCanonicalPath((String)PathManager.getSystemPath()), "symbol.cache.marker");
    }

    @NotNull
    private static String getKeyForSerialization(String projectLocationHash) {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        builder.append(TABLES_KEY_PREFIX);
        builder.append(":");
        builder.append(projectLocationHash);
        String string = builder.toString();
        String string2 = string;
        if (string2 == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(40);
        }
        return string2;
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    @NotNull
    private static FileAttribute getFileCacheAttribute(String projectLocationHash) {
        FileAttribute fileAttribute2 = FileSymbolTablesCache.getFileCacheAttributeForProjectKey(FileSymbolTablesCache.getKeyForSerialization(projectLocationHash));
        if (fileAttribute2 == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(41);
        }
        return fileAttribute2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static FileAttribute getFileCacheAttributeForProjectKey(@NotNull String key) {
        FileAttribute attribute;
        if (key == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(42);
        }
        Map<String, FileAttribute> map2 = ourFileCacheAttributes;
        synchronized (map2) {
            attribute = ourFileCacheAttributes.get(key);
            if (attribute == null) {
                attribute = new FileAttribute(key, FileSymbolTablesCache.getVersion(), false);
                ourFileCacheAttributes.put(key, attribute);
            }
        }
        FileAttribute fileAttribute2 = attribute;
        if (fileAttribute2 == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(43);
        }
        return fileAttribute2;
    }

    public long deserializeTables(@NotNull String projectLocationHash, @NotNull Collection<VirtualFile> filesToLoad, @NotNull ProgressIndicator indicator, double indicatorScale) {
        if (projectLocationHash == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(44);
        }
        if (filesToLoad == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(45);
        }
        if (indicator == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(46);
        }
        ModuleMapManager moduleMapManager = ModuleMapManager.getInstance(this.getProject());
        ModuleMapResolveService moduleMapResolveService = ModuleMapResolveService.getInstance(this.getProject());
        THashSet processedFiles = new THashSet();
        Set notLoaded = ContainerUtil.newConcurrentSet();
        notLoaded.addAll(filesToLoad);
        ArrayDeque<VirtualFile> workset = new ArrayDeque<VirtualFile>(filesToLoad);
        Set dirtySet = ContainerUtil.newConcurrentSet();
        MultiMap importsMap = new MultiMap();
        long total = notLoaded.size();
        this.serializeParallel(indicator, (Consumer<FileSymbolTableSerializer>)((Consumer)arg_0 -> this.lambda$deserializeTables$9(indicator, workset, (Set)processedFiles, projectLocationHash, dirtySet, notLoaded, indicatorScale, total, importsMap, moduleMapManager, moduleMapResolveService, arg_0)));
        workset.addAll(dirtySet);
        while (!workset.isEmpty()) {
            VirtualFile file = workset.pop();
            for (VirtualFile dep : importsMap.get((Object)file)) {
                if (!dirtySet.add(dep)) continue;
                workset.push(dep);
            }
        }
        for (VirtualFile file : dirtySet) {
            this.clearCache(file);
        }
        return total - (long)notLoaded.size();
    }

    public void tryDeserializingTableIfNecessary(@NotNull FileSymbolTableSerializer serializer, @NotNull String projectLocationHash, @NotNull VirtualFile file) {
        if (serializer == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(47);
        }
        if (projectLocationHash == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(48);
        }
        if (file == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(49);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.myCache.get(file) != null) {
            return;
        }
        ProgressManager.getInstance().executeNonCancelableSection(() -> {
            if (serializer == null) {
                FileSymbolTablesCache.$$$reportNull$$$0(53);
            }
            if (projectLocationHash == null) {
                FileSymbolTablesCache.$$$reportNull$$$0(54);
            }
            if (file == null) {
                FileSymbolTablesCache.$$$reportNull$$$0(55);
            }
            try {
                FileSymbolTablesPack p = FileSymbolTablesCache.readTablesForFile(serializer, projectLocationHash, file);
                if (p != null && !p.isEmpty()) {
                    this.myCache.putIfAbsent(file, p);
                }
            }
            catch (IOException e) {
                LOG.error("Can't deserialize file symbol table", (Throwable)e);
            }
        });
    }

    private void serializeParallel(ProgressIndicator indicator, Consumer<FileSymbolTableSerializer> task) {
        ArrayList<Future> futures = new ArrayList<Future>();
        for (FileSymbolTableSerializer serializer : this.mySerializers) {
            futures.add(ApplicationManager.getApplication().executeOnPooledThread(() -> task.consume((Object)serializer)));
        }
        SmartList exceptions = new SmartList();
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException serializer) {
            }
            catch (ExecutionException e) {
                exceptions.add(e.getCause());
            }
        }
        if (!exceptions.isEmpty()) {
            throw new CompoundRuntimeException((List)exceptions);
        }
        indicator.checkCanceled();
    }

    private static boolean shouldSerializeTable(@NotNull VirtualFile file) {
        if (file == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(50);
        }
        return file.isValid() && file instanceof VirtualFileWithId && !file.isDirectory();
    }

    public void handleFileChange(@NotNull PsiFile file, boolean hasMacro) {
        if (file == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(51);
        }
        if (SymbolTableProvider.isSourceFile(file)) {
            this.incOutOfCodeBlockTrackers(file);
            this.invalidate(file, false, (Set<VirtualFile>)new THashSet(), hasMacro);
            this.schedulePSIUpdates();
            OCInclusionContextUtil.invalidateHeaderContextsExcept(OCInclusionContextUtil.getVirtualFile(file), file.getProject());
        }
        if (hasMacro) {
            OCImportGraph.invalidateHeaderRootsCache(file.getProject());
            OCInclusionContextUtil.invalidateHeaderRootAndActiveConfigurationForAllExcept(OCInclusionContextUtil.getVirtualFile(file), file.getProject());
        }
    }

    private void incOutOfCodeBlockTrackers(@NotNull PsiFile file) {
        if (file == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(52);
        }
        this.myOutOfBlockModificationTracker.incModificationCount();
        SymbolTableProvider.fireOutOfCodeBlockModification(file);
    }

    public void dumpStats() {
        ArrayList list = new ArrayList(this.myCache.entrySet());
        Collections.sort(list, (o1, o2) -> {
            int c = Comparing.compare((int)((FileSymbolTablesPack)o1.getValue()).getTablesCountSynchronized(), (int)((FileSymbolTablesPack)o2.getValue()).getTablesCountSynchronized());
            if (c != 0) {
                return c;
            }
            List<FileSymbolTable> ts1 = ((FileSymbolTablesPack)o1.getValue()).tablesView();
            List<FileSymbolTable> ts2 = ((FileSymbolTablesPack)o2.getValue()).tablesView();
            if (ts1.size() > 0 && ts2.size() > 0) {
                VirtualFile f1 = ts1.get(0).getContainingFile();
                VirtualFile f2 = ts2.get(0).getContainingFile();
                int fc = Comparing.compare((Comparable)((Object)f1.getName()), (Comparable)((Object)f2.getName()));
                if (fc != 0) {
                    return fc;
                }
                return Comparing.compare((Comparable)((Object)f1.getPath()), (Comparable)((Object)f2.getPath()));
            }
            return Comparing.compare((int)ts1.size(), (int)ts2.size());
        });
        int totalFiles = 0;
        int multiTableFiles = 0;
        int totalSymbols = 0;
        int totalUniqueSymbols = 0;
        int totalContents = 0;
        int totalUniqueContents = 0;
        int totalUniqueContentsLen = 0;
        for (Map.Entry entry : list) {
            ++totalFiles;
            VirtualFile file = (VirtualFile)entry.getKey();
            FileSymbolTablesPack pack = (FileSymbolTablesPack)entry.getValue();
            ArrayList<FileSymbolTable> tables = new ArrayList<FileSymbolTable>(pack.getTablesSynchronized());
            if (tables.size() <= 1) continue;
            ++multiTableFiles;
            Function tablePrinter = table -> Integer.toString(table.getUsageCount());
            int symbolCount = 0;
            int contentsCount = 0;
            THashSet uniqueSymbols = new THashSet(TObjectHashingStrategy.IDENTITY);
            THashSet uniqueContents = new THashSet();
            int uniqueContentsLength = 0;
            for (FileSymbolTable table2 : tables) {
                List<OCSymbol> contents = table2.getContents();
                symbolCount += contents.size();
                uniqueSymbols.addAll(contents);
                ++contentsCount;
                if (!uniqueContents.add(contents)) continue;
                uniqueContentsLength += contents.size();
            }
            totalSymbols += symbolCount;
            totalUniqueSymbols += uniqueSymbols.size();
            totalContents += contentsCount;
            totalUniqueContents += uniqueContents.size();
            totalUniqueContentsLen += uniqueContentsLength;
            double reuseFactor = (double)uniqueSymbols.size() / (double)symbolCount;
            if (reuseFactor == 0.5) {
                int br_1371 = 0;
                ++br_1371;
            }
            if (reuseFactor < 0.005) {
                int br_1379 = 0;
                ++br_1379;
            }
            String num = String.format("%5d", totalFiles + 1);
            String contentsReuseInfo = "";
            if (uniqueContents.size() != contentsCount) {
                contentsReuseInfo = ", " + uniqueContents.size() + "/" + contentsCount + " <" + uniqueContentsLength + "/" + symbolCount + ">";
            }
            String tableBaseInfo = file.getName() + " (" + tables.size() + ") -> : [" + String.format("%.4f", reuseFactor) + contentsReuseInfo + "] ";
            System.out.println(num + " -- " + tableBaseInfo + StringUtil.join(tables, (Function)tablePrinter, (String)", "));
            Collections.sort(tables, (o1, o2) -> Comparing.compare((int)o2.getUsageCount(), (int)o1.getUsageCount()));
            System.out.println(num + "    " + tableBaseInfo + StringUtil.join(tables, (Function)tablePrinter, (String)", "));
        }
        System.out.println("============================");
        System.out.println("multitable files: " + multiTableFiles + " / " + totalFiles + " (" + (double)multiTableFiles / (double)totalFiles + ")");
        System.out.println("reusedSym/totalSym = " + totalUniqueSymbols + "/" + totalSymbols);
        System.out.println("uniqueTables/totalTables = " + totalUniqueContents + "/" + totalContents);
        System.out.println("uniqueTablesSize/totalTablesSize = " + totalUniqueContentsLen + "/" + totalSymbols);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$deserializeTables$9(final @NotNull ProgressIndicator indicator, ArrayDeque workset, Set processedFiles, @NotNull String projectLocationHash, Set dirtySet, Set notLoaded, double indicatorScale, long total, MultiMap importsMap, ModuleMapManager moduleMapManager, ModuleMapResolveService moduleMapResolveService, FileSymbolTableSerializer fileSymbolTableSerializer) {
        if (indicator == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(56);
        }
        if (projectLocationHash == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(57);
        }
        try {
            while (true) {
                void serializer;
                VirtualFile file;
                indicator.checkCanceled();
                ArrayDeque arrayDeque = workset;
                synchronized (arrayDeque) {
                    if (workset.isEmpty()) {
                        return;
                    }
                    file = (VirtualFile)workset.pop();
                    if (!processedFiles.add(file)) {
                        continue;
                    }
                }
                FileSymbolTablesPack pack = (FileSymbolTablesPack)ApplicationManager.getApplication().runReadAction((ThrowableComputable)new ThrowableComputable<FileSymbolTablesPack, IOException>((FileSymbolTableSerializer)serializer, projectLocationHash, dirtySet){
                    final /* synthetic */ FileSymbolTableSerializer val$serializer;
                    final /* synthetic */ String val$projectLocationHash;
                    final /* synthetic */ Set val$dirtySet;
                    {
                        this.val$serializer = fileSymbolTableSerializer;
                        this.val$projectLocationHash = string;
                        this.val$dirtySet = set;
                    }

                    public FileSymbolTablesPack compute() throws IOException {
                        indicator.checkCanceled();
                        if (!FileSymbolTablesCache.shouldSerializeTable(file)) {
                            return null;
                        }
                        FileSymbolTablesPack p = FileSymbolTablesCache.readTablesForFile(this.val$serializer, this.val$projectLocationHash, file);
                        if (p == null) {
                            this.val$dirtySet.add(file);
                        }
                        return p;
                    }
                });
                if (pack == null) continue;
                notLoaded.remove(file);
                indicator.setFraction(indicatorScale * ((double)total - (double)notLoaded.size()) / (double)total);
                if (pack.isEmpty()) continue;
                for (FileSymbolTable table : pack.tablesView()) {
                    void moduleMapResolveService2;
                    table.processIncludes((Processor<OCSymbol>)((Processor)arg_0 -> FileSymbolTablesCache.lambda$null$8(indicator, workset, importsMap, file, moduleMapManager, (ModuleMapResolveService)moduleMapResolveService2, arg_0)));
                }
                this.myCache.put(file, pack);
            }
        }
        catch (IOException e) {
            LOG.error("Can't deserialize file symbol table", (Throwable)e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ boolean lambda$null$8(@NotNull ProgressIndicator indicator, ArrayDeque workset, MultiMap importsMap, VirtualFile file, ModuleMapManager moduleMapManager, ModuleMapResolveService moduleMapResolveService, OCSymbol include) {
        ModuleMapModuleSymbol module2;
        if (indicator == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(58);
        }
        indicator.checkCanceled();
        if (include instanceof OCIncludeSymbol) {
            VirtualFile targetFile = ((OCIncludeSymbol)include).getTargetFile();
            if (targetFile != null) {
                ArrayDeque arrayDeque = workset;
                synchronized (arrayDeque) {
                    workset.push(targetFile);
                    importsMap.putValue((Object)targetFile, (Object)file);
                }
            }
        } else if (include instanceof OCModuleImportSymbol && (module2 = moduleMapManager.findModule(include.getName(), null)) != null) {
            ArrayDeque arrayDeque = workset;
            synchronized (arrayDeque) {
                for (VirtualFile header : moduleMapResolveService.getIncludeHeaders(module2, null)) {
                    workset.push(header);
                    importsMap.putValue((Object)header, (Object)file);
                }
            }
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$invalidateDirtyIncludes$1(Set dirtyNames, boolean isRelativePath, Set pendingInvalidation, PsiFile psiFile, ModuleMapManager moduleMapManager, ModuleMapResolveService moduleMapResolveService, OCSymbol include) {
        if (include instanceof OCIncludeSymbol) {
            OCIncludeSymbol includeSymbol = (OCIncludeSymbol)include;
            if (dirtyNames.contains(isRelativePath ? includeSymbol.getRelativePath() : includeSymbol.getLastPathComponent())) {
                pendingInvalidation.add(psiFile);
                return false;
            }
        } else if (include instanceof OCModuleImportSymbol) {
            ModuleMapModuleSymbol module2 = moduleMapManager.findModule(include.getName(), null);
            if (module2 == null) {
                return true;
            }
            List<String> names = isRelativePath ? moduleMapResolveService.getIncludeHeaderRelativePaths(module2) : moduleMapResolveService.getIncludeHeaders(module2, null).stream().map(VirtualFile::getName)::iterator;
            for (String name2 : names) {
                if (!dirtyNames.contains(name2)) continue;
                pendingInvalidation.add(psiFile);
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 26: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 26: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 26: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesCache";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 17: 
            case 30: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 18: 
            case 21: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirty";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "each";
                break;
            }
            case 28: 
            case 47: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 29: 
            case 31: 
            case 44: 
            case 48: 
            case 54: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectLocationHash";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tables";
                break;
            }
            case 33: 
            case 46: 
            case 56: 
            case 58: 
            case 59: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToLoad";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesCache";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutOfBlockModificationTracker";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOCOutOfBlockModificationTracker";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "setShouldBuildTablesInTests";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToBuildTablesFor";
                break;
            }
            case 19: 
            case 20: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "allTablesForFile";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "packForFile";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesWithChangedTables";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesWithUsedTables";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "readMetaData";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyForSerialization";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileCacheAttribute";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileCacheAttributeForProjectKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 26: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addFilesToCache";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeFilesFromCache";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "calcTableUsingPSI";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "forFile";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findForFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkForDeadlock";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processDirtyFile";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "allTablesForFile";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "allTablesForFileCount";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "packForFile";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "clearCache";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "readTablesForFile";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "serializeTables";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "areSymbolsLoaded";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getFileCacheAttributeForProjectKey";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "deserializeTables";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "tryDeserializingTableIfNecessary";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "shouldSerializeTable";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "handleFileChange";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "incOutOfCodeBlockTrackers";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "lambda$tryDeserializingTableIfNecessary$10";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "lambda$deserializeTables$9";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$8";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "lambda$serializeTables$7";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$6";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 26: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class OCCodeBlockModificationListener
    implements PsiTreeChangePreprocessor {
        private final Key<String> FILE_PREPROCESSOR_STAMP = Key.create((String)"FILE_PREPROCESSOR_STAMP");

        private OCCodeBlockModificationListener() {
        }

        public void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
            String stamp;
            if (event == null) {
                OCCodeBlockModificationListener.$$$reportNull$$$0(0);
            }
            int start = 0;
            int lengthShift = 0;
            PsiFile file = event.getFile();
            PsiElement child = event.getChild();
            if (file == null && child != null) {
                file = child.getContainingFile();
            }
            if (file == null && event.getParent() != null) {
                file = event.getParent().getContainingFile();
            }
            PsiElement parent = event.getParent();
            if (!SymbolTableProvider.isSourceFile(file)) {
                return;
            }
            switch (event.getCode()) {
                case BEFORE_CHILDREN_CHANGE: {
                    if (event.getParent() instanceof PsiFile) break;
                    this.processBeforeChange(file);
                    break;
                }
                case BEFORE_CHILD_REPLACEMENT: {
                    this.processBeforeChange(file);
                    break;
                }
                case BEFORE_CHILD_ADDITION: {
                    this.processBeforeChange(file);
                    break;
                }
                case BEFORE_CHILD_REMOVAL: {
                    this.processBeforeChange(file);
                    break;
                }
                case BEFORE_CHILD_MOVEMENT: {
                    break;
                }
                case CHILD_ADDED: {
                    start = event.getOffset();
                    assert (child != null);
                    if (!child.isValid()) {
                        LOG.warn("Invalid child in OCCodeBlockModificationListener.treeChanged: " + child + ", event: " + event);
                        break;
                    }
                    lengthShift = child.getTextLength();
                    this.processChange(file, parent);
                    break;
                }
                case CHILD_REMOVED: {
                    start = event.getOffset();
                    lengthShift = -event.getOldLength();
                    this.processChange(file, parent);
                    break;
                }
                case CHILD_REPLACED: {
                    start = event.getOffset();
                    assert (child != null);
                    if (!child.isValid()) {
                        LOG.warn("Invalid child in OCCodeBlockModificationListener.treeChanged: " + child + ", event: " + event);
                        break;
                    }
                    lengthShift = child.getTextLength() - event.getOldLength();
                    this.processChange(file, parent);
                    break;
                }
                case CHILDREN_CHANGED: {
                    if (event.isGenericChange()) break;
                    if (!parent.isValid()) {
                        LOG.warn("Invalid parent in OCCodeBlockModificationListener.treeChanged: " + parent + ", event: " + event);
                        break;
                    }
                    start = event.getOffset();
                    lengthShift = parent.getTextLength() - event.getOldLength();
                    this.processChange(file, parent);
                    break;
                }
                case CHILD_MOVED: 
                case BEFORE_PROPERTY_CHANGE: 
                case PROPERTY_CHANGED: {
                    FileSymbolTablesCache.this.incOutOfCodeBlockTrackers(file);
                    break;
                }
                default: {
                    LOG.error("Unknown code:" + event.getCode());
                }
            }
            if (lengthShift != 0) {
                FileSymbolTablesCache.this.validate(file, start, lengthShift);
            }
            if (event.isGenericChange() && (stamp = (String)file.getUserData(this.FILE_PREPROCESSOR_STAMP)) != null) {
                if (!stamp.equals(this.macroStamp(file))) {
                    FileSymbolTablesCache.this.handleFileChange(file, true);
                }
                file.putUserData(this.FILE_PREPROCESSOR_STAMP, null);
            }
        }

        private void processBeforeChange(@NotNull PsiFile file) {
            if (file == null) {
                OCCodeBlockModificationListener.$$$reportNull$$$0(1);
            }
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (!(file instanceof OCCodeFragment) && file.getUserData(this.FILE_PREPROCESSOR_STAMP) == null) {
                file.putUserData(this.FILE_PREPROCESSOR_STAMP, (Object)this.macroStamp(file));
            }
        }

        private void processChange(PsiFile file, PsiElement parent) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (!(file instanceof OCCodeFragment) && !this.isInsideCodeBlock(parent)) {
                FileSymbolTablesCache.this.handleFileChange(file, false);
            }
        }

        @NotNull
        private String macroStamp(PsiFile file) {
            if (!(file instanceof OCFile)) {
                if ("" == null) {
                    OCCodeBlockModificationListener.$$$reportNull$$$0(2);
                }
                return "";
            }
            StringBuilder acc = new StringBuilder();
            this.processASTNodeForMacros((ASTNode)file.getNode(), acc);
            String string = acc.toString();
            if (string == null) {
                OCCodeBlockModificationListener.$$$reportNull$$$0(3);
            }
            return string;
        }

        private void processASTNodeForMacros(@Nullable ASTNode node, @NotNull StringBuilder acc) {
            if (acc == null) {
                OCCodeBlockModificationListener.$$$reportNull$$$0(4);
            }
            if (node == null) {
                return;
            }
            IElementType elementType = node.getElementType();
            if (OCElementTypes.IMPORTANT_DIRECTIVES.contains(elementType)) {
                acc.append(node.getText());
            }
            for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                this.processASTNodeForMacros(child, acc);
            }
        }

        private boolean isInsideCodeBlock(@Nullable PsiElement element) {
            if (element instanceof PsiFileSystemItem) {
                return false;
            }
            if (element == null || element.getParent() == null) {
                return true;
            }
            PsiElement parent = element;
            while (!(parent instanceof PsiFile) && !(parent instanceof PsiDirectory) && parent != null) {
                if (parent instanceof OCLocalBlock && !(parent instanceof OCEagerBlockStatementImpl)) {
                    return true;
                }
                parent = parent.getParent();
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesCache$OCCodeBlockModificationListener";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "acc";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesCache$OCCodeBlockModificationListener";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "macroStamp";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "treeChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "processBeforeChange";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "processASTNodeForMacros";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class MetaData {
        private Map<String, String> projectKeysWithPaths = new HashMap<String, String>();
        private transient boolean isFileUpToDate;

        MetaData() {
        }

        private boolean checkProjectExistsForKey(@NotNull String projectKey) {
            String projectPath;
            if (projectKey == null) {
                MetaData.$$$reportNull$$$0(0);
            }
            return (projectPath = this.projectKeysWithPaths.get(projectKey)) != null && new File(projectPath).exists();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectKey", "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesCache$MetaData", "checkProjectExistsForKey"));
        }
    }
}

