/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCModuleImportSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.modulemap.resolve.ModuleMapResolveService;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapModuleSymbol;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSymbolTablesPack {
    @NotNull
    private final ArrayList<FileSymbolTable> myTables = new ArrayList();
    @Nullable
    private transient Internary myInternary;
    private volatile transient boolean myIsChanged;

    public boolean isEmpty() {
        return this.myTables.isEmpty();
    }

    public List<FileSymbolTable> tablesView() {
        return Collections.unmodifiableList(this.myTables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compactSynchronized() {
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            this.myTables.trimToSize();
            for (FileSymbolTable table : this.myTables) {
                table.compact();
            }
            this.myInternary = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompactSynchronized(@NotNull FileSymbolTable table) {
        if (table == null) {
            FileSymbolTablesPack.$$$reportNull$$$0(0);
        }
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            if (!this.myTables.isEmpty()) {
                if (this.myInternary == null) {
                    this.myInternary = new Internary();
                    for (FileSymbolTable t : this.myTables) {
                        this.myInternary.internBatch((Consumer<Function<OCSymbol, OCSymbol>>)((Consumer)i -> {
                            for (OCSymbol symbol : t.getContents()) {
                                i.fun((Object)symbol);
                            }
                        }));
                    }
                }
                this.myInternary.internBatch((Consumer<Function<OCSymbol, OCSymbol>>)((Consumer)i -> {
                    if (table == null) {
                        FileSymbolTablesPack.$$$reportNull$$$0(9);
                    }
                    table.internSymbols((Function<OCSymbol, OCSymbol>)i);
                }));
            }
            this.addTableInternal(table);
            table.incUsageCount();
            FileSymbolTablesPack.addToImportGraph(table);
        }
    }

    private void addTableInternal(@NotNull FileSymbolTable table) {
        if (table == null) {
            FileSymbolTablesPack.$$$reportNull$$$0(1);
        }
        this.myIsChanged = true;
        this.myTables.add(table);
        table.setPackStamp(this.getTimeStamp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUnusedTables() {
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            boolean hasUnused = false;
            for (FileSymbolTable table : this.myTables) {
                if (table.getUsageCount() != 0) continue;
                hasUnused = true;
                break;
            }
            if (hasUnused) {
                this.myIsChanged = true;
                this.myInternary = null;
                ArrayList<FileSymbolTable> oldTables = new ArrayList<FileSymbolTable>(this.myTables);
                this.myTables.clear();
                for (FileSymbolTable table : oldTables) {
                    if (table.getUsageCount() > 0) {
                        this.addTableInternal(table);
                        continue;
                    }
                    FileSymbolTablesPack.removeFromImportGraph(table);
                }
            }
        }
    }

    public boolean isChanged() {
        return this.myIsChanged;
    }

    private int getTimeStamp() {
        return this.myTables.size();
    }

    private static void addToImportGraph(@NotNull FileSymbolTable table) {
        if (table == null) {
            FileSymbolTablesPack.$$$reportNull$$$0(2);
        }
        OCLog.LOG.assertTrue(table.getContainingFile() != null);
        ModuleMapManager moduleMapManager = ModuleMapManager.getInstance(table.getProject());
        ModuleMapResolveService moduleMapResolveService = ModuleMapResolveService.getInstance(table.getProject());
        table.processIncludes((Processor<OCSymbol>)((Processor)symbol -> {
            ModuleMapModuleSymbol module2;
            if (table == null) {
                FileSymbolTablesPack.$$$reportNull$$$0(8);
            }
            if (symbol instanceof OCIncludeSymbol) {
                VirtualFile header = ((OCIncludeSymbol)symbol).getTargetFile();
                if (header != null && header.isValid()) {
                    OCImportGraph.addHeaderIncluder(table.getProject(), header, table.getContainingFile());
                }
            } else if (symbol instanceof OCModuleImportSymbol && (module2 = moduleMapManager.findModule(symbol.getName(), null)) != null) {
                for (VirtualFile header : moduleMapResolveService.getIncludeHeaders(module2, null)) {
                    if (!header.isValid()) continue;
                    OCImportGraph.addHeaderIncluder(table.getProject(), header, table.getContainingFile());
                }
            }
            return true;
        }));
    }

    private static void removeFromImportGraph(@NotNull FileSymbolTable table) {
        if (table == null) {
            FileSymbolTablesPack.$$$reportNull$$$0(3);
        }
        OCLog.LOG.assertTrue(table.getContainingFile() != null);
        ModuleMapManager moduleMapManager = ModuleMapManager.getInstance(table.getProject());
        ModuleMapResolveService moduleMapResolveService = ModuleMapResolveService.getInstance(table.getProject());
        table.processIncludes((Processor<OCSymbol>)((Processor)symbol -> {
            ModuleMapModuleSymbol module2;
            if (table == null) {
                FileSymbolTablesPack.$$$reportNull$$$0(7);
            }
            if (symbol instanceof OCIncludeSymbol) {
                VirtualFile header = ((OCIncludeSymbol)symbol).getTargetFile();
                if (header != null) {
                    OCImportGraph.removeHeaderIncluder(table.getProject(), header, table.getContainingFile());
                }
            } else if (symbol instanceof OCModuleImportSymbol && (module2 = moduleMapManager.findModule(symbol.getName(), null)) != null) {
                for (VirtualFile header : moduleMapResolveService.getIncludeHeaders(module2, null)) {
                    if (!header.isValid()) continue;
                    OCImportGraph.removeHeaderIncluder(table.getProject(), header, table.getContainingFile());
                }
            }
            return true;
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRemove() {
        ArrayList<FileSymbolTable> arrayList = this.myTables;
        synchronized (arrayList) {
            for (FileSymbolTable table : this.myTables) {
                FileSymbolTablesPack.removeFromImportGraph(table);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public ArrayList<FileSymbolTable> getTablesSynchronized() {
        Object object = this.getTablesAccessLock();
        // MONITORENTER : object
        ArrayList<FileSymbolTable> arrayList = new ArrayList<FileSymbolTable>(this.myTables);
        // MONITOREXIT : object
        if (arrayList != null) return arrayList;
        FileSymbolTablesPack.$$$reportNull$$$0(4);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTablesCountSynchronized() {
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            return this.myTables.size();
        }
    }

    @NotNull
    public Object getTablesAccessLock() {
        ArrayList<FileSymbolTable> arrayList = this.myTables;
        if (arrayList == null) {
            FileSymbolTablesPack.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOffsetsSynchronized(int start, int lengthShift) {
        THashSet processed = new THashSet(ContainerUtil.identityStrategy());
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            for (FileSymbolTable table : this.myTables) {
                table.updateOffsets(start, lengthShift, (THashSet<OCSymbol>)processed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public FileSymbolTable findConformingTable(@NotNull OCInclusionContext context, int sinceTimeStamp, @Nullable Ref<Integer> outCurrentTimeStamp) {
        if (context == null) {
            FileSymbolTablesPack.$$$reportNull$$$0(6);
        }
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            int timeStamp = this.getTimeStamp();
            if (outCurrentTimeStamp != null) {
                outCurrentTimeStamp.set((Object)timeStamp);
            }
            if (timeStamp > sinceTimeStamp) {
                for (int i = 0; i < this.myTables.size(); ++i) {
                    FileSymbolTable table = this.myTables.get(i);
                    if (table.getPackStamp() <= sinceTimeStamp || !context.checkConformanceAndFillSignatures(table)) continue;
                    int usingCount = table.incUsageCount();
                    if (usingCount < 0) {
                        for (FileSymbolTable t : this.myTables) {
                            t.resetUsageCount();
                        }
                    } else {
                        for (int prev = i - 1; prev >= 0 && this.myTables.get(prev).getUsageCount() + 2 < usingCount; --prev) {
                            Collections.swap(this.myTables, prev, prev + 1);
                        }
                    }
                    return table;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasUsedTables() {
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            for (FileSymbolTable table : this.myTables) {
                if (table.getUsageCount() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesPack";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesPack";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTablesSynchronized";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTablesAccessLock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompactSynchronized";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addTableInternal";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addToImportGraph";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeFromImportGraph";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findConformingTable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$removeFromImportGraph$3";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addToImportGraph$2";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addCompactSynchronized$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Internary {
        private DeepEqual.Resolver myEqualityResolver;
        @NotNull
        private final THashMap<OCSymbol, OCSymbol> mySymbols = new THashMap((TObjectHashingStrategy)new TObjectHashingStrategy<OCSymbol>(){

            public int computeHashCode(OCSymbol object) {
                return object.hashCodeExcludingOffset();
            }

            public boolean equals(OCSymbol o1, OCSymbol o2) {
                ProgressManager.checkCanceled();
                return myEqualityResolver.equalObjects(o1, o2);
            }
        });

        private Internary() {
        }

        public void internBatch(@NotNull Consumer<Function<OCSymbol, OCSymbol>> action) {
            if (action == null) {
                Internary.$$$reportNull$$$0(0);
            }
            this.myEqualityResolver = DeepEqual.newResolver();
            try {
                action.consume(symbol -> {
                    OCSymbol same = (OCSymbol)this.mySymbols.get(symbol);
                    if (same != null) {
                        return same;
                    }
                    this.mySymbols.put(symbol, symbol);
                    return symbol;
                });
            }
            finally {
                this.myEqualityResolver = null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesPack$Internary", "internBatch"));
        }
    }

    static class FileSymbolsPackSerializer
    extends FieldSerializer<FileSymbolTablesPack> {
        public FileSymbolsPackSerializer(Kryo kryo) {
            super(kryo, FileSymbolTablesPack.class);
        }

        protected FileSymbolTablesPack create(Kryo kryo, Input input, Class<FileSymbolTablesPack> type) {
            return new FileSymbolTablesPack();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileSymbolTablesPack read(Kryo kryo, Input input, Class<FileSymbolTablesPack> type) {
            FileSymbolTablesPack result = (FileSymbolTablesPack)super.read(kryo, input, type);
            Object object = result.getTablesAccessLock();
            synchronized (object) {
                for (FileSymbolTable table : result.myTables) {
                    FileSymbolTablesPack.addToImportGraph(table);
                }
            }
            return result;
        }
    }
}

