/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCModuleImportSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.AbstractGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.util.OCMostlySingularMultiUniqueMap;
import com.jetbrains.cidr.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.modulemap.resolve.ModuleMapResolveService;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapModuleSymbol;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGlobalProjectSymbolsCache
extends AbstractGlobalProjectSymbolsCache<OCSymbol, OCSymbols> {
    protected OCGlobalProjectSymbolsCache(Project project2) {
        super(OCGlobalProjectSymbolsCache.class, project2);
    }

    @Override
    protected OCSymbols buildGlobalSymbols(Project project2) {
        OCSymbols answer = new OCSymbols();
        if (FileSymbolTablesCache.areSymbolsLoaded(project2)) {
            ModuleMapManager moduleMapManager = ModuleMapManager.getInstance(project2);
            ModuleMapResolveService moduleMapResolveService = ModuleMapResolveService.getInstance(project2);
            Stack<VirtualFile> workset = new Stack<VirtualFile>();
            HashSet<VirtualFile> processed = new HashSet<VirtualFile>();
            final FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(project2);
            workset.addAll((Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Collection<VirtualFile>>(){

                public Collection<VirtualFile> compute() {
                    return cache.getFilesToBuildTablesFor();
                }
            }));
            while (!workset.isEmpty()) {
                VirtualFile vfile = (VirtualFile)workset.pop();
                if (!processed.add(vfile)) continue;
                for (FileSymbolTable table : cache.allTablesForFile(vfile)) {
                    for (OCSymbol content : table.getContents()) {
                        ModuleMapModuleSymbol module2;
                        if (content instanceof OCIncludeSymbol) {
                            VirtualFile targetFile = ((OCIncludeSymbol)content).getTargetFile();
                            if (targetFile != null && !processed.contains(targetFile)) {
                                workset.add(targetFile);
                            }
                        } else if (content instanceof OCModuleImportSymbol && (module2 = moduleMapManager.findModule(content.getName(), null)) != null) {
                            workset.addAll(moduleMapResolveService.getIncludeHeaders(module2, null));
                        }
                        answer.process(content.getDelegate());
                    }
                }
            }
        }
        return answer;
    }

    @NotNull
    public static OCGlobalProjectSymbolsCache getInstance(@NotNull Project project2) {
        if (project2 == null) {
            OCGlobalProjectSymbolsCache.$$$reportNull$$$0(0);
        }
        OCGlobalProjectSymbolsCache oCGlobalProjectSymbolsCache = (OCGlobalProjectSymbolsCache)((Object)project2.getComponent(OCGlobalProjectSymbolsCache.class));
        if (oCGlobalProjectSymbolsCache == null) {
            OCGlobalProjectSymbolsCache.$$$reportNull$$$0(1);
        }
        return oCGlobalProjectSymbolsCache;
    }

    public static OCSymbol findNearestTopLevelSymbol(Project project2, @Nullable String name2, @Nullable Condition<OCSymbol> condition, @Nullable VirtualFile contextFile) {
        return OCGlobalProjectSymbolsCache.findNearestTopLevelSymbol(OCGlobalProjectSymbolsCache.class, project2, name2, condition, contextFile);
    }

    public static boolean processTopLevelSymbols(@NotNull Project project2, @NotNull Processor<OCSymbol> processor2, @Nullable String name2) {
        if (project2 == null) {
            OCGlobalProjectSymbolsCache.$$$reportNull$$$0(2);
        }
        if (processor2 == null) {
            OCGlobalProjectSymbolsCache.$$$reportNull$$$0(3);
        }
        return OCGlobalProjectSymbolsCache.processTopLevelSymbols(OCGlobalProjectSymbolsCache.class, project2, processor2, name2);
    }

    public static boolean processTopLevelAndMemberSymbols(@NotNull Project project2, @NotNull Processor<OCSymbol> processor2, @Nullable String name2) {
        if (project2 == null) {
            OCGlobalProjectSymbolsCache.$$$reportNull$$$0(4);
        }
        if (processor2 == null) {
            OCGlobalProjectSymbolsCache.$$$reportNull$$$0(5);
        }
        return OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(OCGlobalProjectSymbolsCache.class, project2, processor2, name2);
    }

    public static boolean processByQualifiedName(@NotNull Project project2, @NotNull Processor<OCSymbol> processor2, @NotNull String name2) {
        if (project2 == null) {
            OCGlobalProjectSymbolsCache.$$$reportNull$$$0(6);
        }
        if (processor2 == null) {
            OCGlobalProjectSymbolsCache.$$$reportNull$$$0(7);
        }
        if (name2 == null) {
            OCGlobalProjectSymbolsCache.$$$reportNull$$$0(8);
        }
        return OCGlobalProjectSymbolsCache.processByQualifiedName(OCGlobalProjectSymbolsCache.class, project2, processor2, name2);
    }

    public static boolean processAliasNamesForType(@NotNull Project project2, @NotNull String name2, @NotNull Processor<String> processor2) {
        if (project2 == null) {
            OCGlobalProjectSymbolsCache.$$$reportNull$$$0(9);
        }
        if (name2 == null) {
            OCGlobalProjectSymbolsCache.$$$reportNull$$$0(10);
        }
        if (processor2 == null) {
            OCGlobalProjectSymbolsCache.$$$reportNull$$$0(11);
        }
        return OCGlobalProjectSymbolsCache.processAliasNamesForType(OCGlobalProjectSymbolsCache.class, project2, name2, processor2);
    }

    public static boolean processTopLevelAndMemberSymbols(@NotNull Project project2, @NotNull Processor<OCSymbol> processor2, @Nullable String name2, boolean topLevelOnly) {
        if (project2 == null) {
            OCGlobalProjectSymbolsCache.$$$reportNull$$$0(12);
        }
        if (processor2 == null) {
            OCGlobalProjectSymbolsCache.$$$reportNull$$$0(13);
        }
        return OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(OCGlobalProjectSymbolsCache.class, project2, processor2, name2, topLevelOnly);
    }

    public static Set<String> getAllSymbolNames(@NotNull Project project2) {
        if (project2 == null) {
            OCGlobalProjectSymbolsCache.$$$reportNull$$$0(14);
        }
        return OCGlobalProjectSymbolsCache.getAllSymbolNames(OCGlobalProjectSymbolsCache.class, project2);
    }

    public static OCMostlySingularMultiUniqueMap<String, OCSymbol> getCppMemberSymbols(@NotNull Project project2) {
        if (project2 == null) {
            OCGlobalProjectSymbolsCache.$$$reportNull$$$0(15);
        }
        return ((OCSymbols)OCGlobalProjectSymbolsCache.getInstance(project2).getGlobalSymbols()).myCppMemberSymbols;
    }

    public static boolean processSymbolsByCategory(@NotNull Project project2, @NotNull Processor<OCSymbol> processor2, String name2) {
        if (project2 == null) {
            OCGlobalProjectSymbolsCache.$$$reportNull$$$0(16);
        }
        if (processor2 == null) {
            OCGlobalProjectSymbolsCache.$$$reportNull$$$0(17);
        }
        FileSymbolTablesCache.getInstance(project2).ensurePendingFilesProcessed();
        return ((OCSymbols)OCGlobalProjectSymbolsCache.getInstance(project2).getGlobalSymbols()).processSymbolsByCategory(processor2, name2);
    }

    public static OCMostlySingularMultiUniqueMap<String, OCClassSymbol> getAllCategories(@NotNull Project project2) {
        if (project2 == null) {
            OCGlobalProjectSymbolsCache.$$$reportNull$$$0(18);
        }
        return ((OCSymbols)OCGlobalProjectSymbolsCache.getInstance(project2).getGlobalSymbols()).getAllNamesWithCategories();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/symtable/OCGlobalProjectSymbolsCache";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 11: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/OCGlobalProjectSymbolsCache";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processTopLevelSymbols";
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processTopLevelAndMemberSymbols";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processByQualifiedName";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processAliasNamesForType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAllSymbolNames";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCppMemberSymbols";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processSymbolsByCategory";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAllCategories";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class OCSymbols
    implements AbstractGlobalProjectSymbolsCache.Symbols<OCSymbol> {
        private final OCMostlySingularMultiUniqueMap<String, OCClassSymbol> myCategoryToClass;
        private final OCMostlySingularMultiUniqueMap<String, OCSymbol> myTopLevelSymbols;
        private final OCMostlySingularMultiUniqueMap<String, OCSymbol> myMemberSymbols;
        private final OCMostlySingularMultiUniqueMap<String, OCSymbol> myCppMemberSymbols;
        private final OCMostlySingularMultiUniqueMap<String, String> myTypeAliases;

        private OCSymbols() {
            TObjectHashingStrategy<OCSymbol> strategy = new TObjectHashingStrategy<OCSymbol>(){

                public int computeHashCode(OCSymbol object) {
                    return System.identityHashCode(object);
                }

                public boolean equals(OCSymbol o1, OCSymbol o2) {
                    return o1 == o2;
                }
            };
            this.myCategoryToClass = new OCMostlySingularMultiUniqueMap(strategy);
            this.myTopLevelSymbols = new OCMostlySingularMultiUniqueMap(strategy);
            this.myMemberSymbols = new OCMostlySingularMultiUniqueMap(strategy);
            this.myCppMemberSymbols = new OCMostlySingularMultiUniqueMap(strategy);
            this.myTypeAliases = new OCMostlySingularMultiUniqueMap();
        }

        public boolean process(OCSymbol symbol) {
            ProgressManager.checkCanceled();
            if (symbol instanceof OCIncludeSymbol || symbol instanceof OCModuleImportSymbol) {
                return true;
            }
            String name2 = symbol.getName();
            if (OCSymbolWithQualifiedName.WITHOUT_QUALIFIER.value((Object)symbol)) {
                this.myTopLevelSymbols.add(name2, symbol);
            } else {
                this.myCppMemberSymbols.add(name2, symbol);
            }
            if (symbol instanceof OCClassSymbol) {
                OCClassSymbol classSymbol = (OCClassSymbol)symbol;
                if (classSymbol.getCategoryName() != null) {
                    this.myCategoryToClass.add(classSymbol.getCategoryName(), classSymbol);
                }
                classSymbol.processMembers(OCMemberSymbol.class, ocMemberSymbol -> {
                    ProgressManager.checkCanceled();
                    this.myMemberSymbols.add(ocMemberSymbol.getName(), (OCSymbol)ocMemberSymbol);
                    return true;
                });
            } else if (symbol instanceof OCNamespaceSymbol) {
                OCNamespaceSymbol namespaceSymbol = (OCNamespaceSymbol)symbol;
                namespaceSymbol.processMembers((String)null, new Processor<OCSymbol>(){

                    public boolean process(OCSymbol ocSymbol) {
                        ProgressManager.checkCanceled();
                        boolean isMember = true;
                        if (ocSymbol instanceof OCSymbolWithQualifiedName) {
                            OCSymbolWithQualifiedName qualifiedSymbol = (OCSymbolWithQualifiedName)ocSymbol;
                            boolean bl = isMember = qualifiedSymbol.getQualifierParent() != null;
                        }
                        if (isMember) {
                            myCppMemberSymbols.add(ocSymbol.getName(), ocSymbol);
                        }
                        if (ocSymbol instanceof OCNamespaceSymbol) {
                            ((OCNamespaceSymbol)ocSymbol).processMembers((String)null, this);
                        }
                        return true;
                    }
                });
            } else if (symbol.getKind().isTypedefOrAlias()) {
                String refName = symbol.getType().getName();
                this.myTypeAliases.add(refName, symbol.getName());
            }
            return true;
        }

        @Override
        public boolean processAliasNamesForType(@NotNull String name2, @NotNull Processor<String> processor2) {
            if (name2 == null) {
                OCSymbols.$$$reportNull$$$0(0);
            }
            if (processor2 == null) {
                OCSymbols.$$$reportNull$$$0(1);
            }
            return this.myTypeAliases.processForKey(name2, processor2);
        }

        @Override
        public boolean processTopLevel(Processor<? super OCSymbol> processor2, @Nullable String name2) {
            return OCResolveUtil.processMap(processor2, name2, this.myTopLevelSymbols);
        }

        public boolean processCppMemberSymbols(Processor<? super OCSymbol> processor2, @Nullable String name2) {
            return OCResolveUtil.processMap(processor2, name2, this.myCppMemberSymbols);
        }

        @Override
        public boolean processAllSymbols(Processor<? super OCSymbol> processor2, @Nullable String name2) {
            return OCResolveUtil.processMap(processor2, name2, this.myTopLevelSymbols) && OCResolveUtil.processMap(processor2, name2, this.myMemberSymbols) && OCResolveUtil.processMap(processor2, name2, this.myCppMemberSymbols);
        }

        public boolean processSymbolsByCategory(Processor<OCSymbol> processor2, @Nullable String name2) {
            return OCResolveUtil.processMap(processor2, name2, this.myCategoryToClass);
        }

        public OCMostlySingularMultiUniqueMap<String, OCClassSymbol> getAllNamesWithCategories() {
            return this.myCategoryToClass;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "processor";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/symbols/symtable/OCGlobalProjectSymbolsCache$OCSymbols";
            objectArray[2] = "processAliasNamesForType";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

