/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCInternator;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Contract;

public class OCNamesInternary {
    private static final OCInternator<String> STRING_INTERNATOR = OCInternator.createStringInternator();
    private static final ConcurrentMap<OCQualifiedName, OCQualifiedName> ourQualifiedNamesCache = ContainerUtil.createConcurrentWeakKeyWeakValueMap();

    private OCNamesInternary() {
    }

    @Contract(value="null->null; !null->!null")
    public static String intern(String text) {
        return text != null ? STRING_INTERNATOR.intern(text) : null;
    }

    public static OCQualifiedName intern(OCQualifiedName name2) {
        for (OCQualifiedName current = name2; current != null; current = current.getQualifier()) {
            if (current.canThisNamePartBeInterned()) continue;
            return name2;
        }
        OCQualifiedName value = (OCQualifiedName)ourQualifiedNamesCache.get(name2);
        if (value != null) {
            return value;
        }
        return (OCQualifiedName)ConcurrencyUtil.cacheOrGet(ourQualifiedNamesCache, (Object)name2, (Object)name2);
    }
}

