/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.ide.util.DelegatingProgressIndicator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullProducer;
import com.intellij.util.Processor;
import com.intellij.util.Producer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.hmap.OCHeaderMapManager;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCConfigurationOwner;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.SymbolTableProvider;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.modulemap.ModuleMapModules;
import com.jetbrains.cidr.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.modulemap.resolve.ModuleMapResolveService;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapCache;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapDiskCache;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapFileSymbolPack;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapModuleSymbol;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSymbolTablesBuildingActivity {
    @NotNull
    private final ModuleMapResolveService myModuleMapResolveService;
    @NotNull
    private final ModuleMapManager myModuleMapManager;
    @Nullable
    private static NotNullProducer<ProgressIndicator> ourIndicatorFactory;
    @NotNull
    private static final Set<Thread> mySymbolBuildingThreads;
    public static final NotNullLazyKey<List<String>, Project> ACTIVITY_LOG;
    @NotNull
    private final Project project;
    private final SimpleModificationTracker myModificationTracker;
    @NotNull
    private final AtomicInteger ourRequestCount;
    private volatile int ourLastBuild;

    public static OCSymbolTablesBuildingActivity getInstance(Project project2) {
        return (OCSymbolTablesBuildingActivity)ServiceManager.getService((Project)project2, OCSymbolTablesBuildingActivity.class);
    }

    public OCSymbolTablesBuildingActivity(@NotNull Project project2, @NotNull ModuleMapResolveService moduleMapResolveService, @NotNull ModuleMapManager moduleMapManager) {
        if (project2 == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(0);
        }
        if (moduleMapResolveService == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(1);
        }
        if (moduleMapManager == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(2);
        }
        this.myModificationTracker = new SimpleModificationTracker();
        this.ourRequestCount = new AtomicInteger();
        this.project = project2;
        this.myModuleMapResolveService = moduleMapResolveService;
        this.myModuleMapManager = moduleMapManager;
    }

    @NotNull
    public SimpleModificationTracker getModificationTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myModificationTracker;
        if (simpleModificationTracker == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(3);
        }
        return simpleModificationTracker;
    }

    public void assertParsingAndSymbolBuildingAllowed() {
        this.assertParsingAndSymbolBuildingAllowed(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertParsingAndSymbolBuildingAllowed(Thread thread) {
        boolean allowed;
        boolean bl = allowed = FileSymbolTablesCache.areSymbolsLoaded(this.project) || mySymbolBuildingThreads.contains(thread);
        if (!allowed) {
            String logEntries;
            List log;
            List list = log = (List)ACTIVITY_LOG.getValue((UserDataHolder)this.project);
            synchronized (list) {
                logEntries = StringUtil.join((Collection)log, (String)"\n");
            }
            OCLog.LOG.error("Symbol building is not allowed: " + System.currentTimeMillis() + " . \nLoaded: " + FileSymbolTablesCache.areSymbolsLoaded(this.project) + "\nDumb: " + DumbService.isDumb((Project)this.project) + "\nPrevious activities: \n" + logEntries);
        }
    }

    public static void setIndicatorFactory(@Nullable NotNullProducer<ProgressIndicator> indicatorFactory) {
        ourIndicatorFactory = indicatorFactory;
    }

    public void rebuildSymbols() {
        this.rebuildSymbols(Mode.FAST);
    }

    public void rebuildSymbols(@NotNull Mode mode) {
        if (mode == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(4);
        }
        int requestNumber = this.ourRequestCount.incrementAndGet();
        this.runSymbolActivity("rebuildSymbols", (Processor<MyProgressIndicator>)((Processor)indicator -> {
            if (mode == null) {
                OCSymbolTablesBuildingActivity.$$$reportNull$$$0(65);
            }
            if (requestNumber <= this.ourLastBuild) {
                return false;
            }
            this.ourLastBuild = this.ourRequestCount.get();
            this.buildSymbolsInternal((MyProgressIndicator)((Object)indicator), mode);
            return true;
        }));
    }

    public void rebuildSwiftModules(FileType swiftFileType) {
        this.runSymbolActivity("rebuildSwiftModules", (Processor<MyProgressIndicator>)((Processor)indicator -> {
            this.processSwiftModules(ContainerUtil.createMaybeSingletonList((Object)new LightVirtualFile("", swiftFileType, (CharSequence)"")), (MyProgressIndicator)((Object)indicator));
            return true;
        }));
    }

    public void buildSymbolsForFiles(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(5);
        }
        this.runSymbolActivity("buildSymbolsForFiles", (Processor<MyProgressIndicator>)((Processor)indicator -> {
            if (files == null) {
                OCSymbolTablesBuildingActivity.$$$reportNull$$$0(64);
            }
            this.buildSymbolsForFilesInternal((MyProgressIndicator)((Object)indicator), files);
            return true;
        }));
    }

    public void rebuildModuleMaps() {
        if (!ModuleMapCache.shouldBuildCache()) {
            return;
        }
        this.runSymbolActivity("rebuildModuleMaps", (Processor<MyProgressIndicator>)((Processor)indicator -> {
            this.buildModuleMapsInternal((MyProgressIndicator)((Object)indicator), (Collection<HeadersSearchRoot>)this.getAllHeaderRoots());
            return true;
        }));
    }

    private void buildModuleMapsInternal(@NotNull MyProgressIndicator indicator, Collection<HeadersSearchRoot> allHeaderRoots) {
        if (indicator == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(6);
        }
        ModuleMapCache.getInstance(this.project).reset();
        indicator.setIndeterminate(false);
        this.deserializeModuleMaps(indicator, allHeaderRoots);
        this.buildRemainingModuleMaps(indicator);
        this.serializeModuleMaps(indicator, allHeaderRoots);
    }

    @NotNull
    private Set<HeadersSearchRoot> getAllHeaderRoots() {
        THashSet roots = ContainerUtil.newTroveSet();
        ReadAction.run(() -> this.lambda$getAllHeaderRoots$5((Set)roots));
        THashSet tHashSet = roots;
        if (tHashSet == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(7);
        }
        return tHashSet;
    }

    private void deserializeModuleMaps(@NotNull MyProgressIndicator indicator, @NotNull Collection<HeadersSearchRoot> roots) {
        if (indicator == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(8);
        }
        if (roots == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(9);
        }
        if (!ModuleMapCache.shouldReloadCache()) {
            return;
        }
        indicator.setText("Loading Module Maps...");
        indicator.startTiming("Loading Module Maps");
        indicator.setInterval(0.0, 0.1);
        ModuleMapDiskCache.getInstance(this.project).deserializeModuleMaps((ProgressIndicator)indicator, roots, (Consumer<ModuleMapFileSymbolPack>)((Consumer)pack -> {
            if (indicator == null) {
                OCSymbolTablesBuildingActivity.$$$reportNull$$$0(63);
            }
            indicator.setText2(((Object)((Object)pack.getHeaderRoot())).toString());
            ModuleMapCache.getInstance(this.project).cacheOrGet(pack.getHeaderRoot(), (Function0<ModuleMapFileSymbolPack>)((Function0)() -> pack));
        }));
        indicator.setText2(null);
        indicator.logTiming();
    }

    private void buildRemainingModuleMaps(@NotNull MyProgressIndicator indicator) {
        OCWorkspace workspace;
        TaskProvider task;
        if (indicator == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(10);
        }
        if ((task = (TaskProvider)ReadAction.compute(() -> this.lambda$buildRemainingModuleMaps$8(workspace = OCWorkspace.getInstance(this.project), indicator))) == null) {
            return;
        }
        indicator.setText("Building Module Maps...");
        indicator.startTiming("Building Module Maps");
        indicator.setIndeterminate(false);
        indicator.setInterval(0.1, 0.9);
        indicator.setFraction(0.0);
        OCSymbolTablesBuildingActivity.processFutures(OCSymbolTablesBuildingActivity.createTasks(task, (ProgressIndicator)indicator));
        indicator.setText2(null);
        indicator.logTiming();
    }

    private void serializeModuleMaps(@NotNull MyProgressIndicator indicator, @NotNull Collection<HeadersSearchRoot> roots) {
        if (indicator == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(11);
        }
        if (roots == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(12);
        }
        indicator.setText("Saving Module Maps...");
        indicator.startTiming("Saving Module Maps");
        indicator.setInterval(0.9, 1.0);
        List packs = ContainerUtil.mapNotNull(roots, root -> {
            if (indicator == null) {
                OCSymbolTablesBuildingActivity.$$$reportNull$$$0(61);
            }
            indicator.setText2(((Object)root).toString());
            return ModuleMapCache.getInstance(this.project).get((HeadersSearchRoot)((Object)root));
        });
        ModuleMapDiskCache.getInstance(this.project).serializeModuleMaps((ProgressIndicator)indicator, packs);
        indicator.setText2(null);
        indicator.logTiming();
    }

    private void runSymbolActivity(final @NotNull String activityName, final @NotNull Processor<MyProgressIndicator> activity) {
        if (activityName == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(13);
        }
        if (activity == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(14);
        }
        final Runnable r = () -> {
            if (activityName == null) {
                OCSymbolTablesBuildingActivity.$$$reportNull$$$0(59);
            }
            if (activity == null) {
                OCSymbolTablesBuildingActivity.$$$reportNull$$$0(60);
            }
            DumbService.getInstance((Project)this.project).queueTask(new DumbModeTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void performInDumbMode(@NotNull ProgressIndicator original) {
                    if (original == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    final MyProgressIndicator indicator = new MyProgressIndicator(original);
                    class MyDisposable
                    implements Disposable {
                        boolean shouldCancel = true;

                        MyDisposable() {
                        }

                        public void dispose() {
                            if (this.shouldCancel) {
                                indicator.cancel();
                            }
                        }
                    }
                    MyDisposable cancelOnProjectDispose = new MyDisposable();
                    try {
                        List log = (List)ACTIVITY_LOG.getValue((UserDataHolder)OCSymbolTablesBuildingActivity.this.project);
                        long start = System.currentTimeMillis();
                        List list = log;
                        synchronized (list) {
                            log.add(activityName + " " + start + ": START");
                        }
                        Disposer.register((Disposable)OCSymbolTablesBuildingActivity.this.project, (Disposable)cancelOnProjectDispose);
                        activity.process((Object)indicator);
                        cancelOnProjectDispose.shouldCancel = false;
                        list = log;
                        synchronized (list) {
                            log.add(activityName + " " + start + ": END after " + (System.currentTimeMillis() - start));
                        }
                    }
                    catch (Throwable t) {
                        if (!OCSymbolTablesBuildingActivity.this.project.isDisposed() && OCSymbolTablesBuildingActivity.this.project.isOpen()) {
                            boolean pce = t instanceof ProcessCanceledException;
                            OCLog.LOG.error("Unexpected exception during symbol building (" + activityName + ")", pce ? new RuntimeException(t) : t);
                        }
                    }
                    finally {
                        Disposer.dispose((Disposable)cancelOnProjectDispose);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/jetbrains/cidr/lang/symbols/symtable/OCSymbolTablesBuildingActivity$2", "performInDumbMode"));
                }
            });
        };
        final ApplicationEx app = ApplicationManagerEx.getApplicationEx();
        if (app.isUnitTestMode() && app.isWriteAccessAllowed()) {
            ApplicationAdapter applicationListener = new ApplicationAdapter(){
                AtomicBoolean isHandled = new AtomicBoolean();

                public void afterWriteActionFinished(@NotNull Object action) {
                    if (action == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (!this.isHandled.getAndSet(true)) {
                        app.removeApplicationListener((ApplicationListener)this);
                        r.run();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/jetbrains/cidr/lang/symbols/symtable/OCSymbolTablesBuildingActivity$3", "afterWriteActionFinished"));
                }
            };
            app.addApplicationListener((ApplicationListener)applicationListener);
        } else {
            r.run();
        }
    }

    private void buildSymbolsForFilesInternal(@NotNull MyProgressIndicator indicator, @NotNull Collection<VirtualFile> sourceFiles) {
        FileSymbolTablesCache cache;
        if (indicator == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(15);
        }
        if (sourceFiles == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(16);
        }
        if (!(cache = FileSymbolTablesCache.getInstance(this.project)).shouldBuildTables()) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        application.invokeAndWait(() -> {
            if (indicator == null) {
                OCSymbolTablesBuildingActivity.$$$reportNull$$$0(57);
            }
            application.runWriteAction(() -> {
                if (indicator == null) {
                    OCSymbolTablesBuildingActivity.$$$reportNull$$$0(58);
                }
                if (indicator.isCanceled()) {
                    return;
                }
                cache.notifySymbolsUnloaded();
                cache.reparseCachedPsiFiles();
            });
        });
        indicator.checkCanceled();
        indicator.setText("Updating symbols...");
        indicator.setIndeterminate(false);
        indicator.setFraction(0.0);
        indicator.setInterval(indicator.getFraction(), 1.0);
        new OCSymbolTableBuilder(this.project, (ProgressIndicator)indicator, sourceFiles).processBuildFiles();
        this.notifySymbolsAreLoadedAndReparseCachedFiles(cache, indicator);
    }

    private void buildSymbolsInternal(@NotNull MyProgressIndicator indicator, @NotNull Mode mode) {
        FileSymbolTablesCache cache;
        if (indicator == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(17);
        }
        if (mode == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(18);
        }
        if (!(cache = FileSymbolTablesCache.getInstance(this.project)).shouldBuildTables()) {
            return;
        }
        if (ApplicationManagerEx.getApplicationEx().isWriteAccessAllowed()) {
            OCLog.LOG.error("Symbols building must not be initiated from write action, otherwise deadlock will occur");
            return;
        }
        indicator.checkCanceled();
        indicator.setText("Building symbols...");
        indicator.setText2("");
        indicator.setIndeterminate(true);
        indicator.startTiming("Clearing symbols");
        String[] projectLocationHash = new String[1];
        Application application = ApplicationManager.getApplication();
        application.invokeAndWait(() -> {
            if (indicator == null) {
                OCSymbolTablesBuildingActivity.$$$reportNull$$$0(55);
            }
            application.runWriteAction(() -> {
                if (indicator == null) {
                    OCSymbolTablesBuildingActivity.$$$reportNull$$$0(56);
                }
                if (indicator.isCanceled()) {
                    return;
                }
                cache.notifySymbolsUnloaded();
                cache.clearAllTables();
                cache.reparseCachedPsiFiles();
                this.clearAllSymbolDependentCaches();
                projectLocationHash[0] = this.project.getLocationHash();
            });
        });
        indicator.logTiming();
        indicator.checkCanceled();
        indicator.setText("Loading symbols...");
        indicator.startTiming("Loading symbols");
        indicator.setIndeterminate(false);
        indicator.setFraction(0.0);
        Collection<VirtualFile> allFiles = OCSymbolTablesBuildingActivity.getFilesToBuildCachesForSafely((ProgressIndicator)indicator, cache);
        ArrayList sourceFiles = new ArrayList();
        OCSymbolTablesBuildingActivity.runReadActionSafely((ProgressIndicator)indicator, () -> sourceFiles.addAll(ContainerUtil.findAll((Collection)allFiles, file -> !OCInclusionContextUtil.isNeedToFindRoot(file, this.project))));
        OCLog.LOG.info("Building symbols in " + mode.name() + " mode, " + sourceFiles.size() + " source files from total " + allFiles.size() + " project files");
        long loadedFileCount = 0L;
        if (mode != Mode.FULL) {
            loadedFileCount = cache.deserializeTables(projectLocationHash[0], allFiles, (ProgressIndicator)indicator, 0.25);
        }
        double loadedFraction = indicator.getFraction();
        double savingFraction = 1.0 - 0.1 * (double)((long)allFiles.size() - loadedFileCount) / (double)Math.max(1, allFiles.size());
        indicator.logTiming();
        Set<HeadersSearchRoot> allHeaderRoots = this.getAllHeaderRoots();
        indicator.startTiming("Loading Header Maps");
        OCHeaderMapManager.getInstance(this.project).load(allHeaderRoots);
        indicator.logTiming();
        this.buildModuleMapsInternal(indicator, allHeaderRoots);
        HashSet<VirtualFile> loadedFiles = new HashSet<VirtualFile>(cache.getCachedFiles());
        OCLog.LOG.info("Loaded " + OCSymbolTablesBuildingActivity.getAllTablesCount(cache) + " tables for " + loadedFiles.size() + " files (" + loadedFileCount + " project files)");
        indicator.checkCanceled();
        indicator.setText(loadedFiles.isEmpty() ? "Building symbols..." : "Updating symbols...");
        indicator.startTiming("Building symbols");
        List sourceFilesWithoutTables = ContainerUtil.findAll(sourceFiles, file -> !loadedFiles.contains(file));
        List<VirtualFile> sourceFilesToIndex = mode == Mode.COMPACT ? sourceFiles : sourceFilesWithoutTables;
        OCLog.LOG.info("Building symbols for " + sourceFilesToIndex.size() + " source files");
        double sourcePart = sourceFilesToIndex.size();
        double headerWithoutTablesCount = allFiles.size() - sourceFiles.size();
        double headersPart = headerWithoutTablesCount * 0.2;
        double sourceFraction = loadedFraction + (savingFraction - loadedFraction) * (sourcePart / Math.max(sourcePart + headersPart, 1.0));
        indicator.setInterval(loadedFraction, sourceFraction);
        new OCSymbolTableBuilder(this.project, (ProgressIndicator)indicator, sourceFilesToIndex).processBuildFiles();
        indicator.checkCanceled();
        HashSet<VirtualFile> headersWithoutTables = new HashSet<VirtualFile>(allFiles);
        if (mode == Mode.COMPACT) {
            headersWithoutTables.removeAll(cache.getFilesWithUsedTables());
        } else {
            headersWithoutTables.removeAll(cache.getCachedFiles());
        }
        OCLog.LOG.info("Building symbols for " + headersWithoutTables.size() + " unused headers");
        indicator.setInterval(indicator.getFraction(), savingFraction);
        new OCSymbolTableBuilder(this.project, (ProgressIndicator)indicator, headersWithoutTables).processBuildFiles();
        indicator.logTiming();
        if (mode == Mode.COMPACT) {
            cache.removeUnusedTables();
        }
        this.processSwiftModules(allFiles, indicator);
        HashSet<VirtualFile> filesWithModifiedTables = new HashSet<VirtualFile>(cache.getFilesWithChangedTables());
        this.notifySymbolsAreLoadedAndReparseCachedFiles(cache, indicator);
        indicator.checkCanceled();
        indicator.setText("Saving symbols...");
        indicator.startTiming("Saving symbols");
        indicator.setInterval(savingFraction, 1.0);
        OCLog.LOG.info("Saving modified symbols for " + filesWithModifiedTables.size() + " files (" + OCSymbolTablesBuildingActivity.getAllTablesCount(cache, filesWithModifiedTables) + " tables of total " + OCSymbolTablesBuildingActivity.getAllTablesCount(cache) + ")");
        cache.serializeTables(projectLocationHash[0], filesWithModifiedTables, (ProgressIndicator)indicator);
        indicator.logTiming();
        FileSymbolTable.reportStats(this.project);
    }

    private static int getAllTablesCount(@NotNull FileSymbolTablesCache cache) {
        if (cache == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(19);
        }
        Set<VirtualFile> files = cache.getCachedFiles();
        return OCSymbolTablesBuildingActivity.getAllTablesCount(cache, files);
    }

    private static int getAllTablesCount(@NotNull FileSymbolTablesCache cache, @NotNull Set<VirtualFile> files) {
        if (cache == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(20);
        }
        if (files == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(21);
        }
        int result = 0;
        for (VirtualFile file : files) {
            result += cache.allTablesForFileCount(file);
        }
        return result;
    }

    private void processSwiftModules(@NotNull Collection<VirtualFile> allFiles, @NotNull MyProgressIndicator indicator) {
        if (allFiles == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(22);
        }
        if (indicator == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(23);
        }
        ArrayList tasks = ContainerUtil.newArrayList();
        for (SymbolTableProvider provider2 : (SymbolTableProvider[])SymbolTableProvider.INSTANCE.getExtensions()) {
            TaskProvider<?> additionalActivity = provider2.getItemProviderAndWorkerForAdditionalSymbolLoading(this.project, (ProgressIndicator)indicator, allFiles);
            if (additionalActivity == null) continue;
            tasks.addAll(OCSymbolTablesBuildingActivity.createTasks(additionalActivity, (ProgressIndicator)indicator));
        }
        if (!tasks.isEmpty()) {
            indicator.setText("Processing Swift modules...");
            indicator.setIndeterminate(false);
            indicator.setInterval(0.0, 1.0);
            indicator.setFraction(0.0);
            indicator.startTiming("Processing swift modules");
            OCSymbolTablesBuildingActivity.processFutures(tasks);
            indicator.logTiming();
        }
    }

    private void notifySymbolsAreLoadedAndReparseCachedFiles(@NotNull FileSymbolTablesCache cache, @NotNull MyProgressIndicator indicator) {
        if (cache == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(24);
        }
        if (indicator == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(25);
        }
        indicator.checkCanceled();
        OCSymbolTablesBuildingActivity.runReadActionSafely((ProgressIndicator)indicator, () -> {
            if (indicator == null) {
                OCSymbolTablesBuildingActivity.$$$reportNull$$$0(53);
            }
            if (cache == null) {
                OCSymbolTablesBuildingActivity.$$$reportNull$$$0(54);
            }
            indicator.checkCanceled();
            cache.compact();
            cache.notifySymbolsLoaded();
        });
        indicator.checkCanceled();
        Runnable runnable2 = () -> {
            if (indicator == null) {
                OCSymbolTablesBuildingActivity.$$$reportNull$$$0(51);
            }
            if (cache == null) {
                OCSymbolTablesBuildingActivity.$$$reportNull$$$0(52);
            }
            if (this.project.isDisposed() || indicator.isCanceled()) {
                return;
            }
            cache.reparseCachedPsiFiles();
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            TransactionGuard.getInstance().submitTransactionAndWait(runnable2);
        } else {
            TransactionGuard.submitTransaction((Disposable)this.project, (Runnable)runnable2);
        }
    }

    private void clearAllSymbolDependentCaches() {
        this.myModificationTracker.incModificationCount();
        for (OCResolveConfiguration configuration : OCWorkspace.getInstance(this.project).getConfigurations()) {
            OCInclusionContext.onPrecompiledContextChange(configuration);
            OCInclusionContext.clearSymbolTableConformanceCache(configuration);
            OCImportGraph.invalidateRootHeadersCache(configuration);
        }
        OCInclusionContextUtil.invalidateHeaderRootAndActiveConfigurationForAllExcept(null, this.project);
    }

    @NotNull
    private static Collection<VirtualFile> getFilesToBuildCachesForSafely(@NotNull ProgressIndicator indicator, @NotNull FileSymbolTablesCache cache) {
        if (indicator == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(26);
        }
        if (cache == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(27);
        }
        Ref result = new Ref();
        OCSymbolTablesBuildingActivity.runReadActionSafely(indicator, () -> {
            if (cache == null) {
                OCSymbolTablesBuildingActivity.$$$reportNull$$$0(50);
            }
            result.set(cache.getFilesToBuildTablesFor());
        });
        Collection collection = (Collection)result.get();
        if (collection == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(28);
        }
        return collection;
    }

    public static void runReadActionSafely(@NotNull ProgressIndicator indicator, @NotNull Runnable runnable2) {
        if (indicator == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(29);
        }
        if (runnable2 == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(30);
        }
        OCSymbolTablesBuildingActivity.waitForCondition(indicator, o -> {
            if (runnable2 == null) {
                OCSymbolTablesBuildingActivity.$$$reportNull$$$0(49);
            }
            return ApplicationManagerEx.getApplicationEx().tryRunReadAction(runnable2);
        });
    }

    private static void waitForCondition(@NotNull ProgressIndicator indicator, @NotNull Condition condition) {
        if (indicator == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(31);
        }
        if (condition == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(32);
        }
        long sleep = 1L;
        while (true) {
            indicator.checkCanceled();
            if (condition.value(null)) break;
            try {
                Thread.sleep(sleep);
                sleep *= 2L;
                sleep = Math.min(sleep, 100L);
            }
            catch (InterruptedException ignore) {
                throw new ProcessCanceledException();
            }
        }
    }

    private static void processFutures(@NotNull Iterable<Future<?>> tasks) {
        if (tasks == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(33);
        }
        for (Future<?> future : tasks) {
            try {
                future.get();
            }
            catch (InterruptedException ignore) {
                return;
            }
            catch (ExecutionException e) {
                OCLog.LOG.error(e.getMessage());
            }
        }
    }

    @NotNull
    private static <T> List<Future<?>> createTasks(@NotNull TaskProvider<T> taskProvider, @NotNull ProgressIndicator indicator) {
        if (taskProvider == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(34);
        }
        if (indicator == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(35);
        }
        int threadCount = FileSymbolTablesCache.getIndexingThreadCount();
        List<Future<?>> list = Stream.generate(() -> {
            if (taskProvider == null) {
                OCSymbolTablesBuildingActivity.$$$reportNull$$$0(45);
            }
            if (indicator == null) {
                OCSymbolTablesBuildingActivity.$$$reportNull$$$0(46);
            }
            return ApplicationManager.getApplication().executeOnPooledThread(() -> {
                if (taskProvider == null) {
                    OCSymbolTablesBuildingActivity.$$$reportNull$$$0(47);
                }
                if (indicator == null) {
                    OCSymbolTablesBuildingActivity.$$$reportNull$$$0(48);
                }
                Thread currentThread = Thread.currentThread();
                assert (!mySymbolBuildingThreads.contains(currentThread)) : "Dedicated thread should be used for symbols building";
                mySymbolBuildingThreads.add(currentThread);
                try {
                    OCSymbolTablesBuildingActivity.processItemsInReadAction(taskProvider.getItemProvider(), taskProvider.getWorker(), indicator);
                }
                finally {
                    mySymbolBuildingThreads.remove(currentThread);
                }
            });
        }).limit(threadCount).collect(Collectors.toList());
        if (list == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(36);
        }
        return list;
    }

    private static <T> void processItemsInReadAction(@NotNull Producer<T> itemProvider, @NotNull Consumer<T> worker, @NotNull ProgressIndicator globalIndicator) {
        if (itemProvider == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(37);
        }
        if (worker == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(38);
        }
        if (globalIndicator == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(39);
        }
        Object localProgress = ourIndicatorFactory != null ? (ProgressIndicator)ourIndicatorFactory.produce() : new SensitiveProgressWrapper(globalIndicator){

            protected boolean isReuseable() {
                return true;
            }
        };
        ProgressManager.getInstance().runProcess(() -> OCSymbolTablesBuildingActivity.lambda$processItemsInReadAction$25((ProgressIndicator)localProgress, globalIndicator, itemProvider, worker), localProgress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$processItemsInReadAction$25(final ProgressIndicator localProgress, @NotNull ProgressIndicator globalIndicator, @NotNull Producer itemProvider, @NotNull Consumer worker) {
        if (globalIndicator == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(40);
        }
        if (itemProvider == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(41);
        }
        if (worker == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(42);
        }
        ApplicationAdapter applicationListener = new ApplicationAdapter(){

            public void beforeWriteActionStart(@NotNull Object action) {
                if (action == null) {
                    5.$$$reportNull$$$0(0);
                }
                localProgress.cancel();
            }

            public void writeActionFinished(@NotNull Object action) {
                if (action == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (localProgress.isRunning()) {
                    localProgress.stop();
                }
                localProgress.start();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "action";
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/OCSymbolTablesBuildingActivity$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeWriteActionStart";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "writeActionFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ApplicationManager.getApplication().addApplicationListener((ApplicationListener)applicationListener);
        try {
            Ref currentItem = new Ref();
            while (!globalIndicator.isCanceled()) {
                if (currentItem.get() == null) {
                    Object item = itemProvider.produce();
                    if (item == null) {
                        break;
                    }
                    currentItem.set(item);
                }
                OCSymbolTablesBuildingActivity.runReadActionSafely(globalIndicator, () -> {
                    if (globalIndicator == null) {
                        OCSymbolTablesBuildingActivity.$$$reportNull$$$0(43);
                    }
                    if (worker == null) {
                        OCSymbolTablesBuildingActivity.$$$reportNull$$$0(44);
                    }
                    if (globalIndicator.isCanceled()) {
                        return;
                    }
                    Object item = currentItem.get();
                    currentItem.set(null);
                    try {
                        worker.consume(item);
                    }
                    catch (ProcessCanceledException ignore) {
                        currentItem.set(item);
                    }
                    catch (Throwable e) {
                        OCLog.LOG.error(e);
                    }
                });
            }
        }
        finally {
            ApplicationManager.getApplication().removeApplicationListener((ApplicationListener)applicationListener);
        }
    }

    private /* synthetic */ TaskProvider lambda$buildRemainingModuleMaps$8(final OCWorkspace workspace, final @NotNull MyProgressIndicator indicator) throws RuntimeException {
        if (indicator == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(62);
        }
        return new TaskProviderBuilder<Pair<OCResolveConfiguration, HeadersSearchRoot>>(){

            @Override
            @NotNull
            public Collection<Pair<OCResolveConfiguration, HeadersSearchRoot>> getInputData() {
                HashSet items = ContainerUtil.newHashSet();
                HashSet allRoots = ContainerUtil.newHashSet();
                for (OCResolveConfiguration configuration : workspace.getConfigurations()) {
                    List<HeadersSearchRoot> roots = OCSymbolTablesBuildingActivity.this.myModuleMapManager.getHeaderSearchRoots(configuration);
                    allRoots.addAll(roots);
                    items.addAll(ContainerUtil.map(roots, root -> Pair.create((Object)configuration, (Object)root)));
                }
                items.addAll(ContainerUtil.map((Collection)allRoots, root -> Pair.create(null, (Object)root)));
                HashSet hashSet = items;
                if (hashSet == null) {
                    1.$$$reportNull$$$0(0);
                }
                return hashSet;
            }

            @Override
            public void invoke(@NotNull Pair<OCResolveConfiguration, HeadersSearchRoot> item) {
                if (item == null) {
                    1.$$$reportNull$$$0(1);
                }
                indicator.setText2(((Object)((Object)((HeadersSearchRoot)((Object)item.second)))).toString());
                ModuleMapModules modules = OCSymbolTablesBuildingActivity.this.myModuleMapManager.getModules((OCResolveConfiguration)item.getFirst(), (HeadersSearchRoot)((Object)item.getSecond()));
                for (ModuleMapModuleSymbol module2 : modules.getModules()) {
                    OCSymbolTablesBuildingActivity.this.myModuleMapResolveService.getIncludeHeaders(module2, (OCResolveConfiguration)item.first);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/lang/symbols/symtable/OCSymbolTablesBuildingActivity$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "item";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getInputData";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/OCSymbolTablesBuildingActivity$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "invoke";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }.getTask((ProgressIndicator)indicator);
    }

    private /* synthetic */ void lambda$getAllHeaderRoots$5(Set roots) throws RuntimeException {
        List<OCResolveConfiguration> configurations = OCWorkspace.getInstance(this.project).getConfigurations();
        for (OCResolveConfiguration configuration : configurations) {
            roots.addAll(ModuleMapManager.getInstance(this.project).getHeaderSearchRoots(configuration));
        }
    }

    static {
        mySymbolBuildingThreads = ContainerUtil.newConcurrentSet();
        ACTIVITY_LOG = NotNullLazyKey.create((String)"SYMBOL ACTIVITY LOG", dom -> new ArrayList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 28: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 28: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleMapResolveService";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleMapManager";
                break;
            }
            case 3: 
            case 7: 
            case 28: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/symtable/OCSymbolTablesBuildingActivity";
                break;
            }
            case 4: 
            case 18: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 5: 
            case 21: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 23: 
            case 25: 
            case 26: 
            case 29: 
            case 31: 
            case 35: 
            case 46: 
            case 48: 
            case 51: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 61: 
            case 62: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 13: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activityName";
                break;
            }
            case 14: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activity";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFiles";
                break;
            }
            case 19: 
            case 20: 
            case 24: 
            case 27: 
            case 50: 
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allFiles";
                break;
            }
            case 30: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 34: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskProvider";
                break;
            }
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemProvider";
                break;
            }
            case 38: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "worker";
                break;
            }
            case 39: 
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalIndicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/OCSymbolTablesBuildingActivity";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllHeaderRoots";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToBuildCachesForSafely";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createTasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 7: 
            case 28: 
            case 36: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "rebuildSymbols";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildSymbolsForFiles";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildModuleMapsInternal";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "deserializeModuleMaps";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildRemainingModuleMaps";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "serializeModuleMaps";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "runSymbolActivity";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "buildSymbolsForFilesInternal";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "buildSymbolsInternal";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getAllTablesCount";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processSwiftModules";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "notifySymbolsAreLoadedAndReparseCachedFiles";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getFilesToBuildCachesForSafely";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "runReadActionSafely";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "waitForCondition";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processFutures";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createTasks";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "processItemsInReadAction";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processItemsInReadAction$25";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$24";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createTasks$23";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$22";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runReadActionSafely$21";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getFilesToBuildCachesForSafely$20";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "lambda$notifySymbolsAreLoadedAndReparseCachedFiles$19";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "lambda$notifySymbolsAreLoadedAndReparseCachedFiles$18";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "lambda$buildSymbolsInternal$14";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$13";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "lambda$buildSymbolsForFilesInternal$12";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$11";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runSymbolActivity$10";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "lambda$serializeModuleMaps$9";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "lambda$buildRemainingModuleMaps$8";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "lambda$deserializeModuleMaps$7";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "lambda$buildSymbolsForFiles$3";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "lambda$rebuildSymbols$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 28: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class TaskProviderBuilder<T> {
        @Nullable
        public TaskProvider<T> getTask(ProgressIndicator indicator) {
            Collection<T> items = this.getInputData();
            if (items.isEmpty()) {
                return null;
            }
            return this.createTask(items, indicator);
        }

        @NotNull
        public abstract Collection<T> getInputData();

        public abstract void invoke(@NotNull T var1);

        @NotNull
        private TaskProvider<T> createTask(@NotNull Collection<T> items, final @NotNull ProgressIndicator indicator) {
            if (items == null) {
                TaskProviderBuilder.$$$reportNull$$$0(0);
            }
            if (indicator == null) {
                TaskProviderBuilder.$$$reportNull$$$0(1);
            }
            final ArrayList pool = ContainerUtil.newArrayList(items);
            final AtomicInteger allCount = new AtomicInteger(items.size());
            final AtomicInteger processedCount = new AtomicInteger(0);
            TaskProvider taskProvider = new TaskProvider<T>(){

                @Override
                public Producer<T> getItemProvider() {
                    return () -> {
                        ArrayList arrayList = pool;
                        synchronized (arrayList) {
                            if (!pool.isEmpty()) {
                                return pool.remove(pool.size() - 1);
                            }
                        }
                        return null;
                    };
                }

                @Override
                public Consumer<T> getWorker() {
                    return t -> {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        this.invoke(t);
                        Integer newProcessed = processedCount.incrementAndGet();
                        indicator.setFraction(newProcessed.doubleValue() / (double)allCount.get());
                    };
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/lang/symbols/symtable/OCSymbolTablesBuildingActivity$TaskProviderBuilder$1", "lambda$getWorker$1"));
                }
            };
            if (taskProvider == null) {
                TaskProviderBuilder.$$$reportNull$$$0(2);
            }
            return taskProvider;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "items";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/symbols/symtable/OCSymbolTablesBuildingActivity$TaskProviderBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/OCSymbolTablesBuildingActivity$TaskProviderBuilder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createTask";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface TaskProvider<T> {
        public Producer<T> getItemProvider();

        public Consumer<T> getWorker();
    }

    private static class MyProgressIndicator
    extends DelegatingProgressIndicator {
        private double myFromFraction;
        private double myToFraction;
        private String lastActivity;
        private long activityStarted;

        public MyProgressIndicator(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                MyProgressIndicator.$$$reportNull$$$0(0);
            }
            super(indicator);
            this.myToFraction = 1.0;
        }

        public void startTiming(String activity) {
            this.activityStarted = System.currentTimeMillis();
            this.lastActivity = activity;
        }

        public void setText(String text) {
            super.setText(text);
        }

        public void logTiming() {
            long now = System.currentTimeMillis();
            OCLog.LOG.info(this.lastActivity + " finished in " + String.format("%.3f", (double)(now - this.activityStarted) / 1000.0) + " s.");
        }

        public void setInterval(double from, double to) {
            this.myFromFraction = from;
            this.myToFraction = to;
        }

        public void setFraction(double fraction) {
            super.setFraction(this.myFromFraction + (this.myToFraction - this.myFromFraction) * fraction);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/lang/symbols/symtable/OCSymbolTablesBuildingActivity$MyProgressIndicator", "<init>"));
        }
    }

    private static class OCSymbolTableBuilder {
        private final ProgressIndicator myIndicator;
        private final MultiMap<OCBuildFileCategory, OCBuildFileDescriptor> myClusterization;

        public OCSymbolTableBuilder(@NotNull Project project2, @NotNull ProgressIndicator progressIndicator, @NotNull Collection<VirtualFile> files) {
            if (project2 == null) {
                OCSymbolTableBuilder.$$$reportNull$$$0(0);
            }
            if (progressIndicator == null) {
                OCSymbolTableBuilder.$$$reportNull$$$0(1);
            }
            if (files == null) {
                OCSymbolTableBuilder.$$$reportNull$$$0(2);
            }
            this.myClusterization = new MultiMap();
            this.myIndicator = progressIndicator;
            Iterator<VirtualFile> iterator = files.iterator();
            Producer provider2 = () -> iterator.hasNext() ? (VirtualFile)iterator.next() : null;
            OCSymbolTablesBuildingActivity.processItemsInReadAction(provider2, virtualFile -> {
                if (project2 == null) {
                    OCSymbolTableBuilder.$$$reportNull$$$0(3);
                }
                if (!virtualFile.isValid()) {
                    return;
                }
                PsiFile file = PsiManager.getInstance((Project)project2).findFile(virtualFile);
                if (file instanceof OCConfigurationOwner) {
                    for (OCResolveConfiguration config : OCInclusionContextUtil.getAllBuildConfigurationsForIndexing(virtualFile, project2)) {
                        OCLanguageKind kind = OCInclusionContextUtil.isNeedToFindRoot(file) ? OCLanguageKindCalculator.calculateLanguageKind(config, virtualFile, project2, false) : ((OCConfigurationOwner)file).getKind();
                        OCBuildFileCategory traits = new OCBuildFileCategory(config.getIndexingCluster(), kind);
                        OCBuildFileDescriptor fileDescriptor = new OCBuildFileDescriptor(config, (VirtualFile)virtualFile, kind);
                        this.myClusterization.putValue((Object)traits, (Object)fileDescriptor);
                    }
                }
            }, progressIndicator);
        }

        public void processBuildFiles() {
            final int totalFilesCount = this.myClusterization.values().size();
            Set traits = this.myClusterization.keySet();
            ArrayList tasks = new ArrayList(traits.size());
            final AtomicInteger processedFiles = new AtomicInteger(0);
            final ArrayList<BuildFileProvider> clusterProviders = new ArrayList<BuildFileProvider>();
            final HashMap<VirtualFile, OCBuildFileDescriptor> notProcessedFiles = new HashMap<VirtualFile, OCBuildFileDescriptor>();
            for (OCBuildFileCategory t : traits) {
                Collection<OCBuildFileDescriptor> files = Collections.unmodifiableCollection(this.myClusterization.get((Object)t));
                for (OCBuildFileDescriptor desc : files) {
                    notProcessedFiles.put(desc.myFile, desc);
                }
                Iterator<OCBuildFileDescriptor> clusterIterator = files.iterator();
                clusterProviders.add(() -> {
                    while (clusterIterator.hasNext()) {
                        OCBuildFileDescriptor next = (OCBuildFileDescriptor)clusterIterator.next();
                        Map map2 = notProcessedFiles;
                        synchronized (map2) {
                            if (notProcessedFiles.containsKey(next.myFile)) {
                                notProcessedFiles.remove(next.myFile);
                                return next;
                            }
                        }
                    }
                    return null;
                });
            }
            final BuildFileProvider remainingProvider = () -> {
                Map map2 = notProcessedFiles;
                synchronized (map2) {
                    if (!notProcessedFiles.isEmpty()) {
                        Map.Entry next = notProcessedFiles.entrySet().iterator().next();
                        notProcessedFiles.remove(next.getKey());
                        return (OCBuildFileDescriptor)next.getValue();
                    }
                }
                return null;
            };
            tasks.addAll(OCSymbolTablesBuildingActivity.createTasks(new TaskProvider<OCBuildFileDescriptor>(){

                @Override
                public Producer<OCBuildFileDescriptor> getItemProvider() {
                    return new PrioritizedBuildFileProvider(clusterProviders, remainingProvider);
                }

                @Override
                public Consumer<OCBuildFileDescriptor> getWorker() {
                    return descriptor2 -> {
                        Set<VirtualFile> processed = OCImportGraph.buildSymbolAndRootHeaderCache(((OCBuildFileDescriptor)descriptor2).myConfiguration, ((OCBuildFileDescriptor)descriptor2).myFile, ((OCBuildFileDescriptor)descriptor2).myLanguageKind, myIndicator);
                        if (processed != null) {
                            int sizeDelta = 0;
                            Map map2 = notProcessedFiles;
                            synchronized (map2) {
                                int prevSize = notProcessedFiles.size();
                                for (VirtualFile f : processed) {
                                    notProcessedFiles.remove(f);
                                }
                                sizeDelta = prevSize - notProcessedFiles.size();
                            }
                            processedFiles.addAndGet(sizeDelta);
                        } else {
                            processedFiles.incrementAndGet();
                        }
                        myIndicator.setFraction((double)processedFiles.get() / (double)totalFilesCount);
                    };
                }
            }, this.myIndicator));
            OCSymbolTablesBuildingActivity.processFutures(tasks);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressIndicator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/OCSymbolTablesBuildingActivity$OCSymbolTableBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$new$1";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class PrioritizedBuildFileProvider
        implements BuildFileProvider {
            private boolean myUseClusters;
            private Producer<OCBuildFileDescriptor> myCurrentProvider;
            @NotNull
            private final Collection<BuildFileProvider> myProviders;
            @NotNull
            private final BuildFileProvider myBottomProvider;

            private PrioritizedBuildFileProvider(@NotNull Collection<BuildFileProvider> providers, @NotNull BuildFileProvider bottomProvider) {
                if (providers == null) {
                    PrioritizedBuildFileProvider.$$$reportNull$$$0(0);
                }
                if (bottomProvider == null) {
                    PrioritizedBuildFileProvider.$$$reportNull$$$0(1);
                }
                this.myUseClusters = true;
                this.myProviders = providers;
                this.myBottomProvider = bottomProvider;
            }

            @Nullable
            public OCBuildFileDescriptor produce() {
                OCBuildFileDescriptor fromCluster = this.nextFromProviders();
                return fromCluster != null ? fromCluster : (OCBuildFileDescriptor)this.myBottomProvider.produce();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private OCBuildFileDescriptor nextFromProviders() {
                if (!this.myUseClusters) {
                    return null;
                }
                while (true) {
                    BuildFileProvider provider2;
                    OCBuildFileDescriptor next;
                    if (this.myCurrentProvider != null && (next = (OCBuildFileDescriptor)this.myCurrentProvider.produce()) != null) {
                        return next;
                    }
                    Collection<BuildFileProvider> collection = this.myProviders;
                    synchronized (collection) {
                        Iterator<BuildFileProvider> iterator = this.myProviders.iterator();
                        if (!iterator.hasNext()) {
                            break;
                        }
                        provider2 = iterator.next();
                        iterator.remove();
                    }
                    this.myCurrentProvider = provider2;
                }
                this.myUseClusters = false;
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "providers";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "bottomProvider";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/lang/symbols/symtable/OCSymbolTablesBuildingActivity$OCSymbolTableBuilder$PrioritizedBuildFileProvider";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        @FunctionalInterface
        private static interface BuildFileProvider
        extends Producer<OCBuildFileDescriptor> {
        }

        private static final class OCBuildFileDescriptor {
            private final VirtualFile myFile;
            private final OCResolveConfiguration myConfiguration;
            @NotNull
            private final OCLanguageKind myLanguageKind;

            private OCBuildFileDescriptor(OCResolveConfiguration configuration, VirtualFile file, @NotNull OCLanguageKind kind) {
                if (kind == null) {
                    OCBuildFileDescriptor.$$$reportNull$$$0(0);
                }
                this.myConfiguration = configuration;
                this.myFile = file;
                this.myLanguageKind = kind;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/jetbrains/cidr/lang/symbols/symtable/OCSymbolTablesBuildingActivity$OCSymbolTableBuilder$OCBuildFileDescriptor", "<init>"));
            }
        }

        private static final class OCBuildFileCategory {
            private final Object myConfigurationCluster;
            private final OCLanguageKind myKind;

            private OCBuildFileCategory(@Nullable Object configurationCluster, @Nullable OCLanguageKind kind) {
                this.myConfigurationCluster = configurationCluster;
                this.myKind = kind;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                OCBuildFileCategory category = (OCBuildFileCategory)o;
                if (this.myKind != category.myKind) {
                    return false;
                }
                return !(this.myConfigurationCluster != null ? !this.myConfigurationCluster.equals(category.myConfigurationCluster) : category.myConfigurationCluster != null);
            }

            public int hashCode() {
                int result = this.myConfigurationCluster != null ? this.myConfigurationCluster.hashCode() : 0;
                result = 31 * result + (this.myKind != null ? this.myKind.hashCode() : 0);
                return result;
            }
        }
    }

    public static enum Mode {
        FAST,
        COMPACT,
        FULL;

    }
}

