/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.symtable.EmptySymbolTableProvider;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolTablesBuildingActivity;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SymbolTableProvider<FILE extends PsiFile> {
    private static final Logger LOG = Logger.getInstance(SymbolTableProvider.class);
    public static final ExtensionPointName<SymbolTableProvider> INSTANCE = ExtensionPointName.create((String)"cidr.lang.symbolTableProvider");

    protected abstract boolean isSource(@NotNull PsiFile var1);

    public abstract boolean isSource(@NotNull VirtualFile var1);

    public abstract void onOutOfCodeBlockModification(@NotNull PsiFile var1);

    @NotNull
    public abstract FileSymbolTable calcTableUsingPSI(@NotNull FILE var1, @NotNull VirtualFile var2, @NotNull OCInclusionContext var3);

    @NotNull
    public abstract FileSymbolTable calcTable(@NotNull FILE var1, @NotNull VirtualFile var2, @NotNull OCInclusionContext var3);

    @Nullable
    public OCSymbolTablesBuildingActivity.TaskProvider<?> getItemProviderAndWorkerForAdditionalSymbolLoading(@NotNull Project project2, @NotNull ProgressIndicator indicator, @NotNull Collection<VirtualFile> allFiles) {
        if (project2 == null) {
            SymbolTableProvider.$$$reportNull$$$0(0);
        }
        if (indicator == null) {
            SymbolTableProvider.$$$reportNull$$$0(1);
        }
        if (allFiles == null) {
            SymbolTableProvider.$$$reportNull$$$0(2);
        }
        return null;
    }

    public static void fireOutOfCodeBlockModification(@NotNull PsiFile file) {
        if (file == null) {
            SymbolTableProvider.$$$reportNull$$$0(3);
        }
        for (SymbolTableProvider provider2 : (SymbolTableProvider[])INSTANCE.getExtensions()) {
            provider2.onOutOfCodeBlockModification(file);
        }
    }

    @NotNull
    public static <FILE extends PsiFile> SymbolTableProvider<FILE> getProvider(@NotNull FILE file) {
        SymbolTableProvider<FILE> provider2;
        if (file == null) {
            SymbolTableProvider.$$$reportNull$$$0(4);
        }
        if ((provider2 = SymbolTableProvider.findProvider(file)) != null) {
            SymbolTableProvider<FILE> symbolTableProvider = provider2;
            if (symbolTableProvider == null) {
                SymbolTableProvider.$$$reportNull$$$0(5);
            }
            return symbolTableProvider;
        }
        LOG.error(file.getClass() + "(\"" + file.getName() + "\")");
        SymbolTableProvider<FILE> symbolTableProvider = SymbolTableProvider.emptyTableProvider();
        if (symbolTableProvider == null) {
            SymbolTableProvider.$$$reportNull$$$0(6);
        }
        return symbolTableProvider;
    }

    @Nullable
    private static <FILE extends PsiFile> SymbolTableProvider<FILE> findProvider(@NotNull FILE file) {
        SymbolTableProvider[] providers;
        if (file == null) {
            SymbolTableProvider.$$$reportNull$$$0(7);
        }
        for (SymbolTableProvider provider2 : providers = (SymbolTableProvider[])INSTANCE.getExtensions()) {
            if (!provider2.isSource(file)) continue;
            return provider2;
        }
        return null;
    }

    @NotNull
    private static <FILE extends PsiFile> SymbolTableProvider<FILE> emptyTableProvider() {
        EmptySymbolTableProvider emptySymbolTableProvider = EmptySymbolTableProvider.INSTANCE;
        if (emptySymbolTableProvider == null) {
            SymbolTableProvider.$$$reportNull$$$0(8);
        }
        return emptySymbolTableProvider;
    }

    public static boolean isSourceFile(@Nullable VirtualFile virtualFile) {
        if (virtualFile == null) {
            return false;
        }
        for (SymbolTableProvider provider2 : (SymbolTableProvider[])INSTANCE.getExtensions()) {
            if (!provider2.isSource(virtualFile)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSourceFile(@Nullable PsiFile file) {
        if (file == null) {
            return false;
        }
        for (SymbolTableProvider provider2 : (SymbolTableProvider[])INSTANCE.getExtensions()) {
            if (!provider2.isSource(file)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected static String getFileText(@NotNull PsiFile file, @NotNull VirtualFile virtualFile) {
        PsiDocumentManager manager;
        Document document;
        if (file == null) {
            SymbolTableProvider.$$$reportNull$$$0(9);
        }
        if (virtualFile == null) {
            SymbolTableProvider.$$$reportNull$$$0(10);
        }
        if ((document = (manager = PsiDocumentManager.getInstance((Project)file.getProject())).getCachedDocument(file)) != null) {
            String string = document.getText();
            if (string == null) {
                SymbolTableProvider.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = LoadTextUtil.loadText((VirtualFile)virtualFile).toString();
        if (string == null) {
            SymbolTableProvider.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allFiles";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/symtable/SymbolTableProvider";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/SymbolTableProvider";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvider";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyTableProvider";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getItemProviderAndWorkerForAdditionalSymbolLoading";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fireOutOfCodeBlockModification";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getProvider";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 12: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findProvider";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFileText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

