/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.toolchains;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.NamedPipe;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import com.jetbrains.cidr.toolchains.OSType;
import java.io.File;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrToolEnvironment {
    public static final char[] UNIX_FILE_SEPARATORS = new char[]{'/'};
    public static final char[] WINDOWS_UNIX_FILE_SEPARATORS = new char[]{'/', '\\'};
    protected final boolean isWindows;

    public CidrToolEnvironment() {
        this(SystemInfo.isWindows);
    }

    public CidrToolEnvironment(boolean isWindows) {
        this.isWindows = isWindows;
    }

    public void prepare(@NotNull GeneralCommandLine cl, @NotNull PrepareFor prepareFor) throws ExecutionException {
        if (cl == null) {
            CidrToolEnvironment.$$$reportNull$$$0(0);
        }
        if (prepareFor == null) {
            CidrToolEnvironment.$$$reportNull$$$0(1);
        }
    }

    @Contract(value="null -> null")
    public final String toLocalPath(@Nullable String absoluteEnvPath) {
        return this.toLocalPath(null, absoluteEnvPath);
    }

    @Contract(value="_, null -> null")
    public String toLocalPath(@Nullable File localBaseDir, @Nullable String absoluteOrRelativeEnvPath) {
        if (absoluteOrRelativeEnvPath == null) {
            return null;
        }
        if (localBaseDir != null && !this.isEnvAbsolute(absoluteOrRelativeEnvPath)) {
            String baseDirPath = StringsKt.trimEnd((String)localBaseDir.getPath(), (char[])this.getSupportedFileSeparators());
            absoluteOrRelativeEnvPath = FileUtil.toCanonicalPath((String)(baseDirPath + "/" + absoluteOrRelativeEnvPath));
        }
        return absoluteOrRelativeEnvPath;
    }

    protected boolean isEnvAbsolute(@NotNull String absoluteOrRelativeEnvPath) {
        if (absoluteOrRelativeEnvPath == null) {
            CidrToolEnvironment.$$$reportNull$$$0(2);
        }
        return this.isWindows ? FileUtil.isWindowsAbsolutePath((String)absoluteOrRelativeEnvPath) : FileUtil.isUnixAbsolutePath((String)absoluteOrRelativeEnvPath);
    }

    @Contract(value="null -> null")
    public String toEnvPath(@Nullable String localPath) {
        return localPath;
    }

    @NotNull
    public char[] getSupportedFileSeparators() {
        char[] cArray = this.isWindows ? WINDOWS_UNIX_FILE_SEPARATORS : UNIX_FILE_SEPARATORS;
        if (cArray == null) {
            CidrToolEnvironment.$$$reportNull$$$0(3);
        }
        return cArray;
    }

    public boolean isRemote() {
        return false;
    }

    @NotNull
    public OSType getEnvOSType() {
        OSType oSType = OSType.getCurrent();
        if (oSType == null) {
            CidrToolEnvironment.$$$reportNull$$$0(4);
        }
        return oSType;
    }

    @NotNull
    public ProcessOutput runProcess(@NotNull GeneralCommandLine cl, @Nullable ProgressIndicator indicator, int timeout) throws ExecutionException {
        if (cl == null) {
            CidrToolEnvironment.$$$reportNull$$$0(5);
        }
        ProcessOutput processOutput = CidrToolsUtil.runProcess((BaseProcessHandler)new CapturingProcessHandler(cl), indicator, timeout);
        if (processOutput == null) {
            CidrToolEnvironment.$$$reportNull$$$0(6);
        }
        return processOutput;
    }

    @NotNull
    public BaseProcessHandler createProcess(@NotNull GeneralCommandLine cl, boolean colored, boolean usePty) throws ExecutionException {
        if (cl == null) {
            CidrToolEnvironment.$$$reportNull$$$0(7);
        }
        ColoredProcessHandler processHandler = colored ? new ColoredProcessHandler(cl) : new CapturingProcessHandler(cl);
        CidrToolsUtil.setHasPty((OSProcessHandler)processHandler, usePty);
        ColoredProcessHandler coloredProcessHandler = processHandler;
        if (coloredProcessHandler == null) {
            CidrToolEnvironment.$$$reportNull$$$0(8);
        }
        return coloredProcessHandler;
    }

    public void killProcessTree(@NotNull BaseProcessHandler handler) {
        if (handler == null) {
            CidrToolEnvironment.$$$reportNull$$$0(9);
        }
        OSProcessUtil.killProcessTree((Process)handler.getProcess());
    }

    @NotNull
    public NamedPipe openNamedPipe() throws ExecutionException {
        throw new UnsupportedOperationException();
    }

    public boolean isFileExist(@NotNull String path) throws ExecutionException {
        if (path == null) {
            CidrToolEnvironment.$$$reportNull$$$0(10);
        }
        return FileUtil.exists((String)path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prepareFor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absoluteOrRelativeEnvPath";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/toolchains/CidrToolEnvironment";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/toolchains/CidrToolEnvironment";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFileSeparators";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvOSType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcess";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEnvAbsolute";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runProcess";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createProcess";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "killProcessTree";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isFileExist";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum PrepareFor {
        BUILD,
        RUN;

    }
}

