/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.names.OCTypeNameVisitor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum CVQualifiers {
    EMPTY(false, false),
    CONST(true, false),
    VOLATILE(false, true),
    CONST_VOLATILE(true, true);

    private final boolean myConst;
    private final boolean myVolatile;

    private CVQualifiers(boolean isConst, boolean isVolatile) {
        this.myConst = isConst;
        this.myVolatile = isVolatile;
    }

    @Contract(pure=true)
    @NotNull
    public static CVQualifiers get(boolean isConst, boolean isVolatile) {
        if (isConst) {
            CVQualifiers cVQualifiers = isVolatile ? CONST_VOLATILE : CONST;
            if (cVQualifiers == null) {
                CVQualifiers.$$$reportNull$$$0(0);
            }
            return cVQualifiers;
        }
        CVQualifiers cVQualifiers = isVolatile ? VOLATILE : EMPTY;
        if (cVQualifiers == null) {
            CVQualifiers.$$$reportNull$$$0(1);
        }
        return cVQualifiers;
    }

    public boolean isConst() {
        return this.myConst;
    }

    public boolean isVolatile() {
        return this.myVolatile;
    }

    @NotNull
    public CVQualifiers or(@NotNull CVQualifiers modifiers) {
        if (modifiers == null) {
            CVQualifiers.$$$reportNull$$$0(2);
        }
        CVQualifiers cVQualifiers = CVQualifiers.get(this.myConst || modifiers.isConst(), this.myVolatile || modifiers.isVolatile());
        if (cVQualifiers == null) {
            CVQualifiers.$$$reportNull$$$0(3);
        }
        return cVQualifiers;
    }

    public void appendCVQualifiers(@NotNull StringBuilder buffer) {
        if (buffer == null) {
            CVQualifiers.$$$reportNull$$$0(4);
        }
        if (this.isConst()) {
            buffer.append(" const");
        }
        if (this.isVolatile()) {
            buffer.append(" volatile");
        }
    }

    public boolean isSuperset(@NotNull CVQualifiers other) {
        if (other == null) {
            CVQualifiers.$$$reportNull$$$0(5);
        }
        return !(!this.isConst() && other.isConst() || !this.isVolatile() && other.isVolatile());
    }

    @NotNull
    public static String appendCVQualifiers(@NotNull String typeString, @NotNull OCType type, @Nullable Project project2) {
        if (typeString == null) {
            CVQualifiers.$$$reportNull$$$0(6);
        }
        if (type == null) {
            CVQualifiers.$$$reportNull$$$0(7);
        }
        if (type.isConst()) {
            typeString = OCTypeNameVisitor.addTypeQualifier(typeString, type, project2, "const");
        }
        if (type.isVolatile()) {
            typeString = OCTypeNameVisitor.addTypeQualifier(typeString, type, project2, "volatile");
        }
        String string = typeString;
        if (string == null) {
            CVQualifiers.$$$reportNull$$$0(8);
        }
        return string;
    }

    public String toString() {
        return (this.isConst() ? "c" : "") + (this.isVolatile() ? "v" : "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/types/CVQualifiers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiers";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeString";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/types/CVQualifiers";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "or";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "appendCVQualifiers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "or";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "appendCVQualifiers";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isSuperset";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

