/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.jetbrains.cidr.lang.symbols.OCAttributes;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum MachineModeAttribute {
    QI(1, true),
    HI(2, true),
    SI(4, true),
    DI(8, true),
    TI(16, true),
    SF(4, false),
    DF(8, false),
    TF(16, false);

    private final short mySizeInBytes;
    private final boolean myIsIntegralType;

    private MachineModeAttribute(short sizeInBytes, boolean isIntegralType) {
        this.mySizeInBytes = sizeInBytes;
        this.myIsIntegralType = isIntegralType;
    }

    public short getSizeInBytes() {
        return this.mySizeInBytes;
    }

    public boolean isIntegralType() {
        return this.myIsIntegralType;
    }

    @Nullable
    public static MachineModeAttribute forModeAttributeParameter(@NotNull String mode) {
        if (mode == null) {
            MachineModeAttribute.$$$reportNull$$$0(0);
        }
        mode = OCAttributes.trimUnderscores(mode);
        try {
            return MachineModeAttribute.valueOf(mode);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Nullable
    public static MachineModeAttribute getModeAttribute(@NotNull Collection<String> attributes) {
        String mode;
        if (attributes == null) {
            MachineModeAttribute.$$$reportNull$$$0(1);
        }
        return (mode = OCAttributes.getAttributeParameter(attributes, "mode")) == null ? null : MachineModeAttribute.forModeAttributeParameter(mode);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/types/MachineModeAttribute";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "forModeAttributeParameter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getModeAttribute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

