/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import com.jetbrains.cidr.lang.util.OCExceptionSpecificationInfo;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFunctionType
extends OCType {
    private OCType myReturnType;
    private List<OCType> myParameterTypes;
    private List<String> myParameterNames;
    @NotNull
    private OCExceptionSpecificationInfo myExceptionSpecification;

    public OCFunctionType() {
    }

    public OCFunctionType(@NotNull OCType returnType, @NotNull List<OCType> parameterTypes) {
        if (returnType == null) {
            OCFunctionType.$$$reportNull$$$0(0);
        }
        if (parameterTypes == null) {
            OCFunctionType.$$$reportNull$$$0(1);
        }
        this(returnType, parameterTypes, null, false, false, false, false, OCExceptionSpecificationInfo.createForNone());
    }

    public OCFunctionType(@NotNull OCType returnType, @NotNull List<OCType> parameterTypes, @Nullable List<String> parameterNames) {
        if (returnType == null) {
            OCFunctionType.$$$reportNull$$$0(2);
        }
        if (parameterTypes == null) {
            OCFunctionType.$$$reportNull$$$0(3);
        }
        this(returnType, parameterTypes, parameterNames, false, false, false, false, OCExceptionSpecificationInfo.createForNone());
    }

    public OCFunctionType(@NotNull OCType returnType, @NotNull List<OCType> parameterTypes, @Nullable List<String> parameterNames, boolean isConst, boolean isVolatile, boolean isLvalue, boolean isRvalue, @NotNull OCExceptionSpecificationInfo myExceptionSpecification) {
        if (returnType == null) {
            OCFunctionType.$$$reportNull$$$0(4);
        }
        if (parameterTypes == null) {
            OCFunctionType.$$$reportNull$$$0(5);
        }
        if (myExceptionSpecification == null) {
            OCFunctionType.$$$reportNull$$$0(6);
        }
        super(isConst, isVolatile);
        this.myReturnType = returnType;
        this.myParameterTypes = parameterTypes;
        this.myParameterNames = parameterNames;
        if (isLvalue) {
            this.myTypeAttributes = OCFunctionType.attachAttribute(this.myTypeAttributes, 32);
        }
        if (isRvalue) {
            this.myTypeAttributes = OCFunctionType.attachAttribute(this.myTypeAttributes, 64);
        }
        this.myExceptionSpecification = myExceptionSpecification;
        assert (this.myParameterNames == null || this.myParameterNames.size() == this.myParameterTypes.size());
    }

    @Override
    public void compact() {
        this.myParameterNames = ContainerUtil.trimToSize(this.myParameterNames);
        this.myParameterTypes = ContainerUtil.trimToSize(this.myParameterTypes);
    }

    public static OCType convertArrayParameterType(OCType type) {
        if (type instanceof OCArrayType) {
            OCArrayType array = (OCArrayType)type;
            OCPointerType pointer = OCPointerType.to(array.getRefType(), array.getARCAttribute(), array.getClassQualifier(), false, array.isVolatile());
            pointer.setLengthInBrackets(array.getLengthSymbol());
            type = pointer;
        }
        return type;
    }

    @NotNull
    public OCType getReturnType() {
        OCType oCType = this.myReturnType;
        if (oCType == null) {
            OCFunctionType.$$$reportNull$$$0(7);
        }
        return oCType;
    }

    @NotNull
    public List<OCType> getParameterTypes(boolean includeVoid) {
        List<OCType> list = !includeVoid && this.hasNoParameters() ? Collections.emptyList() : this.myParameterTypes;
        if (list == null) {
            OCFunctionType.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public List<OCType> getParameterTypes() {
        List<OCType> list = this.getParameterTypes(false);
        if (list == null) {
            OCFunctionType.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Nullable
    public List<String> getParameterNames(boolean includeVoid) {
        return !includeVoid && this.hasNoParameters() ? Collections.emptyList() : this.myParameterNames;
    }

    @Nullable
    public List<String> getParameterNames() {
        return this.getParameterNames(false);
    }

    public boolean isVararg() {
        if (this.myParameterTypes.size() > 0) {
            OCType lastParamType = this.myParameterTypes.get(this.myParameterTypes.size() - 1).getTerminalType();
            return lastParamType instanceof OCEllipsisType || lastParamType instanceof OCVariadicType;
        }
        return false;
    }

    public boolean isLValueRef() {
        return this.checkAttribute(32);
    }

    public boolean isRValueRef() {
        return this.checkAttribute(64);
    }

    public boolean hasNoParameters() {
        if (this.myParameterTypes.isEmpty()) {
            return true;
        }
        if (this.myParameterTypes.size() == 1) {
            return this.myParameterTypes.get(0) instanceof OCVoidType && (this.myParameterNames == null || "<unnamed>".equals(this.myParameterNames.get(0)));
        }
        return false;
    }

    @NotNull
    public OCExceptionSpecificationInfo getExceptionSpecification() {
        OCExceptionSpecificationInfo oCExceptionSpecificationInfo = this.myExceptionSpecification;
        if (oCExceptionSpecificationInfo == null) {
            OCFunctionType.$$$reportNull$$$0(10);
        }
        return oCExceptionSpecificationInfo;
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitFunctionType(this);
    }

    @Override
    public int hashCode() {
        int result = this.baseHashCode();
        result = 31 * result + this.myReturnType.hashCode();
        result = 31 * result + this.myParameterTypes.hashCode();
        return result;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            OCFunctionType.$$$reportNull$$$0(11);
        }
        if (first == null) {
            OCFunctionType.$$$reportNull$$$0(12);
        }
        if (second == null) {
            OCFunctionType.$$$reportNull$$$0(13);
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCFunctionType f = (OCFunctionType)first;
        OCFunctionType s = (OCFunctionType)second;
        if (!Comparing.equal(f.myParameterNames, s.myParameterNames)) {
            return false;
        }
        if (!c.equalLists(f.myParameterTypes, s.myParameterTypes)) {
            return false;
        }
        return c.equalObjects(f.myReturnType, s.myReturnType);
    }

    @Override
    @NotNull
    protected OCType doGetLeastCommonType(OCType type, @NotNull OCResolveContext context) {
        if (context == null) {
            OCFunctionType.$$$reportNull$$$0(14);
        }
        if (type == null) {
            OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
            if (oCUnknownType == null) {
                OCFunctionType.$$$reportNull$$$0(15);
            }
            return oCUnknownType;
        }
        if (type instanceof OCMagicType) {
            OCType oCType = type;
            if (oCType == null) {
                OCFunctionType.$$$reportNull$$$0(16);
            }
            return oCType;
        }
        if (type.isNumberCompatible(context)) {
            OCType oCType = OCIntType.INT.getLeastCommonType(type, context);
            if (oCType == null) {
                OCFunctionType.$$$reportNull$$$0(17);
            }
            return oCType;
        }
        if (type.isPointerCompatible(context)) {
            if (this.equals(type, context)) {
                OCFunctionType oCFunctionType = this;
                if (oCFunctionType == null) {
                    OCFunctionType.$$$reportNull$$$0(18);
                }
                return oCFunctionType;
            }
            OCPointerType oCPointerType = OCPointerType.to(OCVoidType.instance());
            if (oCPointerType == null) {
                OCFunctionType.$$$reportNull$$$0(19);
            }
            return oCPointerType;
        }
        OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
        if (oCUnknownType == null) {
            OCFunctionType.$$$reportNull$$$0(20);
        }
        return oCUnknownType;
    }

    @Override
    public boolean isPointerCompatible(@NotNull OCResolveContext context, boolean checkCppConvertible) {
        if (context == null) {
            OCFunctionType.$$$reportNull$$$0(21);
        }
        return true;
    }

    @Override
    public boolean isScalar() {
        return true;
    }

    @Override
    public boolean isUnresolved(@NotNull OCResolveContext context) {
        if (context == null) {
            OCFunctionType.$$$reportNull$$$0(22);
        }
        if (this.myReturnType.isUnresolved(context) || this.myReturnType instanceof OCFunctionType || this.myReturnType instanceof OCArrayType) {
            return true;
        }
        for (OCType type : this.myParameterTypes) {
            if (!type.isUnresolved(context)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getFormatString() {
        return "%p";
    }

    @Override
    public int getSizeInBytes(@Nullable PsiFile file, @Nullable OCInclusionContext context, @NotNull Project project2) {
        if (project2 == null) {
            OCFunctionType.$$$reportNull$$$0(23);
        }
        return OCIntType.INT.getSizeInBytes(file, context, project2);
    }

    @Override
    public boolean isMagicInside(@NotNull OCResolveContext context) {
        if (context == null) {
            OCFunctionType.$$$reportNull$$$0(24);
        }
        return this.myReturnType.isMagicInside(context) || this.myParameterTypes.stream().anyMatch(p -> {
            if (context == null) {
                OCFunctionType.$$$reportNull$$$0(26);
            }
            return p.isMagicInside(context);
        });
    }

    @NotNull
    public OCFunctionType cloneWithFunctionAttributes(boolean isConst, boolean isVolatile, boolean isLvalueRef, boolean isRvalueRef) {
        OCFunctionType oCFunctionType = new OCFunctionType(this.getReturnType(), this.getParameterTypes(true), this.getParameterNames(true), isConst, isVolatile, isLvalueRef, isRvalueRef, this.getExceptionSpecification());
        if (oCFunctionType == null) {
            OCFunctionType.$$$reportNull$$$0(25);
        }
        return oCFunctionType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myExceptionSpecification";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/types/OCFunctionType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 14: 
            case 21: 
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/types/OCFunctionType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnType";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterTypes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionSpecification";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetLeastCommonType";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneWithFunctionAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 25: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doGetLeastCommonType";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isPointerCompatible";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isUnresolved";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getSizeInBytes";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isMagicInside";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isMagicInside$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

