/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.Predicate;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCNullability;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCTollFreeBridges;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeCheckResult;
import com.jetbrains.cidr.lang.types.OCTypeCheckState;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCloneVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeResolveVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import com.jetbrains.cidr.lang.types.visitors.names.OCDumbTypeNameVisitor;
import com.jetbrains.cidr.lang.types.visitors.names.OCTypeNameVisitor;
import com.jetbrains.cidr.lang.types.visitors.names.OCTypeNameVisitorBase;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCType
implements OCTypeArgument {
    private static final int IS_CONST = 1;
    private static final int IS_VOLATILE = 2;
    private static final int IS_NULLABLE = 4;
    private static final int IS_NONNULL = 8;
    private static final int IS_NULL_UNSPECIFIED = 16;
    protected static final int IS_FUNCTION_LVALUE_REF = 32;
    protected static final int IS_FUNCTION_RVALUE_REF = 64;
    @Nullable
    protected String myAliasName;
    @Nullable
    private OCType myGuessedType;
    protected int myTypeAttributes;
    private static Pattern requiresNilAttributePattern = Pattern.compile("sentinel.*");

    public OCType() {
    }

    public OCType(boolean isConst, boolean isVolatile) {
        this.myTypeAttributes = (isConst ? 1 : 0) | (isVolatile ? 2 : 0);
    }

    public OCType(boolean isConst, boolean isVolatile, @Nullable OCNullability nullability) {
        this(isConst, isVolatile);
        this.attachNullability(nullability);
    }

    public void compact() {
    }

    public void attachAliasName(@Nullable String aliasName) {
        this.myAliasName = aliasName;
    }

    public void attachGuessedType(@Nullable OCType guessedType) {
        this.myGuessedType = guessedType;
    }

    protected static int clearAttribute(int mask, int attribute) {
        return mask & ~attribute;
    }

    protected static int attachAttribute(int mask, int attribute) {
        return mask | attribute;
    }

    protected boolean checkAttribute(int attribute) {
        return (this.myTypeAttributes & attribute) != 0;
    }

    public void attachNullability(@Nullable OCNullability nullability) {
        int newAttribute = this.myTypeAttributes;
        newAttribute = OCType.clearAttribute(newAttribute, 8);
        newAttribute = OCType.clearAttribute(newAttribute, 4);
        newAttribute = OCType.clearAttribute(newAttribute, 16);
        if (nullability == OCNullability.NONNULL) {
            newAttribute = OCType.attachAttribute(newAttribute, 8);
        } else if (nullability == OCNullability.NULLABLE) {
            newAttribute = OCType.attachAttribute(newAttribute, 4);
        } else if (nullability == OCNullability.UNSPECIFIED) {
            newAttribute = OCType.attachAttribute(newAttribute, 16);
        }
        this.myTypeAttributes = newAttribute;
    }

    @NotNull
    public String getName() {
        String string = this.getShortName(0);
        if (string == null) {
            OCType.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public String getShortName(int templateDepth) {
        return new OCDumbTypeNameVisitor(templateDepth).getName(this);
    }

    @NotNull
    public String getName(@NotNull PsiElement context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(1);
        }
        String string = this.getBestNameInContext(OCResolveContext.forPsi(context), null, 0);
        if (string == null) {
            OCType.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getName(@NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(3);
        }
        String string = this.getBestNameInContext(context, null, 0);
        if (string == null) {
            OCType.$$$reportNull$$$0(4);
        }
        return string;
    }

    public String getBestNameInContext(@NotNull PsiElement context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(5);
        }
        return this.getName(context);
    }

    public String getBestNameInContext(@NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(6);
        }
        return this.getName(context);
    }

    public String getBestNameInContext(@NotNull PsiElement context, @Nullable String nameHint) {
        if (context == null) {
            OCType.$$$reportNull$$$0(7);
        }
        return this.getBestNameInContext(OCResolveContext.forPsi(context), nameHint, 0);
    }

    public String getBestNameInContext(@NotNull OCResolveContext context, @Nullable String nameHint) {
        if (context == null) {
            OCType.$$$reportNull$$$0(8);
        }
        return this.getBestNameInContext(context, nameHint, 0);
    }

    private String getBestNameInContext(@NotNull OCResolveContext context, @Nullable String nameHint, int templateDepth) {
        if (context == null) {
            OCType.$$$reportNull$$$0(9);
        }
        if (nameHint != null && this.equalsAfterResolving(nameHint, context)) {
            return nameHint;
        }
        return new OCTypeNameVisitor(Presentation.BEST, true, true, context, templateDepth).getName(this.resolve(context));
    }

    @NotNull
    public String getCanonicalName(@NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(10);
        }
        String string = new OCTypeNameVisitor(Presentation.FULL, false, true, context, 0).getName(this);
        if (string == null) {
            OCType.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    public String getNameForPresentation(Presentation presentation, @NotNull OCResolveContext context, boolean includeGlobalQualifier, int templateDepth) {
        if (context == null) {
            OCType.$$$reportNull$$$0(12);
        }
        if (presentation == Presentation.BEST) {
            return this.getBestNameInContext(context, null, templateDepth);
        }
        return new OCTypeNameVisitor(Presentation.FULL, false, includeGlobalQualifier, context, templateDepth).getName(this);
    }

    @Nullable
    public String getAliasName() {
        return this.myAliasName;
    }

    public boolean isBetterAliasName(OCType candidateType, String candidateName, String bestAliasName, PsiElement context) {
        if (context != null && candidateName != null && (bestAliasName == null || OCType.getNameComplexity(bestAliasName) > OCType.getNameComplexity(candidateName))) {
            OCType thisType = this;
            if (thisType instanceof OCCppReferenceType) {
                thisType = ((OCCppReferenceType)thisType).getRefType();
            }
            if (candidateType instanceof OCCppReferenceType) {
                candidateType = ((OCCppReferenceType)candidateType).getRefType();
            }
            return thisType.equals(candidateType, OCResolveContext.forPsi(context));
        }
        return false;
    }

    protected static int getNameComplexity(String name2) {
        int complexity = 0;
        for (int i = 0; i < name2.length(); ++i) {
            char symbol = name2.charAt(i);
            if (symbol != ':' && symbol != '<' && symbol != '>') continue;
            ++complexity;
        }
        return complexity;
    }

    @NotNull
    public OCType getGuessedType() {
        OCType oCType = this.myGuessedType != null ? this.myGuessedType : this;
        if (oCType == null) {
            OCType.$$$reportNull$$$0(13);
        }
        return oCType;
    }

    public boolean hasGuessedType() {
        return this.myGuessedType != null;
    }

    public boolean isConst() {
        return (this.myTypeAttributes & 1) != 0;
    }

    public boolean isVolatile() {
        return (this.myTypeAttributes & 2) != 0;
    }

    @Nullable
    public OCNullability getNullability() {
        if (this.checkAttribute(4)) {
            return OCNullability.NULLABLE;
        }
        if (this.checkAttribute(8)) {
            return OCNullability.NONNULL;
        }
        if (this.checkAttribute(16)) {
            return OCNullability.UNSPECIFIED;
        }
        return null;
    }

    @NotNull
    public CVQualifiers getCVQualifiers() {
        CVQualifiers cVQualifiers = CVQualifiers.get(this.isConst(), this.isVolatile());
        if (cVQualifiers == null) {
            OCType.$$$reportNull$$$0(14);
        }
        return cVQualifiers;
    }

    @NotNull
    public OCType getGuessedUnmagicType() {
        OCType oCType = this;
        if (oCType == null) {
            OCType.$$$reportNull$$$0(15);
        }
        return oCType;
    }

    @NotNull
    public OCType cloneWithCVQualifiers(@NotNull CVQualifiers modifiers, @Nullable Project project2) {
        if (modifiers == null) {
            OCType.$$$reportNull$$$0(16);
        }
        if (this.getCVQualifiers() != modifiers) {
            OCType clone = this.getShallowCopy(true, modifiers.isConst(), modifiers.isVolatile());
            if (clone.myAliasName != null) {
                String aliasName = clone.myAliasName;
                aliasName = modifiers.isConst() ? OCTypeNameVisitorBase.addTypeQualifier(aliasName, clone, project2, "const") : OCTypeNameVisitorBase.removeTypeQualifier(aliasName, clone, project2, "const");
                aliasName = modifiers.isVolatile() ? OCTypeNameVisitorBase.addTypeQualifier(aliasName, clone, project2, "volatile") : OCTypeNameVisitorBase.removeTypeQualifier(aliasName, clone, project2, "volatile");
                clone.attachAliasName(aliasName);
            }
            OCType oCType = clone;
            if (oCType == null) {
                OCType.$$$reportNull$$$0(17);
            }
            return oCType;
        }
        OCType oCType = this;
        if (oCType == null) {
            OCType.$$$reportNull$$$0(18);
        }
        return oCType;
    }

    @NotNull
    public OCType cloneWithoutCVQualifiers(@Nullable Project project2) {
        OCType oCType = this.cloneWithCVQualifiers(CVQualifiers.EMPTY, project2);
        if (oCType == null) {
            OCType.$$$reportNull$$$0(19);
        }
        return oCType;
    }

    @NotNull
    public OCType cloneWithAddedCVQualifiers(@NotNull CVQualifiers modifiers, @Nullable Project project2) {
        if (modifiers == null) {
            OCType.$$$reportNull$$$0(20);
        }
        OCType oCType = this.cloneWithCVQualifiers(this.getCVQualifiers().or(modifiers), project2);
        if (oCType == null) {
            OCType.$$$reportNull$$$0(21);
        }
        return oCType;
    }

    @NotNull
    public OCType cloneWithoutConstModifier(@Nullable Project project2) {
        OCType oCType = this.cloneWithCVQualifiers(CVQualifiers.get(false, this.isVolatile()), project2);
        if (oCType == null) {
            OCType.$$$reportNull$$$0(22);
        }
        return oCType;
    }

    @NotNull
    public OCType cloneWithConstModifier(@Nullable Project project2) {
        OCType oCType = this.cloneWithCVQualifiers(CVQualifiers.get(true, this.isVolatile()), project2);
        if (oCType == null) {
            OCType.$$$reportNull$$$0(23);
        }
        return oCType;
    }

    @NotNull
    public OCType cloneWithAliasName(String aliasName) {
        if (!Comparing.equal((String)this.myAliasName, (String)aliasName)) {
            OCType clone = this.getShallowCopy();
            clone.attachAliasName(aliasName);
            OCType oCType = clone;
            if (oCType == null) {
                OCType.$$$reportNull$$$0(24);
            }
            return oCType;
        }
        OCType oCType = this;
        if (oCType == null) {
            OCType.$$$reportNull$$$0(25);
        }
        return oCType;
    }

    @NotNull
    public OCType cloneWithGuessedType(OCType guessedType) {
        if (this.myGuessedType != null || guessedType != null) {
            OCType clone = this.getShallowCopy(true, null, null);
            clone.attachGuessedType(guessedType);
            OCType oCType = clone;
            if (oCType == null) {
                OCType.$$$reportNull$$$0(26);
            }
            return oCType;
        }
        OCType oCType = this;
        if (oCType == null) {
            OCType.$$$reportNull$$$0(27);
        }
        return oCType;
    }

    @NotNull
    public OCType cloneWithNullability(@Nullable OCNullability nullability) {
        if (this.getNullability() != nullability) {
            OCType clone = this.getShallowCopy(true, null, null);
            clone.attachNullability(nullability);
            OCType oCType = clone;
            if (oCType == null) {
                OCType.$$$reportNull$$$0(28);
            }
            return oCType;
        }
        OCType oCType = this;
        if (oCType == null) {
            OCType.$$$reportNull$$$0(29);
        }
        return oCType;
    }

    public OCType getShallowCopy() {
        return this.getShallowCopy(false, null, null);
    }

    private OCType getShallowCopy(boolean keepAliasName, Boolean forcedConst, Boolean forcedVolatile) {
        OCTypeCloneVisitor visitor = new OCTypeCloneVisitor(true, this, forcedConst, forcedVolatile);
        OCType clone = this.transformType(visitor);
        if (!keepAliasName) {
            clone.attachAliasName(null);
        }
        return clone;
    }

    @NotNull
    public OCType resolve(@NotNull PsiElement element) {
        if (element == null) {
            OCType.$$$reportNull$$$0(30);
        }
        OCType oCType = this.resolve(OCResolveContext.forPsi(element));
        if (oCType == null) {
            OCType.$$$reportNull$$$0(31);
        }
        return oCType;
    }

    @NotNull
    public OCType resolve(@NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(32);
        }
        OCType oCType = this.transformType(new OCTypeResolveVisitor(context));
        if (oCType == null) {
            OCType.$$$reportNull$$$0(33);
        }
        return oCType;
    }

    @NotNull
    public OCType resolve(@NotNull PsiElement context, boolean ignoringImports) {
        if (context == null) {
            OCType.$$$reportNull$$$0(34);
        }
        OCType oCType = this.transformType(new OCTypeResolveVisitor(OCResolveContext.forPsi(context), ignoringImports));
        if (oCType == null) {
            OCType.$$$reportNull$$$0(35);
        }
        return oCType;
    }

    @NotNull
    public OCType resolve(@NotNull OCResolveContext context, boolean ignoringImports) {
        if (context == null) {
            OCType.$$$reportNull$$$0(36);
        }
        OCType oCType = this.transformType(new OCTypeResolveVisitor(context, ignoringImports));
        if (oCType == null) {
            OCType.$$$reportNull$$$0(37);
        }
        return oCType;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }

    @NotNull
    public OCType getTerminalType() {
        OCType oCType = this;
        if (oCType == null) {
            OCType.$$$reportNull$$$0(38);
        }
        return oCType;
    }

    @NotNull
    public OCType getArrayElementType() {
        OCType oCType = this;
        if (oCType == null) {
            OCType.$$$reportNull$$$0(39);
        }
        return oCType;
    }

    public int pointersDepth() {
        return 0;
    }

    public boolean isVoid() {
        return false;
    }

    public boolean isUnknown() {
        return false;
    }

    public final boolean isUnresolved(@NotNull PsiElement context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(40);
        }
        return this.isUnresolved(OCResolveContext.forPsi(context));
    }

    public boolean isUnresolved(@NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(41);
        }
        return false;
    }

    public boolean isMagicInside(@NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(42);
        }
        return false;
    }

    public boolean isSubclassOfMagic(@NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(43);
        }
        return false;
    }

    public boolean isScalar() {
        return false;
    }

    public boolean isChar() {
        return false;
    }

    public boolean isScalarOrConvertibleToScalar(@NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(44);
        }
        if (this.isScalar()) {
            return true;
        }
        if (!this.isCppStructType(context)) {
            return false;
        }
        if (this.isIntConvertible(context) || OCIntType.BOOL_NATIVE.isConvertibleByOperator(this, context, true)) {
            return true;
        }
        if (this.isPointerConvertible(context)) {
            return true;
        }
        return this.isEnumOrEnumConvertible(context);
    }

    public boolean isInstanceable() {
        return false;
    }

    public boolean isPointerCompatible(@NotNull OCResolveContext context, boolean checkCppConvertible) {
        if (context == null) {
            OCType.$$$reportNull$$$0(45);
        }
        return !context.isCpp() && this.isIntegerCompatible(context) || checkCppConvertible && this.isCppStructType(context) && this.isPointerConvertible(context);
    }

    public boolean isPointerCompatible(@NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(46);
        }
        return this.isPointerCompatible(context, true);
    }

    public boolean isPointerToString() {
        return "NSString *".equals(this.getName());
    }

    public boolean isPointerToStringCompatible() {
        return this.isPointerToStringCompatible(false);
    }

    public boolean isPointerToStringCompatible(boolean includeMutable) {
        return "NSString *".equals(this.getName()) || "NSString *".equals(OCTollFreeBridges.getNSCounterpart(this.getName())) || includeMutable && ("NSMutableString *".equals(this.getName()) || "NSMutableString *".equals(OCTollFreeBridges.getNSCounterpart(this.getName())));
    }

    public boolean isObjCRootType() {
        String name2 = this.getName();
        return "id".equals(name2) || "NSObject *".equals(name2);
    }

    public boolean isEnumOrEnumConvertible(@NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(47);
        }
        if (!(this instanceof OCStructType)) {
            return false;
        }
        OCStructType that = (OCStructType)this;
        if (that.isEnum()) {
            return true;
        }
        Pair<OCType, OCFunctionSymbol> convertedRes = OCTypeCompatibilityVisitor.convertByOperator(that, false, true, context, (Predicate<OCType>)((Predicate)type -> OCTypeUtils.isEnumType(type)));
        return convertedRes != null;
    }

    private boolean isPointerConvertible(@NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(48);
        }
        return OCPointerType.to(OCVoidType.instance()).isConvertibleByOperator(this, context, false);
    }

    private boolean isIntConvertible(@NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(49);
        }
        return OCIntType.INT.isConvertibleByOperator(this, context, false);
    }

    public boolean isNumberCompatible(@NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(50);
        }
        return this.isCppStructType(context) && OCRealType.DOUBLE.isConvertibleByOperator(this, context, false);
    }

    public boolean isIntegerCompatible(@NotNull OCResolveContext context, boolean checkCppConvertible) {
        if (context == null) {
            OCType.$$$reportNull$$$0(51);
        }
        return checkCppConvertible && this.isCppStructType(context) && this.isIntConvertible(context);
    }

    public boolean isIntegerCompatible(@NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(52);
        }
        return this.isIntegerCompatible(context, true);
    }

    public boolean isPointerToObject() {
        return false;
    }

    public boolean isPointerToObjectCompatible() {
        return this.isPointerToObject() || this.isClassType() || this instanceof OCBlockPointerType;
    }

    public boolean isPointerToPointerToObjectCompatible() {
        return this.isPointerToObjectCompatible() || this instanceof OCPointerType && ((OCPointerType)this).getRefType().isPointerToPointerToObjectCompatible();
    }

    public boolean isPointerToID(boolean withProtocols) {
        return false;
    }

    public boolean isPointerToID() {
        return this.isPointerToID(false);
    }

    public boolean isPointerToChar() {
        return false;
    }

    public boolean isCString() {
        return false;
    }

    public boolean isPointer() {
        return false;
    }

    public boolean isPointerToVoid() {
        return false;
    }

    public boolean isClassType(boolean withProtocols) {
        if (this instanceof OCPointerType) {
            OCType refType = ((OCPointerType)this).getRefType();
            String name2 = refType.getName();
            return (name2.equals("struct objc_class") || name2.equals("objc_class")) && (!withProtocols || refType instanceof OCObjectType && !((OCObjectType)refType).getAugmentedProtocols().isEmpty());
        }
        return false;
    }

    public boolean isClassType() {
        return this.isClassType(false);
    }

    public boolean isCppStructType(@NotNull OCCompilationContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(53);
        }
        return false;
    }

    public boolean isPointerToCppStructType(@NotNull OCCompilationContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(54);
        }
        return false;
    }

    @Override
    public boolean isVariadic() {
        return false;
    }

    @NotNull
    public String getDefaultValue(@NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(55);
        }
        if (this.isPointerToObject()) {
            if ("nil" == null) {
                OCType.$$$reportNull$$$0(56);
            }
            return "nil";
        }
        if (OCCompilerFeatures.supportsNullptr(context.getFile())) {
            if ("nullptr" == null) {
                OCType.$$$reportNull$$$0(57);
            }
            return "nullptr";
        }
        if ("NULL" == null) {
            OCType.$$$reportNull$$$0(58);
        }
        return "NULL";
    }

    public int getSizeInBytes(@Nullable PsiFile file, @Nullable OCInclusionContext context, @NotNull Project project2) {
        if (project2 == null) {
            OCType.$$$reportNull$$$0(59);
        }
        return -1;
    }

    public OCType transformType(OCTypeVisitor<OCType> visitor) {
        OCType result = this.accept(visitor);
        if (result == null) {
            return null;
        }
        if (this.myAliasName != null) {
            result = result.cloneWithAliasName(this.myAliasName);
        }
        if (this.myGuessedType != null) {
            result = result.cloneWithGuessedType(this.myGuessedType);
        }
        if (this.getNullability() != null) {
            result = result.cloneWithNullability(this.getNullability());
        }
        return result;
    }

    public abstract <T> T accept(OCTypeVisitor<T> var1);

    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            OCType.$$$reportNull$$$0(60);
        }
        if (first == null) {
            OCType.$$$reportNull$$$0(61);
        }
        if (second == null) {
            OCType.$$$reportNull$$$0(62);
        }
        OCType f = (OCType)first;
        OCType s = (OCType)second;
        if (f.myTypeAttributes != s.myTypeAttributes) {
            return false;
        }
        if (!Comparing.equal((String)f.myAliasName, (String)s.myAliasName)) {
            return false;
        }
        return c.equalObjects(f.myGuessedType, s.myGuessedType);
    }

    public boolean equals(Object o) {
        throw new UnsupportedOperationException("Use equals(Object o, @NotNull OCResolveContext context) instead");
    }

    @Override
    public boolean equals(Object o, @NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(63);
        }
        return this.equals(o, true, context);
    }

    public boolean equals(Object o, boolean checkCV, @NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(64);
        }
        return o instanceof OCType && new OCTypeEqualityVisitor((OCType)o, false, !checkCV, context).equal(this);
    }

    protected int baseHashCode() {
        int result = this.myAliasName != null ? this.myAliasName.hashCode() : 0;
        result = 31 * result + (this.myGuessedType != null ? this.myGuessedType.hashCode() : 0);
        result = 31 * result + this.myTypeAttributes;
        return result;
    }

    public int hashCode() {
        OCLog.LOG.warn("An attempt to get hashCode for OCType base class!");
        return 0;
    }

    public boolean equalsAfterResolving(String typeName, @NotNull OCResolveContext context) {
        PsiElement element;
        if (context == null) {
            OCType.$$$reportNull$$$0(65);
        }
        return (element = context.getElement()) != null && this.equalsAfterResolving(OCElementUtil.getType(OCElementFactory.typeCodeFragment(typeName, element)), context, true);
    }

    public boolean equalsAfterResolving(OCType type, @NotNull OCResolveContext context, boolean magicTypeEquals) {
        if (context == null) {
            OCType.$$$reportNull$$$0(66);
        }
        OCType thisType = this;
        if (type == null) {
            return false;
        }
        if (thisType instanceof OCCppReferenceType) {
            thisType = ((OCCppReferenceType)thisType).getRefType();
        }
        if (type instanceof OCCppReferenceType) {
            type = ((OCCppReferenceType)type).getRefType();
        }
        return new OCTypeEqualityAfterResolvingVisitor(type, false, magicTypeEquals, true, true, context).equal(thisType);
    }

    public boolean equalsAfterResolving(OCType type, @NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(67);
        }
        return new OCTypeEqualityAfterResolvingVisitor(type, false, context).equal(this);
    }

    public boolean equalsWithAliasName(OCType type, @NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(68);
        }
        String thisAliasName = this.getAliasName();
        String typeAliasName = type.getAliasName();
        if (thisAliasName == null) {
            thisAliasName = this.getCanonicalName(context);
        }
        if (typeAliasName == null) {
            typeAliasName = type.getCanonicalName(context);
        }
        return Comparing.equal((String)thisAliasName, (String)typeAliasName) && this.equalsAfterResolving(type, context);
    }

    @Deprecated
    @NotNull
    public OCType getLeastCommonType(OCType type, @NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(69);
        }
        if (type == null) {
            OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
            if (oCUnknownType == null) {
                OCType.$$$reportNull$$$0(70);
            }
            return oCUnknownType;
        }
        OCType result = this.doGetLeastCommonType(type, context);
        result = result.cloneWithAddedCVQualifiers(this.getCVQualifiers().or(type.getCVQualifiers()), context.getProject());
        OCType oCType = result = OCType.updateWithCommonGuessedType(this, type, result, context);
        if (oCType == null) {
            OCType.$$$reportNull$$$0(71);
        }
        return oCType;
    }

    @NotNull
    public static OCType updateWithCommonGuessedType(OCType type1, OCType type2, OCType result, @NotNull OCResolveContext context) {
        OCType commonGuessedType;
        if (context == null) {
            OCType.$$$reportNull$$$0(72);
        }
        if (!(type1.myGuessedType == null || type2.myGuessedType == null || (commonGuessedType = type1.myGuessedType.doGetLeastCommonType(type2.myGuessedType, context)).isUnknown() || !result.isPointerToID() && commonGuessedType.isCompatible(result, context))) {
            OCType oCType = result.cloneWithGuessedType(commonGuessedType);
            if (oCType == null) {
                OCType.$$$reportNull$$$0(73);
            }
            return oCType;
        }
        OCType oCType = result;
        if (oCType == null) {
            OCType.$$$reportNull$$$0(74);
        }
        return oCType;
    }

    @NotNull
    protected OCType doGetLeastCommonType(OCType type, @NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(75);
        }
        OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
        if (oCUnknownType == null) {
            OCType.$$$reportNull$$$0(76);
        }
        return oCUnknownType;
    }

    @NotNull
    public OCTypeCheckResult checkCompatible(OCType type, @Nullable OCTypeOwner expression, @Nullable PsiElement context, @NotNull OCResolveContext resolveContext) {
        if (resolveContext == null) {
            OCType.$$$reportNull$$$0(77);
        }
        OCTypeCheckResult oCTypeCheckResult = this.checkCompatible(type, expression, context, true, resolveContext);
        if (oCTypeCheckResult == null) {
            OCType.$$$reportNull$$$0(78);
        }
        return oCTypeCheckResult;
    }

    @NotNull
    public OCTypeCheckResult checkCompatible(OCType type, @Nullable OCTypeOwner expression, @Nullable PsiElement context, boolean allowImplicitConversions, @NotNull OCResolveContext resolveContext) {
        if (resolveContext == null) {
            OCType.$$$reportNull$$$0(79);
        }
        OCTypeCheckResult oCTypeCheckResult = OCTypeCompatibilityVisitor.checkConvertible(this, type, expression, context, allowImplicitConversions, allowImplicitConversions, resolveContext);
        if (oCTypeCheckResult == null) {
            OCType.$$$reportNull$$$0(80);
        }
        return oCTypeCheckResult;
    }

    public boolean isConvertibleByOperator(OCType type, @NotNull OCResolveContext context, boolean isExplicitCast) {
        if (context == null) {
            OCType.$$$reportNull$$$0(81);
        }
        if (type instanceof OCCppReferenceType) {
            type = ((OCCppReferenceType)type).getRefType();
        }
        if (type instanceof OCStructType) {
            OCTypeCheckResult error = new OCTypeCheckResult(OCTypeCheckState.ERROR);
            PsiElement element = context.getElement();
            return !OCTypeCompatibilityVisitor.checkConversionOperators(this, (OCStructType)type, null, element, error, isExplicitCast, context).getState().isError(element);
        }
        return false;
    }

    public boolean isCompatible(OCType type, @NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(82);
        }
        return this.checkCompatible(type, null, context.getElement(), true, context).getState() == OCTypeCheckState.OK;
    }

    public boolean isSuperType(OCType type, @NotNull PsiElement context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(83);
        }
        OCResolveContext resolveContext = OCResolveContext.forPsi(context);
        OCType self = this.resolve(resolveContext);
        type = type.resolve(resolveContext);
        if (self.isPointerToObject() && type.isPointerToObject()) {
            return self.isCompatible(type, resolveContext);
        }
        if (self.isCppStructType(resolveContext) && type.isCppStructType(resolveContext)) {
            return OCTypeUtils.isSameOrDerivedFrom(type, self, resolveContext) && this.getCVQualifiers() == type.getCVQualifiers();
        }
        if (type instanceof OCArrayType && this instanceof OCPointerType) {
            OCType refType = ((OCPointerType)this).getRefType().resolve(resolveContext);
            OCType typeRefType = ((OCArrayType)type).getRefType().resolve(resolveContext);
            if (refType.isPointerToID() && typeRefType.isPointerToID()) {
                return true;
            }
        }
        return self.equalsAfterResolving(type, resolveContext);
    }

    @Nullable
    public String getFormatString() {
        return null;
    }

    public static boolean isFunctionRequiringNil(OCSymbol<?> callable) {
        for (String attribute : callable.getAttributes()) {
            Matcher matcher = requiresNilAttributePattern.matcher(attribute);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 16: 
            case 20: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 72: 
            case 75: 
            case 77: 
            case 79: 
            case 81: 
            case 82: 
            case 83: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 16: 
            case 20: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 72: 
            case 75: 
            case 77: 
            case 79: 
            case 81: 
            case 82: 
            case 83: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/types/OCType";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 32: 
            case 34: 
            case 36: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 72: 
            case 75: 
            case 81: 
            case 82: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiers";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 77: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 16: 
            case 20: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 72: 
            case 75: 
            case 77: 
            case 79: 
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/types/OCType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getGuessedType";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCVQualifiers";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getGuessedUnmagicType";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneWithCVQualifiers";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneWithoutCVQualifiers";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneWithAddedCVQualifiers";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneWithoutConstModifier";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneWithConstModifier";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneWithAliasName";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneWithGuessedType";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneWithNullability";
                break;
            }
            case 31: 
            case 33: 
            case 35: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getTerminalType";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayElementType";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeastCommonType";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "updateWithCommonGuessedType";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetLeastCommonType";
                break;
            }
            case 78: 
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "checkCompatible";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getBestNameInContext";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicalName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getNameForPresentation";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "cloneWithCVQualifiers";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "cloneWithAddedCVQualifiers";
                break;
            }
            case 30: 
            case 32: 
            case 34: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isUnresolved";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isMagicInside";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isSubclassOfMagic";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isScalarOrConvertibleToScalar";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isPointerCompatible";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isEnumOrEnumConvertible";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isPointerConvertible";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isIntConvertible";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isNumberCompatible";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isIntegerCompatible";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isCppStructType";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "isPointerToCppStructType";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultValue";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getSizeInBytes";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "equals";
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "equalsAfterResolving";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "equalsWithAliasName";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getLeastCommonType";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "updateWithCommonGuessedType";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "doGetLeastCommonType";
                break;
            }
            case 77: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "checkCompatible";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "isConvertibleByOperator";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "isCompatible";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "isSuperType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 16: 
            case 20: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 72: 
            case 75: 
            case 77: 
            case 79: 
            case 81: 
            case 82: 
            case 83: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Presentation {
        FULL,
        BEST;

    }
}

