/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class OCMultiTypeSubstitution
extends OCTypeSubstitution {
    private List<OCSimpleTypeSubstitution> mySubstitutions;

    public OCMultiTypeSubstitution(List<OCSimpleTypeSubstitution> substitutions) {
        this.mySubstitutions = substitutions;
    }

    @Override
    public OCType substitute(@NotNull OCType type, final boolean overwriteSubstitution, final @NotNull OCResolveContext context) {
        if (type == null) {
            OCMultiTypeSubstitution.$$$reportNull$$$0(0);
        }
        if (context == null) {
            OCMultiTypeSubstitution.$$$reportNull$$$0(1);
        }
        return type.accept(new OCTypeSubstitution.TypeSubstituteVisitor(this, overwriteSubstitution, context){

            @Override
            public OCType visitTypeParameterType(OCTypeParameterType type) {
                OCType partiallySubstitutedType = null;
                for (OCSimpleTypeSubstitution substitution : OCMultiTypeSubstitution.this.mySubstitutions) {
                    if (partiallySubstitutedType != null) {
                        partiallySubstitutedType = substitution.substitute(partiallySubstitutedType, context);
                        continue;
                    }
                    OCTypeArgument arg = substitution.getSubstitutionFor(type.getSymbol());
                    if (arg == null) continue;
                    if (arg instanceof OCType) {
                        if (arg instanceof OCReferenceType) {
                            OCReferenceType result = OCTypeSubstitution.substituteReferenceType((OCReferenceType)arg, OCMultiTypeSubstitution.this, overwriteSubstitution, context);
                            return result.cloneWithAddedCVQualifiers(type.getCVQualifiers(), context.getProjectOrNull());
                        }
                        partiallySubstitutedType = (OCType)arg;
                        continue;
                    }
                    return new OCMagicType(arg.getNameForPresentation(OCType.Presentation.FULL, context, true, 0));
                }
                return partiallySubstitutedType != null ? partiallySubstitutedType.cloneWithAddedCVQualifiers(type.getCVQualifiers(), context.getProjectOrNull()) : type;
            }
        });
    }

    @Override
    public Collection<OCTypeArgument> getSubstitutedTypes() {
        Set<OCTypeArgument> arguments = OCTypeUtils.newTypeSet();
        for (OCSimpleTypeSubstitution substitution : this.mySubstitutions) {
            arguments.addAll(substitution.getSubstitutedTypes());
        }
        return arguments;
    }

    @Override
    public boolean processSubstitutions(Processor<Map.Entry<OCTypeParameterSymbol, OCTypeArgument>> processor2) {
        for (OCSimpleTypeSubstitution substitution : this.mySubstitutions) {
            if (substitution.processSubstitutions(processor2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public OCTypeArgument getSubstitutionFor(@NotNull OCTypeParameterSymbol argument) {
        if (argument == null) {
            OCMultiTypeSubstitution.$$$reportNull$$$0(2);
        }
        for (OCTypeSubstitution oCTypeSubstitution : this.mySubstitutions) {
            OCTypeArgument result = oCTypeSubstitution.getSubstitutionFor(argument);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public boolean hasSubstitutionForName(@NotNull String name2) {
        if (name2 == null) {
            OCMultiTypeSubstitution.$$$reportNull$$$0(3);
        }
        for (OCTypeSubstitution oCTypeSubstitution : this.mySubstitutions) {
            if (!oCTypeSubstitution.hasSubstitutionForName(name2)) continue;
            return true;
        }
        return false;
    }

    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            OCMultiTypeSubstitution.$$$reportNull$$$0(4);
        }
        if (first == null) {
            OCMultiTypeSubstitution.$$$reportNull$$$0(5);
        }
        if (second == null) {
            OCMultiTypeSubstitution.$$$reportNull$$$0(6);
        }
        OCMultiTypeSubstitution f = (OCMultiTypeSubstitution)first;
        OCMultiTypeSubstitution s = (OCMultiTypeSubstitution)second;
        return c.equalLists(f.mySubstitutions, s.mySubstitutions);
    }

    @Override
    public OCTypeSubstitution getMinimalDependentSubstitution(Object reference, @NotNull OCResolveContext context) {
        if (context == null) {
            OCMultiTypeSubstitution.$$$reportNull$$$0(7);
        }
        HashMap<OCTypeParameterSymbol, OCTypeArgument> map2 = new HashMap<OCTypeParameterSymbol, OCTypeArgument>();
        THashMap unusedSubstitutions = new THashMap();
        ArrayList<Object> workset = new ArrayList<Object>();
        workset.add(reference);
        for (OCSimpleTypeSubstitution substitution : this.mySubstitutions) {
            unusedSubstitutions.putAll(substitution.getSubstitutions());
        }
        while (!workset.isEmpty()) {
            ArrayList<OCTypeArgument> newWorkset = new ArrayList<OCTypeArgument>();
            THashSet keysToRemove = new THashSet();
            for (OCTypeParameterSymbol key : unusedSubstitutions.keySet()) {
                OCTypeArgument value;
                if (!new OCSimpleTypeSubstitution(Collections.singletonMap(key, value = (OCTypeArgument)unusedSubstitutions.get(key))).dependsOn(workset, context)) continue;
                map2.put(key, value);
                newWorkset.add(value);
                keysToRemove.add(key);
            }
            for (OCTypeParameterSymbol key : keysToRemove) {
                unusedSubstitutions.remove(key);
            }
            workset = newWorkset;
        }
        return map2.isEmpty() ? ID : new OCSimpleTypeSubstitution(map2);
    }

    public String toString() {
        Function converter = substitution -> substitution.substList();
        return "{" + StringUtil.join((Collection)ContainerUtil.map(this.mySubstitutions, (Function)converter), (String)" // ") + "}";
    }

    public int hashCode() {
        return this.mySubstitutions != null ? this.mySubstitutions.hashCode() : 0;
    }

    public List<OCSimpleTypeSubstitution> getSubstitutions() {
        return this.mySubstitutions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/types/visitors/OCMultiTypeSubstitution";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "substitute";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSubstitutionFor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hasSubstitutionForName";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "deepEqualStep";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getMinimalDependentSubstitution";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

