/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTypeIntentionAction;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeCheckResult;
import com.jetbrains.cidr.lang.types.OCTypeCheckResultBuilder;
import com.jetbrains.cidr.lang.types.OCTypeCheckState;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCTypeCompatibilityVisitor_OCFunctionType
extends OCTypeCompatibilityVisitor<OCFunctionType> {
    protected OCTypeCompatibilityVisitor_OCFunctionType(@NotNull OCFunctionType sourceType, @Nullable OCTypeOwner source, @Nullable PsiElement context, boolean allowImplicitConversions, boolean assumeNullSubstitutionsEquals, @NotNull OCResolveContext resolveContext) {
        if (sourceType == null) {
            OCTypeCompatibilityVisitor_OCFunctionType.$$$reportNull$$$0(0);
        }
        if (resolveContext == null) {
            OCTypeCompatibilityVisitor_OCFunctionType.$$$reportNull$$$0(1);
        }
        super(sourceType, source, context, allowImplicitConversions, assumeNullSubstitutionsEquals, resolveContext);
    }

    @Override
    public OCTypeCheckResult visitFunctionType(final OCFunctionType type) {
        final OCFunctionType functionType = (OCFunctionType)this.mySourceType;
        if (!this.isSuperTypeForFunctionChecks(type.getReturnType(), functionType.getReturnType())) {
            IntentionAction[] intentionActionArray;
            OCTypeElement annotationElement = null;
            OCSymbol blockSymbol = null;
            if (this.mySource instanceof OCBlockExpression) {
                annotationElement = ((OCBlockExpression)this.mySource).getReturnTypeElement();
                blockSymbol = ((OCBlockExpression)this.mySource).getSymbol();
            }
            if (blockSymbol == null) {
                intentionActionArray = new OCChangeTypeIntentionAction[]{};
            } else {
                OCChangeTypeIntentionAction[] oCChangeTypeIntentionActionArray = new OCChangeTypeIntentionAction[1];
                intentionActionArray = oCChangeTypeIntentionActionArray;
                oCChangeTypeIntentionActionArray[0] = new OCChangeTypeIntentionAction(blockSymbol, type.getReturnType(), true, (OCCompilationContext)this.myResolveContext);
            }
            IntentionAction[] actions = intentionActionArray;
            return new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP, OCInspections.IncompatiblePointers.class, "ext_typecheck_convert_incompatible_pointer", annotationElement, actions){

                @Override
                public String getMessage() {
                    return "Incompatible function return types '" + type.getReturnType().getName(OCTypeCompatibilityVisitor_OCFunctionType.this.myResolveContext) + "' and '" + functionType.getReturnType().getName(OCTypeCompatibilityVisitor_OCFunctionType.this.myResolveContext) + "'";
                }
            };
        }
        if (OCCodeInsightUtil.isInPlainOldC((PsiElement)this.myResolveContext.getFile()) && type.getParameterTypes(true).isEmpty()) {
            return OCTypeCheckResultBuilder.createOK();
        }
        if (type.getParameterTypes().size() != functionType.getParameterTypes().size()) {
            return new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP, "Incompatible number of arguments in function types", OCInspections.IncompatiblePointers.class, "CIDRincompatible-function-pointer-arguments", new IntentionAction[0]);
        }
        for (int i = 0; i < type.getParameterTypes().size(); ++i) {
            IntentionAction[] intentionActionArray;
            List<OCDeclarator> parameters;
            final OCType selfArgumentType = type.getParameterTypes().get(i);
            final OCType hisArgumentType = functionType.getParameterTypes().get(i);
            if (this.isSuperTypeForFunctionChecks(hisArgumentType, selfArgumentType)) continue;
            PsiElement annotationElement = null;
            OCSymbol parameterSymbol = null;
            if (this.mySource instanceof OCBlockExpression && (parameters = ((OCBlockExpression)this.mySource).getParameters()) != null && parameters.size() == type.getParameterTypes().size()) {
                parameterSymbol = parameters.get(i).getSymbol();
                annotationElement = parameters.get(i).getParent();
            }
            if (parameterSymbol == null) {
                intentionActionArray = new OCChangeTypeIntentionAction[]{};
            } else {
                OCChangeTypeIntentionAction[] oCChangeTypeIntentionActionArray = new OCChangeTypeIntentionAction[1];
                intentionActionArray = oCChangeTypeIntentionActionArray;
                oCChangeTypeIntentionActionArray[0] = new OCChangeTypeIntentionAction(parameterSymbol, selfArgumentType, this.myResolveContext);
            }
            IntentionAction[] actions = intentionActionArray;
            return new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP, OCInspections.IncompatiblePointers.class, "CIDRincompatible-function-pointer-arguments", annotationElement, actions){

                @Override
                public String getMessage() {
                    return "Incompatible function parameter types '" + selfArgumentType.getName(OCTypeCompatibilityVisitor_OCFunctionType.this.myResolveContext) + "' and '" + hisArgumentType.getName(OCTypeCompatibilityVisitor_OCFunctionType.this.myResolveContext) + "'";
                }
            };
        }
        return OCTypeCheckResultBuilder.createOK();
    }

    @Override
    public OCTypeCheckResult visitObjectType(OCObjectType type) {
        return this.visitType(type);
    }

    @Override
    public OCTypeCheckResult visitPointerType(final OCPointerType type) {
        OCTypeCheckResult result;
        OCType lTerminalType = type.getTerminalType();
        if (!lTerminalType.isUnknown() && !(lTerminalType instanceof OCFunctionType) && type.isPointerToPointerToObjectCompatible() && OCCompilerFeatures.isArcEnabled(this.myContext.getContainingFile()) && (result = this.checkArcBridgeCast(type, false)) != null) {
            return result;
        }
        boolean isCpp = ((OCFile)this.myContext.getContainingFile()).isCpp();
        if (type.getRefType() instanceof OCFunctionType && !(type instanceof OCBlockPointerType)) {
            return type.getRefType().checkCompatible(this.mySourceType, this.mySource, this.myContext, this.myResolveContext);
        }
        if (type.isPointerToVoid() && !isCpp) {
            return OCTypeCheckResultBuilder.createOK();
        }
        return new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP, OCInspections.IncompatiblePointers.class, "ext_typecheck_convert_incompatible_pointer", new IntentionAction[0]){

            @Override
            public String getMessage() {
                return "Incompatible pointer types '" + type.getName(OCTypeCompatibilityVisitor_OCFunctionType.this.myResolveContext) + "' and '" + OCTypeCompatibilityVisitor_OCFunctionType.this.getSourceTypeName() + "'";
            }
        };
    }

    @Override
    public OCTypeCheckResult visitStructType(OCStructType type) {
        if (type.getKind() == OCSymbolKind.ENUM && !type.isEnumClass()) {
            Computable message = () -> "Taking enum type '" + type.getBestNameInContext(this.myResolveContext) + "' from pointer";
            return this.checkAssignToEnum(type, (Computable<String>)message);
        }
        return this.checkStructCompatibleCtor(type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "sourceType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "resolveContext";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor_OCFunctionType";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

