/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.quickfixes.OCSetSuperclassIntentionAction;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCTollFreeBridges;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeCheckResult;
import com.jetbrains.cidr.lang.types.OCTypeCheckResultBuilder;
import com.jetbrains.cidr.lang.types.OCTypeCheckState;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCTypeCompatibilityVisitor_OCStructType
extends OCTypeCompatibilityVisitor<OCStructType> {
    protected OCTypeCompatibilityVisitor_OCStructType(@NotNull OCStructType sourceType, @Nullable OCTypeOwner source, @Nullable PsiElement context, boolean allowImplicitConversions, boolean assumeNullSubstitutionsEquals, @NotNull OCResolveContext resolveContext) {
        if (sourceType == null) {
            OCTypeCompatibilityVisitor_OCStructType.$$$reportNull$$$0(0);
        }
        if (resolveContext == null) {
            OCTypeCompatibilityVisitor_OCStructType.$$$reportNull$$$0(1);
        }
        super(sourceType, source, context, allowImplicitConversions, assumeNullSubstitutionsEquals, resolveContext);
    }

    @Override
    public OCTypeCheckResult visitFunctionType(final OCFunctionType type) {
        if (((OCStructType)this.mySourceType).isIntegerCompatible(this.myResolveContext, false)) {
            String message = "Taking pointer from integer without a cast";
            return new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP, "Taking pointer from integer without a cast", OCInspections.ImplicitPointerAndIntegerConversion.class, "ext_typecheck_convert_int_pointer", new IntentionAction[0]);
        }
        if (((OCStructType)this.mySourceType).getKind() == OCSymbolKind.ENUM && !((OCStructType)this.mySourceType).isEnumClass()) {
            return new OCTypeCheckResult(OCTypeCheckState.WARNING, OCInspections.ImplicitIntegerAndEnumConversion.class, "CIDR", new IntentionAction[0]){

                @Override
                public String getMessage() {
                    return "Taking integer from enum type '" + OCTypeCompatibilityVisitor_OCStructType.this.getSourceTypeName() + "'";
                }
            };
        }
        if (((OCStructType)this.mySourceType).isPointerCompatible(this.myResolveContext, false)) {
            return new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP, OCInspections.IncompatiblePointers.class, "ext_typecheck_convert_incompatible_pointer", new IntentionAction[0]){

                @Override
                public String getMessage() {
                    return "Incompatible pointer types '" + type.getName(OCTypeCompatibilityVisitor_OCStructType.this.myResolveContext) + "' and '" + OCTypeCompatibilityVisitor_OCStructType.this.getSourceTypeName() + "'";
                }
            };
        }
        return this.visitType(type);
    }

    @Override
    public OCTypeCheckResult visitObjectType(OCObjectType type) {
        return this.visitType(type);
    }

    @Override
    public OCTypeCheckResult visitPointerType(final OCPointerType type) {
        OCTypeCheckResult result;
        OCType lTerminalType = type.getTerminalType();
        if (((OCStructType)this.mySourceType).isPointerCompatible(this.myResolveContext, false) && !lTerminalType.isUnknown() && type.isPointerToPointerToObjectCompatible() ^ ((OCStructType)this.mySourceType).isPointerToPointerToObjectCompatible() && OCCompilerFeatures.isArcEnabled(this.myContext.getContainingFile()) && (result = this.checkArcBridgeCast(type, false)) != null) {
            return result;
        }
        boolean isCpp = this.myResolveContext.isCpp();
        if (((OCStructType)this.mySourceType).isIntegerCompatible(this.myResolveContext, false)) {
            return new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP, "Taking pointer from integer without a cast", OCInspections.ImplicitPointerAndIntegerConversion.class, "ext_typecheck_convert_int_pointer", new IntentionAction[0]);
        }
        if (type.isPointerToVoid() && ((OCStructType)this.mySourceType).isPointerCompatible(this.myResolveContext, this.myAllowImplicitConversions) && !isCpp) {
            return OCTypeCheckResultBuilder.createOK();
        }
        if (((OCStructType)this.mySourceType).isPointerCompatible(this.myResolveContext, false)) {
            return new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP, OCInspections.IncompatiblePointers.class, "ext_typecheck_convert_incompatible_pointer", new IntentionAction[0]){

                @Override
                public String getMessage() {
                    return "Incompatible pointer types '" + type.getName(OCTypeCompatibilityVisitor_OCStructType.this.myResolveContext) + "' and '" + OCTypeCompatibilityVisitor_OCStructType.this.getSourceTypeName() + "'";
                }
            };
        }
        return this.visitType(type);
    }

    @Override
    protected OCTypeCheckResult checkRefType(OCCppReferenceType type) {
        OCTypeCheckResult result = super.checkRefType(type);
        if (this.myContext instanceof OCCastExpression && result.getState().isError(this.myContext) && this.isCppClassType(type.getTerminalType()) && ((OCFile)this.myContext.getContainingFile()).isCpp() && ((OCStructType)this.mySourceType).getKind() == OCSymbolKind.STRUCT) {
            result.setState(OCTypeCheckState.WARNING);
        }
        return result;
    }

    @Override
    public OCTypeCheckResult visitStructType(final OCStructType type) {
        OCFunctionDefinition declaringFun;
        if (OCTollFreeBridges.isCompatible(this.mySourceType, type)) {
            return OCTypeCheckResultBuilder.createOK();
        }
        if (type.getKind() == OCSymbolKind.ENUM) {
            if (((OCStructType)this.mySourceType).getKind() == OCSymbolKind.ENUM) {
                if (((OCStructType)this.mySourceType).equals(type, false, this.myResolveContext)) {
                    return OCTypeCheckResultBuilder.createOK();
                }
                return new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP, OCInspections.IncompatibleEnums.class, "warn_impcast_different_enum_types", new IntentionAction[0]){

                    @Override
                    public String getMessage() {
                        return "Incompatible enum types '" + type.getBestNameInContext(OCTypeCompatibilityVisitor_OCStructType.this.myResolveContext) + "' and '" + OCTypeCompatibilityVisitor_OCStructType.this.getSourceTypeName() + "'";
                    }
                };
            }
            Computable message = null;
            if (((OCStructType)this.mySourceType).isIntegerCompatible(this.myResolveContext, false)) {
                message = () -> "Taking enum type '" + type.getBestNameInContext(this.myResolveContext) + "' from integer";
            } else if (!type.isEnumClass() && ((OCStructType)this.mySourceType).isPointerCompatible(this.myResolveContext, false)) {
                message = () -> "Taking enum type '" + type.getBestNameInContext(this.myResolveContext) + "' from pointer";
            }
            if (message != null) {
                return this.checkAssignToEnum(type, (Computable<String>)message);
            }
        }
        OCFunctionSymbol declaringSymbol = (declaringFun = (OCFunctionDefinition)PsiTreeUtil.getParentOfType((PsiElement)this.myContext, OCFunctionDefinition.class)) != null ? declaringFun.getSymbol() : null;
        boolean isFunctionReturnTypeContext = this.myContext.getParent() instanceof OCFunctionDeclaration && ((OCFunctionDeclaration)this.myContext.getParent()).getReturnTypeElement() == this.myContext;
        for (final OCStructSymbol struct : type.getStructs()) {
            OCTypeCheckResult result = this.processTransparentUnion(struct, type);
            if (result != null) {
                return result;
            }
            if (this.myIsSecondStepOfCopyInit) {
                if (new OCTypeEqualityVisitor(type, true, true, this.myResolveContext).equal(this.mySourceType)) {
                    return OCTypeCheckResultBuilder.createOK();
                }
            } else if (this.myAllowImplicitConversions) {
                result = OCTypeCompatibilityVisitor_OCStructType.processConstructors(struct, this.mySourceType, this.mySource, this.myContext, this.myResolveContext, this.myIsCopyInitWithSameClass);
            }
            if (((OCFile)this.myContext.getContainingFile()).isCpp() && ((OCStructType)this.mySourceType).getKind() == OCSymbolKind.STRUCT && this.isCppClassType(type)) {
                boolean isInsideClass = declaringSymbol != null && declaringSymbol.getResolvedOwner(this.myResolveContext) instanceof OCStructSymbol && struct.isAncestor((OCStructSymbol)declaringSymbol.getResolvedOwner(this.myResolveContext), this.myResolveContext);
                for (final OCStructSymbol symbol : ((OCStructType)this.mySourceType).getStructs()) {
                    final Ref visibilityRef = new Ref();
                    if (!symbol.processAllBaseClasses(OCResolveContext.forPsi(this.myContext), (baseSymbol, visibility) -> {
                        if (baseSymbol instanceof OCStructSymbol && ((OCStructSymbol)baseSymbol).resolvedNamesEqual(struct) || baseSymbol instanceof OCTypeParameterSymbol) {
                            visibilityRef.set((Object)visibility);
                            return false;
                        }
                        return true;
                    }, isInsideClass)) {
                        if (!isFunctionReturnTypeContext && (!isInsideClass && visibilityRef.get() != OCVisibility.PUBLIC || visibilityRef.get() == OCVisibility.PRIVATE)) {
                            if (result == null) {
                                result = new OCTypeCheckResult(OCTypeCheckState.ERROR, OCInspections.MemberVisibility.class, "err_typecheck_convert_incompatible", new IntentionAction[]{new OCSetSuperclassIntentionAction(symbol, struct, OCVisibility.PUBLIC, this.myResolveContext), this.getNewConstructorFix(struct)}){

                                    @Override
                                    public String getMessage() {
                                        return struct.getKindUppercase(OCTypeCompatibilityVisitor_OCStructType.this.myResolveContext) + " '" + type.getBestNameInContext(OCTypeCompatibilityVisitor_OCStructType.this.myResolveContext) + "' is a " + visibilityRef.toString() + " base class of " + symbol.getKindLowercase(OCTypeCompatibilityVisitor_OCStructType.this.myResolveContext) + " '" + OCTypeCompatibilityVisitor_OCStructType.this.getSourceTypeName() + "'";
                                    }
                                };
                            }
                        } else {
                            return result != null ? result : OCTypeCheckResultBuilder.createOK();
                        }
                    }
                    if (result != null) continue;
                    result = new OCTypeCheckResult(OCTypeCheckState.ERROR, OCInspections.NotSuperclass.class, "err_ovl_no_viable_oper", new IntentionAction[]{new OCSetSuperclassIntentionAction(symbol, struct, OCVisibility.PUBLIC, this.myResolveContext), this.getNewConstructorFix(struct)}){

                        @Override
                        public String getMessage() {
                            return symbol.getKindUppercase(OCTypeCompatibilityVisitor_OCStructType.this.myResolveContext) + " '" + OCTypeCompatibilityVisitor_OCStructType.this.getSourceTypeName() + "' is not compatible with " + struct.getKindLowercase(OCTypeCompatibilityVisitor_OCStructType.this.myResolveContext) + " '" + type.getBestNameInContext(OCTypeCompatibilityVisitor_OCStructType.this.myResolveContext) + "'";
                        }
                    };
                }
            }
            if (result == null) continue;
            return result;
        }
        OCTypeCheckResult result = this.visitType(type);
        if (!result.getState().isOK() && this.isCppClassType(type)) {
            result.addQuickFix(this.getNewConstructorFix(type.getSymbol()));
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "sourceType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "resolveContext";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor_OCStructType";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

