/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.openapi.util.Comparing;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCTollFreeBridges;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class OCTypeEqualityAfterResolvingVisitor
extends OCTypeEqualityVisitor {
    private final boolean myAssumeNotResolvedTypesEquals;
    private final boolean myAssumeMagicTypesEquals;
    private final boolean myAssumeTollFreeTypesEquals;

    public OCTypeEqualityAfterResolvingVisitor(OCType type, boolean assumeNotResolvedTypeEquals, boolean assumeMagicTypeEquals, boolean assumeConstValueEquals, boolean assumeTollFreeTypesEquals, @NotNull OCResolveContext context) {
        if (context == null) {
            OCTypeEqualityAfterResolvingVisitor.$$$reportNull$$$0(0);
        }
        super(type, true, assumeConstValueEquals, context);
        this.myAssumeNotResolvedTypesEquals = assumeNotResolvedTypeEquals;
        this.myAssumeMagicTypesEquals = assumeMagicTypeEquals;
        this.myAssumeTollFreeTypesEquals = assumeTollFreeTypesEquals;
    }

    public OCTypeEqualityAfterResolvingVisitor(OCType type, boolean assumeNotResolvedTypeEquals, @NotNull OCResolveContext context) {
        if (context == null) {
            OCTypeEqualityAfterResolvingVisitor.$$$reportNull$$$0(1);
        }
        this(type, assumeNotResolvedTypeEquals, false, false, true, context);
    }

    @Override
    public boolean equal(OCType type, boolean checkCV) {
        if (this.myAssumeMagicTypesEquals && (this.myType instanceof OCMagicType || type instanceof OCMagicType || this.myType instanceof OCAutoType || type instanceof OCAutoType)) {
            return true;
        }
        this.myType = this.myType.resolve(this.myContext);
        OCType resolvedType = type.resolve(this.myContext);
        if (checkCV && this.myType.isConst() != type.isConst()) {
            return false;
        }
        if (checkCV && this.myType.isVolatile() != type.isVolatile()) {
            return false;
        }
        if (this.myType instanceof OCUnknownType || resolvedType instanceof OCUnknownType) {
            return true;
        }
        if (this.myAssumeNotResolvedTypesEquals && (this.myType instanceof OCReferenceType || resolvedType instanceof OCReferenceType)) {
            return true;
        }
        if (this.myType instanceof OCTypeParameterType && resolvedType instanceof OCTypeParameterType) {
            return true;
        }
        if (this.myAssumeTollFreeTypesEquals && OCTollFreeBridges.isCompatible(this.myType, resolvedType)) {
            return true;
        }
        return resolvedType.accept(this);
    }

    @Override
    public Boolean visitObjectType(OCObjectType type) {
        if (type == this.myType) {
            return true;
        }
        if (!(this.myType instanceof OCObjectType)) {
            return false;
        }
        OCObjectType that = (OCObjectType)this.myType;
        if (!(type instanceof OCIdType && type.getAugmentedProtocols().isEmpty() || that instanceof OCIdType && that.getAugmentedProtocols().isEmpty() || OCTypeEqualityAfterResolvingVisitor.getProtocolNames(type).equals(OCTypeEqualityAfterResolvingVisitor.getProtocolNames(that)))) {
            return false;
        }
        OCInterfaceSymbol thisInterface = type.getInterface();
        OCInterfaceSymbol thatInterface = that.getInterface();
        if (thisInterface == null || thatInterface == null) {
            return thisInterface == thatInterface;
        }
        return Comparing.equal((String)thisInterface.getName(), (String)thatInterface.getName());
    }

    private static Set<String> getProtocolNames(OCObjectType type) {
        HashSet<String> result = new HashSet<String>();
        for (OCProtocolSymbol protocol : type.getAugmentedProtocols()) {
            result.add(protocol.getName());
        }
        return result;
    }

    @Override
    protected Boolean substitutionTypesEqual(@NotNull OCType thatSust, @NotNull OCType mySust, @NotNull OCResolveContext context) {
        if (thatSust == null) {
            OCTypeEqualityAfterResolvingVisitor.$$$reportNull$$$0(2);
        }
        if (mySust == null) {
            OCTypeEqualityAfterResolvingVisitor.$$$reportNull$$$0(3);
        }
        if (context == null) {
            OCTypeEqualityAfterResolvingVisitor.$$$reportNull$$$0(4);
        }
        return thatSust.accept(new OCTypeEqualityAfterResolvingVisitor(mySust, true, this.myAssumeMagicTypesEquals, this.myDontCheckCV, true, this.myContext));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thatSust";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mySust";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/types/visitors/OCTypeEqualityAfterResolvingVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "substitutionTypesEqual";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

