/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCStructuredBindingType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCNonPrimitiveTypeCloneVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;

public class OCTypeParameterResolveVisitor
extends OCNonPrimitiveTypeCloneVisitor {
    private final PsiFile myContext;

    public OCTypeParameterResolveVisitor(PsiFile context) {
        this.myContext = context;
    }

    @Override
    public OCType visitStructType(OCStructType type) {
        return type;
    }

    @Override
    public OCType visitReferenceType(OCReferenceType type) {
        OCSymbolReference reference = type.getReference(this.myContext);
        OCTypeSubstitution subst = type.getSubstitution();
        if (this.myContext != null && subst != OCTypeSubstitution.ID) {
            OCQualifiedName qualifiedName = reference.getQualifiedName();
            for (String name2 : qualifiedName.flatten()) {
                if (!subst.hasSubstitutionForName(name2)) continue;
                return type.resolve((PsiElement)this.myContext);
            }
        }
        return type;
    }

    @Override
    public OCType visitAutoType(OCAutoType type) {
        return this.myContext == null ? type : type.resolve((PsiElement)this.myContext);
    }

    @Override
    public OCType visitStructuredBindingType(OCStructuredBindingType type) {
        return this.myContext == null ? type : type.resolve((PsiElement)this.myContext);
    }
}

