/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCInternator;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCAliasUsingSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLambdaExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCCompatibilityAliasSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBracedInitListType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCStructuredBindingType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCNonPrimitiveTypeCloneVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCloneVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeUnificationVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import com.jetbrains.cidr.lang.util.OCStructuredBindingUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTypeResolveVisitor
extends OCNonPrimitiveTypeCloneVisitor {
    private static final int MAX_TYPES_TO_RESOLVE_PER_CONTEXT = 10000;
    private final boolean myResolveIgnoreImports;
    private final boolean myIsInOldC;
    private Set<VirtualFile> myUsedFiles;
    private OCFile myFile;
    @NotNull
    private final OCResolveContext myContext;
    private int myDepth;
    private int myMaxDepth;
    private static final Key<CachedValue<Map<TypeKey, ResultInfo>>> RESOLVE_CACHE_LOCAL = Key.create((String)"RESOLVE_CACHE_LOCAL");
    private static final Key<CachedValue<Map<TypeKey, ResultInfo>>> RESOLVE_CACHE_GLOBAL = Key.create((String)"RESOLVE_CACHE_GLOBAL");
    private static final OCInternator<ArrayList<VirtualFile>> USED_FILE_LIST_INTERNATOR = new OCInternator<ArrayList<VirtualFile>>(){

        @Override
        @NotNull
        protected ArrayList<VirtualFile> valueToStore(@NotNull ArrayList<VirtualFile> original) {
            if (original == null) {
                1.$$$reportNull$$$0(0);
            }
            original.trimToSize();
            ArrayList<VirtualFile> arrayList = original;
            if (arrayList == null) {
                1.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/types/visitors/OCTypeResolveVisitor$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/types/visitors/OCTypeResolveVisitor$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "valueToStore";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "valueToStore";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private static final Comparator<VirtualFile> FILE_PATH_COMPARATOR = (o1, o2) -> Comparing.compare((Comparable)((Object)o1.getPath()), (Comparable)((Object)o2.getPath()));

    public OCTypeResolveVisitor(@NotNull OCResolveContext context, boolean resolveIgnoreImports) {
        if (context == null) {
            OCTypeResolveVisitor.$$$reportNull$$$0(0);
        }
        this.myUsedFiles = new HashSet<VirtualFile>();
        this.myMaxDepth = 256;
        PsiFile psiFile = context.getFile();
        this.myFile = psiFile instanceof OCFile ? (OCFile)psiFile : null;
        this.myResolveIgnoreImports = resolveIgnoreImports;
        this.myContext = context;
        boolean bl = this.myIsInOldC = this.myFile != null && !this.myFile.isCpp();
        if (this.myFile instanceof OCCodeFragment) {
            PsiElement parent = this.myFile.getContext();
            this.myFile = parent != null ? (OCFile)parent.getContainingFile() : null;
        }
    }

    public OCTypeResolveVisitor(@NotNull OCResolveContext context) {
        if (context == null) {
            OCTypeResolveVisitor.$$$reportNull$$$0(1);
        }
        this(context, false);
    }

    @Override
    public OCType visitStructType(OCStructType type) {
        return type;
    }

    @Override
    public OCType visitFunctionType(OCFunctionType type) {
        List<String> oldParamNames = type.getParameterNames(true);
        List<OCType> paramTypes = OCArgumentsList.expandVariadicTypes(type.getParameterTypes(true), this.myContext);
        OCFunctionType functionType = (OCFunctionType)super.visitFunctionType(new OCFunctionType(type.getReturnType(), paramTypes, null, type.isConst(), type.isVolatile(), type.isLValueRef(), type.isRValueRef(), type.getExceptionSpecification()));
        List<OCType> parameterTypes = functionType.getParameterTypes(true);
        ArrayList<String> clonedNames = null;
        if (oldParamNames != null) {
            clonedNames = new ArrayList<String>(parameterTypes.size());
            for (int i = 0; i < parameterTypes.size(); ++i) {
                clonedNames.add(i < oldParamNames.size() ? oldParamNames.get(i) : null);
            }
        }
        return new OCFunctionType(functionType.getReturnType(), parameterTypes, clonedNames, functionType.isConst(), functionType.isVolatile(), functionType.isLValueRef(), functionType.isRValueRef(), functionType.getExceptionSpecification());
    }

    @Override
    public OCType visitArrayType(OCArrayType type) {
        OCTypeArgument typeArg;
        OCType refType = type.getRefType().transformType(this);
        OCResolveContext ctx = this.myContext.substitute(type.getSubstitution());
        OCExpressionSymbol lenSymbol = type.getLengthSymbol();
        if (lenSymbol != null && (typeArg = lenSymbol.evaluateToTypeArgument(ctx)) instanceof OCExpressionTypeArgument) {
            lenSymbol = ((OCExpressionTypeArgument)typeArg).getSymbol();
        }
        return OCArrayType.to(refType, lenSymbol, type.getARCAttribute());
    }

    @Override
    public OCType visitAutoType(OCAutoType type) {
        return this.getCachedOrResolve((OCType)type, (TypeKey)this.getTypeKey((OCType)type), (boolean)true).resolvedType;
    }

    @Override
    public OCType visitStructuredBindingType(OCStructuredBindingType type) {
        return this.getCachedOrResolve((OCType)type, (TypeKey)this.getTypeKey((OCType)type), (boolean)true).resolvedType;
    }

    @Override
    public OCType visitPointerType(@NotNull OCPointerType type) {
        if (type == null) {
            OCTypeResolveVisitor.$$$reportNull$$$0(2);
        }
        OCType referenceType = type.getRefType();
        ARCAttribute referenceArcAttribute = null;
        if (referenceType instanceof OCReferenceType && type.getARCAttribute() == null) {
            referenceArcAttribute = ((OCReferenceType)referenceType).getARCAttribute();
        }
        OCPointerType resolvedPointerType = (OCPointerType)super.visitPointerType(type);
        if (referenceArcAttribute != null && resolvedPointerType.getRefType() instanceof OCObjectType) {
            return resolvedPointerType.cloneWithArcAttribute(referenceArcAttribute);
        }
        return resolvedPointerType;
    }

    @Override
    public OCType visitReferenceType(OCReferenceType type) {
        ResultInfo resolved;
        if (type.getReference(this.myFile).getQualifiedName().getName() == null) {
            return OCUnknownType.INSTANCE;
        }
        if (this.myFile == null) {
            return type;
        }
        if (this.myDepth > this.myMaxDepth) {
            return type;
        }
        ++this.myDepth;
        TypeKey typeKey = this.getTypeKey(type);
        if (!this.myResolveIgnoreImports && type.getReference(this.myFile) instanceof OCSymbolReference.GlobalReference) {
            resolved = this.getCachedOrResolve(type, typeKey, false);
        } else {
            OCType resolvedType = this.doResolve(type, typeKey);
            Set<OCTypeParameterSymbol> dependencies = this.myContext.getTypeDependencies();
            resolved = new ResultInfo(resolvedType, this.myUsedFiles, !dependencies.isEmpty() ? dependencies : null);
        }
        --this.myDepth;
        OCFileSymbols.markImportsNeeded(this.myFile, resolved.usedFiles);
        OCType myGuessedType = type.getGuessedType();
        return myGuessedType != type ? resolved.resolvedType.cloneWithGuessedType(myGuessedType.resolve(this.myContext)) : resolved.resolvedType;
    }

    protected ResultInfo getCachedOrResolve(OCType type, TypeKey typeKey, boolean trackLocalChanges) {
        ResultInfo resolved;
        Map cacheValue;
        ResultInfo cached;
        Key modificationTracker;
        Key<CachedValue<Map<TypeKey, ResultInfo>>> cacheKey = trackLocalChanges ? RESOLVE_CACHE_LOCAL : RESOLVE_CACHE_GLOBAL;
        CachedValue cache = (CachedValue)this.myFile.getUserData(cacheKey);
        Object object = modificationTracker = trackLocalChanges ? PsiModificationTracker.MODIFICATION_COUNT : FileSymbolTablesCache.getInstance(this.myFile.getProject()).getOutOfBlockModificationTracker();
        if (cache == null) {
            cache = CachedValuesManager.getManager((Project)this.myFile.getProject()).createCachedValue(() -> new CachedValueProvider.Result((Object)ContainerUtil.newConcurrentMap(), new Object[]{modificationTracker}), false);
            cache = (CachedValue)((UserDataHolderEx)this.myFile).putUserDataIfAbsent(cacheKey, (Object)cache);
        }
        if ((cached = (ResultInfo)(cacheValue = (Map)cache.getValue()).get(typeKey)) == null) {
            OCType resolvedType;
            Set<OCTypeParameterSymbol> oldDependencies = this.myContext.getTypeDependencies();
            this.myContext.clearTypeDependencies();
            if (type instanceof OCReferenceType) {
                OCReferenceType referenceType = (OCReferenceType)type;
                resolvedType = this.doResolve(referenceType, typeKey);
                if (resolvedType instanceof OCArrayType && referenceType.isFunctionParameterType()) {
                    resolvedType = OCFunctionType.convertArrayParameterType(resolvedType);
                }
            } else {
                resolvedType = type instanceof OCStructuredBindingType ? this.doResolve((OCStructuredBindingType)type) : this.doResolve((OCAutoType)type, typeKey);
            }
            Set<OCTypeParameterSymbol> dependencies = this.myContext.getTypeDependencies();
            dependencies = !dependencies.isEmpty() ? dependencies : null;
            resolved = new ResultInfo(resolvedType, this.internedUsedFilesCopy(), dependencies);
            this.myContext.addTypeDependencies(oldDependencies);
            if (!(resolvedType instanceof OCUnknownType) && !(resolvedType instanceof OCReferenceType)) {
                cacheValue.put(typeKey, resolved);
            }
        } else {
            resolved = cached;
            ContainerUtil.addAllNotNull(this.myUsedFiles, cached.usedFiles);
            if (cached.typeDependencies != null) {
                this.myContext.addTypeDependencies(cached.typeDependencies);
            }
        }
        return resolved;
    }

    @NotNull
    private TypeKey getTypeKey(OCType type) {
        OCTypeSubstitution substitution = this.myContext.getSubstitution();
        if (!(type instanceof OCAutoType)) {
            substitution = substitution.getMinimalDependentSubstitution(type, this.myContext);
        }
        TypeKey typeKey = new TypeKey(type, substitution, this.myContext.isInSFINAE());
        if (typeKey == null) {
            OCTypeResolveVisitor.$$$reportNull$$$0(3);
        }
        return typeKey;
    }

    @NotNull
    private Collection<VirtualFile> internedUsedFilesCopy() {
        if (this.myUsedFiles.isEmpty()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                OCTypeResolveVisitor.$$$reportNull$$$0(4);
            }
            return list;
        }
        ArrayList<VirtualFile> copy = new ArrayList<VirtualFile>(this.myUsedFiles);
        Collections.sort(copy, FILE_PATH_COMPARATOR);
        Collection collection = USED_FILE_LIST_INTERNATOR.intern(copy);
        if (collection == null) {
            OCTypeResolveVisitor.$$$reportNull$$$0(5);
        }
        return collection;
    }

    private OCType doResolve(OCReferenceType type, TypeKey typeKey) {
        int typesResolved = this.myContext.getTypeResolveCounter();
        this.myContext.incTypeResolveCounter();
        OCQualifiedName qualifiedName = type.getReference(this.myFile).getQualifiedName();
        if (typesResolved > 10000) {
            return new OCMagicType(type);
        }
        Resolver resolver = new Resolver(type);
        String canonicalName = type.getCanonicalName(this.myContext);
        OCSymbolReference.NameWithToken nameWithToken = OCSymbolReference.removeTypeToken(canonicalName);
        if (nameWithToken.typeToken != null) {
            resolver.setPreferableKind(OCSymbolKind.parse(nameWithToken.typeToken));
        }
        if (this.addProcessingType(typeKey)) {
            if (qualifiedName.getQualifier() == null && "id".equals(qualifiedName.getName()) && this.myContext.isObjc()) {
                OCIdType idType = new OCIdType(resolver.getProtocols(false, true), resolver.getProtocols(false, false), this.myFile.getProject(), false, false);
                idType.attachNullability(type.getNullability());
                return OCPointerType.to(idType, type.getARCAttribute(), null, type.getNullability(), false, false);
            }
            this.processPossibleSymbols(type, resolver, this.myResolveIgnoreImports);
            OCType answer = resolver.getAnswer();
            if (answer != null) {
                answer = answer.cloneWithAddedCVQualifiers(type.getCVQualifiers(), this.myContext.getProjectOrNull());
            }
            this.removeProcessingType(typeKey);
            return answer != null ? answer : type;
        }
        return OCUnknownType.INSTANCE;
    }

    protected OCType doResolve(OCAutoType type, TypeKey typeKey) {
        OCTypeArgument argument;
        OCTypeParameterType typeParameterType;
        OCType result;
        OCFunctionSymbol function;
        OCResolveContext context = this.myContext.substituteFirst(type.getSubstitution());
        if (type.needsAutoParamsResolving()) {
            return type;
        }
        if (!this.addProcessingType(typeKey)) {
            return OCUnknownType.INSTANCE;
        }
        OCExpressionSymbol symbol = type.getExpressionSymbol();
        OCExpression element = type.getExpressionElement();
        if (type.getLambdaExpression() != null) {
            Collection<OCType> expectedTypes = OCExpectedTypeUtil.getExpectedTypes(type.getLambdaExpression(), false, this.myContext);
            OCType expectedType = ((OCType)ContainerUtil.getFirstItem(expectedTypes, (Object)OCUnknownType.INSTANCE)).resolve(this.myContext).getTerminalType();
            if (expectedType instanceof OCFunctionType) {
                OCType result2;
                List<OCType> parameterTypes = ((OCFunctionType)expectedType).getParameterTypes();
                if (type.getParameterIndex() < parameterTypes.size() && !((result2 = parameterTypes.get(type.getParameterIndex())).getTerminalType() instanceof OCAutoType)) {
                    return result2;
                }
            }
            this.removeProcessingType(typeKey);
            return type;
        }
        if (symbol instanceof OCLambdaExpressionSymbol && (function = ((OCLambdaExpressionSymbol)symbol).getFunctionSymbol()) != null && function.isConstexpr() && type.getIncompleteType() != null) {
            this.removeProcessingType(typeKey);
            return type.getIncompleteType().resolve(context);
        }
        if (element != null && element.isValid() && !(element instanceof OCLambdaExpression)) {
            result = element.getResolvedType(context);
        } else {
            if (element != null && !element.isValid()) {
                PsiFile file = this.myContext.getFile();
                if (file != null) {
                    OCLog.LOG.error("Invalid PSI context in auto type", new Attachment[]{new Attachment(file.getName(), file.getText())});
                } else {
                    OCLog.LOG.error("Invalid PSI context in auto type");
                }
            }
            OCType oCType = result = symbol != null ? symbol.getResolvedType(context) : null;
        }
        if (result != null) {
            result = result.cloneWithAddedCVQualifiers(type.getCVQualifiers(), context.getProjectOrNull());
        }
        this.removeProcessingType(typeKey);
        OCType incompleteType = type.getIncompleteType();
        if (result instanceof OCAutoType && ((OCAutoType)result).needsAutoParamsResolving() && (incompleteType == null || incompleteType instanceof OCAutoType)) {
            return result;
        }
        if (result != null && element != null && element.getParent() instanceof OCForeachStatement) {
            if ((result = OCCodeInsightUtil.getCollectionElementType(element, result)) == null) {
                return OCUnknownType.INSTANCE;
            }
        } else if (result instanceof OCBracedInitListType && element instanceof OCCompoundInitializer) {
            if (element.getParent() instanceof OCDeclarator && ((OCDeclarator)element.getParent()).getInitializer() == null) {
                List<OCExpression> expressions = ((OCCompoundInitializer)element).getInitializerExpressions();
                if (expressions.size() != 1) {
                    return OCUnknownType.INSTANCE;
                }
                return expressions.get(0).getResolvedType(context);
            }
            result = OCTypeResolveVisitor.calcStdInitListTypeByArguments(OCArgumentsList.getArgumentList(((OCCompoundInitializer)element).getInitializerExpressions()), context);
        }
        if (result != null && incompleteType != null) {
            Map<OCTypeParameterSymbol, OCTypeArgument> substitutionMap;
            Map<OCType, OCType> map2;
            if (!(incompleteType instanceof OCCppReferenceType) && (result = result.cloneWithCVQualifiers(CVQualifiers.EMPTY, context.getProjectOrNull())) instanceof OCCppReferenceType) {
                result = OCCppReferenceType.to(((OCCppReferenceType)result).getRefType().cloneWithCVQualifiers(CVQualifiers.EMPTY, context.getProjectOrNull()), ((OCCppReferenceType)result).isRvalueRef(), false, false);
            }
            if (OCSimpleTypeSubstitution.unify(incompleteType = OCTypeUtils.replaceAutoTypesWithTypeParameters(incompleteType, map2 = OCTypeUtils.newTypesMap(), this.myContext.getProject()), result, element, substitutionMap = OCTypeUtils.newTypeParameterMap(), null, true, false, context) != OCTypeUnificationVisitor.NOT_UNIFIED) {
                for (OCType typeParameterType2 : map2.values()) {
                    OCTypeParameterSymbol autoSymbol = ((OCTypeParameterType)typeParameterType2).getSymbol();
                    if (substitutionMap.containsKey(autoSymbol)) continue;
                    substitutionMap.put(autoSymbol, OCUnknownType.INSTANCE);
                }
                return new OCSimpleTypeSubstitution(substitutionMap).substitute(incompleteType, context);
            }
            return OCUnknownType.INSTANCE;
        }
        if (context.getAutoParamTypeMapping(type) != null && (typeParameterType = context.getAutoParamTypeMapping(type)) != null && (argument = context.getSubstitution().getSubstitutionFor(typeParameterType.getSymbol())) instanceof OCType) {
            return (OCType)argument;
        }
        return result != null ? result : (incompleteType != null ? incompleteType : type);
    }

    @NotNull
    protected OCType doResolve(OCStructuredBindingType type) {
        OCStructType structType;
        OCType result = null;
        OCType initializerType = OCStructuredBindingUtil.resolveInitializerType(type, this.myContext);
        if (initializerType instanceof OCCppReferenceType) {
            initializerType = ((OCCppReferenceType)initializerType).getRefType();
        }
        if (initializerType instanceof OCArrayType) {
            result = initializerType.getArrayElementType();
        } else if (initializerType instanceof OCStructType && (structType = (OCStructType)initializerType).getKind() == OCSymbolKind.STRUCT) {
            if (OCStructuredBindingUtil.isTupleLikeType(structType, this.myContext, this.myFile)) {
                result = OCStructuredBindingUtil.getTupleElementType(structType, type.getDeclaratorIndex(), this.myContext, this.myFile);
                if (result != null && result.isUnresolved(this.myContext)) {
                    result = new OCMagicType();
                }
            } else {
                result = OCStructuredBindingUtil.getStructMemberType(structType, type.getDeclaratorIndex(), this.myContext);
                if (result != null && type.getCVQualifiers() != CVQualifiers.EMPTY) {
                    result = result.cloneWithAddedCVQualifiers(type.getCVQualifiers(), this.myFile.getProject());
                }
            }
        }
        OCType oCType = result != null ? result : OCUnknownType.INSTANCE;
        if (oCType == null) {
            OCTypeResolveVisitor.$$$reportNull$$$0(6);
        }
        return oCType;
    }

    private boolean processPossibleSymbols(OCReferenceType type, Resolver resolver, boolean ignoreImports) {
        OCResolveContext context = this.myContext.substituteFirst(type.getSubstitution());
        context.setProcessNonImported(ignoreImports);
        List<OCSymbol> symbols = context.resolveToSymbols(type.getReference(this.myFile), false, false, true);
        int oldMaxDepth = this.myMaxDepth;
        if (context.wasDependentType()) {
            this.myMaxDepth = 6;
        }
        ContainerUtil.process(symbols, (Processor)resolver);
        this.myMaxDepth = oldMaxDepth;
        this.myContext.addTypeDependencies(context.getTypeDependencies());
        return !symbols.isEmpty();
    }

    private boolean addProcessingType(TypeKey typeKey) {
        return this.myContext.getResolvingTypes().add(typeKey);
    }

    private void removeProcessingType(TypeKey typeKey) {
        this.myContext.getResolvingTypes().remove(typeKey);
    }

    private boolean containsProcessingType(TypeKey typeKey) {
        return this.myContext.getResolvingTypes().contains(typeKey);
    }

    @NotNull
    private static OCType calcStdInitListTypeByArguments(@NotNull OCArgumentsList<? extends OCTypeOwner> arguments, @NotNull OCResolveContext context) {
        if (arguments == null) {
            OCTypeResolveVisitor.$$$reportNull$$$0(7);
        }
        if (context == null) {
            OCTypeResolveVisitor.$$$reportNull$$$0(8);
        }
        OCType type = null;
        for (OCType exprType : arguments.getTypes()) {
            type = type == null ? exprType : type.getLeastCommonType(exprType, context);
        }
        if (type == null) {
            OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
            if (oCUnknownType == null) {
                OCTypeResolveVisitor.$$$reportNull$$$0(9);
            }
            return oCUnknownType;
        }
        List<Object> typeArguments = Collections.singletonList(type);
        OCType oCType = OCReferenceType.fromQualifiedName(new OCQualifiedNameWithArguments(OCQualifiedName.parse("::std::initializer_list"), typeArguments)).resolve(context);
        if (oCType == null) {
            OCTypeResolveVisitor.$$$reportNull$$$0(10);
        }
        return oCType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/types/visitors/OCTypeResolveVisitor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/types/visitors/OCTypeResolveVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeKey";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "internedUsedFilesCopy";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolve";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "calcStdInitListTypeByArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitPointerType";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "calcStdInitListTypeByArguments";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class OCObjectTypeReResolver
    extends OCTypeCloneVisitor {
        private OCResolveContext myContext;

        public OCObjectTypeReResolver(@NotNull OCResolveContext context) {
            if (context == null) {
                OCObjectTypeReResolver.$$$reportNull$$$0(0);
            }
            super(false);
            this.myContext = context;
        }

        @Override
        public OCType visitObjectType(OCObjectType type) {
            Function protocolNameCalculator = symbol -> symbol.getName();
            return OCReferenceType.fromText(type.getClassName(), ContainerUtil.map(type.getAllProtocols(), (Function)protocolNameCalculator)).resolve(this.myContext, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/visitors/OCTypeResolveVisitor$OCObjectTypeReResolver", "<init>"));
        }
    }

    private class Resolver
    implements Processor<OCSymbol> {
        private OCReferenceType myType;
        private OCType myAnswer;
        private OCInterfaceSymbol myInterface;
        private OCImplementationSymbol myImplementation;
        private List<OCInterfaceSymbol> myCategoryInterfaces = new ArrayList<OCInterfaceSymbol>();
        private List<OCImplementationSymbol> myCategoryImplementations = new ArrayList<OCImplementationSymbol>();
        private OCSymbolKind myPreferableKind;

        private Resolver(OCReferenceType type) {
            this.myType = type;
        }

        void setPreferableKind(OCSymbolKind kind) {
            this.myPreferableKind = kind;
        }

        private int getInterfaceClassRank(@Nullable OCInterfaceSymbol clazz) {
            if (clazz == null) {
                return 0;
            }
            if (clazz.isPredeclaration()) {
                return 1;
            }
            return 2;
        }

        public boolean process(@NotNull OCSymbol symbol) {
            OCSymbol definition;
            if (symbol == null) {
                Resolver.$$$reportNull$$$0(0);
            }
            if (OCTypeResolveVisitor.this.myResolveIgnoreImports && symbol.isPredeclaration() && (definition = symbol.getDefinitionSymbol(OCTypeResolveVisitor.this.myContext.getProject())) != null) {
                symbol = definition;
            }
            if (symbol instanceof OCClassSymbol) {
                OCClassSymbol aClass = (OCClassSymbol)symbol;
                if (aClass.getCategoryName() == null) {
                    if (aClass instanceof OCInterfaceSymbol && this.getInterfaceClassRank((OCInterfaceSymbol)aClass) > this.getInterfaceClassRank(this.myInterface)) {
                        this.myInterface = (OCInterfaceSymbol)aClass;
                        this.addUsedImport(symbol);
                    } else if (aClass instanceof OCImplementationSymbol) {
                        this.myImplementation = (OCImplementationSymbol)aClass;
                    }
                } else if (aClass instanceof OCInterfaceSymbol) {
                    this.myCategoryInterfaces.add((OCInterfaceSymbol)aClass);
                    if (!aClass.getProtocolNames().isEmpty()) {
                        this.addUsedImport(symbol);
                    }
                } else if (aClass instanceof OCImplementationSymbol) {
                    this.myCategoryImplementations.add((OCImplementationSymbol)aClass);
                }
            } else if (symbol instanceof OCDeclaratorSymbol || symbol instanceof OCCompatibilityAliasSymbol || symbol instanceof OCAliasUsingSymbol) {
                if (symbol.getKind().isTypedefOrAlias() && (this.isNullOrMagic(this.myAnswer) || this.myAnswer instanceof OCStructType)) {
                    OCType type = this.myType.getSubstitution().substitute(symbol.getType(), OCTypeResolveVisitor.this.myContext);
                    Project project2 = OCTypeResolveVisitor.this.myContext.getProjectOrNull();
                    type = type.cloneWithAddedCVQualifiers(this.myType.getCVQualifiers(), project2);
                    if ((type = OCTypeUtils.changeTypeReferences(type, this.myType.getReference(), OCTypeResolveVisitor.this.myContext)).getName().startsWith("__builtin")) {
                        this.myAnswer = new OCMagicType();
                    } else if (!(type instanceof OCReferenceType && OCTypeResolveVisitor.this.containsProcessingType(OCTypeResolveVisitor.this.getTypeKey(type)) || symbol.getContainingFile() == null || project2 == null)) {
                        OCFile containingFile = symbol.getContainingOCFile(project2);
                        if (containingFile != null) {
                            OCType inner = type.accept(OCTypeResolveVisitor.this);
                            inner = this.myType.getSubstitution().substitute(inner, OCTypeResolveVisitor.this.myContext);
                            if (inner instanceof OCStructType) {
                                for (OCStructSymbol innerStruct : ((OCStructType)inner).getStructs()) {
                                    this.storeStructSymbolInAnswer(innerStruct, ((OCStructType)inner).getTypedefName(), ((OCStructType)inner).getArguments());
                                }
                                this.myAnswer = this.myAnswer.cloneWithAddedCVQualifiers(inner.getCVQualifiers(), OCTypeResolveVisitor.this.myContext.getProject());
                            } else if (this.myAnswer == null || this.myAnswer instanceof OCTypeParameterType && !(inner instanceof OCTypeParameterType) || this.myAnswer.isUnresolved(OCTypeResolveVisitor.this.myContext) && !inner.isUnresolved(OCTypeResolveVisitor.this.myContext)) {
                                this.myAnswer = this.handleSubstitutedVoid(inner);
                            }
                            if (symbol instanceof OCSymbolWithQualifiedName && this.myAnswer != OCMagicType.SEVERAL_UNRELATED_STRUCTS) {
                                OCSymbolWithQualifiedName substitutedSymbol = (OCSymbolWithQualifiedName)OCTypeResolveVisitor.this.myContext.getSubstitution().substitute(symbol, OCTypeResolveVisitor.this.myContext);
                                substitutedSymbol = this.myType.getSubstitution().substitute(substitutedSymbol, OCTypeResolveVisitor.this.myContext);
                                OCQualifiedName qualifiedName = substitutedSymbol.getResolvedQualifiedName(true, OCTypeResolveVisitor.this.myContext, true, true, true, true, true);
                                if (qualifiedName != null) {
                                    String alias = qualifiedName.getCanonicalName(OCType.Presentation.FULL, false, OCTypeResolveVisitor.this.myContext, 0);
                                    alias = CVQualifiers.appendCVQualifiers(alias, this.myType, project2);
                                    this.myAnswer = this.myAnswer.equals(OCIntType.BOOL, OCTypeResolveVisitor.this.myContext) && Comparing.equal((String)"BOOL", (String)alias) ? OCIntType.BOOL : this.myAnswer.cloneWithAliasName(alias);
                                }
                            }
                        }
                    } else {
                        this.myAnswer = OCUnknownType.INSTANCE;
                    }
                    this.addUsedImport(symbol);
                    if (this.myAnswer == null) {
                        this.myAnswer = type.cloneWithAliasName(this.myType.getCanonicalName(OCTypeResolveVisitor.this.myContext));
                    }
                    return true;
                }
            } else {
                if (symbol instanceof OCStructSymbol) {
                    if (this.myPreferableKind != null && this.myPreferableKind != symbol.getKind() || OCTypeResolveVisitor.this.myIsInOldC && this.myPreferableKind == null || ((OCStructSymbol)symbol).isQualifiedContainer()) {
                        return true;
                    }
                    this.addUsedImport(symbol);
                    this.storeStructSymbolInAnswer((OCStructSymbol)symbol, null, null);
                    return true;
                }
                if (symbol instanceof OCTypeParameterSymbol) {
                    TypeKey typeKey;
                    OCTypeArgument argument = this.myType.getSubstitution().getSubstitutionFor((OCTypeParameterSymbol)((Object)symbol));
                    String aliasName = null;
                    if (argument == null) {
                        argument = OCTypeResolveVisitor.this.myContext.getSubstitution().getSubstitutionFor((OCTypeParameterSymbol)((Object)symbol));
                    }
                    if (argument instanceof OCReferenceType || argument instanceof OCAutoType) {
                        OCType substituted = this.myType.getSubstitution().substitute((OCType)argument, OCTypeResolveVisitor.this.myContext);
                        this.myAnswer = substituted.accept(OCTypeResolveVisitor.this).cloneWithAliasName(this.myType.getCanonicalName(OCTypeResolveVisitor.this.myContext));
                        return true;
                    }
                    if (argument instanceof OCTypeParameterType && OCTypeResolveVisitor.this.addProcessingType(typeKey = OCTypeResolveVisitor.this.getTypeKey((OCType)argument))) {
                        boolean result = this.process((OCSymbol)((Object)((OCTypeParameterType)argument).getSymbol()));
                        OCTypeResolveVisitor.this.removeProcessingType(typeKey);
                        if (this.myAnswer != null) {
                            this.myAnswer = this.myAnswer.cloneWithAddedCVQualifiers(((OCTypeParameterType)argument).getCVQualifiers(), OCTypeResolveVisitor.this.myContext.getProject());
                        }
                        return result;
                    }
                    if (argument instanceof OCType) {
                        this.myAnswer = (OCType)argument;
                    } else if (this.myAnswer == null) {
                        this.myAnswer = new OCTypeParameterType((OCTypeParameterSymbol)((Object)symbol));
                    }
                    if (aliasName != null) {
                        this.myAnswer = this.myAnswer.cloneWithAliasName(aliasName);
                    }
                    this.myAnswer = this.handleSubstitutedVoid(this.myAnswer);
                } else if (symbol instanceof OCUsingSymbol) {
                    this.addUsedImport(symbol);
                    return ((OCUsingSymbol)symbol).getSymbolReference().processPossibleSymbols(this, OCResolveContext.forPsi(OCTypeResolveVisitor.this.myFile));
                }
            }
            return true;
        }

        private OCType handleSubstitutedVoid(OCType answer) {
            if (this.myType.isFunctionParameterType() && answer.resolve(OCTypeResolveVisitor.this.myContext) instanceof OCVoidType) {
                return OCUnknownType.INSTANCE;
            }
            return answer;
        }

        private boolean isNullOrMagic(@Nullable OCType type) {
            return type == null || type instanceof OCReferenceType || type instanceof OCTypeParameterType;
        }

        private void addUsedImport(@NotNull OCSymbol symbol) {
            if (symbol == null) {
                Resolver.$$$reportNull$$$0(1);
            }
            ContainerUtil.addIfNotNull((Collection)OCTypeResolveVisitor.this.myUsedFiles, (Object)OCFileSymbols.getFileToImport(OCTypeResolveVisitor.this.myFile, symbol));
        }

        private void storeStructSymbolInAnswer(OCStructSymbol symbol, String typedefName, @Nullable List<OCTypeArgument> typeArguments) {
            List<OCTypeArgument> arguments;
            OCStructSymbol substitute = this.myType.getSubstitution().substitute(symbol, OCTypeResolveVisitor.this.myContext);
            OCQualifiedName qualifiedName = this.myType.getReference(OCTypeResolveVisitor.this.myFile).getQualifiedName();
            List<OCTypeArgument> list = arguments = qualifiedName instanceof OCQualifiedNameWithArguments ? ((OCQualifiedNameWithArguments)qualifiedName).getArguments() : typeArguments;
            if (this.myAnswer instanceof OCStructType) {
                Object innerStructs = null;
                if (((OCStructType)this.myAnswer).isPredeclaration() && !symbol.isPredeclaration()) {
                    innerStructs = new SmartList();
                    this.myAnswer = new OCStructType((List<OCStructSymbol>)innerStructs, typedefName, arguments);
                } else if (((OCStructType)this.myAnswer).isPredeclaration() == symbol.isPredeclaration() && ((OCStructType)this.myAnswer).getStructs().stream().noneMatch(s -> DeepEqual.equalObjects(s, substitute))) {
                    innerStructs = ((OCStructType)this.myAnswer).getStructs();
                }
                if (innerStructs != null) {
                    if (!innerStructs.isEmpty() && !Comparing.equal((String)((OCStructSymbol)innerStructs.get(0)).getName(), (String)substitute.getName())) {
                        this.myAnswer = OCMagicType.SEVERAL_UNRELATED_STRUCTS;
                    }
                    innerStructs.add(substitute);
                }
            } else if (this.isNullOrMagic(this.myAnswer)) {
                this.myAnswer = new OCStructType((List<OCStructSymbol>)new SmartList((Object)substitute), typedefName, arguments);
            }
        }

        public List<OCProtocolSymbol> getProtocols(boolean addDeclaredProtocols, boolean isTransitive) {
            ArrayDeque<String> queue = new ArrayDeque<String>(this.myType.getProtocolNames());
            if (addDeclaredProtocols) {
                if (this.myInterface != null) {
                    queue.addAll(this.myInterface.getProtocolNames());
                }
                for (OCInterfaceSymbol category : this.myCategoryInterfaces) {
                    queue.addAll(category.getProtocolNames());
                }
            }
            HashSet<String> processed = new HashSet<String>();
            ArrayList<OCProtocolSymbol> result = new ArrayList<OCProtocolSymbol>();
            while (!queue.isEmpty()) {
                String protocol = (String)queue.poll();
                if (processed.contains(protocol)) continue;
                processed.add(protocol);
                OCClassSymbol foundProtocol = null;
                for (OCSymbol symbol : OCSymbolReference.getDummyGlobalReference(OCQualifiedName.with(protocol)).resolveToSymbols(OCTypeResolveVisitor.this.myContext)) {
                    if (!(symbol instanceof OCProtocolSymbol)) continue;
                    if (!symbol.isPredeclaration()) {
                        foundProtocol = (OCProtocolSymbol)symbol;
                        break;
                    }
                    foundProtocol = (OCProtocolSymbol)symbol;
                }
                if (foundProtocol == null) continue;
                result.add((OCProtocolSymbol)foundProtocol);
                if (!isTransitive) continue;
                queue.addAll(foundProtocol.getProtocolNames());
            }
            return result;
        }

        @Nullable
        public OCType getAnswer() {
            if (this.myAnswer != null) {
                return this.myAnswer;
            }
            if (this.myInterface != null || this.myImplementation != null || this.myType.getProtocolNames().size() > 0) {
                OCReferenceType superType;
                OCType resolved;
                OCObjectType resolvedSuper = null;
                if ((this.myInterface != null || this.myImplementation != null) && (resolved = OCTypeResolveVisitor.this.visitReferenceType(superType = this.myInterface != null ? this.myInterface.getSuperType() : this.myImplementation.getSuperType())) instanceof OCObjectType) {
                    resolvedSuper = (OCObjectType)resolved;
                }
                List<OCProtocolSymbol> allProtocols = this.getProtocols(true, true);
                List<OCProtocolSymbol> augmentedProtocols = this.getProtocols(false, false);
                if (this.myInterface == null && this.myImplementation == null && allProtocols.isEmpty() && augmentedProtocols.isEmpty()) {
                    return null;
                }
                OCObjectType answer = new OCObjectType(this.myInterface, this.myImplementation, allProtocols, augmentedProtocols, this.myCategoryInterfaces, this.myCategoryImplementations, resolvedSuper, false, false, this.myType.isKindof());
                answer.attachNullability(this.myType.getNullability());
                return answer;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "symbol";
            objectArray2[1] = "com/jetbrains/cidr/lang/types/visitors/OCTypeResolveVisitor$Resolver";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addUsedImport";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TypeKey {
        private OCType type;
        private OCTypeSubstitution substitution;
        private final boolean isInSFINAE;

        public TypeKey(OCType type, OCTypeSubstitution substitution, boolean isInSFINAE) {
            this.type = type;
            this.substitution = substitution;
            this.isInSFINAE = isInSFINAE;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TypeKey)) {
                return false;
            }
            TypeKey key = (TypeKey)obj;
            return DeepEqual.equalObjects(this.type, key.type) && DeepEqual.equalObjects(this.substitution, key.substitution) && this.isInSFINAE == key.isInSFINAE;
        }

        @NotNull
        public OCQualifiedName getTypeName() {
            OCQualifiedName oCQualifiedName = this.type instanceof OCReferenceType ? ((OCReferenceType)this.type).getReference().getQualifiedName().dropArguments() : OCQualifiedName.interned(this.type.getName());
            if (oCQualifiedName == null) {
                TypeKey.$$$reportNull$$$0(0);
            }
            return oCQualifiedName;
        }

        public int hashCode() {
            int result = this.type != null ? this.type.hashCode() : 0;
            result = 31 * result + (this.substitution != null ? this.substitution.hashCode() : 0);
            result = 31 * result + (this.isInSFINAE ? 1 : 0);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/visitors/OCTypeResolveVisitor$TypeKey", "getTypeName"));
        }
    }

    private static class ResultInfo {
        final OCType resolvedType;
        final Collection<VirtualFile> usedFiles;
        final Set<OCTypeParameterSymbol> typeDependencies;

        private ResultInfo(OCType type, Collection<VirtualFile> files, Set<OCTypeParameterSymbol> typeDependencies) {
            this.resolvedType = type;
            this.usedFiles = files;
            this.typeDependencies = typeDependencies;
        }
    }
}

