/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors.names;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBracedInitListType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructuredBindingType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCTypeNameVisitorBase
implements OCTypeVisitor<String> {
    public static final int MAX_STRUCT_PARAMETERS_IN_PRESENTATION = 5;
    public static final int MAX_TEMPLATE_DEPTH_IN_PRESENTATION = 10;
    protected final int myTemplateDepth;

    protected OCTypeNameVisitorBase(int templateDepth) {
        this.myTemplateDepth = templateDepth;
    }

    @NotNull
    public abstract String getName(OCType var1);

    protected abstract String getNameForTypeArgument(OCTypeArgument var1);

    @NotNull
    protected abstract List<OCTypeArgument> getTypeArguments(OCTemplateSymbol<? extends PsiElement> var1);

    @Nullable
    protected abstract String getCanonicalName(OCReferenceType var1);

    @Nullable
    protected abstract Project getProject();

    protected String getSubstitutedTypeName(String baseName, OCTemplateSymbol<? extends PsiElement> symbol) {
        List<OCTypeArgument> arguments = this.getTypeArguments(symbol);
        StringBuilder builder = new StringBuilder(baseName);
        if (arguments.size() > 0) {
            builder.append('<');
            if (this.myTemplateDepth < 10) {
                for (int j = 0; j < arguments.size(); ++j) {
                    if (j > 5) {
                        builder.append("...");
                        break;
                    }
                    if (j != 0) {
                        builder.append(", ");
                    }
                    OCTypeArgument argument = arguments.get(j);
                    if (symbol.isSpecialization() && argument != null) {
                        builder.append(this.getNameForTypeArgument(argument));
                        continue;
                    }
                    if (argument instanceof OCType) {
                        builder.append(this.getName((OCType)argument));
                        continue;
                    }
                    if (argument != null) {
                        builder.append(this.getNameForTypeArgument(argument));
                        continue;
                    }
                    builder.append(symbol.getTemplateParameters().get(j).getName());
                }
            } else {
                builder.append("...");
            }
            builder.append(">");
        }
        return builder.toString();
    }

    private static String appendIsKindof(boolean isKindof, String typeString) {
        if (!isKindof || typeString.startsWith("__kindof ")) {
            return typeString;
        }
        return "__kindof " + typeString;
    }

    protected String appendCVQualifiers(OCType type, String typeString) {
        return CVQualifiers.appendCVQualifiers(typeString, type, this.getProject());
    }

    @NotNull
    public static String addTypeQualifier(@NotNull String typeString, @NotNull OCType type, @Nullable Project project2, @NotNull String qualifier) {
        OCCodeStyleSettings settings;
        if (typeString == null) {
            OCTypeNameVisitorBase.$$$reportNull$$$0(0);
        }
        if (type == null) {
            OCTypeNameVisitorBase.$$$reportNull$$$0(1);
        }
        if (qualifier == null) {
            OCTypeNameVisitorBase.$$$reportNull$$$0(2);
        }
        if (qualifier.isEmpty()) {
            String string = typeString;
            if (string == null) {
                OCTypeNameVisitorBase.$$$reportNull$$$0(3);
            }
            return string;
        }
        OCCodeStyleSettings oCCodeStyleSettings = settings = project2 != null ? (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project2).getCustomSettings(OCCodeStyleSettings.class) : null;
        if (type instanceof OCPointerType || type instanceof OCFunctionType || settings != null && settings.TYPE_QUALIFIERS_PLACEMENT == OCCodeStyleSettings.Placement.AFTER) {
            String string = typeString.endsWith(" " + qualifier) ? typeString : typeString + " " + qualifier;
            if (string == null) {
                OCTypeNameVisitorBase.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = typeString.startsWith(qualifier + " ") ? typeString : qualifier + " " + typeString;
        if (string == null) {
            OCTypeNameVisitorBase.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static String removeTypeQualifier(@NotNull String typeString, @NotNull OCType type, @Nullable Project project2, @NotNull String qualifier) {
        OCCodeStyleSettings settings;
        if (typeString == null) {
            OCTypeNameVisitorBase.$$$reportNull$$$0(6);
        }
        if (type == null) {
            OCTypeNameVisitorBase.$$$reportNull$$$0(7);
        }
        if (qualifier == null) {
            OCTypeNameVisitorBase.$$$reportNull$$$0(8);
        }
        OCCodeStyleSettings oCCodeStyleSettings = settings = project2 != null ? (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project2).getCustomSettings(OCCodeStyleSettings.class) : null;
        if (type instanceof OCPointerType || settings != null && settings.TYPE_QUALIFIERS_PLACEMENT == OCCodeStyleSettings.Placement.AFTER) {
            String string = typeString.endsWith(" " + qualifier) ? typeString.substring(0, typeString.length() - qualifier.length() - 1) : typeString;
            if (string == null) {
                OCTypeNameVisitorBase.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = typeString.startsWith(qualifier + " ") ? typeString.substring(qualifier.length() + 1) : typeString;
        if (string == null) {
            OCTypeNameVisitorBase.$$$reportNull$$$0(10);
        }
        return string;
    }

    protected String getFunctionSignature(OCFunctionType type, String signatureWithoutParams) {
        StringBuilder builder = new StringBuilder(signatureWithoutParams);
        builder.append('(');
        builder.append(StringUtil.join(type.getParameterTypes(true), argumentType -> this.getName((OCType)argumentType), (String)","));
        builder.append(')');
        return this.appendCVQualifiers(type, builder.toString());
    }

    @Override
    public String visitEllipsisReferenceType(OCEllipsisType type) {
        return "...";
    }

    @Override
    public String visitObjectType(OCObjectType type) {
        boolean isGeneric;
        List<OCProtocolSymbol> protocols = type.getAugmentedProtocols();
        OCInterfaceSymbol interfaceSymbol = type.getInterface();
        boolean bl = isGeneric = interfaceSymbol != null && !interfaceSymbol.getGenericParameters().isEmpty() && interfaceSymbol.getSubstitution() != OCTypeSubstitution.ID;
        if (protocols.isEmpty() && !isGeneric) {
            return OCTypeNameVisitorBase.appendIsKindof(type.isKindof(), this.appendCVQualifiers(type, type.getClassName()));
        }
        StringBuilder builder = new StringBuilder();
        builder.append(isGeneric ? this.getSubstitutedTypeName(type.getClassName(), interfaceSymbol) : type.getClassName());
        if (!protocols.isEmpty()) {
            builder.append('<');
            builder.append(StringUtil.join(protocols, OCSymbol::getName, (String)", "));
            builder.append('>');
        }
        return OCTypeNameVisitorBase.appendIsKindof(type.isKindof(), this.appendCVQualifiers(type, builder.toString()));
    }

    @Override
    public String visitUnknownType(OCUnknownType type) {
        return (String)this.visitMagicType(type);
    }

    @Override
    public String visitVoidType(OCVoidType type) {
        return this.appendCVQualifiers(type, "void");
    }

    @Override
    public String visitTypeParameterType(OCTypeParameterType type) {
        return this.appendCVQualifiers(type, type.getSymbol().getName());
    }

    @Override
    public String visitAutoType(OCAutoType type) {
        return "auto";
    }

    @Override
    public String visitVariadicType(OCVariadicType type) {
        return this.getName(type.getUnderlyingType()) + "...";
    }

    @Override
    public String visitBracedInitListType(OCBracedInitListType type) {
        return "<braced-init-list>";
    }

    @Override
    public String visitReferenceType(OCReferenceType type) {
        String name2 = this.getCanonicalName(type);
        if (type.getProtocolNames().isEmpty()) {
            return name2 != null ? OCTypeNameVisitorBase.appendIsKindof(type.isKindof(), this.appendCVQualifiers(type, name2)) : "<unnamed>";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(name2).append('<');
        StringUtil.join(type.getProtocolNames(), (String)", ", (StringBuilder)builder);
        builder.append('>');
        return OCTypeNameVisitorBase.appendIsKindof(type.isKindof(), this.appendCVQualifiers(type, builder.toString()));
    }

    @Override
    public String visitStructuredBindingType(OCStructuredBindingType type) {
        return "<structured-binding>";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeString";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/types/visitors/names/OCTypeNameVisitorBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/types/visitors/names/OCTypeNameVisitorBase";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "addTypeQualifier";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "removeTypeQualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addTypeQualifier";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeTypeQualifier";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

