/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ReferenceEditorWithBrowseButton;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.ui.OCFileChooserDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFileReferenceEditor
extends ReferenceEditorWithBrowseButton {
    private OCFile myLastSelectedFile;

    public OCFileReferenceEditor(ActionListener browseActionListener, EditorTextField editorTextField, Function<String, Document> factory2) {
        super(browseActionListener, editorTextField, factory2);
    }

    public static OCFileReferenceEditor create(final Project project2) {
        final Ref result = Ref.create(null);
        ArrayList<OCFile> files = new ArrayList<OCFile>();
        ClassCompletionProvider completionProvider = new ClassCompletionProvider(files);
        TextFieldWithAutoCompletion textField = new TextFieldWithAutoCompletion(project2, (TextFieldWithAutoCompletionListProvider)completionProvider, false, null);
        Function documentFactory = arg_0 -> OCFileReferenceEditor.lambda$create$0((EditorTextField)textField, arg_0);
        result.set((Object)new OCFileReferenceEditor(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OCFileChooserDialog dialog = new OCFileChooserDialog("Choose Containing Class", project2);
                dialog.showDialog();
                if (dialog.isOK()) {
                    OCFile selectedFile = (OCFile)dialog.getSelected();
                    ((OCFileReferenceEditor)((Object)result.get())).myLastSelectedFile = selectedFile;
                    ((OCFileReferenceEditor)((Object)result.get())).setText(selectedFile.getName());
                }
            }
        }, (EditorTextField)textField, (Function<String, Document>)documentFactory));
        return (OCFileReferenceEditor)((Object)result.get());
    }

    @Nullable
    public OCFile getFile(@NotNull Project project2) {
        if (project2 == null) {
            OCFileReferenceEditor.$$$reportNull$$$0(0);
        }
        return (OCFile)ContainerUtil.getFirstItem(OCSearchUtil.getProjectOCFilesByName(project2, this.getText()));
    }

    private static /* synthetic */ Document lambda$create$0(EditorTextField textField, String s) {
        textField.setText(s);
        return textField.getDocument();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/ui/OCFileReferenceEditor", "getFile"));
    }

    private static class ClassCompletionProvider
    extends TextFieldWithAutoCompletionListProvider<OCFile> {
        protected ClassCompletionProvider(@Nullable Collection<OCFile> variants) {
            super(variants);
        }

        protected Icon getIcon(@NotNull OCFile file) {
            if (file == null) {
                ClassCompletionProvider.$$$reportNull$$$0(0);
            }
            return file.getIcon(0);
        }

        @NotNull
        protected String getLookupString(@NotNull OCFile file) {
            if (file == null) {
                ClassCompletionProvider.$$$reportNull$$$0(1);
            }
            String string = file.getName();
            if (string == null) {
                ClassCompletionProvider.$$$reportNull$$$0(2);
            }
            return string;
        }

        protected String getTailText(@NotNull OCFile file) {
            VirtualFile virtualFile;
            if (file == null) {
                ClassCompletionProvider.$$$reportNull$$$0(3);
            }
            VirtualFile parent = (virtualFile = file.getVirtualFile()) != null ? virtualFile.getParent() : null;
            return parent != null ? parent.getPath() : null;
        }

        protected String getTypeText(@NotNull OCFile file) {
            if (file == null) {
                ClassCompletionProvider.$$$reportNull$$$0(4);
            }
            return null;
        }

        public int compare(OCFile file1, OCFile file2) {
            return file1.getName().compareTo(file2.getName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/ui/OCFileReferenceEditor$ClassCompletionProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/ui/OCFileReferenceEditor$ClassCompletionProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLookupString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getIcon";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getLookupString";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getTailText";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getTypeText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

