/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.PingProgress;
import com.intellij.openapi.progress.util.PotemkinProgress;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.concurrency.Semaphore;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCLog;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLongActionUtil {
    public static final String TIMEOUT_PROPERTY = "cidr.resolve.in.ui.timeout";
    public static final int DEFAULT_TIMEOUT = 5000;
    public static boolean ourAutoCancelLongAction = false;

    public static void setAutoCancelLongAction(boolean autoCancelLongAction) {
        ourAutoCancelLongAction = autoCancelLongAction;
    }

    private static int getTimeoutInMs(@NotNull String timeoutPropertyName) {
        if (timeoutPropertyName == null) {
            OCLongActionUtil.$$$reportNull$$$0(0);
        }
        try {
            return Integer.parseInt(System.getProperty(timeoutPropertyName, String.valueOf(5000)));
        }
        catch (Throwable ignored) {
            return 5000;
        }
    }

    @Nullable
    public static <T> T execWithTimeoutProgressInDispatch(@NotNull String descriptorIdForIndicator, @NotNull String timeoutPropertyName, @Nullable Project project2, Computable<T> longAction) {
        ProgressIndicator progress;
        Application application;
        if (descriptorIdForIndicator == null) {
            OCLongActionUtil.$$$reportNull$$$0(1);
        }
        if (timeoutPropertyName == null) {
            OCLongActionUtil.$$$reportNull$$$0(2);
        }
        if ((application = ApplicationManager.getApplication()).isDispatchThread() && (progress = OCLongActionUtil.installTimeoutIndicatorIfNeed(descriptorIdForIndicator, timeoutPropertyName, project2)) != null) {
            try {
                return (T)ProgressManager.getInstance().runProcess(longAction, progress);
            }
            catch (ProcessCanceledException pie) {
                if (progress.isCanceled()) {
                    OCLog.LOG.warn(descriptorIdForIndicator, new Throwable(pie));
                }
                throw pie;
            }
        }
        return (T)longAction.compute();
    }

    @Nullable
    private static ProgressIndicator installTimeoutIndicatorIfNeed(@NotNull String descriptorIdForIndicator, @NotNull String timeoutPropertyName, @Nullable Project project2) {
        ProgressIndicator indicator;
        if (descriptorIdForIndicator == null) {
            OCLongActionUtil.$$$reportNull$$$0(3);
        }
        if (timeoutPropertyName == null) {
            OCLongActionUtil.$$$reportNull$$$0(4);
        }
        if ((indicator = ProgressManager.getInstance().getProgressIndicator()) != null) {
            return null;
        }
        return new WatchDogIndicator(OCLongActionUtil.getTimeoutInMs(timeoutPropertyName), project2, descriptorIdForIndicator);
    }

    @Nullable(value="null if the timeout is exceeded")
    public static <T> T readInBackgroundAndWait(Computable<T> computable, long maxTimeoutMs) {
        Application application = ApplicationManager.getApplication();
        if (!application.isDispatchThread()) {
            throw new UnsupportedOperationException("This method is not needed in background thread (let your caller cancel you instead)");
        }
        if (application.isWriteAccessAllowed()) {
            throw new UnsupportedOperationException("This method can't be run in write action (it'll deadlock waiting for read action in spawned thread)");
        }
        Ref result = Ref.create();
        Semaphore semaphore = new Semaphore(1);
        Runnable cancellableRunnable = () -> {
            result.set(application.runReadAction(computable));
            semaphore.up();
        };
        ProgressIndicatorBase indicator = new ProgressIndicatorBase();
        application.executeOnPooledThread(() -> OCLongActionUtil.lambda$readInBackgroundAndWait$1(cancellableRunnable, (ProgressIndicator)indicator));
        try {
            if (!semaphore.waitFor(maxTimeoutMs)) {
                indicator.cancel();
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
        return (T)result.get();
    }

    private static /* synthetic */ void lambda$readInBackgroundAndWait$1(Runnable cancellableRunnable, ProgressIndicator indicator) {
        ProgressManager.getInstance().runProcess(cancellableRunnable, indicator);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeoutPropertyName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorIdForIndicator";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/ui/OCLongActionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getTimeoutInMs";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "execWithTimeoutProgressInDispatch";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "installTimeoutIndicatorIfNeed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class WatchDogIndicator
    extends AbstractProgressIndicatorExBase
    implements PingProgress {
        private final long myStartTimeMs;
        private final long myTimeOutMs;
        private final Project myProject;
        private final String myDescriptorIdForIndicator;
        private PotemkinProgress myProgress;

        /*
         * WARNING - void declaration
         */
        public WatchDogIndicator(long timeOutMs, @Nullable Project project2, @NotNull String string) {
            void descriptorIdForIndicator;
            if (string == null) {
                WatchDogIndicator.$$$reportNull$$$0(0);
            }
            this.myTimeOutMs = timeOutMs;
            this.myDescriptorIdForIndicator = descriptorIdForIndicator;
            this.myStartTimeMs = System.currentTimeMillis();
            this.myProject = project2;
            this.setIndeterminate(true);
        }

        public boolean isCanceled() {
            if (System.currentTimeMillis() - this.myStartTimeMs >= this.myTimeOutMs) {
                if (ourAutoCancelLongAction) {
                    this.cancel();
                } else if (this.myProgress == null && ApplicationManager.getApplication().isDispatchThread() && !ApplicationManager.getApplication().isHeadlessEnvironment() && !ApplicationManager.getApplication().isUnitTestMode()) {
                    List titles = StringUtil.split((String)OCBundle.message(this.myDescriptorIdForIndicator, new Object[0]), (String)"\n");
                    if (titles.size() > 1) {
                        this.setText((String)titles.get(1));
                    }
                    if (titles.size() > 2) {
                        this.setText2((String)titles.get(2));
                    }
                    this.myProgress = new PotemkinProgress((String)titles.get(0), this.myProject, null, CommonBundle.getCancelButtonText());
                    this.myProgress.start();
                    this.addStateDelegate((ProgressIndicatorEx)this.myProgress);
                }
            }
            return super.isCanceled();
        }

        public void interact() {
            if (this.myProgress != null) {
                this.myProgress.interact();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorIdForIndicator", "com/jetbrains/cidr/lang/ui/OCLongActionUtil$WatchDogIndicator", "<init>"));
        }
    }
}

