/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.ui;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.ClickListener;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextListener;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.psi.OCConfigurationOwner;
import com.jetbrains.cidr.lang.psi.OCParsedLanguageAndConfiguration;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCResolveContextPanel
extends EditorBasedWidget
implements StatusBarWidget.Multiframe,
CustomStatusBarWidget {
    public static final String ID = "ActiveOCBuildConfiguration";
    private final TextPanel myComponent;
    private volatile boolean myActionEnabled;
    private volatile boolean myHasList;
    private JLabel myArrowsIcon;
    private final AsyncProcessIcon myRepoActivityIcon;
    private ProgressIndicator myCurrentProgress;
    @Nullable
    private volatile VirtualFile myCurrentFile;
    private volatile boolean isCalculatingContext;

    @NotNull
    private static AsyncProcessIcon createActivityIcon(@NotNull String name2) {
        if (name2 == null) {
            OCResolveContextPanel.$$$reportNull$$$0(0);
        }
        AsyncProcessIcon icon = new AsyncProcessIcon(name2).setUseMask(false);
        icon.setPaintPassiveIcon(false);
        icon.setOpaque(false);
        icon.suspend();
        AsyncProcessIcon asyncProcessIcon = icon;
        if (asyncProcessIcon == null) {
            OCResolveContextPanel.$$$reportNull$$$0(1);
        }
        return asyncProcessIcon;
    }

    public OCResolveContextPanel(@NotNull Project project2) {
        if (project2 == null) {
            OCResolveContextPanel.$$$reportNull$$$0(2);
        }
        super(project2);
        this.myArrowsIcon = new JLabel(AllIcons.Ide.Statusbar_arrows);
        this.myRepoActivityIcon = OCResolveContextPanel.createActivityIcon("Resolve Context Activity");
        this.myComponent = new TextPanel(){

            public void doLayout() {
                super.doLayout();
                Rectangle r = this.getBounds();
                Insets insets = this.getInsets();
                Dimension aSize = OCResolveContextPanel.this.myRepoActivityIcon.getMinimumSize();
                int aWidth = (int)aSize.getWidth();
                int aHeight = (int)aSize.getHeight();
                OCResolveContextPanel.this.myRepoActivityIcon.setBounds(r.width - insets.right - aWidth, r.height / 2 - aHeight / 2, aWidth, aHeight);
                Icon icon = OCResolveContextPanel.this.myArrowsIcon.getIcon();
                int iconWidth = icon.getIconWidth();
                int iconHeight = icon.getIconHeight();
                OCResolveContextPanel.this.myArrowsIcon.setBounds(r.width - insets.right - iconWidth - 2, r.height / 2 - iconHeight / 2, iconWidth, iconHeight);
            }
        };
        this.myComponent.add((Component)this.myArrowsIcon);
        this.myComponent.add((Component)this.myRepoActivityIcon);
        this.myComponent.setRightPadding((int)(this.myRepoActivityIcon.getMinimumSize().getWidth() + 6.0));
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (OCResolveContextPanel.this.myHasList) {
                    OCResolveContextPanel.this.showPopup(e);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/cidr/lang/ui/OCResolveContextPanel$2", "onClick"));
            }
        }.installOn((Component)this.myComponent);
        this.myComponent.setBorder(StatusBarWidget.WidgetBorder.INSTANCE);
        class Listener
        implements DumbService.DumbModeListener,
        OCInclusionContextListener {
            volatile boolean isDumbMode;

            Listener() {
            }

            public void enteredDumbMode() {
                this.isDumbMode = true;
                OCResolveContextPanel.this.scheduleUpdate();
            }

            public void exitDumbMode() {
                this.isDumbMode = false;
                OCResolveContextPanel.this.scheduleUpdate();
            }

            @Override
            public void resolveRootAndActiveConfigurationChanged(@NotNull VirtualFile file, @NotNull OCResolveRootAndConfiguration rootAndConfiguration) {
                if (file == null) {
                    Listener.$$$reportNull$$$0(0);
                }
                if (rootAndConfiguration == null) {
                    Listener.$$$reportNull$$$0(1);
                }
                if (!OCResolveContextPanel.this.isCalculatingContext && !this.isDumbMode && file.equals(OCResolveContextPanel.this.myCurrentFile)) {
                    OCResolveContextPanel.this.scheduleUpdate();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rootAndConfiguration";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/lang/ui/OCResolveContextPanel$1Listener";
                objectArray[2] = "resolveRootAndActiveConfigurationChanged";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        Listener listener2 = new Listener();
        this.myConnection.subscribe(DumbService.DUMB_MODE, (Object)listener2);
        this.myConnection.subscribe(OCInclusionContextListener.TOPIC, (Object)listener2);
        this.scheduleUpdate();
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            OCResolveContextPanel.$$$reportNull$$$0(3);
        }
        this.scheduleUpdate();
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            OCResolveContextPanel.$$$reportNull$$$0(4);
        }
        if (file == null) {
            OCResolveContextPanel.$$$reportNull$$$0(5);
        }
        this.scheduleUpdate();
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            OCResolveContextPanel.$$$reportNull$$$0(6);
        }
        if (file == null) {
            OCResolveContextPanel.$$$reportNull$$$0(7);
        }
        this.scheduleUpdate();
    }

    public StatusBarWidget copy() {
        return new OCResolveContextPanel(this.myProject);
    }

    @NotNull
    public String ID() {
        if (ID == null) {
            OCResolveContextPanel.$$$reportNull$$$0(8);
        }
        return ID;
    }

    public TextPanel getComponent() {
        return this.myComponent;
    }

    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        if (type == null) {
            OCResolveContextPanel.$$$reportNull$$$0(9);
        }
        return null;
    }

    private void showPopup(MouseEvent e) {
        ListPopup popup = this.getPopupStep(DataManager.getInstance().getDataContext((Component)this.myStatusBar));
        if (popup == null) {
            return;
        }
        Dimension dimension = popup.getContent().getPreferredSize();
        Point at = new Point(0, -dimension.height);
        popup.show(new RelativePoint(e.getComponent(), at));
        Disposer.register((Disposable)this, (Disposable)popup);
    }

    public ListPopup getPopupStep(@NotNull DataContext context) {
        VirtualFile file;
        if (context == null) {
            OCResolveContextPanel.$$$reportNull$$$0(10);
        }
        if ((file = this.getSelectedFile()) == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
        if (!OCResolveContextPanel.isAppropriateFile(psiFile)) {
            return null;
        }
        Pair<Collection<OCResolveConfiguration>, Boolean> configurations = OCResolveContextPanel.getFileConfigurations(psiFile, true, null);
        DefaultActionGroup group = new DefaultActionGroup();
        if (!((Boolean)configurations.second).booleanValue()) {
            group.addSeparator("All project contexts are listed");
        }
        for (OCResolveConfiguration config : (Collection)configurations.first) {
            group.add((AnAction)new ConfigurationItem(psiFile, config));
        }
        OCResolveConfiguration selected = OCInclusionContextUtil.getOrCalculateParsedLanguageAndConfiguration(psiFile).getConfiguration();
        ListPopup list = JBPopupFactory.getInstance().createActionGroupPopup("Available Resolve Contexts", (ActionGroup)group, context, false, false, false, null, 15, action -> ((ConfigurationItem)((Object)action)).getConfig() == selected);
        list.setAdText("File will be resolved in the selected context", 10);
        return list;
    }

    private static void scheduleReParse(PsiFile psiFile, OCResolveConfiguration config) {
        GuiUtils.invokeLaterIfNeeded(() -> OCInclusionContextUtil.setUserSelectedConfiguration(psiFile, config), (ModalityState)ModalityState.defaultModalityState());
    }

    public void scheduleUpdate() {
        UIUtil.invokeLaterIfNeeded(() -> {
            PsiFile psiFile;
            VirtualFile file;
            if (this.myCurrentProgress != null) {
                this.myCurrentProgress.cancel();
            }
            if (this.isDisposed()) {
                return;
            }
            this.myCurrentFile = file = this.getSelectedFile();
            if (this.hasAccessToSymbols() && file != null && file.isValid() && OCResolveContextPanel.isAppropriateFile(psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file))) {
                this.myCurrentProgress = new EmptyProgressIndicator();
                this.updateUI(file, null, false, false, null, true);
                this.scheduleReloadFileContexts(file, this.myCurrentProgress);
                return;
            }
            this.updateUI(null, null, false, false, null, false);
        });
    }

    private static boolean isAppropriateFile(@Nullable PsiFile psiFile) {
        return psiFile instanceof OCConfigurationOwner && psiFile.isValid();
    }

    private void scheduleReloadFileContexts(@NotNull VirtualFile file, @NotNull ProgressIndicator globalProgress) {
        if (file == null) {
            OCResolveContextPanel.$$$reportNull$$$0(11);
        }
        if (globalProgress == null) {
            OCResolveContextPanel.$$$reportNull$$$0(12);
        }
        SensitiveProgressWrapper progress = new SensitiveProgressWrapper(globalProgress);
        ReadTask task = new ReadTask((ProgressIndicator)progress, file, globalProgress){
            final /* synthetic */ ProgressIndicator val$progress;
            final /* synthetic */ VirtualFile val$file;
            final /* synthetic */ ProgressIndicator val$globalProgress;
            {
                this.val$progress = progressIndicator;
                this.val$file = virtualFile;
                this.val$globalProgress = progressIndicator2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void computeInReadAction(@NotNull ProgressIndicator indicator) {
                OCParsedLanguageAndConfiguration langAndConfig;
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (OCResolveContextPanel.this.isDisposed() || OCResolveContextPanel.this.myProject.isDisposed()) {
                    return;
                }
                this.val$progress.checkCanceled();
                if (!this.val$file.isValid()) {
                    OCResolveContextPanel.this.updateUI(null, null, false, false, null, false);
                    return;
                }
                PsiFile psiFile = PsiManager.getInstance((Project)OCResolveContextPanel.this.myProject).findFile(this.val$file);
                if (!OCResolveContextPanel.isAppropriateFile(psiFile) || !OCResolveContextPanel.this.hasAccessToSymbols()) {
                    OCResolveContextPanel.this.updateUI(this.val$file, null, false, false, null, true);
                    return;
                }
                OCResolveContextPanel.this.isCalculatingContext = true;
                try {
                    langAndConfig = OCInclusionContextUtil.getOrCalculateParsedLanguageAndConfiguration(psiFile);
                }
                finally {
                    OCResolveContextPanel.this.isCalculatingContext = false;
                }
                OCResolveConfiguration config = langAndConfig.getConfiguration();
                OCLanguageKind kind = langAndConfig.getLanguageKind();
                this.val$progress.checkCanceled();
                OCResolveContextPanel.this.updateUI(this.val$file, config, false, false, kind, true);
                Collection cs = (Collection)OCResolveContextPanel.getFileConfigurations((PsiFile)psiFile, (boolean)false, (ProgressIndicator)this.val$progress).first;
                this.val$progress.checkCanceled();
                if (cs.size() > 0 && !cs.contains(config)) {
                    OCResolveContextPanel.scheduleReParse(psiFile, (OCResolveConfiguration)ContainerUtil.getFirstItem((Collection)cs));
                } else {
                    OCResolveContextPanel.this.updateUI(this.val$file, config, config != null, cs.size() > 1, kind, false);
                }
            }

            public void onCanceled(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (!this.val$globalProgress.isCanceled()) {
                    OCResolveContextPanel.this.scheduleReloadFileContexts(this.val$file, this.val$globalProgress);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "indicator";
                objectArray2[1] = "com/jetbrains/cidr/lang/ui/OCResolveContextPanel$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "computeInReadAction";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onCanceled";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (globalProgress == null) {
                    OCResolveContextPanel.$$$reportNull$$$0(17);
                }
                ApplicationManager.getApplication().runReadAction(() -> {
                    if (globalProgress == null) {
                        OCResolveContextPanel.$$$reportNull$$$0(18);
                    }
                    task.computeInReadAction(globalProgress);
                });
            });
        } else {
            ProgressIndicatorUtils.scheduleWithWriteActionPriority((ProgressIndicator)progress, (ReadTask)task);
        }
    }

    private void updateUI(@Nullable VirtualFile file, @Nullable OCResolveConfiguration config, boolean actionsEnabled, boolean hasMoreConfigs, @Nullable OCLanguageKind kind, boolean isLoading) {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (file != null && !Comparing.equal((Object)this.getSelectedFile(), (Object)file)) {
                return;
            }
            this.myActionEnabled = actionsEnabled;
            this.myHasList = actionsEnabled && hasMoreConfigs;
            Pair<String, String> titleWithDescription = OCResolveContextPanel.getTitleWithDescription(config, kind, !this.hasAccessToSymbols(), isLoading);
            String title = (String)titleWithDescription.first;
            this.myComponent.setText(title);
            this.myComponent.setToolTipText((String)titleWithDescription.second);
            this.myComponent.setForeground(this.myActionEnabled ? UIUtil.getActiveTextColor() : UIUtil.getInactiveTextColor());
            if (this.myStatusBar != null) {
                this.myStatusBar.updateWidget(this.ID());
            }
            boolean haveTitle = title != null;
            this.myArrowsIcon.setVisible(haveTitle && !isLoading && this.myHasList);
            if (haveTitle && isLoading) {
                this.myRepoActivityIcon.resume();
            } else {
                this.myRepoActivityIcon.suspend();
            }
        });
    }

    private boolean hasAccessToSymbols() {
        return !DumbService.getInstance((Project)this.myProject).isDumb() && FileSymbolTablesCache.areSymbolsLoaded(this.myProject);
    }

    @NotNull
    private static Pair<String, String> getTitleWithDescription(@Nullable OCResolveConfiguration config, @Nullable OCLanguageKind kind, boolean dumb, boolean isLoading) {
        String description;
        String title;
        if (dumb) {
            title = "Indexing...";
            description = ActionUtil.getUnavailableMessage((String)"Resolve context", (boolean)false);
        } else if (config == null) {
            if (isLoading) {
                title = "Loading...";
                description = "Loading resolve contexts...";
            } else {
                title = "<no context>";
                description = "No resolve context for current file";
            }
        } else {
            title = config.getDisplayName(true);
            description = "Current file is resolved in context of " + config.getDisplayName(false);
            if (kind != null) {
                description = description + " (" + kind.getDisplayName() + ")";
            }
        }
        Pair pair2 = Pair.create((Object)("Context: " + title), (Object)description);
        if (pair2 == null) {
            OCResolveContextPanel.$$$reportNull$$$0(13);
        }
        return pair2;
    }

    @NotNull
    private static Pair<Collection<OCResolveConfiguration>, Boolean> getFileConfigurations(@NotNull PsiFile psiFile, boolean sort, @Nullable ProgressIndicator progress) {
        if (psiFile == null) {
            OCResolveContextPanel.$$$reportNull$$$0(14);
        }
        boolean isDetermined = true;
        Collection<OCResolveConfiguration> allConfigurations = OCInclusionContextUtil.getAllBuildConfigurationsForFile(psiFile, progress);
        if (allConfigurations.isEmpty()) {
            isDetermined = false;
            allConfigurations = OCWorkspace.getInstance(psiFile.getProject()).getConfigurations();
        }
        if (!sort) {
            Pair pair2 = new Pair(allConfigurations, (Object)isDetermined);
            if (pair2 == null) {
                OCResolveContextPanel.$$$reportNull$$$0(15);
            }
            return pair2;
        }
        ArrayList<OCResolveConfiguration> sorted = new ArrayList<OCResolveConfiguration>(allConfigurations);
        Collections.sort(sorted);
        Pair pair3 = new Pair(sorted, (Object)isDetermined);
        if (pair3 == null) {
            OCResolveContextPanel.$$$reportNull$$$0(16);
        }
        return pair3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 8: 
            case 13: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 8: 
            case 13: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 8: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/ui/OCResolveContextPanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 5: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalProgress";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/ui/OCResolveContextPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createActivityIcon";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "ID";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitleWithDescription";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createActivityIcon";
                break;
            }
            case 1: 
            case 8: 
            case 13: 
            case 15: 
            case 16: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "selectionChanged";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fileOpened";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fileClosed";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPopupStep";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "scheduleReloadFileContexts";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFileConfigurations";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$scheduleReloadFileContexts$4";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 8: 
            case 13: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ConfigurationItem
    extends AnAction {
        @NotNull
        private final PsiFile myFile;
        @NotNull
        private final OCResolveConfiguration myConfig;

        public ConfigurationItem(@NotNull PsiFile file, @NotNull OCResolveConfiguration config) {
            if (file == null) {
                ConfigurationItem.$$$reportNull$$$0(0);
            }
            if (config == null) {
                ConfigurationItem.$$$reportNull$$$0(1);
            }
            super(config.getDisplayName(false));
            this.myFile = file;
            this.myConfig = config;
        }

        public void actionPerformed(AnActionEvent e) {
            OCResolveContextPanel.scheduleReParse(this.myFile, this.myConfig);
        }

        @NotNull
        public OCResolveConfiguration getConfig() {
            OCResolveConfiguration oCResolveConfiguration = this.myConfig;
            if (oCResolveConfiguration == null) {
                ConfigurationItem.$$$reportNull$$$0(2);
            }
            return oCResolveConfiguration;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/ui/OCResolveContextPanel$ConfigurationItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/ui/OCResolveContextPanel$ConfigurationItem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfig";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

