/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.FilteredQuery;
import com.intellij.util.Query;
import com.jetbrains.cidr.lang.generate.OCCppGeneratedQualifiedFunctionKt;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.search.OCFunctionAncestorsQuery;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.ComplexTextRange;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolAttribute;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterTypeSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCBooleanTypeVisitor;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCallableUtil {
    public static final String IMPLEMENTED_METHOD_TEMPLATE_NAME = "OC Implemented Method Body.m";
    public static final String OVERRIDDEN_METHOD_TEMPLATE_NAME = "OC Overridden Method Body.m";
    private static final String OVERRIDDEN_INIT_METHOD_TEMPLATE_NAME = "OC Overridden InitWith Method Body.m";
    private static final String OVERRIDDEN_IS_EQUAL_METHOD_TEMPLATE_NAME = "OC Overridden IsEqual Method Body.m";
    public static final String OVERRIDDEN_DESCRIPTION_TEMPLATE_NAME1 = "OC Overridden Description Body 1.m";
    public static final String OVERRIDDEN_DESCRIPTION_TEMPLATE_NAME2 = "OC Overridden Description Body 2.m";
    public static final String OVERRIDDEN_DESCRIPTION_TEMPLATE_NAME3 = "OC Overridden Description Body 3.m";
    public static final String OVERRIDDEN_COPY_TEMPLATE_NAME1 = "OC Overridden CopyWithZone Body 1.m";
    public static final String OVERRIDDEN_COPY_TEMPLATE_NAME2 = "OC Overridden CopyWithZone Body 2.m";
    public static final String OVERRIDDEN_COPY_TEMPLATE_NAME3 = "OC Overridden CopyWithZone Body 3.m";
    private static final String PROPERTY_GETTER_TEMPLATE_NAME = "OC Property Getter Body.m";
    private static final String PROPERTY_SETTER_TEMPLATE_NAME = "OC Property Setter Body.m";
    private static final String CPP_IMPLEMENTED_FUNCTION_TEMPLATE_NAME = "C++ Implemented Function Body.cc";
    private static final String CPP_OVERRIDDEN_FUNCTION_TEMPLATE_NAME = "C++ Overridden Function Body.cc";
    private static final String CONTAINING_CLASS_TEMPLATE_PROPERTY = "CONTAINING_CLASS";
    private static final String RETURN_TYPE_TEMPLATE_PROPERTY = "RETURN_TYPE";
    private static final String DEFAULT_RETURN_VALUE_TEMPLATE_PROPERTY = "DEFAULT_RETURN_VALUE";
    private static final String CALL_SUPER_TEMPLATE_PROPERTY = "CALL_SUPER";
    private static final String CUSTOM_CODE_TEMPLATE_PROPERTY = "CUSTOM_CODE";
    public static final String IVAR_IS_AVAILABLE_TEMPLATE_PROPERTY = "IVAR_IS_AVAILABLE";
    private static final String IVAR_TEMPLATE_PROPERTY = "IVAR";
    private static final String PARAM_TEMPLATE_PROPERTY = "PARAM";
    private static final String SETTER_SEMANTICS_TEMPLATE_PROPERTY = "SETTER_SEMANTICS";

    private OCCallableUtil() {
    }

    public static String methodText(@NotNull OCMethodSymbol baseMethod, String customCode, @NotNull PsiElement context) {
        if (baseMethod == null) {
            OCCallableUtil.$$$reportNull$$$0(0);
        }
        if (context == null) {
            OCCallableUtil.$$$reportNull$$$0(1);
        }
        return OCCallableUtil.methodText(baseMethod, null, OCCallableUtil.methodSignature(baseMethod, context, OCResolveContext.forPsi(context)), customCode, context);
    }

    public static String methodFromTemplate(@NotNull OCMethodSymbol baseMethod, String customTemplate, PsiElement context, @Nullable Map<String, String> customProperties, @NotNull Project project2) {
        if (baseMethod == null) {
            OCCallableUtil.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            OCCallableUtil.$$$reportNull$$$0(3);
        }
        OCResolveContext resolveContext = context != null ? OCResolveContext.forPsi(context) : OCResolveContext.forSymbol(baseMethod, project2);
        OCType returnType = baseMethod.getReturnType(resolveContext.getProject()).resolve(resolveContext);
        return OCCallableUtil.methodText(baseMethod, returnType, customTemplate, OCCallableUtil.methodSignature(baseMethod, context, resolveContext), "", context, customProperties);
    }

    public static String methodFromTemplate(@NotNull OCMethodSymbol baseMethod, String customTemplate, String customCode, @NotNull PsiElement context) {
        if (baseMethod == null) {
            OCCallableUtil.$$$reportNull$$$0(4);
        }
        if (context == null) {
            OCCallableUtil.$$$reportNull$$$0(5);
        }
        return OCCallableUtil.methodText(baseMethod, customTemplate, OCCallableUtil.methodSignature(baseMethod, context, OCResolveContext.forPsi(context)), customCode, context);
    }

    public static String methodWithSignature(@NotNull OCType returnType, String signature, PsiElement context) {
        if (returnType == null) {
            OCCallableUtil.$$$reportNull$$$0(6);
        }
        return OCCallableUtil.methodText(null, returnType, IMPLEMENTED_METHOD_TEMPLATE_NAME, signature, "", context, null);
    }

    public static String functionWithSignature(@NotNull OCType returnType, String signature, @NotNull PsiElement context) {
        if (returnType == null) {
            OCCallableUtil.$$$reportNull$$$0(7);
        }
        if (context == null) {
            OCCallableUtil.$$$reportNull$$$0(8);
        }
        StringBuilder answer = new StringBuilder();
        answer.append(signature).append("{\n ");
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)context.getProject());
        FileTemplate bodyTemplate = fileTemplateManager.getCodeTemplate(CPP_IMPLEMENTED_FUNCTION_TEMPLATE_NAME);
        if (bodyTemplate != null) {
            Properties templateProperties = new Properties(FileTemplateManager.getInstance((Project)context.getProject()).getDefaultProperties());
            OCResolveContext resolveContext = OCResolveContext.forPsi(context);
            OCType resolved = returnType.resolve(resolveContext);
            templateProperties.setProperty(RETURN_TYPE_TEMPLATE_PROPERTY, resolved.getBestNameInContext(resolveContext));
            templateProperties.setProperty(DEFAULT_RETURN_VALUE_TEMPLATE_PROPERTY, resolved.getDefaultValue(resolveContext));
            try {
                answer.append(bodyTemplate.getText(templateProperties));
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Unable to load template for file template '%s'!", fileTemplateManager.internalTemplateToSubject(CPP_IMPLEMENTED_FUNCTION_TEMPLATE_NAME)), e);
            }
        }
        answer.append("\n}\n");
        return answer.toString();
    }

    public static String methodWithSignature(@NotNull OCMethodSymbol baseMethod, String signature, String customCode, @NotNull PsiElement context) {
        if (baseMethod == null) {
            OCCallableUtil.$$$reportNull$$$0(9);
        }
        if (context == null) {
            OCCallableUtil.$$$reportNull$$$0(10);
        }
        return OCCallableUtil.methodText(baseMethod, null, signature, customCode, context);
    }

    public static String methodText(@NotNull OCMethodSymbol baseMethod, String customTemplate, String signature, String customCode, @NotNull PsiElement context) {
        if (baseMethod == null) {
            OCCallableUtil.$$$reportNull$$$0(11);
        }
        if (context == null) {
            OCCallableUtil.$$$reportNull$$$0(12);
        }
        OCType returnType = baseMethod.getReturnType(context.getProject()).resolve(OCResolveContext.forSymbol(baseMethod, context.getProject()));
        return OCCallableUtil.methodText(baseMethod, returnType, customTemplate, signature, customCode, context, null);
    }

    public static String methodText(@NotNull String signature, @NotNull String body, @NotNull PsiElement context) {
        if (signature == null) {
            OCCallableUtil.$$$reportNull$$$0(13);
        }
        if (body == null) {
            OCCallableUtil.$$$reportNull$$$0(14);
        }
        if (context == null) {
            OCCallableUtil.$$$reportNull$$$0(15);
        }
        StringBuilder answer = new StringBuilder();
        answer.append(signature);
        Project project2 = context.getProject();
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project2).getCustomSettings(OCCodeStyleSettings.class);
        if (settings != null && settings.SEMICOLON_AFTER_METHOD_SIGNATURE) {
            answer.append(";");
        }
        answer.append("{\n ");
        answer.append(body);
        answer.append("\n}\n");
        return answer.toString();
    }

    private static String methodText(@Nullable OCMethodSymbol baseMethod, @NotNull OCType returnType, @Nullable String customTemplate, String signature, String customCode, @NotNull PsiElement context, @Nullable Map<String, String> customProperties) {
        if (returnType == null) {
            OCCallableUtil.$$$reportNull$$$0(16);
        }
        if (context == null) {
            OCCallableUtil.$$$reportNull$$$0(17);
        }
        StringBuilder answer = new StringBuilder();
        answer.append(signature);
        Project project2 = context.getProject();
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project2).getCustomSettings(OCCodeStyleSettings.class);
        if (settings != null && settings.SEMICOLON_AFTER_METHOD_SIGNATURE) {
            answer.append(";");
        }
        answer.append("{\n ");
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)project2);
        OCPropertySymbol property = baseMethod != null ? baseMethod.getGeneratedFromProperty() : null;
        OCInstanceVariableSymbol ivar = property != null ? property.getAssociatedIvar(project2) : null;
        OCClassDeclaration parentClass = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)context, OCClassDeclaration.class, (boolean)false);
        String templateName = property != null && ivar != null ? (baseMethod.isSetter(OCResolveContext.forPsi(context)) ? PROPERTY_SETTER_TEMPLATE_NAME : PROPERTY_GETTER_TEMPLATE_NAME) : (customTemplate != null && customTemplate != OVERRIDDEN_METHOD_TEMPLATE_NAME ? customTemplate : (baseMethod != null && OCElementUtil.startsWithWord(baseMethod.getName(), "init") ? OVERRIDDEN_INIT_METHOD_TEMPLATE_NAME : (baseMethod != null && baseMethod.getName().equals("isEqual:") ? OVERRIDDEN_IS_EQUAL_METHOD_TEMPLATE_NAME : (baseMethod != null && baseMethod.getName().equals("description") ? OVERRIDDEN_DESCRIPTION_TEMPLATE_NAME2 : (baseMethod != null && baseMethod.getName().equals("copyWithZone:") ? OVERRIDDEN_COPY_TEMPLATE_NAME2 : (customTemplate != null ? customTemplate : OVERRIDDEN_METHOD_TEMPLATE_NAME))))));
        FileTemplate bodyTemplate = fileTemplateManager.getCodeTemplate(templateName);
        if (bodyTemplate != null) {
            Properties templateProperties = new Properties(FileTemplateManager.getInstance((Project)project2).getDefaultProperties());
            if (customProperties != null) {
                for (Map.Entry<String, String> entry : customProperties.entrySet()) {
                    templateProperties.setProperty(entry.getKey(), entry.getValue());
                }
            }
            OCResolveContext resolveContext = OCResolveContext.forPsi(context);
            templateProperties.setProperty(CONTAINING_CLASS_TEMPLATE_PROPERTY, parentClass != null ? parentClass.getName() : "");
            templateProperties.setProperty(RETURN_TYPE_TEMPLATE_PROPERTY, returnType.getBestNameInContext(resolveContext));
            templateProperties.setProperty(DEFAULT_RETURN_VALUE_TEMPLATE_PROPERTY, returnType.getDefaultValue(resolveContext));
            templateProperties.setProperty(CALL_SUPER_TEMPLATE_PROPERTY, OCCallableUtil.getCallSuperText(baseMethod, context));
            templateProperties.setProperty(CUSTOM_CODE_TEMPLATE_PROPERTY, customCode != null ? customCode : "");
            boolean arcEnabled = OCCompilerFeatures.isArcEnabled(context.getContainingFile());
            if (property != null && ivar != null) {
                OCDeclaratorSymbol parameter;
                templateProperties.setProperty(IVAR_TEMPLATE_PROPERTY, ivar.getName());
                if (baseMethod.isSetter(resolveContext) && (parameter = baseMethod.getSelectors().get(0).getParameter()) != null) {
                    templateProperties.setProperty(PARAM_TEMPLATE_PROPERTY, OCNameSuggester.suggestUniqueName(parameter, context));
                }
                if (property.hasAttribute(OCPropertySymbol.PropertyAttribute.COPY)) {
                    templateProperties.setProperty(SETTER_SEMANTICS_TEMPLATE_PROPERTY, arcEnabled ? "copyArc" : "copy");
                } else if (property.hasAttribute(OCPropertySymbol.PropertyAttribute.RETAIN) && !arcEnabled) {
                    templateProperties.setProperty(SETTER_SEMANTICS_TEMPLATE_PROPERTY, "retain");
                } else {
                    templateProperties.setProperty(SETTER_SEMANTICS_TEMPLATE_PROPERTY, "assign");
                }
            }
            try {
                if (baseMethod == null || !baseMethod.getName().equals("dealloc") || !arcEnabled) {
                    answer.append(bodyTemplate.getText(templateProperties));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Unable to load template for file template '%s'!", fileTemplateManager.internalTemplateToSubject(templateName)), e);
            }
        }
        answer.append("\n}\n");
        return answer.toString();
    }

    @NotNull
    private static String fillFunctionBodyTemplate(@NotNull OCFunctionSymbol function, @Nullable OCFunctionSymbol overridingFunction, @NotNull PsiElement context) {
        if (function == null) {
            OCCallableUtil.$$$reportNull$$$0(18);
        }
        if (context == null) {
            OCCallableUtil.$$$reportNull$$$0(19);
        }
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)context.getProject());
        String templateName = overridingFunction != null ? CPP_OVERRIDDEN_FUNCTION_TEMPLATE_NAME : CPP_IMPLEMENTED_FUNCTION_TEMPLATE_NAME;
        FileTemplate bodyTemplate = fileTemplateManager.getCodeTemplate(templateName);
        OCResolveContext resolveContext = OCResolveContext.forPsi(context);
        OCType returnType = function.getEffectiveResolvedType(resolveContext);
        if (function.isCppConstructor() || function.isCppDestructor()) {
            returnType = OCVoidType.instance();
        }
        if (bodyTemplate != null) {
            String string;
            Properties templateProperties = new Properties(FileTemplateManager.getInstance((Project)context.getProject()).getDefaultProperties());
            templateProperties.setProperty(RETURN_TYPE_TEMPLATE_PROPERTY, returnType.getBestNameInContext(resolveContext));
            templateProperties.setProperty(DEFAULT_RETURN_VALUE_TEMPLATE_PROPERTY, returnType.getDefaultValue(resolveContext));
            if (overridingFunction != null) {
                templateProperties.setProperty(CALL_SUPER_TEMPLATE_PROPERTY, overridingFunction.getVisibility() != OCVisibility.PRIVATE ? OCCallableUtil.getBaseCallText(function, overridingFunction) : "");
            }
            try {
                string = bodyTemplate.getText(templateProperties);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Unable to load template for file template '%s'!", fileTemplateManager.internalTemplateToSubject(templateName)), e);
            }
            if (string == null) {
                OCCallableUtil.$$$reportNull$$$0(20);
            }
            return string;
        }
        if ("" == null) {
            OCCallableUtil.$$$reportNull$$$0(21);
        }
        return "";
    }

    private static String getAdHocParameterName(String methodName, boolean isFirstParameter) {
        if (methodName.startsWith("isEqual") && isFirstParameter) {
            return "other";
        }
        if (methodName.equals("encodeWithCoder:") || methodName.equals("initWithCoder:")) {
            return "coder";
        }
        return null;
    }

    private static String getCallSuperText(@Nullable OCMethodSymbol baseMethod, @NotNull PsiElement context) {
        if (context == null) {
            OCCallableUtil.$$$reportNull$$$0(22);
        }
        if (baseMethod == null) {
            return "";
        }
        StringBuilder callSuper = new StringBuilder();
        callSuper.append("[super ");
        boolean first = true;
        for (OCMethodSymbol.SelectorPartSymbol part : baseMethod.getSelectors()) {
            if (!first) {
                callSuper.append(' ');
            }
            callSuper.append(part.getSelectorName()).append(' ');
            OCDeclaratorSymbol param = part.getParameter();
            if (param != null) {
                String parameterName = OCCallableUtil.getAdHocParameterName(baseMethod.getName(), first);
                if (parameterName != null) {
                    callSuper.append(parameterName);
                } else {
                    callSuper.append(OCNameSuggester.suggestUniqueName(param, context));
                }
            }
            first = false;
        }
        callSuper.append("]");
        return callSuper.toString();
    }

    @NotNull
    private static String getBaseCallText(@NotNull OCFunctionSymbol override, @NotNull OCFunctionSymbol baseToCall) {
        if (override == null) {
            OCCallableUtil.$$$reportNull$$$0(23);
        }
        if (baseToCall == null) {
            OCCallableUtil.$$$reportNull$$$0(24);
        }
        if (baseToCall.isCppConstructor() || baseToCall.isCppDestructor()) {
            if ("" == null) {
                OCCallableUtil.$$$reportNull$$$0(25);
            }
            return "";
        }
        String string = baseToCall.getParent().getName() + "::" + OCCallableUtil.getBaseCallExpression(override, baseToCall);
        if (string == null) {
            OCCallableUtil.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    private static String getBaseCallExpression(@NotNull OCFunctionSymbol override, @NotNull OCFunctionSymbol baseToCall) {
        OCDeclaratorSymbol param;
        OCType type;
        if (override == null) {
            OCCallableUtil.$$$reportNull$$$0(27);
        }
        if (baseToCall == null) {
            OCCallableUtil.$$$reportNull$$$0(28);
        }
        StringBuilder callSuper = new StringBuilder();
        callSuper.append(baseToCall.getName()).append("(");
        boolean first = true;
        Iterator<OCDeclaratorSymbol> iterator = override.getParameterSymbols().iterator();
        while (iterator.hasNext() && !((type = (param = iterator.next()).getType()) instanceof OCEllipsisType) && !(type instanceof OCVoidType)) {
            if (!first) {
                callSuper.append(",");
            }
            callSuper.append(param.getName());
            first = false;
        }
        callSuper.append(")");
        String string = callSuper.toString();
        if (string == null) {
            OCCallableUtil.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    public static String methodSignature(OCMethodSymbol method, PsiElement context, @NotNull OCResolveContext resolveContext) {
        if (resolveContext == null) {
            OCCallableUtil.$$$reportNull$$$0(30);
        }
        if (context != null) {
            resolveContext = OCResolveContext.forPsi(context);
        }
        StringBuilder answer = new StringBuilder();
        answer.append(method.isStatic() ? (char)'+' : '-');
        answer.append('(');
        Project project2 = resolveContext.getProject();
        if (method.getReturnType(project2).isVoid() && method.hasAttribute("ibaction")) {
            answer.append("IBAction");
        } else {
            answer.append(method.getReturnType(project2).getBestNameInContext(resolveContext, OCElementUtil.getReturnTypeText(method, project2)));
        }
        answer.append(')');
        boolean first = true;
        for (OCMethodSymbol.SelectorPartSymbol part : method.getSelectors()) {
            if (!first) {
                answer.append(' ');
            }
            answer.append(part.getSelectorName());
            OCDeclaratorSymbol param = part.getParameter();
            if (param != null) {
                OCType type = param.getType();
                answer.append('(').append(type.getBestNameInContext(resolveContext, OCElementUtil.getTypeTextWithModifiers(param, project2))).append(')');
                String parameterName = OCCallableUtil.getAdHocParameterName(method.getName(), first);
                if (parameterName != null) {
                    answer.append(parameterName);
                } else {
                    answer.append(OCNameSuggester.suggestUniqueName(param, context));
                }
            }
            first = false;
        }
        if (method.isVararg()) {
            answer.append(",...");
        }
        String string = answer.toString();
        if (string == null) {
            OCCallableUtil.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NotNull
    public static String getFunctionTemplateHeader(@NotNull OCType type, final @NotNull OCResolveContext context) {
        if (type == null) {
            OCCallableUtil.$$$reportNull$$$0(32);
        }
        if (context == null) {
            OCCallableUtil.$$$reportNull$$$0(33);
        }
        final ArrayList typeParameters = new ArrayList();
        type.resolve(context).accept(new OCBooleanTypeVisitor(){

            @Override
            public Boolean visitTypeParameterType(OCTypeParameterType type) {
                PsiElement sibling;
                OCTypeParameterTypeSymbol symbol = (OCTypeParameterTypeSymbol)type.getSymbol();
                ComplexTextRange scope = symbol.getContainingFile() != null ? symbol.getScope() : null;
                OCFunctionDeclaration function = (OCFunctionDeclaration)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context.getElement(), (Class[])new Class[]{OCFunctionDeclaration.class});
                PsiElement psiElement = sibling = function != null ? function.getPrevSibling() : null;
                if (sibling == null && function != null) {
                    sibling = function.getNextSibling();
                }
                if (sibling == null || scope == null || !scope.contains(OCSymbolOffsetUtil.getComplexOffset(sibling))) {
                    typeParameters.add(type.getSymbol());
                }
                return false;
            }

            @Override
            public Boolean visitStructType(OCStructType type) {
                for (OCTypeArgument typeArgument : type.getSymbol().getSubstitution().getSubstitutedTypes()) {
                    if (!(typeArgument instanceof OCType)) continue;
                    ((OCType)typeArgument).accept(this);
                }
                return false;
            }
        });
        if (!typeParameters.isEmpty()) {
            String string = OCCppGeneratedQualifiedFunctionKt.makeTemplateHeader(typeParameters, context);
            if (string == null) {
                OCCallableUtil.$$$reportNull$$$0(34);
            }
            return string;
        }
        if ("" == null) {
            OCCallableUtil.$$$reportNull$$$0(35);
        }
        return "";
    }

    @NotNull
    public static String defaultFunctionBody(@NotNull OCFunctionSymbol function, @Nullable OCFunctionSymbol baseToCall, @NotNull PsiElement context) {
        if (function == null) {
            OCCallableUtil.$$$reportNull$$$0(36);
        }
        if (context == null) {
            OCCallableUtil.$$$reportNull$$$0(37);
        }
        StringBuilder answer = new StringBuilder();
        if (function.isCppConstructor() && baseToCall != null) {
            answer.append(':');
            answer.append(OCCallableUtil.getBaseCallExpression(function, baseToCall));
        }
        answer.append("{\n");
        answer.append(OCCallableUtil.fillFunctionBodyTemplate(function, baseToCall, context));
        answer.append("\n}");
        String string = answer.toString();
        if (string == null) {
            OCCallableUtil.$$$reportNull$$$0(38);
        }
        return string;
    }

    public static String getOverridingFunctionName(OCFunctionSymbol member, OCSymbolWithQualifiedName parent) {
        String newName = parent != null && member.isCppConstructor() ? parent.getName() : (parent != null && member.isCppDestructor() ? "~" + parent.getName() : member.getName());
        return newName;
    }

    @NotNull
    public static OCFunctionSymbol createOverridingFunction(@NotNull OCFunctionSymbol base, @NotNull OCNamespaceSymbol newParent, @NotNull PsiElement context, @Nullable OCVisibility visibility, boolean insertOverride, boolean insertVirtual) {
        if (base == null) {
            OCCallableUtil.$$$reportNull$$$0(39);
        }
        if (newParent == null) {
            OCCallableUtil.$$$reportNull$$$0(40);
        }
        if (context == null) {
            OCCallableUtil.$$$reportNull$$$0(41);
        }
        int newAttributes = base.getFunctionAttributes();
        int newProperties = base.getFunctionProperties();
        newProperties &= ~OCFunctionSymbol.Property.IS_PURE_VIRTUAL.getMask();
        newAttributes = insertVirtual && !base.isCppConstructor() ? (newAttributes |= OCSymbolAttribute.VIRTUAL.getMask()) : (newAttributes &= ~OCSymbolAttribute.VIRTUAL.getMask());
        newAttributes = insertOverride && !base.isCppConstructor() ? (newAttributes |= OCSymbolAttribute.OVERRIDE.getMask()) : (newAttributes &= ~OCSymbolAttribute.OVERRIDE.getMask());
        List<OCDeclaratorSymbol> oldParamSymbols = base.getParameterSymbols();
        ArrayList<OCDeclaratorSymbol> newParamSymbols = new ArrayList<OCDeclaratorSymbol>(oldParamSymbols.size());
        ArrayList<String> createdNames = new ArrayList<String>();
        OCResolveContext resolveContext = OCResolveContext.forPsi(context);
        for (OCDeclaratorSymbol param : oldParamSymbols) {
            Collection<String> suggestedNames;
            OCType type = param.getType();
            String paramName = param.isUnnamed() && !(type instanceof OCEllipsisType) && !(type instanceof OCVoidType) ? ((suggestedNames = OCNameSuggester.suggestForType(type, context, createdNames, resolveContext)).isEmpty() ? "param" : suggestedNames.iterator().next()) : param.getName();
            createdNames.add(paramName);
            newParamSymbols.add(new OCDeclaratorSymbol(param, param.getSubstitution(), OCQualifiedName.with(param.getQualifier(), paramName), null));
        }
        OCFunctionSymbol oCFunctionSymbol = new OCFunctionSymbol(context.getProject(), null, Long.MAX_VALUE, newParent, OCQualifiedName.with(null, OCCallableUtil.getOverridingFunctionName(base, newParent)), base.getTemplateParameters(), base.getTemplateSpecialization(), newProperties, newAttributes, base.getAttributes(), base.getType(), newParamSymbols, base.getKind(), visibility);
        if (oCFunctionSymbol == null) {
            OCCallableUtil.$$$reportNull$$$0(42);
        }
        return oCFunctionSymbol;
    }

    @Nullable
    public static OCFunctionSymbol getDefaultBaseToCall(OCFunctionSymbol function, @NotNull Project project2) {
        if (project2 == null) {
            OCCallableUtil.$$$reportNull$$$0(43);
        }
        return function.isCppDestructor() || function.isCppConstructor() && function.getType().hasNoParameters() ? null : (OCFunctionSymbol)new FilteredQuery((Query)new OCFunctionAncestorsQuery(function, false, false, true, project2), symbol -> !symbol.isPureVirtual()).findFirst();
    }

    public static boolean isParameterNameEmpty(@NotNull String paramName) {
        if (paramName == null) {
            OCCallableUtil.$$$reportNull$$$0(44);
        }
        return paramName.isEmpty() || paramName.equals("<unnamed>");
    }

    public static boolean resolveIsVirtual(@NotNull OCFunctionSymbol symbol, Project project2) {
        if (symbol == null) {
            OCCallableUtil.$$$reportNull$$$0(45);
        }
        return symbol.isVirtual() || symbol.isOverride() || symbol.isFinal() || OCFunctionAncestorsQuery.findFirstVirtual(symbol, false, project2) != null;
    }

    public static boolean hasVoidReturnType(@NotNull OCCallable callable, @NotNull OCResolveContext resolveContext) {
        if (callable == null) {
            OCCallableUtil.$$$reportNull$$$0(46);
        }
        if (resolveContext == null) {
            OCCallableUtil.$$$reportNull$$$0(47);
        }
        return callable.getReturnType().resolve(resolveContext).isVoid();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 29: 
            case 31: 
            case 34: 
            case 35: 
            case 38: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 29: 
            case 31: 
            case 34: 
            case 35: 
            case 38: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseMethod";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 22: 
            case 33: 
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 18: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 29: 
            case 31: 
            case 34: 
            case 35: 
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/util/OCCallableUtil";
                break;
            }
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "override";
                break;
            }
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseToCall";
                break;
            }
            case 30: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramName";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/util/OCCallableUtil";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "fillFunctionBodyTemplate";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseCallText";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseCallExpression";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "methodSignature";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionTemplateHeader";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultFunctionBody";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "createOverridingFunction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "methodText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "methodFromTemplate";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "methodWithSignature";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "functionWithSignature";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "fillFunctionBodyTemplate";
                break;
            }
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 29: 
            case 31: 
            case 34: 
            case 35: 
            case 38: 
            case 42: {
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getCallSuperText";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getBaseCallText";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getBaseCallExpression";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "methodSignature";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionTemplateHeader";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "defaultFunctionBody";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "createOverridingFunction";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultBaseToCall";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isParameterNameEmpty";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "resolveIsVirtual";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "hasVoidReturnType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 29: 
            case 31: 
            case 34: 
            case 35: 
            case 38: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

