/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.Queue;
import com.jetbrains.cidr.lang.dfa.OCControlFlowBuilder;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCNode;
import com.jetbrains.cidr.lang.dfa.OCUnreachableCodeFinder;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCControlFlowUtil {
    private OCControlFlowUtil() {
    }

    public static boolean isNodeReachableFrom(@NotNull OCNode fromNode, @NotNull OCNode toNode, boolean allowBackwardJumps) {
        if (fromNode == null) {
            OCControlFlowUtil.$$$reportNull$$$0(0);
        }
        if (toNode == null) {
            OCControlFlowUtil.$$$reportNull$$$0(1);
        }
        Queue nodesToProcess = new Queue(8);
        HashSet<OCNode> processedNodes = new HashSet<OCNode>();
        nodesToProcess.addLast((Object)fromNode);
        processedNodes.add(fromNode);
        while (!nodesToProcess.isEmpty()) {
            OCNode node = (OCNode)nodesToProcess.pullFirst();
            List<OCNode> jumpTargets = node.getJumpTargets();
            if (jumpTargets == null) continue;
            for (OCNode jumpTarget : jumpTargets) {
                if (!allowBackwardJumps && OCControlFlowUtil.isBackwardJump(node, jumpTarget) || processedNodes.contains(jumpTarget)) continue;
                processedNodes.add(jumpTarget);
                nodesToProcess.addLast((Object)jumpTarget);
            }
        }
        return processedNodes.contains(toNode);
    }

    public static boolean isBackwardJump(@NotNull OCNode fromNode, @NotNull OCNode toNode) {
        if (fromNode == null) {
            OCControlFlowUtil.$$$reportNull$$$0(2);
        }
        if (toNode == null) {
            OCControlFlowUtil.$$$reportNull$$$0(3);
        }
        int fromNodeEndOffset = fromNode.getEndOffset();
        int toNodeEndOffset = toNode.getEndOffset();
        return fromNodeEndOffset != -1 && toNodeEndOffset != -1 && toNodeEndOffset < fromNodeEndOffset;
    }

    @NotNull
    public static OCNode getSignificantNode(@NotNull OCNode node) {
        if (node == null) {
            OCControlFlowUtil.$$$reportNull$$$0(4);
        }
        while (node.getRange() == null && node.getJumpTargets() != null && node.getJumpTargets().size() == 1) {
            node = node.getJumpTargets().get(0);
        }
        OCNode oCNode = node;
        if (oCNode == null) {
            OCControlFlowUtil.$$$reportNull$$$0(5);
        }
        return oCNode;
    }

    @Nullable
    public static PsiElement getFirstPsiElement(@NotNull OCNode node) {
        OCElementsRange elementsRange;
        if (node == null) {
            OCControlFlowUtil.$$$reportNull$$$0(6);
        }
        if ((elementsRange = node.getRange()) == null) {
            return null;
        }
        PsiElement psiElementToJump = elementsRange.getFirstElement();
        while (psiElementToJump instanceof OCMacroCall) {
            psiElementToJump = psiElementToJump.getNextSibling();
        }
        if (psiElementToJump != null && !(psiElementToJump instanceof OCStatement)) {
            psiElementToJump = PsiTreeUtil.getParentOfType((PsiElement)psiElementToJump, OCStatement.class);
        }
        return psiElementToJump;
    }

    @Nullable
    public static OCNode findNodeForElement(@NotNull OCControlFlowGraph controlFlowGraph, @NotNull OCElement element) {
        if (controlFlowGraph == null) {
            OCControlFlowUtil.$$$reportNull$$$0(7);
        }
        if (element == null) {
            OCControlFlowUtil.$$$reportNull$$$0(8);
        }
        TextRange textRange = element.getTextRange();
        List<OCNode> nodes = controlFlowGraph.getNodes();
        for (OCNode node : nodes) {
            OCElementsRange range = node.getRange();
            if (range == null || !range.getTextRange().intersectsStrict(textRange)) continue;
            return node;
        }
        return null;
    }

    public static boolean isUnreachable(@NotNull OCControlFlowGraph controlFlowGraph, @NotNull PsiElement elementToCheck) {
        if (controlFlowGraph == null) {
            OCControlFlowUtil.$$$reportNull$$$0(9);
        }
        if (elementToCheck == null) {
            OCControlFlowUtil.$$$reportNull$$$0(10);
        }
        OCUnreachableCodeFinder unreachableCodeFinder = new OCUnreachableCodeFinder(controlFlowGraph);
        unreachableCodeFinder.process();
        TextRange textRangeToCheck = elementToCheck.getTextRange();
        return unreachableCodeFinder.getUnreachableRanges(false).stream().anyMatch(unreachableElementsRange -> unreachableElementsRange.getTextRange().intersectsStrict(textRangeToCheck));
    }

    @NotNull
    public static OCControlFlowGraph buildControlFlowGraph(@NotNull OCCallable callable) {
        if (callable == null) {
            OCControlFlowUtil.$$$reportNull$$$0(11);
        }
        OCControlFlowGraph oCControlFlowGraph = OCControlFlowUtil.buildControlFlowGraph(callable, callable);
        if (oCControlFlowGraph == null) {
            OCControlFlowUtil.$$$reportNull$$$0(12);
        }
        return oCControlFlowGraph;
    }

    @NotNull
    public static OCControlFlowGraph buildControlFlowGraph(@NotNull PsiElement element, @NotNull OCCallable callable) {
        if (element == null) {
            OCControlFlowUtil.$$$reportNull$$$0(13);
        }
        if (callable == null) {
            OCControlFlowUtil.$$$reportNull$$$0(14);
        }
        OCControlFlowGraph controlFlowGraph = new OCControlFlowGraph(callable, null);
        OCControlFlowBuilder controlFlowBuilder = new OCControlFlowBuilder(null, controlFlowGraph, null, false);
        controlFlowBuilder.processFirstCodeFragment(element);
        OCControlFlowGraph oCControlFlowGraph = controlFlowGraph;
        if (oCControlFlowGraph == null) {
            OCControlFlowUtil.$$$reportNull$$$0(15);
        }
        return oCControlFlowGraph;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 12: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 12: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromNode";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toNode";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/util/OCControlFlowUtil";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlFlowGraph";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToCheck";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/util/OCControlFlowUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignificantNode";
                break;
            }
            case 12: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "buildControlFlowGraph";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isNodeReachableFrom";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isBackwardJump";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSignificantNode";
                break;
            }
            case 5: 
            case 12: 
            case 15: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFirstPsiElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findNodeForElement";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isUnreachable";
                break;
            }
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildControlFlowGraph";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 12: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

