/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.EdtInvocationManager;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import java.util.List;

public class OCDebugUtil {
    private static Boolean ourIsInternal = null;
    private static final String CIDR_RESOLVE_DELAY = "__cidr_resolve_delay";

    private OCDebugUtil() {
    }

    private static boolean isInternal() {
        if (ourIsInternal == null) {
            ourIsInternal = ApplicationManager.getApplication().isInternal();
        }
        return ourIsInternal;
    }

    public static void waitWithCheckCanceled(long ms) {
        if (!OCDebugUtil.isInternal()) {
            return;
        }
        long time = System.currentTimeMillis();
        while (System.currentTimeMillis() - time < ms) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new ProcessCanceledException((Throwable)e);
            }
            ProgressManager.checkCanceled();
        }
    }

    public static void throwIfInEdt() {
        if (!OCDebugUtil.isInternal()) {
            return;
        }
        if (EdtInvocationManager.getInstance().isEventDispatchThread()) {
            throw new IllegalStateException("Called from EDT");
        }
    }

    public static boolean tryDebugWaitForSymbol(OCSymbol<?> symbol) {
        if (!OCDebugUtil.isInternal()) {
            return false;
        }
        for (String s : symbol.getAttributes()) {
            String ms;
            if (!s.startsWith(CIDR_RESOLVE_DELAY) || (ms = (String)ArrayUtil.getLastElement((Object[])s.split("_"))) == null) continue;
            try {
                OCDebugUtil.waitWithCheckCanceled(Long.parseLong(ms));
                return true;
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return false;
    }

    public static void tryDebugWaitForSymbols(List<OCSymbol> symbols) {
        if (!OCDebugUtil.isInternal()) {
            return;
        }
        for (OCSymbol symbol : symbols) {
            if (!OCDebugUtil.tryDebugWaitForSymbol(symbol)) continue;
            return;
        }
    }
}

