/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolAttribute;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.visitors.OCTypeParameterResolveVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDocUtil {
    private static EnumSet<OCSymbolAttribute> POST_FUNC_ATTRIBUTES = EnumSet.of(OCSymbolAttribute.CONST, OCSymbolAttribute.FINAL, OCSymbolAttribute.OVERRIDE, OCSymbolAttribute.DELETE, OCSymbolAttribute.DEFAULT);
    private static EnumSet<OCSymbolAttribute> SKIP_DECL_ATTRIBUTES = EnumSet.of(OCSymbolAttribute.CONST, OCSymbolAttribute.CONSTEXPR);
    private static final Function<OCSymbolWithQualifiedName, String> TO_NAME = symbol -> StringUtil.escapeXml((String)symbol.getPresentableName());

    @NotNull
    public static String parameterSignature(@NotNull String type, @Nullable String param) {
        if (type == null) {
            OCDocUtil.$$$reportNull$$$0(0);
        }
        String string = OCDocUtil.parameterSignature(type, param, null);
        if (string == null) {
            OCDocUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String parameterSignature(@NotNull String type, @Nullable String param, @Nullable String defValue) {
        if (type == null) {
            OCDocUtil.$$$reportNull$$$0(2);
        }
        StringBuilder sb = new StringBuilder();
        boolean hasName = param != null && !"<unnamed>".equals(param);
        sb.append(type);
        if (hasName) {
            sb.append(OCDocUtil.delimiter(type));
        }
        sb.append(hasName ? param : "");
        if (defValue != null) {
            sb.append(" = ").append(defValue);
        }
        String string = sb.toString();
        if (string == null) {
            OCDocUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static String delimiter(String type) {
        return OCDocUtil.delimiter(type, " ");
    }

    public static String delimiter(String type, String del) {
        if (!(type.endsWith("*") || type.endsWith("&") || type.endsWith("&amp;"))) {
            return del;
        }
        return "";
    }

    public static void extractModifiers(@NotNull OCDeclaratorSymbol symbol, @NotNull StringBuilder sb) {
        if (symbol == null) {
            OCDocUtil.$$$reportNull$$$0(4);
        }
        if (sb == null) {
            OCDocUtil.$$$reportNull$$$0(5);
        }
        for (OCSymbolAttribute attr : OCSymbolAttribute.values()) {
            if (!symbol.hasAttribute(attr) || SKIP_DECL_ATTRIBUTES.contains((Object)attr)) continue;
            sb.append((Object)attr).append(" ");
        }
    }

    public static void extractModifiers(@NotNull OCFunctionSymbol symbol, @NotNull StringBuilder sb) {
        if (symbol == null) {
            OCDocUtil.$$$reportNull$$$0(6);
        }
        if (sb == null) {
            OCDocUtil.$$$reportNull$$$0(7);
        }
        for (OCSymbolAttribute attr : OCSymbolAttribute.values()) {
            if (POST_FUNC_ATTRIBUTES.contains((Object)attr) || !symbol.hasAttribute(attr)) continue;
            sb.append((Object)attr).append(" ");
        }
    }

    public static void extractModifiers(@NotNull OCStructSymbol symbol, @NotNull StringBuilder sb) {
        if (symbol == null) {
            OCDocUtil.$$$reportNull$$$0(8);
        }
        if (sb == null) {
            OCDocUtil.$$$reportNull$$$0(9);
        }
        for (OCSymbolAttribute attr : OCSymbolAttribute.values()) {
            if (!symbol.hasAttribute(attr)) continue;
            sb.append((Object)attr).append(" ");
        }
        if (symbol.isTemplateSymbol()) {
            sb.append(OCTokenTypes.TEMPLATE_CPP_KEYWORD.getName()).append(" ");
        }
    }

    public static void extractFuncPostModifiers(@NotNull OCFunctionSymbol symbol, @NotNull StringBuilder sb) {
        if (symbol == null) {
            OCDocUtil.$$$reportNull$$$0(10);
        }
        if (sb == null) {
            OCDocUtil.$$$reportNull$$$0(11);
        }
        if (symbol.isConst()) {
            sb.append(" ").append(OCTokenTypes.CONST_KEYWORD.getName());
        }
        for (OCSymbolAttribute attr : POST_FUNC_ATTRIBUTES) {
            if (!symbol.hasAttribute(attr)) continue;
            if (attr == OCSymbolAttribute.DELETE || attr == OCSymbolAttribute.DEFAULT) {
                sb.append(" =");
            }
            sb.append(" ").append((Object)attr);
        }
    }

    @NotNull
    public static String getParametersSignature(OCFunctionSymbol symbol, boolean useSubstitution, Project project2) {
        StringBuilder answer = new StringBuilder("(");
        List<OCSymbolWithQualifiedName> contextNamespace = OCDocUtil.getParents(symbol, OCResolveContext.forSymbol(symbol, project2));
        OCFile containingFile = symbol.getContainingOCFile(project2);
        boolean isFirst = true;
        for (OCDeclaratorSymbol param : symbol.getParameterSymbols()) {
            String typeText;
            if (!isFirst) {
                answer.append(", ");
            }
            if (useSubstitution) {
                OCType type = param.getType().accept(new OCTypeParameterResolveVisitor(param.getContainingOCFile(project2)));
                typeText = OCDocUtil.getCanonicalName(type, contextNamespace, containingFile, project2);
            } else {
                typeText = param.getType().getCanonicalName(OCResolveContext.forSymbol(symbol, project2));
            }
            answer.append(OCDocUtil.parameterSignature(typeText, param.getName()));
            if (param.hasInitializer()) {
                answer.append(" = ").append(param.getInitializer().getSignature(project2));
            }
            isFirst = false;
        }
        String string = answer.append(')').toString();
        if (string == null) {
            OCDocUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public static String getCanonicalName(@NotNull OCType type, @NotNull List<OCSymbolWithQualifiedName> contextNamespace, @Nullable OCFile containingFile, @NotNull Project project2) {
        if (type == null) {
            OCDocUtil.$$$reportNull$$$0(13);
        }
        if (contextNamespace == null) {
            OCDocUtil.$$$reportNull$$$0(14);
        }
        if (project2 == null) {
            OCDocUtil.$$$reportNull$$$0(15);
        }
        OCResolveContext context = OCResolveContext.forNullablePsi(containingFile, project2);
        OCType terminalType = type.getTerminalType();
        OCType resolvedType = terminalType.resolve(context);
        if (resolvedType instanceof OCStructType) {
            CVQualifiers qualifiers;
            OCStructSymbol struct = ((OCStructType)resolvedType).getSymbol();
            List<OCSymbolWithQualifiedName> symbols = OCDocUtil.getQualifiedSymbolChain(context, struct, OCSymbolKind.NAMESPACE, OCSymbolKind.STRUCT, OCSymbolKind.ENUM, OCSymbolKind.UNION);
            if (!symbols.isEmpty()) {
                for (OCSymbolWithQualifiedName ns : contextNamespace) {
                    OCSymbolWithQualifiedName element = symbols.get(0);
                    if (!element.equals(ns)) continue;
                    symbols.remove(0);
                }
            }
            StringBuilder res = new StringBuilder();
            CVQualifiers cVQualifiers = qualifiers = type instanceof OCCppReferenceType || type instanceof OCPointerType ? type.getTerminalType().getCVQualifiers() : type.getCVQualifiers();
            if (qualifiers.isConst()) {
                res.append(OCTokenTypes.CONST_KEYWORD.getName()).append(" ");
            }
            if (qualifiers.isVolatile()) {
                res.append(OCTokenTypes.VOLATILE_KEYWORD.getName()).append(" ");
            }
            res.append(StringUtil.join(symbols, symbol -> OCDocUtil.wrapSymbolName(symbol), (String)"::"));
            List<OCTypeArgument> templateArguments = Collections.emptyList();
            if (terminalType instanceof OCReferenceType) {
                OCQualifiedName name2 = ((OCReferenceType)terminalType).getReference(containingFile).getQualifiedName();
                if (name2 instanceof OCQualifiedNameWithArguments) {
                    templateArguments = ((OCQualifiedNameWithArguments)name2).getArguments();
                }
            } else {
                templateArguments = struct.getTemplateArguments(context);
            }
            OCDocUtil.wrapTemplateArgs(templateArguments, contextNamespace, containingFile, res, project2);
            if (type instanceof OCCppReferenceType) {
                res.append(" &amp;");
            }
            if (type instanceof OCPointerType) {
                res.append(" *");
            }
            String string = res.toString();
            if (string == null) {
                OCDocUtil.$$$reportNull$$$0(16);
            }
            return string;
        }
        String string = StringUtil.escapeXml((String)type.getCanonicalName(context));
        if (string == null) {
            OCDocUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    public static String getNamespace(@NotNull OCSymbolWithQualifiedName<?> symbol, @NotNull OCResolveContext context) {
        if (symbol == null) {
            OCDocUtil.$$$reportNull$$$0(18);
        }
        if (context == null) {
            OCDocUtil.$$$reportNull$$$0(19);
        }
        String string = StringUtil.join(OCDocUtil.getParents(symbol, context), TO_NAME, (String)"::");
        if (string == null) {
            OCDocUtil.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    public static String getCanonicalPrefix(@NotNull OCSymbolWithQualifiedName<?> symbol, @NotNull Project project2) {
        if (symbol == null) {
            OCDocUtil.$$$reportNull$$$0(21);
        }
        if (project2 == null) {
            OCDocUtil.$$$reportNull$$$0(22);
        }
        List<OCSymbolWithQualifiedName> chain = OCDocUtil.getQualifiedSymbolChain(symbol, OCResolveContext.forSymbol(symbol, project2));
        List structParents = chain.stream().filter(s -> s.getKind().isStructLike()).collect(Collectors.toList());
        List<OCSymbolWithQualifiedName> namespace = chain.stream().filter(s -> s.getKind() == OCSymbolKind.NAMESPACE).collect(Collectors.toList());
        if (!structParents.isEmpty()) {
            OCFile containingOCFile = symbol.getContainingOCFile(project2);
            OCSymbolWithQualifiedName parent = (OCSymbolWithQualifiedName)structParents.get(structParents.size() - 1);
            String prefix = OCDocUtil.getCanonicalName(parent.getType(), namespace, containingOCFile, project2);
            String string = OCDocUtil.replaceAnonymous(prefix);
            if (string == null) {
                OCDocUtil.$$$reportNull$$$0(23);
            }
            return string;
        }
        if ("" == null) {
            OCDocUtil.$$$reportNull$$$0(24);
        }
        return "";
    }

    @NotNull
    public static String replaceAnonymous(@NotNull String canonicalName) {
        if (canonicalName == null) {
            OCDocUtil.$$$reportNull$$$0(25);
        }
        String string = canonicalName.replace("anonymous ", "<i>(anonymous)</i>");
        if (string == null) {
            OCDocUtil.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public static List<OCSymbolWithQualifiedName> getParents(@NotNull OCSymbolWithQualifiedName<?> symbol, @NotNull OCResolveContext context) {
        if (symbol == null) {
            OCDocUtil.$$$reportNull$$$0(27);
        }
        if (context == null) {
            OCDocUtil.$$$reportNull$$$0(28);
        }
        List<OCSymbolWithQualifiedName> chain = OCDocUtil.getQualifiedSymbolChain(context, symbol, OCSymbolKind.NAMESPACE);
        chain.remove(symbol);
        List<OCSymbolWithQualifiedName> list = chain;
        if (list == null) {
            OCDocUtil.$$$reportNull$$$0(29);
        }
        return list;
    }

    @NotNull
    private static List<OCSymbolWithQualifiedName> getQualifiedSymbolChain(@NotNull OCResolveContext context, @NotNull OCSymbolWithQualifiedName<?> symbol, OCSymbolKind ... filter) {
        if (context == null) {
            OCDocUtil.$$$reportNull$$$0(30);
        }
        if (symbol == null) {
            OCDocUtil.$$$reportNull$$$0(31);
        }
        if (filter == null) {
            OCDocUtil.$$$reportNull$$$0(32);
        }
        ArrayList<OCSymbolWithQualifiedName> parents = new ArrayList<OCSymbolWithQualifiedName>();
        symbol.getResolvedQualifiedName(true, context, true, true, true, true, false, true, (Consumer<OCSymbolWithQualifiedName>)((Consumer)parent -> {
            if (filter == null) {
                OCDocUtil.$$$reportNull$$$0(58);
            }
            for (OCSymbolKind kind : filter) {
                if (parent.getKind() != kind) continue;
                parents.add((OCSymbolWithQualifiedName)parent);
            }
        }));
        ArrayList<OCSymbolWithQualifiedName> arrayList = parents;
        if (arrayList == null) {
            OCDocUtil.$$$reportNull$$$0(33);
        }
        return arrayList;
    }

    @NotNull
    private static List<OCSymbolWithQualifiedName> getQualifiedSymbolChain(@NotNull OCSymbolWithQualifiedName<?> symbol, @NotNull OCResolveContext context) {
        if (symbol == null) {
            OCDocUtil.$$$reportNull$$$0(34);
        }
        if (context == null) {
            OCDocUtil.$$$reportNull$$$0(35);
        }
        ArrayList<OCSymbolWithQualifiedName> parents = new ArrayList<OCSymbolWithQualifiedName>();
        symbol.getResolvedQualifiedName(true, context, true, true, true, true, false, true, (Consumer<OCSymbolWithQualifiedName>)((Consumer)parents::add));
        parents.remove(symbol);
        ArrayList<OCSymbolWithQualifiedName> arrayList = parents;
        if (arrayList == null) {
            OCDocUtil.$$$reportNull$$$0(36);
        }
        return arrayList;
    }

    @NotNull
    private static String wrapSymbolName(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            OCDocUtil.$$$reportNull$$$0(37);
        }
        if (!(symbol instanceof OCStructSymbol)) {
            String string = StringUtil.escapeXml((String)symbol.getPresentableName());
            if (string == null) {
                OCDocUtil.$$$reportNull$$$0(38);
            }
            return string;
        }
        StringBuilder sb = new StringBuilder();
        OCDocUtil.wrapStruct((OCStructSymbol)symbol, sb);
        String string = sb.toString();
        if (string == null) {
            OCDocUtil.$$$reportNull$$$0(39);
        }
        return string;
    }

    private static void wrapStruct(@NotNull OCStructSymbol symbol, @NotNull StringBuilder sb) {
        String name2;
        if (symbol == null) {
            OCDocUtil.$$$reportNull$$$0(40);
        }
        if (sb == null) {
            OCDocUtil.$$$reportNull$$$0(41);
        }
        boolean hasName = !"<unnamed>".equals(name2 = symbol.getName());
        String link = OCDocUtil.buildLinkSymbol(symbol);
        if (hasName && link != null) {
            sb.append("<a href=\"").append(link).append("\">").append(StringUtil.escapeXml((String)name2)).append("</a>");
        } else {
            sb.append(StringUtil.escapeXml((String)symbol.getPresentableName()));
        }
    }

    public static String getLink(@NotNull OCSymbol symbol) {
        String name2;
        if (symbol == null) {
            OCDocUtil.$$$reportNull$$$0(42);
        }
        boolean hasName = !"<unnamed>".equals(name2 = symbol.getPresentableName());
        String link = OCDocUtil.buildLinkSymbol(symbol);
        if (hasName && link != null) {
            return "<a href=\"" + link + "\">" + StringUtil.escapeXml((String)name2) + "</a>";
        }
        return StringUtil.escapeXml((String)symbol.getPresentableName());
    }

    public static void wrapTemplateArgs(@NotNull List<OCTypeArgument> templateArguments, @NotNull List<OCSymbolWithQualifiedName> contextNamespace, @Nullable OCFile containingFile, @NotNull StringBuilder answer, @NotNull Project project2) {
        String templateArgumentsStr;
        if (templateArguments == null) {
            OCDocUtil.$$$reportNull$$$0(43);
        }
        if (contextNamespace == null) {
            OCDocUtil.$$$reportNull$$$0(44);
        }
        if (answer == null) {
            OCDocUtil.$$$reportNull$$$0(45);
        }
        if (project2 == null) {
            OCDocUtil.$$$reportNull$$$0(46);
        }
        if (!(templateArgumentsStr = StringUtil.join(templateArguments, templateArgument -> {
            if (contextNamespace == null) {
                OCDocUtil.$$$reportNull$$$0(56);
            }
            if (project2 == null) {
                OCDocUtil.$$$reportNull$$$0(57);
            }
            if (templateArgument instanceof OCType) {
                return OCDocUtil.getCanonicalName((OCType)templateArgument, contextNamespace, containingFile, project2);
            }
            if (templateArgument instanceof OCExpressionTypeArgument) {
                return ((OCExpressionTypeArgument)templateArgument).getSymbol().getPresentableName();
            }
            return "";
        }, (String)", ")).isEmpty()) {
            answer.append(StringUtil.escapeXml((String)"<")).append(templateArgumentsStr).append(StringUtil.escapeXml((String)">"));
        }
    }

    public static void wrapTemplateParams(@NotNull List<OCTypeParameterSymbol> templateParams, @NotNull List<OCSymbolWithQualifiedName> contextNamespace, @Nullable OCFile containingFile, @NotNull StringBuilder answer, @NotNull Project project2) {
        if (templateParams == null) {
            OCDocUtil.$$$reportNull$$$0(47);
        }
        if (contextNamespace == null) {
            OCDocUtil.$$$reportNull$$$0(48);
        }
        if (answer == null) {
            OCDocUtil.$$$reportNull$$$0(49);
        }
        if (project2 == null) {
            OCDocUtil.$$$reportNull$$$0(50);
        }
        String templateParamsStr = StringUtil.join(templateParams, param -> {
            if (contextNamespace == null) {
                OCDocUtil.$$$reportNull$$$0(54);
            }
            if (project2 == null) {
                OCDocUtil.$$$reportNull$$$0(55);
            }
            StringBuilder sb = new StringBuilder();
            if (param instanceof OCTypeParameterValueSymbol) {
                String type = ((OCTypeParameterValueSymbol)param).getType().getName();
                sb.append(type).append(OCDocUtil.delimiter(type));
            }
            if (param.isVariadic()) {
                sb.append("...");
            }
            sb.append(param.getName());
            Object value = param.getDefaultValue();
            if (value != null) {
                sb.append(" = ");
                if (value instanceof OCType) {
                    sb.append(OCDocUtil.getCanonicalName((OCType)value, contextNamespace, containingFile, project2));
                } else if (value instanceof OCExpressionTypeArgument) {
                    sb.append(((OCExpressionTypeArgument)value).getSymbol().getPresentableName());
                }
            }
            return sb.toString();
        }, (String)", ");
        answer.append(StringUtil.escapeXml((String)"template<")).append(templateParamsStr).append(StringUtil.escapeXml((String)">"));
    }

    @Nullable
    private static String buildLinkSymbol(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            OCDocUtil.$$$reportNull$$$0(51);
        }
        StringBuilder sb = new StringBuilder("psi_element://");
        VirtualFile file = symbol.getContainingFile();
        if (file != null) {
            sb.append(file.getPath()).append('#').append(symbol.getOffset());
            return sb.toString();
        }
        return null;
    }

    @NotNull
    public static List<OCSymbolWithParent> getSuperSymbols(@NotNull PsiElement element) {
        Object symbol;
        if (element == null) {
            OCDocUtil.$$$reportNull$$$0(52);
        }
        ArrayList<OCSymbolWithParent> supers = new ArrayList<OCSymbolWithParent>();
        if (element instanceof OCSymbolDeclarator && (symbol = ((OCSymbolDeclarator)element).getSymbol()) instanceof OCSymbolWithParent) {
            OCSearchUtil.processMemberAncestors((OCSymbolWithParent)symbol, (Processor<? super OCSymbolWithParent>)((Processor)s -> {
                supers.add((OCSymbolWithParent)s);
                return true;
            }), true, element.getProject());
        }
        ArrayList<OCSymbolWithParent> arrayList = supers;
        if (arrayList == null) {
            OCDocUtil.$$$reportNull$$$0(53);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 12: 
            case 16: 
            case 17: 
            case 20: 
            case 23: 
            case 24: 
            case 26: 
            case 29: 
            case 33: 
            case 36: 
            case 38: 
            case 39: 
            case 53: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 12: 
            case 16: 
            case 17: 
            case 20: 
            case 23: 
            case 24: 
            case 26: 
            case 29: 
            case 33: 
            case 36: 
            case 38: 
            case 39: 
            case 53: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: 
            case 12: 
            case 16: 
            case 17: 
            case 20: 
            case 23: 
            case 24: 
            case 26: 
            case 29: 
            case 33: 
            case 36: 
            case 38: 
            case 39: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/util/OCDocUtil";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 18: 
            case 21: 
            case 27: 
            case 31: 
            case 34: 
            case 37: 
            case 40: 
            case 42: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 14: 
            case 44: 
            case 48: 
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextNamespace";
                break;
            }
            case 15: 
            case 22: 
            case 46: 
            case 50: 
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 19: 
            case 28: 
            case 30: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canonicalName";
                break;
            }
            case 32: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateArguments";
                break;
            }
            case 45: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "answer";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateParams";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/util/OCDocUtil";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parameterSignature";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersSignature";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalPrefix";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceAnonymous";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getParents";
                break;
            }
            case 33: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedSymbolChain";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapSymbolName";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperSymbols";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parameterSignature";
                break;
            }
            case 1: 
            case 3: 
            case 12: 
            case 16: 
            case 17: 
            case 20: 
            case 23: 
            case 24: 
            case 26: 
            case 29: 
            case 33: 
            case 36: 
            case 38: 
            case 39: 
            case 53: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "extractModifiers";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "extractFuncPostModifiers";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicalName";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getNamespace";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicalPrefix";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "replaceAnonymous";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getParents";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedSymbolChain";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "wrapSymbolName";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "wrapStruct";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getLink";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "wrapTemplateArgs";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "wrapTemplateParams";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "buildLinkSymbol";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getSuperSymbols";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "lambda$wrapTemplateParams$5";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "lambda$wrapTemplateArgs$4";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getQualifiedSymbolChain$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 12: 
            case 16: 
            case 17: 
            case 20: 
            case 23: 
            case 24: 
            case 26: 
            case 29: 
            case 33: 
            case 36: 
            case 38: 
            case 39: 
            case 53: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

