/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.codeStyle.IndentHelper;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.StringBuilderSpinAllocator;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCConstructorInitializationList;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCPropertyAttributesList;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.impl.OCCodeFragmentImpl;
import com.jetbrains.cidr.lang.psi.impl.OCUDLiteralExpressionImpl;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbolImpl;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.names.OCTypeNameVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCElementFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.lang.util.OCElementFactory");

    private OCElementFactory() {
    }

    @NotNull
    public static OCDeclarationStatement declarationStatement(String name2, OCType type, @Nullable OCExpression initializer, PsiElement context) {
        OCDeclarationStatement oCDeclarationStatement = OCElementFactory.declarationStatement(null, name2, type, initializer, context);
        if (oCDeclarationStatement == null) {
            OCElementFactory.$$$reportNull$$$0(0);
        }
        return oCDeclarationStatement;
    }

    @NotNull
    public static OCDeclaration declaration(String name2, OCType type, @Nullable OCExpression initializer, PsiElement context) {
        OCDeclaration oCDeclaration = OCElementFactory.declarationStatement(null, name2, type, initializer, context).getDeclaration();
        if (oCDeclaration == null) {
            OCElementFactory.$$$reportNull$$$0(1);
        }
        return oCDeclaration;
    }

    @NotNull
    public static OCDeclaration declaration(@Nullable String modifier, String name2, OCType type, PsiElement context) {
        OCDeclaration oCDeclaration = OCElementFactory.declarationStatement(modifier, name2, type, null, context).getDeclaration();
        if (oCDeclaration == null) {
            OCElementFactory.$$$reportNull$$$0(2);
        }
        return oCDeclaration;
    }

    @NotNull
    public static OCDeclarationStatement declarationStatement(@Nullable String modifier, String name2, OCType type, @Nullable OCExpression initializer, PsiElement context) {
        String declText = OCElementFactory.declarationText(modifier != null ? Collections.singletonList(modifier) : Collections.emptyList(), name2, type, initializer != null ? "0" : null, context, null, false);
        OCDeclarationStatement statement2 = (OCDeclarationStatement)OCElementFactory.statementFromText(declText, context, true);
        if (initializer != null) {
            OCChangeUtil.replaceHandlingMacros(statement2.getDeclaration().getDeclarators().get(0).getInitializer(), initializer);
        }
        OCDeclarationStatement oCDeclarationStatement = statement2;
        if (oCDeclarationStatement == null) {
            OCElementFactory.$$$reportNull$$$0(3);
        }
        return oCDeclarationStatement;
    }

    @NotNull
    public static OCDeclaration declarationFromText(String text, PsiElement context) {
        OCDeclaration oCDeclaration = (OCDeclaration)OCElementFactory.topLevelDeclarationFromText(text + ";", context);
        if (oCDeclaration == null) {
            OCElementFactory.$$$reportNull$$$0(4);
        }
        return oCDeclaration;
    }

    @NotNull
    public static OCDeclaration declarationFromText(String text, PsiElement context, boolean reformat) {
        OCDeclaration oCDeclaration = (OCDeclaration)OCElementFactory.topLevelDeclarationFromText(text + ";", context, reformat);
        if (oCDeclaration == null) {
            OCElementFactory.$$$reportNull$$$0(5);
        }
        return oCDeclaration;
    }

    @NotNull
    public static String declarationText(String name2, OCType type, @NotNull PsiElement context) {
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(6);
        }
        String string = OCElementFactory.declarationText(Collections.emptyList(), name2, type, null, context, null, false);
        if (string == null) {
            OCElementFactory.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static String declarationText(String name2, OCType type, String typeNameHint, @NotNull PsiElement context) {
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(8);
        }
        String string = OCElementFactory.declarationText(Collections.emptyList(), name2, type, null, context, typeNameHint, false);
        if (string == null) {
            OCElementFactory.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static OCDeclaration declarationByNameAndType(String name2, OCType type, PsiElement context) {
        OCDeclaration oCDeclaration = OCElementFactory.declarationStatement(name2, type, null, context).getDeclaration();
        if (oCDeclaration == null) {
            OCElementFactory.$$$reportNull$$$0(10);
        }
        return oCDeclaration;
    }

    @NotNull
    public static OCParameterDeclaration paramDeclarationFromText(String text, @NotNull PsiElement context) {
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(11);
        }
        OCParameterDeclaration oCParameterDeclaration = ((OCFunctionDefinition)OCElementFactory.topLevelDeclarationFromText("void f(" + text + "){}", context)).getParameterList().getParameterDeclarations().get(0);
        if (oCParameterDeclaration == null) {
            OCElementFactory.$$$reportNull$$$0(12);
        }
        return oCParameterDeclaration;
    }

    @NotNull
    public static OCParameterDeclaration paramDeclarationByNameAndType(String name2, OCType type, PsiElement context) {
        OCParameterDeclaration oCParameterDeclaration = OCElementFactory.paramDeclarationFromText(OCElementFactory.declarationText(name2, type, context), context);
        if (oCParameterDeclaration == null) {
            OCElementFactory.$$$reportNull$$$0(13);
        }
        return oCParameterDeclaration;
    }

    @NotNull
    public static OCProperty propertyDeclaration(String name2, OCType type, PsiElement context) {
        OCProperty oCProperty = OCElementFactory.propertyDeclaration(name2, type, context, null, false);
        if (oCProperty == null) {
            OCElementFactory.$$$reportNull$$$0(14);
        }
        return oCProperty;
    }

    @NotNull
    public static OCProperty propertyDeclaration(String name2, OCType type, PsiElement context, @Nullable OCPropertySymbol.PropertySemantics semantics, boolean readonly) {
        OCProperty oCProperty = OCElementFactory.propertyDeclaration(name2, type, context, semantics, readonly, null);
        if (oCProperty == null) {
            OCElementFactory.$$$reportNull$$$0(15);
        }
        return oCProperty;
    }

    @NotNull
    public static OCProperty propertyDeclaration(String name2, OCType type, PsiElement context, @Nullable OCPropertySymbol.PropertySemantics semantics, boolean readonly, @Nullable String additionalAttributes) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)context.getProject()).getCustomSettings(OCCodeStyleSettings.class);
        OCProperty oCProperty = OCElementFactory.propertyDeclaration(name2, type, context, semantics, settings == null || settings.PROPERTY_NONATOMIC, readonly, additionalAttributes);
        if (oCProperty == null) {
            OCElementFactory.$$$reportNull$$$0(16);
        }
        return oCProperty;
    }

    @NotNull
    public static OCProperty propertyDeclaration(String name2, OCType type, PsiElement context, @Nullable OCPropertySymbol.PropertySemantics semantics, boolean nonatomic, boolean readonly, @Nullable String additionalAttributes) {
        ArrayList<String> attributes = new ArrayList<String>();
        if (nonatomic) {
            attributes.add("nonatomic");
        }
        if (readonly) {
            attributes.add("readonly");
        }
        if (semantics == null && type.isPointerToObjectCompatible()) {
            semantics = OCPropertySymbolImpl.getDefaultSemanticsForType(type, context);
        }
        if (semantics == OCPropertySymbol.PropertySemantics.ASSIGN) {
            attributes.add("assign");
        } else if (semantics == OCPropertySymbol.PropertySemantics.WEAK) {
            attributes.add("weak");
        } else if (type.isPointerToObjectCompatible() && !readonly) {
            if (semantics == OCPropertySymbol.PropertySemantics.STRONG) {
                attributes.add("strong");
            } else if (semantics == OCPropertySymbol.PropertySemantics.RETAIN) {
                attributes.add("retain");
            } else if (semantics == OCPropertySymbol.PropertySemantics.COPY) {
                attributes.add("copy");
            }
        }
        StringBuilder attributesText = new StringBuilder();
        if (!attributes.isEmpty()) {
            attributesText.append('(');
            attributesText.append(StringUtil.join(attributes, (String)","));
            attributesText.append(')');
        }
        if (!StringUtil.isEmpty((String)additionalAttributes)) {
            if (attributesText.length() > 0) {
                attributesText.append(' ');
            }
            attributesText.append(additionalAttributes);
            attributesText.append(' ');
        }
        String text = "@interface c @property " + attributesText + OCElementFactory.declarationText(Collections.emptyList(), name2, type, null, context, null, true) + "; @end";
        OCProperty oCProperty = ((OCInterface)OCElementFactory.topLevelDeclarationFromText(text, context, true)).getProperties().get(0);
        if (oCProperty == null) {
            OCElementFactory.$$$reportNull$$$0(17);
        }
        return oCProperty;
    }

    @NotNull
    public static OCDeclaration enumConst(String name2, PsiElement context) {
        OCDeclaration oCDeclaration = ((OCEnum)OCElementFactory.typeElementFromText("enum { " + name2 + "}", context).getFirstChild()).getFields().get(0);
        if (oCDeclaration == null) {
            OCElementFactory.$$$reportNull$$$0(18);
        }
        return oCDeclaration;
    }

    @NotNull
    public static OCExpression booleanConstant(boolean value, @NotNull OCResolveContext context) {
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(19);
        }
        String constant = OCIntType.getAppropriateBool(context.isObjc()).getValue(value, context);
        OCExpression oCExpression = (OCExpression)PsiTreeUtil.getChildOfType((PsiElement)OCElementFactory.expressionCodeFragment(constant, context.getProject(), context.getElement(), false, false), OCExpression.class);
        if (oCExpression == null) {
            OCElementFactory.$$$reportNull$$$0(20);
        }
        return oCExpression;
    }

    @NotNull
    public static OCSendMessageExpression sendMessageExpression(List<String> paramStubs, PsiElement context) {
        StringBuilder text = new StringBuilder("[ 0 ");
        for (String paramStub : paramStubs) {
            text.append(paramStub).append(' ');
        }
        text.append("]");
        OCSendMessageExpression oCSendMessageExpression = (OCSendMessageExpression)OCElementFactory.expressionFromText(text.toString(), context);
        if (oCSendMessageExpression == null) {
            OCElementFactory.$$$reportNull$$$0(21);
        }
        return oCSendMessageExpression;
    }

    @NotNull
    public static OCCallExpression callExpression(@Nullable String functionName, List<String> paramStubs, PsiElement context) {
        if (functionName == null || functionName.isEmpty()) {
            functionName = "__empty";
        }
        StringBuilder text = new StringBuilder(functionName);
        text.append('(');
        boolean isFirst = true;
        for (String paramStub : paramStubs) {
            if (!isFirst) {
                text.append(',');
            }
            text.append(paramStub);
            isFirst = false;
        }
        text.append(')');
        OCCallExpression oCCallExpression = (OCCallExpression)OCElementFactory.expressionFromText(text.toString(), context);
        if (oCCallExpression == null) {
            OCElementFactory.$$$reportNull$$$0(22);
        }
        return oCCallExpression;
    }

    @NotNull
    public static OCInterface interfaceByName(String name2, PsiElement context) {
        OCInterface oCInterface = (OCInterface)OCElementFactory.topLevelDeclarationFromText("@interface " + name2 + " @end", context, true);
        if (oCInterface == null) {
            OCElementFactory.$$$reportNull$$$0(23);
        }
        return oCInterface;
    }

    @NotNull
    public static OCMethod methodFromText(String text, PsiElement context, boolean reformat) {
        OCMethod oCMethod = ((OCInterface)OCElementFactory.topLevelDeclarationFromText("@interface i " + text + " @end", context, reformat)).getMethods().get(0);
        if (oCMethod == null) {
            OCElementFactory.$$$reportNull$$$0(24);
        }
        return oCMethod;
    }

    @NotNull
    public static OCDefineDirective macroDeclarationFromText(String name2, String defaultValue, PsiFile file) {
        OCDefineDirective oCDefineDirective = (OCDefineDirective)OCElementFactory.topLevelDeclarationFromText("#define " + name2 + " " + defaultValue, (PsiElement)file);
        if (oCDefineDirective == null) {
            OCElementFactory.$$$reportNull$$$0(25);
        }
        return oCDefineDirective;
    }

    @NotNull
    public static OCMethod methodFromSignature(@NotNull String signature, @NotNull PsiElement context, boolean needBody, boolean reformat) {
        OCCodeStyleSettings settings;
        if (signature == null) {
            OCElementFactory.$$$reportNull$$$0(26);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(27);
        }
        String semicolon = (settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)context.getProject()).getCustomSettings(OCCodeStyleSettings.class)) != null && settings.SEMICOLON_AFTER_METHOD_SIGNATURE ? ";" : "";
        OCMethod oCMethod = OCElementFactory.methodFromText(signature + (needBody ? semicolon + "{\n}" : ";"), context, reformat);
        if (oCMethod == null) {
            OCElementFactory.$$$reportNull$$$0(28);
        }
        return oCMethod;
    }

    @NotNull
    public static OCUnaryExpression unaryExpression(PsiElement operand, OCElementType operator) {
        OCUnaryExpression expression = (OCUnaryExpression)OCElementFactory.expressionFromText(operator.getName() + " a", operand, false);
        OCChangeUtil.replaceHandlingMacros(expression.getOperand(), operand);
        OCUnaryExpression oCUnaryExpression = expression;
        if (oCUnaryExpression == null) {
            OCElementFactory.$$$reportNull$$$0(29);
        }
        return oCUnaryExpression;
    }

    @NotNull
    public static PsiElement createUDLSuffux(String name2, PsiElement context) {
        OCUDLiteralExpressionImpl expression = (OCUDLiteralExpressionImpl)OCElementFactory.expressionFromText("\"\"" + name2, context, false);
        PsiElement psiElement = expression.getNameIdentifier();
        if (psiElement == null) {
            OCElementFactory.$$$reportNull$$$0(30);
        }
        return psiElement;
    }

    @NotNull
    public static OCBinaryExpression binaryExpression(PsiElement leftOperand, PsiElement rightOperand, OCElementType operator) {
        OCBinaryExpression expression = (OCBinaryExpression)OCElementFactory.expressionFromText("a " + operator.getName() + " b", leftOperand, false);
        OCChangeUtil.replaceHandlingMacros(expression.getLeft(), leftOperand);
        OCChangeUtil.replaceHandlingMacros(expression.getRight(), rightOperand);
        OCBinaryExpression oCBinaryExpression = expression;
        if (oCBinaryExpression == null) {
            OCElementFactory.$$$reportNull$$$0(31);
        }
        return oCBinaryExpression;
    }

    @NotNull
    public static OCConditionalExpression conditionalExpression(@NotNull OCExpression condition, @NotNull OCExpression thenExpression, @NotNull OCExpression elseExpression) {
        if (condition == null) {
            OCElementFactory.$$$reportNull$$$0(32);
        }
        if (thenExpression == null) {
            OCElementFactory.$$$reportNull$$$0(33);
        }
        if (elseExpression == null) {
            OCElementFactory.$$$reportNull$$$0(34);
        }
        OCConditionalExpression conditionalExpression = (OCConditionalExpression)OCElementFactory.expressionFromText("1 ? 2 : 3", condition);
        OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(conditionalExpression.getCondition(), condition);
        OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(conditionalExpression.getPositiveExpression(false), thenExpression);
        OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(conditionalExpression.getNegativeExpression(), elseExpression);
        OCConditionalExpression oCConditionalExpression = conditionalExpression;
        if (oCConditionalExpression == null) {
            OCElementFactory.$$$reportNull$$$0(35);
        }
        return oCConditionalExpression;
    }

    @NotNull
    public static PsiElement binaryOperatorFromText(String operator, PsiElement context) {
        PsiElement psiElement = ((OCBinaryExpression)OCElementFactory.expressionFromText("a" + operator + "b", context)).getOperationSignNode().getPsi();
        if (psiElement == null) {
            OCElementFactory.$$$reportNull$$$0(36);
        }
        return psiElement;
    }

    @NotNull
    public static ASTNode typeModifierFromText(String modifier, PsiElement context) {
        ASTNode aSTNode = OCElementFactory.typeElementFromText(modifier + " int", context).getNode().getFirstChildNode();
        if (aSTNode == null) {
            OCElementFactory.$$$reportNull$$$0(37);
        }
        return aSTNode;
    }

    @NotNull
    public static PsiElement ivarScopeSpecifier(OCVisibility scope, PsiElement context) {
        OCInstanceVariablesList clazz = ((OCInterface)OCElementFactory.topLevelDeclarationFromText("@interface c { @" + (Object)((Object)scope) + "} #end", context)).getInstanceVariablesList();
        for (PsiElement kid = clazz.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            if (OCVisibility.getVisibilityFromElement(kid) != scope) continue;
            PsiElement psiElement = kid;
            if (psiElement == null) {
                OCElementFactory.$$$reportNull$$$0(38);
            }
            return psiElement;
        }
        if (null == null) {
            OCElementFactory.$$$reportNull$$$0(39);
        }
        return null;
    }

    @NotNull
    public static OCInstanceVariablesList instanceVariableList(PsiElement context) {
        OCInstanceVariablesList oCInstanceVariablesList = ((OCInterface)OCElementFactory.topLevelDeclarationFromText("@interface c {} @end", context)).getInstanceVariablesList();
        if (oCInstanceVariablesList == null) {
            OCElementFactory.$$$reportNull$$$0(40);
        }
        return oCInstanceVariablesList;
    }

    @NotNull
    public static OCDeclaration constructorFromText(String text, PsiElement context) {
        OCDeclaration oCDeclaration = OCElementFactory.constructorFromText(text, context, false);
        if (oCDeclaration == null) {
            OCElementFactory.$$$reportNull$$$0(41);
        }
        return oCDeclaration;
    }

    @NotNull
    public static OCDeclaration constructorFromText(String text, PsiElement context, boolean reformat) {
        String name2 = text.substring(0, text.indexOf(40));
        OCTypeElement type = OCElementFactory.typeElementFromTextOrNull("struct " + name2 + " { " + text + ";}", context, reformat);
        OCStruct struct = (OCStruct)type.getFirstChild();
        OCDeclaration oCDeclaration = (OCDeclaration)PsiTreeUtil.getChildOfType((PsiElement)struct, OCFunctionDeclaration.class);
        if (oCDeclaration == null) {
            OCElementFactory.$$$reportNull$$$0(42);
        }
        return oCDeclaration;
    }

    @NotNull
    public static OCConstructorInitializationList constructorInitializationList(OCElement context) {
        OCFunctionDefinition constructor = (OCFunctionDefinition)OCElementFactory.constructorFromText("XXX() : y(1) {}", context);
        OCConstructorInitializationList list = constructor.getConstructorInitializationList();
        OCChangeUtil.delete(list.getInitializers().get(0));
        OCConstructorInitializationList oCConstructorInitializationList = list;
        if (oCConstructorInitializationList == null) {
            OCElementFactory.$$$reportNull$$$0(43);
        }
        return oCConstructorInitializationList;
    }

    @NotNull
    public static OCConstructorFieldInitializer constructorFieldInitializerFromText(String text, PsiElement context) {
        OCFunctionDefinition constructor = (OCFunctionDefinition)OCElementFactory.constructorFromText("XXX() : " + text + "{}", context);
        OCConstructorInitializationList list = constructor.getConstructorInitializationList();
        OCConstructorFieldInitializer oCConstructorFieldInitializer = list.getInitializers().get(0);
        if (oCConstructorFieldInitializer == null) {
            OCElementFactory.$$$reportNull$$$0(44);
        }
        return oCConstructorFieldInitializer;
    }

    @NotNull
    public static OCPropertyAttributesList propertyAttributeList(OCPropertySymbol.PropertyAttribute attribute, @Nullable String value, PsiElement context) {
        String text = "@interface c @property (" + attribute.getTokenName() + (value != null ? "=" + value : "") + ") int x; @end";
        OCPropertyAttributesList oCPropertyAttributesList = ((OCInterface)OCElementFactory.topLevelDeclarationFromText(text, context, true)).getProperties().get(0).getPropertyAttributesList();
        if (oCPropertyAttributesList == null) {
            OCElementFactory.$$$reportNull$$$0(45);
        }
        return oCPropertyAttributesList;
    }

    @NotNull
    public static OCSynthesizePropertiesList synthesizeList(String myKeyword, String property, @Nullable String ivar, PsiElement context) {
        String text = "@implementation i " + myKeyword + " " + property + (ivar != null ? "=" + ivar : "") + "; @end";
        ASTNode node = OCElementFactory.topLevelDeclarationFromText(text, context, true).getNode();
        OCSynthesizePropertiesList oCSynthesizePropertiesList = (OCSynthesizePropertiesList)node.findChildByType((IElementType)OCElementTypes.SYNTHESIZED_PROPERTIES_LIST).getPsi(OCSynthesizePropertiesList.class);
        if (oCSynthesizePropertiesList == null) {
            OCElementFactory.$$$reportNull$$$0(46);
        }
        return oCSynthesizePropertiesList;
    }

    @NotNull
    public static OCSynthesizeProperty synthesize(String property, @Nullable String ivar, PsiElement context) {
        String text = "@implementation i @synthesize " + property + (ivar != null ? "=" + ivar : "") + "; @end";
        ASTNode node = OCElementFactory.topLevelDeclarationFromText(text, context, true).getNode();
        OCSynthesizeProperty oCSynthesizeProperty = ((OCSynthesizePropertiesList)node.findChildByType((IElementType)OCElementTypes.SYNTHESIZED_PROPERTIES_LIST).getPsi(OCSynthesizePropertiesList.class)).getProperties().get(0);
        if (oCSynthesizeProperty == null) {
            OCElementFactory.$$$reportNull$$$0(47);
        }
        return oCSynthesizeProperty;
    }

    @NotNull
    private static String declaratorText(String name2, OCType type, @NotNull PsiElement context, boolean eraseARCAttributes) {
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(48);
        }
        if ("<unnamed>".equals(name2)) {
            name2 = "";
        }
        OCResolveContext resolveContext = OCResolveContext.forPsi(context);
        if (type.getAliasName() == null) {
            if (type instanceof OCArrayType) {
                OCArrayType arrayType = (OCArrayType)type;
                int length = arrayType.getLength(resolveContext);
                if (name2.startsWith("*")) {
                    name2 = "(" + name2 + ")";
                }
                String string = OCElementFactory.declaratorText(name2 + " [" + (arrayType.hasLength() ? Integer.valueOf(length) : "") + "]", arrayType.getRefType(), context, eraseARCAttributes);
                if (string == null) {
                    OCElementFactory.$$$reportNull$$$0(49);
                }
                return string;
            }
            if (type instanceof OCPointerType) {
                OCPointerType pointerType = (OCPointerType)type;
                if (!(pointerType.getRefType() instanceof OCIdType)) {
                    name2 = (type instanceof OCBlockPointerType ? "^" : "*") + (pointerType.isConst() ? " const " : "") + (pointerType.isVolatile() ? " volatile " : "") + name2;
                }
                String string = (!eraseARCAttributes && pointerType.getARCAttribute() != null ? pointerType.getARCAttribute().getTokenName() + " " : "") + OCElementFactory.declaratorText(name2, pointerType.getRefType(), context, eraseARCAttributes);
                if (string == null) {
                    OCElementFactory.$$$reportNull$$$0(50);
                }
                return string;
            }
            if (type instanceof OCFunctionType) {
                OCFunctionType funType = (OCFunctionType)type;
                StringBuilder b = new StringBuilder();
                b.append(funType.getReturnType().getBestNameInContext(resolveContext));
                b.append(" (").append(name2).append(")");
                b.append(OCTypeNameVisitor.getFunctionSignature(resolveContext, funType, "", false, null));
                String string = b.toString();
                if (string == null) {
                    OCElementFactory.$$$reportNull$$$0(51);
                }
                return string;
            }
        }
        String string = type.getBestNameInContext(resolveContext) + " " + name2;
        if (string == null) {
            OCElementFactory.$$$reportNull$$$0(52);
        }
        return string;
    }

    @NotNull
    public static String declarationText(@NotNull List<String> modifiers, String name2, OCType type, @Nullable String initializerText, @NotNull PsiElement context, @Nullable String typeNameHint, boolean eraseARCAttributes) {
        if (modifiers == null) {
            OCElementFactory.$$$reportNull$$$0(53);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(54);
        }
        if (type instanceof OCFunctionType && type.getAliasName() == null) {
            type = OCPointerType.to(type);
        }
        if (type == null) {
            if ("" == null) {
                OCElementFactory.$$$reportNull$$$0(55);
            }
            return "";
        }
        boolean isUnnamed = "<unnamed>".equals(name2);
        StringBuilder b = new StringBuilder();
        for (String modifier : modifiers) {
            b.append(modifier).append(' ');
        }
        OCResolveContext resolveContext = OCResolveContext.forPsi(context);
        if (type instanceof OCPointerType && type.getAliasName() == null) {
            b.append(OCElementFactory.declaratorText(name2, type, context, eraseARCAttributes));
        } else {
            if (type instanceof OCUnknownType) {
                b.append(resolveContext.isObjc() ? "id" : "int");
            } else {
                b.append(type.getBestNameInContext(resolveContext));
            }
            if (!isUnnamed) {
                b.append(' ').append(name2);
            }
        }
        String declarationText = b.toString();
        if (typeNameHint != null && OCCodeInsightUtil.isSimpleDeclaration(b.toString(), name2) && modifiers.isEmpty() && type.equalsAfterResolving(typeNameHint, resolveContext)) {
            declarationText = isUnnamed ? typeNameHint : typeNameHint + " " + name2;
        }
        if (initializerText != null) {
            String string = declarationText + '=' + initializerText;
            if (string == null) {
                OCElementFactory.$$$reportNull$$$0(56);
            }
            return string;
        }
        String string = declarationText;
        if (string == null) {
            OCElementFactory.$$$reportNull$$$0(57);
        }
        return string;
    }

    @NotNull
    public static PsiElement createIdentifier(@NotNull String name2, @NotNull PsiElement context) {
        OCCodeFragment fragment;
        OCDeclaration declaration;
        List<OCDeclarator> declarators;
        if (name2 == null) {
            OCElementFactory.$$$reportNull$$$0(58);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(59);
        }
        List<OCDeclarator> list = declarators = (declaration = (OCDeclaration)PsiTreeUtil.getChildOfType((PsiElement)(fragment = OCElementFactory.codeFragment("int " + name2, context.getProject(), context, false, false)), OCElement.class)) != null ? declaration.getDeclarators() : null;
        if (declarators == null || declarators.isEmpty()) {
            LOG.error("Bad identifier name " + name2);
        }
        PsiElement psiElement = declarators.get(0).getNameIdentifier();
        if (psiElement == null) {
            OCElementFactory.$$$reportNull$$$0(60);
        }
        return psiElement;
    }

    @NotNull
    public static OCMacroForeignLeafElement createMacroForeignIdentifier(@NotNull String name2, @NotNull OCMacroForeignLeafElement sample) {
        OCCodeFragment fragment;
        OCDeclaration declaration;
        List<OCDeclarator> declarators;
        if (name2 == null) {
            OCElementFactory.$$$reportNull$$$0(61);
        }
        if (sample == null) {
            OCElementFactory.$$$reportNull$$$0(62);
        }
        List<OCDeclarator> list = declarators = (declaration = (OCDeclaration)PsiTreeUtil.getChildOfType((PsiElement)(fragment = OCElementFactory.codeFragment("#define M(x) x\nint M(" + name2 + ")", sample.getProject(), null, false, false)), OCDeclaration.class)) != null ? declaration.getDeclarators() : null;
        if (declarators == null || declarators.isEmpty()) {
            LOG.error("Bad identifier name " + name2);
        }
        OCMacroForeignLeafElement identifier = (OCMacroForeignLeafElement)declarators.get(0).getNameIdentifier();
        identifier.copyFromElement(sample);
        OCMacroForeignLeafElement oCMacroForeignLeafElement = identifier;
        if (oCMacroForeignLeafElement == null) {
            OCElementFactory.$$$reportNull$$$0(63);
        }
        return oCMacroForeignLeafElement;
    }

    @NotNull
    public static OCCppNamespaceQualifier createNamespaceQualifier(String name2, PsiElement context) {
        OCStruct struct = (OCStruct)OCElementFactory.declarationFromText("struct " + name2 + "::XXXX {}", context, true).getTypeElement().getFirstChild();
        OCCppNamespaceQualifier oCCppNamespaceQualifier = struct.getNamespaceQualifier();
        if (oCCppNamespaceQualifier == null) {
            OCElementFactory.$$$reportNull$$$0(64);
        }
        return oCCppNamespaceQualifier;
    }

    @NotNull
    public static ASTNode createColon2x(PsiElement context) {
        OCStruct struct = (OCStruct)OCElementFactory.declarationFromText("struct A::B{}", context).getTypeElement().getFirstChild();
        ASTNode aSTNode = struct.getNode().findChildByType((IElementType)OCTokenTypes.COLON2X);
        if (aSTNode == null) {
            OCElementFactory.$$$reportNull$$$0(65);
        }
        return aSTNode;
    }

    @NotNull
    public static PsiElement topLevelDeclarationFromText(@NotNull String text, @NotNull PsiElement context) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(66);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(67);
        }
        PsiElement psiElement = OCElementFactory.topLevelDeclarationFromText(text, context, false);
        if (psiElement == null) {
            OCElementFactory.$$$reportNull$$$0(68);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement topLevelDeclarationFromText(@NotNull String text, @NotNull PsiElement context, boolean reformat) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(69);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(70);
        }
        OCCodeFragment element = OCElementFactory.codeFragment(text, context.getProject(), context, false, reformat);
        PsiElement child = element.getFirstChild();
        while (child instanceof PsiWhiteSpace || child instanceof PsiComment || child instanceof OCMacroCall) {
            child = child.getNextSibling();
        }
        PsiElement psiElement = child;
        if (psiElement == null) {
            OCElementFactory.$$$reportNull$$$0(71);
        }
        return psiElement;
    }

    @NotNull
    public static OCTypeElement typeElementFromText(@NotNull String text, @NotNull PsiElement context) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(72);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(73);
        }
        OCTypeElement oCTypeElement = OCElementFactory.typeElementFromTextOrNull(text, context, true);
        if (oCTypeElement == null) {
            OCElementFactory.$$$reportNull$$$0(74);
        }
        return oCTypeElement;
    }

    @Nullable
    public static OCTypeElement typeElementFromTextOrNull(@NotNull String text, @NotNull PsiElement context, boolean formatToCodestyle) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(75);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(76);
        }
        return (OCTypeElement)PsiTreeUtil.getChildOfType((PsiElement)OCElementFactory.typeCodeFragment(text, context.getProject(), context, false, formatToCodestyle), OCTypeElement.class);
    }

    @Nullable
    public static OCReferenceElement referenceElementFromText(@NotNull String name2, @NotNull PsiElement context, boolean formatToCodestyle) {
        if (name2 == null) {
            OCElementFactory.$$$reportNull$$$0(77);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(78);
        }
        return (OCReferenceElement)PsiTreeUtil.getChildOfType((PsiElement)OCElementFactory.expressionFromText(name2, context, formatToCodestyle), OCReferenceElement.class);
    }

    @Nullable
    public static OCExpression expressionFromText(@NotNull String text, @NotNull PsiElement context) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(79);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(80);
        }
        return OCElementFactory.expressionFromText(text, context, true);
    }

    @Nullable
    public static OCExpression expressionFromText(@NotNull String text, @NotNull PsiElement context, boolean reformat) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(81);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(82);
        }
        return (OCExpression)PsiTreeUtil.getChildOfType((PsiElement)OCElementFactory.expressionCodeFragment(text, context.getProject(), context, false, reformat), OCExpression.class);
    }

    public static OCStatement statementFromText(@NotNull String text, @NotNull PsiElement context) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(83);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(84);
        }
        return OCElementFactory.statementFromText(text, context, false);
    }

    public static OCStatement statementFromText(@NotNull String text, @NotNull PsiElement context, boolean reformat) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(85);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(86);
        }
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        text = builder.append("void _______dummy(){").append(text).append(";}").toString();
        StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        OCCodeFragment element = OCElementFactory.codeFragment(text, context.getProject(), context, false, reformat);
        element = PsiTreeUtil.getChildOfType((PsiElement)element, OCFunctionDefinition.class);
        element = PsiTreeUtil.getChildOfType((PsiElement)element, OCBlockStatement.class);
        return (OCStatement)PsiTreeUtil.getChildOfType((PsiElement)element, OCStatement.class);
    }

    @NotNull
    public static OCCodeFragment codeFragment(@NotNull String text, @NotNull Project project2, @Nullable PsiElement context, boolean physical, boolean reformat) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(87);
        }
        if (project2 == null) {
            OCElementFactory.$$$reportNull$$$0(88);
        }
        OCCodeFragment oCCodeFragment = OCElementFactory.codeFragment(text, project2, context, OCTokenTypes.OC_FILE, physical, reformat);
        if (oCCodeFragment == null) {
            OCElementFactory.$$$reportNull$$$0(89);
        }
        return oCCodeFragment;
    }

    @NotNull
    public static OCCodeFragment expressionCodeFragment(@NotNull String text, @NotNull Project project2, @Nullable PsiElement context, boolean physical, boolean formatToCodestyle) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(90);
        }
        if (project2 == null) {
            OCElementFactory.$$$reportNull$$$0(91);
        }
        OCCodeFragment oCCodeFragment = OCElementFactory.codeFragment(text, project2, context, OCElementTypes.EXPRESSION_CODE_FRAGMENT, physical, formatToCodestyle);
        if (oCCodeFragment == null) {
            OCElementFactory.$$$reportNull$$$0(92);
        }
        return oCCodeFragment;
    }

    @NotNull
    public static OCCodeFragment expressionCodeFragment(@NotNull String text, @NotNull Project project2, @Nullable PsiElement context, boolean physical, boolean formatToCodestyle, OCLanguageKind kind) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(93);
        }
        if (project2 == null) {
            OCElementFactory.$$$reportNull$$$0(94);
        }
        OCCodeFragment oCCodeFragment = OCElementFactory.codeFragment(text, project2, context, (IFileElementType)OCElementTypes.EXPRESSION_CODE_FRAGMENT, physical, formatToCodestyle, kind);
        if (oCCodeFragment == null) {
            OCElementFactory.$$$reportNull$$$0(95);
        }
        return oCCodeFragment;
    }

    @NotNull
    public static OCCodeFragment expressionCodeFragmentCpp(@NotNull String text, @NotNull Project project2, @Nullable PsiElement context, boolean physical, boolean formatToCodestyle) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(96);
        }
        if (project2 == null) {
            OCElementFactory.$$$reportNull$$$0(97);
        }
        OCCodeFragment oCCodeFragment = OCElementFactory.codeFragment(text, project2, context, (IFileElementType)OCElementTypes.EXPRESSION_CODE_FRAGMENT, physical, true, formatToCodestyle);
        if (oCCodeFragment == null) {
            OCElementFactory.$$$reportNull$$$0(98);
        }
        return oCCodeFragment;
    }

    @NotNull
    public static OCCodeFragment expressionOrStatementsCodeFragment(@NotNull String text, @NotNull Project project2, @Nullable PsiElement context, boolean physical, boolean formatToCodestyle) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(99);
        }
        if (project2 == null) {
            OCElementFactory.$$$reportNull$$$0(100);
        }
        OCCodeFragment oCCodeFragment = OCElementFactory.codeFragment(text, project2, context, OCElementTypes.EXPRESSION_OR_STATEMENTS_CODE_FRAGMENT, physical, formatToCodestyle);
        if (oCCodeFragment == null) {
            OCElementFactory.$$$reportNull$$$0(101);
        }
        return oCCodeFragment;
    }

    @NotNull
    public static OCCodeFragment typeCodeFragment(@NotNull String text, @NotNull PsiElement context) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(102);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(103);
        }
        OCCodeFragment oCCodeFragment = OCElementFactory.typeCodeFragment(text, context.getProject(), context, true, false);
        if (oCCodeFragment == null) {
            OCElementFactory.$$$reportNull$$$0(104);
        }
        return oCCodeFragment;
    }

    @NotNull
    public static OCCodeFragment typeCodeFragment(@NotNull String text, @NotNull Project project2, @Nullable PsiElement context, boolean physical, boolean formatToCodestyle) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(105);
        }
        if (project2 == null) {
            OCElementFactory.$$$reportNull$$$0(106);
        }
        OCCodeFragment oCCodeFragment = OCElementFactory.codeFragment(text, project2, context, OCElementTypes.TYPE_CODE_FRAGMENT, physical, formatToCodestyle);
        if (oCCodeFragment == null) {
            OCElementFactory.$$$reportNull$$$0(107);
        }
        return oCCodeFragment;
    }

    public static OCCodeFragment getTypeCodeFragmentInWriteAction(final String text, final @NotNull Project project2, final @Nullable PsiElement context) {
        if (project2 == null) {
            OCElementFactory.$$$reportNull$$$0(108);
        }
        return (OCCodeFragment)new WriteCommandAction<OCCodeFragment>(project2, new PsiFile[0]){

            protected void run(@NotNull Result<OCCodeFragment> result) throws Throwable {
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                result.setResult((Object)OCElementFactory.typeCodeFragment(text, project2, context, true, true));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/cidr/lang/util/OCElementFactory$1", "run"));
            }
        }.execute().getResultObject();
    }

    @NotNull
    public static OCCodeFragment codeFragment(@NotNull String text, @NotNull Project project2, @Nullable PsiElement context, @NotNull IFileElementType type, boolean physical, boolean formatToCodestyle) {
        PsiFile file;
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(109);
        }
        if (project2 == null) {
            OCElementFactory.$$$reportNull$$$0(110);
        }
        if (type == null) {
            OCElementFactory.$$$reportNull$$$0(111);
        }
        boolean isCpp = false;
        if (context != null && (file = context.getContainingFile()) instanceof OCFile) {
            isCpp = ((OCFile)file).isCpp();
        }
        OCCodeFragment oCCodeFragment = OCElementFactory.codeFragment(text, project2, context, type, physical, isCpp, formatToCodestyle);
        if (oCCodeFragment == null) {
            OCElementFactory.$$$reportNull$$$0(112);
        }
        return oCCodeFragment;
    }

    @NotNull
    public static OCCodeFragment codeFragment(@NotNull String text, @NotNull Project project2, @Nullable PsiElement context, @NotNull IFileElementType type, boolean physical, boolean isCpp, boolean formatToCodestyle) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(113);
        }
        if (project2 == null) {
            OCElementFactory.$$$reportNull$$$0(114);
        }
        if (type == null) {
            OCElementFactory.$$$reportNull$$$0(115);
        }
        OCCodeFragment oCCodeFragment = OCElementFactory.codeFragment(text, project2, context, type, physical, formatToCodestyle, isCpp ? OCLanguageKind.OBJ_CPP : OCLanguageKind.OBJ_C);
        if (oCCodeFragment == null) {
            OCElementFactory.$$$reportNull$$$0(116);
        }
        return oCCodeFragment;
    }

    @NotNull
    public static OCCodeFragment codeFragment(@NotNull String text, @NotNull Project project2, @Nullable PsiElement context, @NotNull IFileElementType type, boolean physical, boolean formatToCodestyle, @NotNull OCLanguageKind kind) {
        if (text == null) {
            OCElementFactory.$$$reportNull$$$0(117);
        }
        if (project2 == null) {
            OCElementFactory.$$$reportNull$$$0(118);
        }
        if (type == null) {
            OCElementFactory.$$$reportNull$$$0(119);
        }
        if (kind == null) {
            OCElementFactory.$$$reportNull$$$0(120);
        }
        text = text.trim();
        OCCodeFragmentImpl fragment = new OCCodeFragmentImpl(project2, kind, text, physical, (IElementType)type);
        if (context != null && context.isValid()) {
            fragment.setContext(context);
        }
        Application app = ApplicationManager.getApplication();
        if (formatToCodestyle) {
            if (app.isWriteAccessAllowed() || !physical) {
                PostprocessReformattingAspect.getInstance((Project)project2).disablePostprocessFormattingInside(() -> {
                    if (project2 == null) {
                        OCElementFactory.$$$reportNull$$$0(134);
                    }
                    CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)fragment);
                });
            } else {
                LOG.error("Write access is required");
            }
        }
        OCCodeFragmentImpl oCCodeFragmentImpl = fragment;
        if (oCCodeFragmentImpl == null) {
            OCElementFactory.$$$reportNull$$$0(121);
        }
        return oCCodeFragmentImpl;
    }

    @NotNull
    public static PsiElement create(@NotNull OCElementType type, @NotNull PsiElement context) {
        if (type == null) {
            OCElementFactory.$$$reportNull$$$0(122);
        }
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(123);
        }
        OCCodeFragment fragment = OCElementFactory.codeFragment(type.getName(), context.getProject(), context, true, false);
        PsiElement psiElement = PsiTreeUtil.findChildOfType((PsiElement)fragment, LeafPsiElement.class);
        if (psiElement == null) {
            OCElementFactory.$$$reportNull$$$0(124);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement spaceFromText(@NotNull PsiElement context) {
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(125);
        }
        PsiElement psiElement = OCElementUtil.getAllChildren(OCElementFactory.topLevelDeclarationFromText("a b", context)).get(1);
        if (psiElement == null) {
            OCElementFactory.$$$reportNull$$$0(126);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement newlineFromText(@NotNull PsiElement context) {
        if (context == null) {
            OCElementFactory.$$$reportNull$$$0(127);
        }
        PsiElement psiElement = OCElementUtil.getAllChildren(OCElementFactory.topLevelDeclarationFromText("a\nb", context)).get(1);
        if (psiElement == null) {
            OCElementFactory.$$$reportNull$$$0(128);
        }
        return psiElement;
    }

    public static void initIndentFromContext(@NotNull PsiElement oldElement, @NotNull PsiElement newElement) {
        if (oldElement == null) {
            OCElementFactory.$$$reportNull$$$0(129);
        }
        if (newElement == null) {
            OCElementFactory.$$$reportNull$$$0(130);
        }
        PsiFile context = oldElement.getContainingFile();
        CodeEditUtil.setOldIndentation((TreeElement)((TreeElement)newElement.getNode()), (int)IndentHelper.getInstance().getIndent(context.getProject(), context.getFileType(), oldElement.getNode()));
    }

    @NotNull
    public static OCBlockStatement surroundByBraces(@NotNull PsiElement element) {
        if (element == null) {
            OCElementFactory.$$$reportNull$$$0(131);
        }
        if (element instanceof OCBlockStatement) {
            OCBlockStatement oCBlockStatement = (OCBlockStatement)element;
            if (oCBlockStatement == null) {
                OCElementFactory.$$$reportNull$$$0(132);
            }
            return oCBlockStatement;
        }
        OCBlockStatement blockStatement = (OCBlockStatement)OCElementFactory.statementFromText("{}", element);
        OCChangeUtil.addAfter(blockStatement, element, blockStatement.getOpeningBrace());
        OCBlockStatement oCBlockStatement = blockStatement;
        if (oCBlockStatement == null) {
            OCElementFactory.$$$reportNull$$$0(133);
        }
        return oCBlockStatement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 19: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 34: 
            case 48: 
            case 53: 
            case 54: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 113: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 130: 
            case 131: 
            case 134: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 19: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 34: 
            case 48: 
            case 53: 
            case 54: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 113: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 130: 
            case 131: 
            case 134: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/util/OCElementFactory";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 19: 
            case 27: 
            case 48: 
            case 54: 
            case 59: 
            case 67: 
            case 70: 
            case 73: 
            case 76: 
            case 78: 
            case 80: 
            case 82: 
            case 84: 
            case 86: 
            case 103: 
            case 123: 
            case 125: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thenExpression";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elseExpression";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiers";
                break;
            }
            case 58: 
            case 61: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
            case 66: 
            case 69: 
            case 72: 
            case 75: 
            case 79: 
            case 81: 
            case 83: 
            case 85: 
            case 87: 
            case 90: 
            case 93: 
            case 96: 
            case 99: 
            case 102: 
            case 105: 
            case 109: 
            case 113: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 88: 
            case 91: 
            case 94: 
            case 97: 
            case 100: 
            case 106: 
            case 108: 
            case 110: 
            case 114: 
            case 118: 
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 111: 
            case 115: 
            case 119: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldElement";
                break;
            }
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "declarationStatement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "declaration";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "declarationFromText";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 19: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 34: 
            case 48: 
            case 53: 
            case 54: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 113: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 130: 
            case 131: 
            case 134: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/util/OCElementFactory";
                break;
            }
            case 7: 
            case 9: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "declarationText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "declarationByNameAndType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "paramDeclarationFromText";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "paramDeclarationByNameAndType";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "propertyDeclaration";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "enumConst";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "booleanConstant";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "sendMessageExpression";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "callExpression";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "interfaceByName";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "methodFromText";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "macroDeclarationFromText";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "methodFromSignature";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "unaryExpression";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createUDLSuffux";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "binaryExpression";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "conditionalExpression";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "binaryOperatorFromText";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "typeModifierFromText";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "ivarScopeSpecifier";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "instanceVariableList";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "constructorFromText";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "constructorInitializationList";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "constructorFieldInitializerFromText";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "propertyAttributeList";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "synthesizeList";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "synthesize";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "declaratorText";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "createIdentifier";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "createMacroForeignIdentifier";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "createNamespaceQualifier";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "createColon2x";
                break;
            }
            case 68: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "topLevelDeclarationFromText";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "typeElementFromText";
                break;
            }
            case 89: 
            case 112: 
            case 116: 
            case 121: {
                objectArray = objectArray2;
                objectArray2[1] = "codeFragment";
                break;
            }
            case 92: 
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "expressionCodeFragment";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "expressionCodeFragmentCpp";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "expressionOrStatementsCodeFragment";
                break;
            }
            case 104: 
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "typeCodeFragment";
                break;
            }
            case 124: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 126: {
                objectArray = objectArray2;
                objectArray2[1] = "spaceFromText";
                break;
            }
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "newlineFromText";
                break;
            }
            case 132: 
            case 133: {
                objectArray = objectArray2;
                objectArray2[1] = "surroundByBraces";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: 
            case 8: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "declarationText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "paramDeclarationFromText";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "booleanConstant";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "methodFromSignature";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "conditionalExpression";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "declaratorText";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "createIdentifier";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "createMacroForeignIdentifier";
                break;
            }
            case 66: 
            case 67: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "topLevelDeclarationFromText";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "typeElementFromText";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "typeElementFromTextOrNull";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "referenceElementFromText";
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "expressionFromText";
                break;
            }
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "statementFromText";
                break;
            }
            case 87: 
            case 88: 
            case 109: 
            case 110: 
            case 111: 
            case 113: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "codeFragment";
                break;
            }
            case 90: 
            case 91: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "expressionCodeFragment";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "expressionCodeFragmentCpp";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "expressionOrStatementsCodeFragment";
                break;
            }
            case 102: 
            case 103: 
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "typeCodeFragment";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCodeFragmentInWriteAction";
                break;
            }
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "spaceFromText";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "newlineFromText";
                break;
            }
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "initIndentFromContext";
                break;
            }
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "surroundByBraces";
                break;
            }
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "lambda$codeFragment$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 19: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 34: 
            case 48: 
            case 53: 
            case 54: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 113: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 130: 
            case 131: 
            case 134: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

