/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCLiteral;
import com.jetbrains.cidr.lang.util.OCStringLiteralUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCStringLiteral
implements OCLiteral {
    public static final OCStringLiteral BAD_LITERAL = new OCStringLiteral(OCStringLiteralUtil.OCStringPrefix.PREFIX_EMPTY, "");
    @NotNull
    public final OCStringLiteralUtil.OCStringPrefix prefix;
    @NotNull
    public final String contents;

    public OCStringLiteral(@NotNull OCStringLiteralUtil.OCStringPrefix prefix, @NotNull String contents) {
        if (prefix == null) {
            OCStringLiteral.$$$reportNull$$$0(0);
        }
        if (contents == null) {
            OCStringLiteral.$$$reportNull$$$0(1);
        }
        this.prefix = prefix;
        this.contents = contents;
    }

    public String getContents(boolean escaped) {
        if (this.prefix.isRaw != escaped) {
            return this.contents;
        }
        if (escaped) {
            return StringUtil.escapeStringCharacters((String)this.contents);
        }
        return OCStringLiteralUtil.unescapeAnsiStringCharacters(this.contents);
    }

    @NotNull
    public OCIntType getElementType(boolean isPlainOldC) {
        OCIntType oCIntType = isPlainOldC ? this.prefix.charTypePlainC : this.prefix.charTypeCpp;
        if (oCIntType == null) {
            OCStringLiteral.$$$reportNull$$$0(2);
        }
        return oCIntType;
    }

    @Override
    @NotNull
    public OCType getType(@Nullable PsiFile file, boolean isPlainOldC, @NotNull Project project2) {
        if (project2 == null) {
            OCStringLiteral.$$$reportNull$$$0(3);
        }
        OCArrayType oCArrayType = OCArrayType.to((OCType)this.getElementType(isPlainOldC), this.getContentLengthInCharacters() + 1, project2);
        if (oCArrayType == null) {
            OCStringLiteral.$$$reportNull$$$0(4);
        }
        return oCArrayType;
    }

    public int getContentLengthInCharacters() {
        String unescapedContents = this.getContents(false);
        if (this.prefix.encoding == OCStringLiteralUtil.OCEncoding.UTF8) {
            byte[] encodedContents = this.prefix.encoding.getBytes(unescapedContents);
            return encodedContents.length;
        }
        return unescapedContents.length();
    }

    public String toString() {
        return "OCStringLiteral{prefix=" + (Object)((Object)this.prefix) + ", contents='" + this.contents + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCStringLiteral literal = (OCStringLiteral)o;
        if (this.prefix != literal.prefix) {
            return false;
        }
        return this.contents.equals(literal.contents);
    }

    public int hashCode() {
        int result = this.prefix.hashCode();
        result = 31 * result + this.contents.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/util/OCStringLiteral";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/util/OCStringLiteral";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

